% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string_operations.r
\name{col_align}
\alias{col_align}
\title{Align an ANSI colored string}
\usage{
col_align(
  text,
  width = getOption("width"),
  align = c("left", "center", "right"),
  type = "width"
)
}
\arguments{
\item{text}{The character vector to align.}

\item{width}{Width of the field to align in.}

\item{align}{Whether to align \code{"left"}, \code{"center"} or \code{"right"}.}

\item{type}{Passed on to \code{\link[=col_nchar]{col_nchar()}} and there to \code{\link[=nchar]{nchar()}}}
}
\value{
The aligned character vector.
}
\description{
Align an ANSI colored string
}
\examples{
col_align(red("foobar"), 20, "left")
col_align(red("foobar"), 20, "center")
col_align(red("foobar"), 20, "right")
}
\seealso{
Other ANSI string operations: 
\code{\link{col_nchar}()},
\code{\link{col_strsplit}()},
\code{\link{col_substring}()},
\code{\link{col_substr}()}
}
\concept{ANSI string operations}
