% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date.R
\name{date_count_between}
\alias{date_count_between}
\title{Counting: date and date-time}
\usage{
date_count_between(start, end, precision, ..., n = 1L)
}
\arguments{
\item{start, end}{\verb{[Date / POSIXct / POSIXlt]}

A pair of date or date-time vectors. These will be recycled to their common
size.}

\item{precision}{\verb{[character(1)]}

A precision. Allowed precisions are dependent on the calendar used.}

\item{...}{These dots are for future extensions and must be empty.}

\item{n}{\verb{[positive integer(1)]}

A single positive integer specifying a multiple of \code{precision} to use.}
}
\value{
An integer representing the number of \code{precision} units between
\code{start} and \code{end}.
}
\description{
\code{date_count_between()} counts the number of \code{precision} units between
\code{start} and \code{end} (i.e., the number of years or months or hours). This count
corresponds to the \emph{whole number} of units, and will never return a
fractional value.

This is suitable for, say, computing the whole number of years or months
between two dates, accounting for the day and time of day.

There are separate help pages for counting for dates and date-times:
\itemize{
\item \link[=date-count-between]{dates (Date)}
\item \link[=posixt-count-between]{date-times (POSIXct/POSIXlt)}
}
}
\section{Comparison Direction}{

The computed count has the property that if \code{start <= end}, then
\verb{start + <count> <= end}. Similarly, if \code{start >= end}, then
\verb{start + <count> >= end}. In other words, the comparison direction between
\code{start} and \code{end} will never change after adding the count to \code{start}. This
makes this function useful for repeated count computations at
increasingly fine precisions.
}

\examples{
# See method specific documentation for more examples

start <- date_parse("2000-05-05")
end <- date_parse(c("2020-05-04", "2020-05-06"))

# Age in years
date_count_between(start, end, "year")

# Number of "whole" months between these dates
date_count_between(start, end, "month")
}
