% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rules.R
\name{rule}
\alias{rule}
\title{Make a rule with one or two text labels}
\usage{
rule(left = "", center = "", right = "", line = 1, col = NULL,
  line_col = col, background_col = NULL, width = console_width())
}
\arguments{
\item{left}{Label to show on the left. It interferes with the \code{center}
label, only at most one of them can be present.}

\item{center}{Label to show at the center. It interferes  with the
\code{left} and \code{right} labels.}

\item{right}{Label to show on the right. It interferes with the \code{center}
label, only at most one of them can be present.}

\item{line}{The character or string that is used to draw the line.
It can also \code{1} or \code{2}, to request a single line (Unicode, if
available), or a double line. Some strings are interpreted specially,
see \emph{Line styles} below.}

\item{col}{Color of text, and default line color. Either a \code{crayon} style
function or a color name that is passed to \code{\link[crayon:make_style]{crayon::make_style()}}.}

\item{line_col, background_col}{Either a color name (used in \code{\link[crayon:make_style]{crayon::make_style()}}),
or a style function from \code{crayon}, to color the line and background.}

\item{width}{Width of the rule. Defaults to the \code{width} option, see
\code{\link[base:options]{base::options()}}.}
}
\value{
Character scalar, the rule.
}
\description{
The rule can include either a centered text label, or labels on the
left and right side.
}
\details{
To color the labels, use the functions from the \code{crayon} package
directly, see examples below. To color the line, either use the
\code{crayon} colors directly, or the \code{line_col} option.
}
\section{Line styles}{

Some strings for the \code{line} argument are interpreted specially:
\itemize{
\item \code{"single"}: (same as \code{1}), a single line,
\item \code{"double"}: (same as \code{2}), a double line,
\item \code{"bar1"}, \code{"bar2"}, \code{"bar3"}, etc., \code{"bar8"} uses varying height bars.
}
}

\examples{

## Simple rule
rule()

## Double rule
rule(line = 2)

## Bars
rule(line = "bar2")
rule(line = "bar5")

## Left label
rule(left = "Results")

## Centered label
rule(center = " * RESULTS * ")

## Colored labels
rule(center = crayon::red(" * RESULTS * "))

## Colored line
rule(center = crayon::red(" * RESULTS * "), line_col = "red")

## Custom line
rule(center = "TITLE", line = "~")

## More custom line
rule(center = "TITLE", line = crayon::blue("~-"))

## Even more custom line
rule(center = crayon::bgRed(" ", symbol$star, "TITLE",
  symbol$star, " "),
  line = "\\u2582",
  line_col = "orange")
}
