% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mock.R
\name{mock}
\alias{mock}
\alias{mock_categorical}
\alias{mock_continuous}
\alias{mock_dichotomous}
\alias{mock_missing}
\alias{mock_attributes}
\alias{mock_total_n}
\title{Mock ARDs}
\usage{
mock_categorical(
  variables,
  statistic = everything() ~ c("n", "p", "N"),
  by = NULL
)

mock_continuous(
  variables,
  statistic = everything() ~ c("N", "mean", "sd", "median", "p25", "p75", "min", "max"),
  by = NULL
)

mock_dichotomous(
  variables,
  statistic = everything() ~ c("n", "p", "N"),
  by = NULL
)

mock_missing(
  variables,
  statistic = everything() ~ c("N_obs", "N_miss", "N_nonmiss", "p_miss", "p_nonmiss"),
  by = NULL
)

mock_attributes(label)

mock_total_n()
}
\arguments{
\item{variables}{(\code{character} or named \code{list})\cr
a character vector of variable names for functions \code{mock_continuous()},
\code{mock_missing()}, and \code{mock_attributes()}.

a named list for functions \code{mock_categorical()} and \code{mock_dichotomous()},
where the list element is a vector of variable values. For
\code{mock_dichotomous()}, only a single value is allowed for each variable.}

\item{statistic}{(\code{\link[=syntax]{formula-list-selector}})\cr
a named list, a list of formulas, or a single formula where the list elements
are character vectors of statistic names to appear in the ARD.}

\item{by}{(named \code{list})\cr
a named list where the list element is a vector of variable values.}

\item{label}{(named \code{list})\cr
named list of variable labels, e.g. \code{list(cyl = "No. Cylinders")}.}
}
\value{
an ARD data frame of class 'card'
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}\cr
Create empty ARDs used to create mock tables or table shells.
Where applicable, the formatting functions are set to return \code{'xx'} or \code{'xx.x'}.
}
\examples{
mock_categorical(
  variables =
    list(
      AGEGR1 = factor(c("<65", "65-80", ">80"), levels = c("<65", "65-80", ">80"))
    ),
  by = list(TRTA = c("Placebo", "Xanomeline High Dose", "Xanomeline Low Dose"))
) |>
  apply_fmt_fn()

mock_continuous(
  variables = c("AGE", "BMIBL"),
  by = list(TRTA = c("Placebo", "Xanomeline High Dose", "Xanomeline Low Dose"))
) |>
  # update the mock to report 'xx.xx' for standard deviations
  update_ard_fmt_fn(variables = c("AGE", "BMIBL"), stat_names = "sd", fmt_fn = \(x) "xx.xx") |>
  apply_fmt_fn()
}
