% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival-survfit-tidiers.R
\name{tidy.survfit}
\alias{tidy.survfit}
\alias{survfit_tidiers}
\title{Tidy a(n) survfit object}
\usage{
\method{tidy}{survfit}(x, ...)
}
\arguments{
\item{x}{An \code{survfit} object returned from \code{\link[survival:survfit]{survival::survfit()}}.}

\item{...}{For \code{glance.survfit()}, additional arguments passed
to \code{\link[=summary]{summary()}}. Otherwise ignored.}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\examples{
\dontshow{if (rlang::is_installed(c("survival", "ggplot2"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# load libraries for models and data
library(survival)

# fit model
cfit <- coxph(Surv(time, status) ~ age + sex, lung)
sfit <- survfit(cfit)

# summarize model fit with tidiers + visualization
tidy(sfit)
glance(sfit)

library(ggplot2)

ggplot(tidy(sfit), aes(time, estimate)) +
  geom_line() +
  geom_ribbon(aes(ymin = conf.low, ymax = conf.high), alpha = .25)

# multi-state
fitCI <- survfit(Surv(stop, status * as.numeric(event), type = "mstate") ~ 1,
  data = mgus1, subset = (start == 0)
)

td_multi <- tidy(fitCI)

td_multi

ggplot(td_multi, aes(time, estimate, group = state)) +
  geom_line(aes(color = state)) +
  geom_ribbon(aes(ymin = conf.low, ymax = conf.high), alpha = .25)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[survival:survfit]{survival::survfit()}}

Other survival tidiers: 
\code{\link{augment.coxph}()},
\code{\link{augment.survreg}()},
\code{\link{glance.aareg}()},
\code{\link{glance.cch}()},
\code{\link{glance.coxph}()},
\code{\link{glance.pyears}()},
\code{\link{glance.survdiff}()},
\code{\link{glance.survexp}()},
\code{\link{glance.survfit}()},
\code{\link{glance.survreg}()},
\code{\link{tidy.aareg}()},
\code{\link{tidy.cch}()},
\code{\link{tidy.coxph}()},
\code{\link{tidy.pyears}()},
\code{\link{tidy.survdiff}()},
\code{\link{tidy.survexp}()},
\code{\link{tidy.survreg}()}
}
\concept{survfit tidiers}
\concept{survival tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{conf.high}{Upper bound on the confidence interval for the estimate.}
  \item{conf.low}{Lower bound on the confidence interval for the estimate.}
  \item{n.censor}{Number of censored events.}
  \item{n.event}{Number of events at time t.}
  \item{n.risk}{Number of individuals at risk at time zero.}
  \item{std.error}{The standard error of the regression term.}
  \item{time}{Point in time.}
  \item{estimate}{estimate of survival or cumulative incidence rate when
    multistate}
  \item{state}{state if multistate survfit object input}
  \item{strata}{strata if stratified survfit object input}

}
