% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-helpers.R
\name{get_dpar}
\alias{get_dpar}
\title{Draws of a Distributional Parameter}
\usage{
get_dpar(prep, dpar, i = NULL, ilink = NULL)
}
\arguments{
\item{prep}{A 'brmsprep' or 'mvbrmsprep' object created by
\code{\link[brms:prepare_predictions.brmsfit]{prepare_predictions}}.}

\item{dpar}{Name of the distributional parameter.}

\item{i}{The observation numbers for which predictions shall be extracted.
If \code{NULL} (the default), all observation will be extracted.
Ignored if \code{dpar} is not predicted.}

\item{ilink}{Should the inverse link function be applied?
If \code{NULL} (the default), the value is chosen internally.
In particular, \code{ilink} is \code{TRUE} by default for custom
families.}
}
\value{
If the parameter is predicted and \code{i} is \code{NULL} or
  \code{length(i) > 1}, an \code{S x N} matrix. If the parameter it not
  predicted or \code{length(i) == 1}, a vector of length \code{S}. Here
  \code{S} is the number of draws and \code{N} is the number of
  observations or length of \code{i} if specified.
}
\description{
Get draws of a distributional parameter from a \code{brmsprep} or 
\code{mvbrmsprep} object. This function is primarily useful when developing
custom families or packages depending on \pkg{brms}. 
This function lets callers easily handle both the case when the
distributional parameter is predicted directly, via a (non-)linear
predictor or fixed to a constant. See the vignette
\code{vignette("brms_customfamilies")} for an example use case.
}
\examples{
\dontrun{
posterior_predict_my_dist <- function(i, prep, ...) {
  mu <- brms::get_dpar(prep, "mu", i = i)
  mypar <- brms::get_dpar(prep, "mypar", i = i)
  my_rng(mu, mypar)
}
} 

}
