% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_predict.R
\name{predict.brmsfit}
\alias{predict.brmsfit}
\title{Samples from the Posterior Predictive Distribution}
\usage{
\method{predict}{brmsfit}(
  object,
  newdata = NULL,
  re_formula = NULL,
  transform = NULL,
  resp = NULL,
  negative_rt = FALSE,
  nsamples = NULL,
  subset = NULL,
  sort = FALSE,
  ntrys = 5,
  summary = TRUE,
  robust = FALSE,
  probs = c(0.025, 0.975),
  ...
)
}
\arguments{
\item{object}{An object of class \code{brmsfit}.}

\item{newdata}{An optional data.frame for which to evaluate predictions. If
\code{NULL} (default), the original data of the model is used.
\code{NA} values within factors are interpreted as if all dummy
variables of this factor are zero. This allows, for instance, to make
predictions of the grand mean when using sum coding.}

\item{re_formula}{formula containing group-level effects to be considered in
the prediction. If \code{NULL} (default), include all group-level effects;
if \code{NA}, include no group-level effects.}

\item{transform}{A function or a character string naming 
a function to be applied on the predicted responses
before summary statistics are computed.}

\item{resp}{Optional names of response variables. If specified, predictions
are performed only for the specified response variables.}

\item{negative_rt}{Only relevant for Wiener diffusion models. 
A flag indicating whether response times of responses
on the lower boundary should be returned as negative values.
This allows to distinguish responses on the upper and
lower boundary. Defaults to \code{FALSE}.}

\item{nsamples}{Positive integer indicating how many posterior samples should
be used. If \code{NULL} (the default) all samples are used. Ignored if
\code{subset} is not \code{NULL}.}

\item{subset}{A numeric vector specifying the posterior samples to be used.
If \code{NULL} (the default), all samples are used.}

\item{sort}{Logical. Only relevant for time series models. 
Indicating whether to return predicted values in the original 
order (\code{FALSE}; default) or in the order of the 
time series (\code{TRUE}).}

\item{ntrys}{Parameter used in rejection sampling 
for truncated discrete models only 
(defaults to \code{5}). See Details for more information.}

\item{summary}{Should summary statistics be returned
instead of the raw values? Default is \code{TRUE}.}

\item{robust}{If \code{FALSE} (the default) the mean is used as 
the measure of central tendency and the standard deviation as 
the measure of variability. If \code{TRUE}, the median and the 
median absolute deviation (MAD) are applied instead.
Only used if \code{summary} is \code{TRUE}.}

\item{probs}{The percentiles to be computed by the \code{quantile} 
function. Only used if \code{summary} is \code{TRUE}.}

\item{...}{Further arguments passed to \code{\link{extract_draws}}
that control several aspects of data validation and prediction.}
}
\value{
An \code{array} of predicted response values.
  If \code{summary = FALSE} the output resembles those of 
  \code{\link{posterior_predict.brmsfit}}.

  If \code{summary = TRUE} the output depends on the family: For categorical
  and ordinal families, the output is an N x C matrix, where N is the number
  of observations, C is the number of categories, and the values are
  predicted category probabilites. For all other families, the output is a N
  x E matrix where E = \code{2 + length(probs)} is the number of summary
  statistics: The \code{Estimate} column contains point estimates (either
  mean or median depending on argument \code{robust}), while the
  \code{Est.Error} column contains uncertainty estimates (either standard
  deviation or median absolute deviation depending on argument
  \code{robust}). The remaining columns starting with \code{Q} contain
  quantile estimates as specifed via argument \code{probs}.
}
\description{
This method is an alias of \code{\link{posterior_predict.brmsfit}}
with additional arguments for obtaining summaries of the computed samples.
}
\examples{
\dontrun{
## fit a model
fit <- brm(time | cens(censored) ~ age + sex + (1 + age || patient), 
           data = kidney, family = "exponential", inits = "0")

## predicted responses
pp <- predict(fit)
head(pp)

## predicted responses excluding the group-level effect of age
pp <- predict(fit, re_formula = ~ (1 | patient))
head(pp)

## predicted responses of patient 1 for new data
newdata <- data.frame(
  sex = factor(c("male", "female")),
  age = c(20, 50),
  patient = c(1, 1)
)
predict(fit, newdata = newdata)
}
 
}
\seealso{
\code{\link{posterior_predict.brmsfit}}
}
