% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sequence.R
\name{getDNAMatrix}
\alias{getDNAMatrix}
\title{Build a DNA distance matrix}
\usage{
getDNAMatrix(gap = -1)
}
\arguments{
\item{gap}{value to assign to characters in the set \code{c("-", ".")}.}
}
\value{
A \code{matrix} of DNA character distances with row and column names 
          indicating the character pair. By default, distances will be either 0 
          (equivalent), 1 (non-equivalent or missing), or -1 (gap).
}
\description{
\code{getDNAMatrix} returns a Hamming distance matrix for IUPAC ambiguous
DNA characters with modifications for gap, \code{c("-", ".")}, and missing, 
\code{c("?")}, character values.
}
\examples{
# Set gap characters to Inf distance
# Distinguishes gaps from Ns
getDNAMatrix()

# Set gap characters to 0 distance
# Makes gap characters equivalent to Ns
getDNAMatrix(gap=0)

}
\seealso{
Creates DNA distance matrix for \link{seqDist}.
          See \link{getAAMatrix} for amino acid distances.
}
