% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Diversity.R
\name{countClones}
\alias{countClones}
\title{Tabulates clones sizes}
\usage{
countClones(
  data,
  groups = NULL,
  copy = NULL,
  clone = "clone_id",
  remove_na = TRUE
)
}
\arguments{
\item{data}{data.frame with columns containing clonal assignments.}

\item{groups}{character vector defining \code{data} columns containing grouping 
variables. If \code{groups=NULL}, then do not group data.}

\item{copy}{name of the \code{data} column containing copy numbers for each 
sequence. If this value is specified, then total copy abundance
is determined by the sum of copy numbers within each clonal group.}

\item{clone}{name of the \code{data} column containing clone identifiers.}

\item{remove_na}{removes rows with \code{NA} values in the clone column if \code{TRUE} and issues a warning. 
Otherwise, keeps those rows and considers \code{NA} as a clone in the final counts 
and relative abundances.}
}
\value{
A data.frame summarizing clone counts and frequencies with columns:
          \itemize{
            \item \code{clone_id}:    clone identifier. This is the default column
                                      name, specified with \code{clone='clone_id'}.
                                      If the function call uses Change-O 
                                      formatted data and \code{clone='CLONE'}, this
                                      column will have name \code{CLONE}.
            \item \code{seq_count}:   total number of sequences for the clone.
            \item \code{seq_freq}:    frequency of the clone as a fraction of the total
                                      number of sequences within each group.
            \item \code{copy_count}:  sum of the copy counts in the \code{copy} column.
                                      Only present if the \code{copy} argument is 
                                      specified.
            \item \code{copy_freq}:   frequency of the clone as a fraction of the total
                                      copy number within each group. Only present if 
                                      the \code{copy} argument is specified.
          }
          Also includes additional columns specified in the \code{groups} argument.
}
\description{
\code{countClones} determines the number of sequences and total copy number of 
clonal groups.
}
\examples{
# Without copy numbers
clones <- countClones(ExampleDb, groups="sample_id")

# With copy numbers and multiple groups
clones <- countClones(ExampleDb, groups=c("sample_id", "c_call"), copy="duplicate_count")

}
