% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Topology.R
\name{permuteLabels}
\alias{permuteLabels}
\title{Permute the node labels of a tree}
\usage{
permuteLabels(graph, field, exclude = c("Germline", NA))
}
\arguments{
\item{graph}{igraph object containing an annotated lineage tree.}

\item{field}{string defining the annotation field to permute.}

\item{exclude}{vector of strings defining \code{field} values to exclude 
from permutation.}
}
\value{
A modified igraph object with vertex annotations permuted.
}
\description{
\code{permuteLabels} permutes the node annotations of a lineage tree.
}
\examples{
# Define and plot example graph
library(igraph)
graph <- ExampleTrees[[23]]
plot(graph, layout=layout_as_tree, vertex.label=V(graph)$ISOTYPE, 
     vertex.size=50, edge.arrow.mode=0, vertex.color="grey80")

# Permute annotations and plot new tree
g <- permuteLabels(graph, "ISOTYPE")
plot(g, layout=layout_as_tree, vertex.label=V(g)$ISOTYPE,
     vertex.size=50, edge.arrow.mode=0, vertex.color="grey80")

}
\seealso{
\link{testEdges}.
}
