% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_markers.R
\name{.logBH}
\alias{.logBH}
\title{BH correction on log-p-values}
\usage{
.logBH(log.p.val)
}
\arguments{
\item{log.p.val}{Numeric vector of log-transformed p-values.}
}
\value{
A numeric vector of the same length as \code{log.p.val} containing log-transformed BH-corrected p-values.
}
\description{
Perform a Benjamini-Hochberg correction on log-transformed p-values to get log-adjusted p-values,
without the loss of precision from undoing and redoing the log-transformations.
}
\examples{
log.p.values <- log(runif(1000))
obs <- .logBH(log.p.values)
head(obs)

ref <- log(p.adjust(exp(log.p.values), method="BH"))
head(ref)

}
\author{
Aaron Lun
}
