% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results.R
\docType{methods}
\name{degMA}
\alias{degMA}
\title{MA-plot from base means and log fold changes}
\usage{
degMA(
  results,
  title = NULL,
  label_points = NULL,
  label_column = "symbol",
  limit = NULL,
  diff = 5,
  raw = FALSE,
  correlation = FALSE
)
}
\arguments{
\item{results}{\link{DEGSet} class.}

\item{title}{\emph{Optional}. Plot title.}

\item{label_points}{Optionally label these particular points.}

\item{label_column}{Match label_points to this column in the results.}

\item{limit}{Absolute maximum to plot on the log2FoldChange.}

\item{diff}{Minimum difference between logFoldChange before and
after shrinking.}

\item{raw}{Whether to plot just the unshrunken log2FC.}

\item{correlation}{Whether to plot the correlation of the two logFCs.}
}
\value{
MA-plot \link{ggplot}.
}
\description{
MA-plot addaptation to show the shrinking effect.
}
\examples{
library(DESeq2)
dds <- makeExampleDESeqDataSet(betaSD=1)
dds <- DESeq(dds)
res <- degComps(dds, contrast = list("condition_B_vs_A"))
degMA(res)
}
\author{
Victor Barrera

Rory Kirchner

Lorena Pantano
}
