% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistic-wmean.R
\name{run_wmean}
\alias{run_wmean}
\title{Weighted Mean (WMEAN)}
\usage{
run_wmean(
  mat,
  network,
  .source = source,
  .target = target,
  .mor = mor,
  .likelihood = likelihood,
  times = 100,
  seed = 42,
  sparse = TRUE,
  randomize_type = "rows",
  minsize = 5
)
}
\arguments{
\item{mat}{Matrix to evaluate (e.g. expression matrix).
Target nodes in rows and conditions in columns.
\code{rownames(mat)} must have at least one intersection with the elements
in \code{network} \code{.target} column.}

\item{network}{Tibble or dataframe with edges and it's associated metadata.}

\item{.source}{Column with source nodes.}

\item{.target}{Column with target nodes.}

\item{.mor}{Column with edge mode of regulation (i.e. mor).}

\item{.likelihood}{Deprecated argument. Now it will always be set to 1.}

\item{times}{How many permutations to do?}

\item{seed}{A single value, interpreted as an integer, or NULL for random
number generation.}

\item{sparse}{Should the matrices used for the calculation be sparse?}

\item{randomize_type}{How to randomize the expression matrix.}

\item{minsize}{Integer indicating the minimum number of targets per source.}
}
\value{
A long format tibble of the enrichment scores for each source
across the samples. Resulting tibble contains the following columns:
\enumerate{
\item \code{statistic}: Indicates which method is associated with which score.
\item \code{source}: Source nodes of \code{network}.
\item \code{condition}: Condition representing each column of \code{mat}.
\item \code{score}: Regulatory activity (enrichment score).
\item \code{p_value}: p-value for the score of the method.
}
}
\description{
Calculates regulatory activities using WMEAN.
}
\details{
WMEAN infers regulator activities by first multiplying each target feature by
its associated weight which then are summed to an enrichment score
\code{wmean}. Furthermore, permutations of random target features can
be performed to obtain a null distribution that can be used to compute a
z-score \code{norm_wmean}, or a corrected estimate \code{corr_wmean} by multiplying
\code{wmean} by the minus log10 of the obtained empirical p-value.
}
\examples{
inputs_dir <- system.file("testdata", "inputs", package = "decoupleR")

mat <- readRDS(file.path(inputs_dir, "mat.rds"))
net <- readRDS(file.path(inputs_dir, "net.rds"))

run_wmean(mat, net, minsize=0)
}
\seealso{
Other decoupleR statistics: 
\code{\link{decouple}()},
\code{\link{run_aucell}()},
\code{\link{run_fgsea}()},
\code{\link{run_gsva}()},
\code{\link{run_mdt}()},
\code{\link{run_mlm}()},
\code{\link{run_ora}()},
\code{\link{run_udt}()},
\code{\link{run_ulm}()},
\code{\link{run_viper}()},
\code{\link{run_wsum}()}
}
\concept{decoupleR statistics}
