\name{sdf.subset}
\alias{sdf.subset}
\title{Subset a SDF and return SDF segements for selected compounds}
\description{
'sdf.subset' will take a descriptor database generated by 'cmp.parse' and an
array of indices, and return an SDF string consisting of SDFs for compounds
corresponding to that list of indices. The returned value is a character
string.
}
\usage{
sdf.subset(db, cmps)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{db}{The database generated by 'cmp.parse'}
  \item{cmps}{An array of indecies that correspond to a set of selected
	  compounds from the database}
}
\details{
	'sdf.subset' depends on information embedded in the descriptor database
	returned by 'cmp.parse'. It also relies on the availability of the
	original SDF where the database has been generated from.  Basically,
	when 'cmp.parse' parses the original SDF file, it will store the path
	of that SDF file as well as offset information for SDF segment in that
	file. Therefore, if the SDF file has been changed or deleted,
	'sdf.subset' cannot function properly.

	The result SDF will also have names added to compounds if they are not
	present in the original SDF.
}
\value{
	Return a character string whose content is the concatenation of SDFs
	for the selected compounds.
}

\seealso{\code{\link{cmp.parse}}, \code{\link{sdf.visualize}}}
\examples{
## Note: this functionality has become obsolete since the introduction of the 
## 'SDFset' and 'apset' S4 classes.

# load sample database from web
# db <- cmp.parse("http://bioweb.ucr.edu/ChemMineV2/static/example_db.sdf")
# select SDF for 1st and 2nd compound in that SDF
# sdf_segments <- sdf.subset(db, c(1, 2))
# now sdf_segments containt the 2 SDFs for those 2 compounds
}
\keyword{utilities}
