# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.resource import PolicyClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-resource
# USAGE
    python create_policy_assignment_non_compliance_messages.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = PolicyClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.policy_assignments.create(
        scope="subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2",
        policy_assignment_name="securityInitAssignment",
        parameters={
            "properties": {
                "displayName": "Enforce security policies",
                "nonComplianceMessages": [
                    {
                        "message": "Resources must comply with all internal security policies. See <internal site URL> for more info."
                    },
                    {
                        "message": "Resource names must start with 'DeptA' and end with '-LC'.",
                        "policyDefinitionReferenceId": "10420126870854049575",
                    },
                    {
                        "message": "Storage accounts must have firewall rules configured.",
                        "policyDefinitionReferenceId": "8572513655450389710",
                    },
                ],
                "policyDefinitionId": "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policySetDefinitions/securityInitiative",
            }
        },
    )
    print(response)


# x-ms-original-file: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/createPolicyAssignmentNonComplianceMessages.json
if __name__ == "__main__":
    main()
