# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class ConfigurationData(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The SAP instance specific configuration data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar saps: Provide the SAPS for each server of the SAP system. This should be a non-zero
     value. For example, 1000.
    :vartype saps: int
    :ivar cpu: Provide the CPU value of the server. For example, 16, 32 etc.
    :vartype cpu: int
    :ivar cpu_type: Provide the CPU architecture type of the server. For example, Xeon Platinum
     8171M, Xeon E5-2673 v3.
    :vartype cpu_type: str
    :ivar cpu_in_mhz: Provide the CPU clock speed of the server in MHz. This should be a non-zero
     value. For example, 2100.
    :vartype cpu_in_mhz: int
    :ivar ram: Provide the RAM of the server. This should be a non-zero value. For example, 256.
    :vartype ram: int
    :ivar hardware_manufacturer: Provide the HW manufacturer company of the server.  For example,
     Microsoft Corporation.
    :vartype hardware_manufacturer: str
    :ivar model: Specify if the Hardware is a physical server or virtual machine.
    :vartype model: str
    :ivar total_disk_size_gb: Provide the total disk volume capacity in GB. Add the disk volume for
     each individual disks and provide the total sum in this field.
    :vartype total_disk_size_gb: int
    :ivar total_disk_iops: Provide the total disk IOPS capacity. Add the disk volume for each
     individual disk and provide the sum total in this field.
    :vartype total_disk_iops: int
    :ivar database_type: The database of this is a server instance. Applicable only if SAP instance
     type for this server instance is 'DB'. Known values are: "Adabas", "Oracle", "SAPMaxDB", "Db2",
     "SAPASE", "SQLServer", "Informix", "SAPDB", and "HANA".
    :vartype database_type: str or ~azure.mgmt.migrationdiscoverysap.models.DatabaseType
    :ivar target_hana_ram_size_gb: Provide the target HANA database size you need. Applicable only
     if SAP instance type for this server instance is 'DB' and you are migrating an AnyDb database
     to SAP S/4HANA.
    :vartype target_hana_ram_size_gb: int
    """

    _validation = {
        "saps": {"readonly": True},
        "cpu": {"readonly": True},
        "cpu_type": {"readonly": True},
        "cpu_in_mhz": {"readonly": True},
        "ram": {"readonly": True},
        "hardware_manufacturer": {"readonly": True},
        "model": {"readonly": True},
        "total_disk_size_gb": {"readonly": True},
        "total_disk_iops": {"readonly": True},
        "database_type": {"readonly": True},
        "target_hana_ram_size_gb": {"readonly": True},
    }

    _attribute_map = {
        "saps": {"key": "saps", "type": "int"},
        "cpu": {"key": "cpu", "type": "int"},
        "cpu_type": {"key": "cpuType", "type": "str"},
        "cpu_in_mhz": {"key": "cpuInMhz", "type": "int"},
        "ram": {"key": "ram", "type": "int"},
        "hardware_manufacturer": {"key": "hardwareManufacturer", "type": "str"},
        "model": {"key": "model", "type": "str"},
        "total_disk_size_gb": {"key": "totalDiskSizeGB", "type": "int"},
        "total_disk_iops": {"key": "totalDiskIops", "type": "int"},
        "database_type": {"key": "databaseType", "type": "str"},
        "target_hana_ram_size_gb": {"key": "targetHanaRamSizeGB", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.saps = None
        self.cpu = None
        self.cpu_type = None
        self.cpu_in_mhz = None
        self.ram = None
        self.hardware_manufacturer = None
        self.model = None
        self.total_disk_size_gb = None
        self.total_disk_iops = None
        self.database_type = None
        self.target_hana_ram_size_gb = None


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDefinition(_serialization.Model):
    """Error definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Service specific error code which serves as the substatus for the HTTP error code.
    :vartype code: str
    :ivar message: Description of the error.
    :vartype message: str
    :ivar recommendation: Description of the recommendation.
    :vartype recommendation: str
    :ivar details: Internal error details.
    :vartype details: list[~azure.mgmt.migrationdiscoverysap.models.ErrorDefinition]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "recommendation": {"readonly": True},
        "details": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "recommendation": {"key": "recommendation", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDefinition]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.recommendation = None
        self.details = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.migrationdiscoverysap.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.migrationdiscoverysap.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.migrationdiscoverysap.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.migrationdiscoverysap.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class PerformanceData(_serialization.Model):
    """The SAP instance specific performance data.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ExcelPerformanceData, NativePerformanceData

    All required parameters must be populated in order to send to Azure.

    :ivar data_source: The data source of the performance data. Required. Known values are: "Excel"
     and "Native".
    :vartype data_source: str or ~azure.mgmt.migrationdiscoverysap.models.DataSource
    """

    _validation = {
        "data_source": {"required": True},
    }

    _attribute_map = {
        "data_source": {"key": "dataSource", "type": "str"},
    }

    _subtype_map = {"data_source": {"Excel": "ExcelPerformanceData", "Native": "NativePerformanceData"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.data_source: Optional[str] = None


class ExcelPerformanceData(PerformanceData):
    """The SAP instance specific performance data for Excel import.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar data_source: The data source of the performance data. Required. Known values are: "Excel"
     and "Native".
    :vartype data_source: str or ~azure.mgmt.migrationdiscoverysap.models.DataSource
    :ivar max_cpu_load: Provide the max CPU percentage load on the server. Omit the percentage
     symbol while filling this value.
    :vartype max_cpu_load: int
    :ivar total_source_db_size_gb: Provide the source Database size in GB. Applicable only if SAP
     instance type for this server instance is 'DB'.
    :vartype total_source_db_size_gb: int
    """

    _validation = {
        "data_source": {"required": True},
        "max_cpu_load": {"readonly": True},
        "total_source_db_size_gb": {"readonly": True},
    }

    _attribute_map = {
        "data_source": {"key": "dataSource", "type": "str"},
        "max_cpu_load": {"key": "maxCpuLoad", "type": "int"},
        "total_source_db_size_gb": {"key": "totalSourceDbSizeGB", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.data_source: str = "Excel"
        self.max_cpu_load = None
        self.total_source_db_size_gb = None


class ExtendedLocation(_serialization.Model):
    """The extended location definition.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The extended location type. Required.
    :vartype type: str
    :ivar name: The extended location name. Required.
    :vartype name: str
    """

    _validation = {
        "type": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, type: str, name: str, **kwargs: Any) -> None:
        """
        :keyword type: The extended location type. Required.
        :paramtype type: str
        :keyword name: The extended location name. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.name = name


class NativePerformanceData(PerformanceData):
    """The SAP instance specific performance data for native discovery.

    All required parameters must be populated in order to send to Azure.

    :ivar data_source: The data source of the performance data. Required. Known values are: "Excel"
     and "Native".
    :vartype data_source: str or ~azure.mgmt.migrationdiscoverysap.models.DataSource
    """

    _validation = {
        "data_source": {"required": True},
    }

    _attribute_map = {
        "data_source": {"key": "dataSource", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.data_source: str = "Native"


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.migrationdiscoverysap.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.migrationdiscoverysap.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.migrationdiscoverysap.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.migrationdiscoverysap.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.migrationdiscoverysap.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class OperationStatusResult(_serialization.Model):
    """The current status of an async operation.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified ID for the async operation.
    :vartype id: str
    :ivar name: Name of the async operation.
    :vartype name: str
    :ivar status: Operation status. Required.
    :vartype status: str
    :ivar percent_complete: Percent of the operation that is complete.
    :vartype percent_complete: float
    :ivar start_time: The start time of the operation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the operation.
    :vartype end_time: ~datetime.datetime
    :ivar operations: The operations list.
    :vartype operations: list[~azure.mgmt.migrationdiscoverysap.models.OperationStatusResult]
    :ivar error: If present, details of the operation error.
    :vartype error: ~azure.mgmt.migrationdiscoverysap.models.ErrorDetail
    """

    _validation = {
        "status": {"required": True},
        "percent_complete": {"maximum": 100, "minimum": 0},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "percent_complete": {"key": "percentComplete", "type": "float"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "operations": {"key": "operations", "type": "[OperationStatusResult]"},
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(
        self,
        *,
        status: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        percent_complete: Optional[float] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        operations: Optional[List["_models.OperationStatusResult"]] = None,
        error: Optional["_models.ErrorDetail"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Fully qualified ID for the async operation.
        :paramtype id: str
        :keyword name: Name of the async operation.
        :paramtype name: str
        :keyword status: Operation status. Required.
        :paramtype status: str
        :keyword percent_complete: Percent of the operation that is complete.
        :paramtype percent_complete: float
        :keyword start_time: The start time of the operation.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time of the operation.
        :paramtype end_time: ~datetime.datetime
        :keyword operations: The operations list.
        :paramtype operations: list[~azure.mgmt.migrationdiscoverysap.models.OperationStatusResult]
        :keyword error: If present, details of the operation error.
        :paramtype error: ~azure.mgmt.migrationdiscoverysap.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.status = status
        self.percent_complete = percent_complete
        self.start_time = start_time
        self.end_time = end_time
        self.operations = operations
        self.error = error


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.migrationdiscoverysap.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.migrationdiscoverysap.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.migrationdiscoverysap.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class SAPDiscoverySite(TrackedResource):
    """Define the SAP Migration discovery site resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.migrationdiscoverysap.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.migrationdiscoverysap.models.SAPDiscoverySiteProperties
    :ivar extended_location: The extended location definition.
    :vartype extended_location: ~azure.mgmt.migrationdiscoverysap.models.ExtendedLocation
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "SAPDiscoverySiteProperties"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.SAPDiscoverySiteProperties"] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.migrationdiscoverysap.models.SAPDiscoverySiteProperties
        :keyword extended_location: The extended location definition.
        :paramtype extended_location: ~azure.mgmt.migrationdiscoverysap.models.ExtendedLocation
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties
        self.extended_location = extended_location


class SAPDiscoverySiteListResult(_serialization.Model):
    """The response of a SAPDiscoverySite list operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The SAPDiscoverySite items on this page. Required.
    :vartype value: list[~azure.mgmt.migrationdiscoverysap.models.SAPDiscoverySite]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SAPDiscoverySite]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.SAPDiscoverySite"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The SAPDiscoverySite items on this page. Required.
        :paramtype value: list[~azure.mgmt.migrationdiscoverysap.models.SAPDiscoverySite]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SAPDiscoverySiteProperties(_serialization.Model):
    """Defines the SAP Migration discovery site resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar master_site_id: The master site ID from Azure Migrate.
    :vartype master_site_id: str
    :ivar migrate_project_id: The migrate project ID from Azure Migrate.
    :vartype migrate_project_id: str
    :ivar provisioning_state: Defines the provisioning states. Known values are: "Succeeded",
     "Updating", "Failed", "Creating", "Canceled", "Accepted", "Deleting", and "Unknown".
    :vartype provisioning_state: str or ~azure.mgmt.migrationdiscoverysap.models.ProvisioningState
    :ivar errors: Indicates any errors on the SAP Migration discovery site resource.
    :vartype errors: ~azure.mgmt.migrationdiscoverysap.models.SAPMigrateError
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "errors": {"readonly": True},
    }

    _attribute_map = {
        "master_site_id": {"key": "masterSiteId", "type": "str"},
        "migrate_project_id": {"key": "migrateProjectId", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "errors": {"key": "errors", "type": "SAPMigrateError"},
    }

    def __init__(
        self, *, master_site_id: Optional[str] = None, migrate_project_id: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword master_site_id: The master site ID from Azure Migrate.
        :paramtype master_site_id: str
        :keyword migrate_project_id: The migrate project ID from Azure Migrate.
        :paramtype migrate_project_id: str
        """
        super().__init__(**kwargs)
        self.master_site_id = master_site_id
        self.migrate_project_id = migrate_project_id
        self.provisioning_state = None
        self.errors = None


class SAPDiscoverySiteTagsUpdate(_serialization.Model):
    """The type used for updating tags in SAPDiscoverySite resources.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class SAPInstance(TrackedResource):
    """Define the SAP Instance resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.migrationdiscoverysap.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.migrationdiscoverysap.models.SAPInstanceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "SAPInstanceProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.SAPInstanceProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.migrationdiscoverysap.models.SAPInstanceProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties


class SAPInstanceListResult(_serialization.Model):
    """The response of a SAPInstance list operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The SAPInstance items on this page. Required.
    :vartype value: list[~azure.mgmt.migrationdiscoverysap.models.SAPInstance]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SAPInstance]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.SAPInstance"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The SAPInstance items on this page. Required.
        :paramtype value: list[~azure.mgmt.migrationdiscoverysap.models.SAPInstance]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SAPInstanceProperties(_serialization.Model):
    """Defines the SAP Instance properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar system_sid: This is the SID of SAP System. Keeping this not equal to ID as different
     landscapes can have repeated System SID IDs.
    :vartype system_sid: str
    :ivar environment: The Environment; PRD, QA, DEV, etc to which SAP system belongs to. Select
     from the list of available dropdown values. Known values are: "Production", "PreProduction",
     "Test", "QualityAssurance", "Development", "Sandbox", "DisasterRecovery", and "Training".
    :vartype environment: str or ~azure.mgmt.migrationdiscoverysap.models.SapInstanceEnvironment
    :ivar landscape_sid: This is the SID of the production system in a landscape.  An SAP system
     could itself be a production SID or a part of a landscape with a different Production SID. This
     field can be used to relate non-prod SIDs, other components, SID (WEBDISP) to the prod SID.
     Enter the value of Production SID.
    :vartype landscape_sid: str
    :ivar application: Enter a business function/department identifier to group multiple SIDs.
    :vartype application: str
    :ivar provisioning_state: Defines the provisioning states. Known values are: "Succeeded",
     "Updating", "Failed", "Creating", "Canceled", "Accepted", "Deleting", and "Unknown".
    :vartype provisioning_state: str or ~azure.mgmt.migrationdiscoverysap.models.ProvisioningState
    :ivar errors: Defines the errors related to SAP Instance resource.
    :vartype errors: ~azure.mgmt.migrationdiscoverysap.models.SAPMigrateError
    """

    _validation = {
        "system_sid": {"readonly": True},
        "environment": {"readonly": True},
        "landscape_sid": {"readonly": True},
        "application": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "errors": {"readonly": True},
    }

    _attribute_map = {
        "system_sid": {"key": "systemSid", "type": "str"},
        "environment": {"key": "environment", "type": "str"},
        "landscape_sid": {"key": "landscapeSid", "type": "str"},
        "application": {"key": "application", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "errors": {"key": "errors", "type": "SAPMigrateError"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.system_sid = None
        self.environment = None
        self.landscape_sid = None
        self.application = None
        self.provisioning_state = None
        self.errors = None


class SAPInstanceTagsUpdate(_serialization.Model):
    """The type used for updating tags in SAPInstance resources.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class SAPMigrateError(_serialization.Model):
    """An error response from the SAP migrate resources.

    :ivar properties: The SAP Discovery site resource error body.
    :vartype properties: ~azure.mgmt.migrationdiscoverysap.models.ErrorDefinition
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "ErrorDefinition"},
    }

    def __init__(self, *, properties: Optional["_models.ErrorDefinition"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The SAP Discovery site resource error body.
        :paramtype properties: ~azure.mgmt.migrationdiscoverysap.models.ErrorDefinition
        """
        super().__init__(**kwargs)
        self.properties = properties


class ServerInstance(ProxyResource):
    """Define the Server Instance resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.migrationdiscoverysap.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.migrationdiscoverysap.models.ServerInstanceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "ServerInstanceProperties"},
    }

    def __init__(self, *, properties: Optional["_models.ServerInstanceProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.migrationdiscoverysap.models.ServerInstanceProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ServerInstanceListResult(_serialization.Model):
    """The response of a ServerInstance list operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The ServerInstance items on this page. Required.
    :vartype value: list[~azure.mgmt.migrationdiscoverysap.models.ServerInstance]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ServerInstance]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.ServerInstance"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The ServerInstance items on this page. Required.
        :paramtype value: list[~azure.mgmt.migrationdiscoverysap.models.ServerInstance]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ServerInstanceProperties(_serialization.Model):
    """Defines the SAP Instance properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar server_name: This is the Virtual Machine Name of the SAP system. Add all the virtual
     machines attached to an SAP system which you wish to migrate to Azure. Keeping this not equal
     to ID as for single tier all InstanceTypes would be on same server, leading to multiple
     resources with same servername.
    :vartype server_name: str
    :ivar sap_instance_type: Defines the type SAP instance on this server instance. Known values
     are: "ASCS", "DB", "APP", "SCS", and "WEBDISP".
    :vartype sap_instance_type: str or ~azure.mgmt.migrationdiscoverysap.models.SapInstanceType
    :ivar instance_sid: This is the Instance SID for ASCS/AP/DB instance.  An SAP system with HANA
     database for example could have a different SID for database Instance than that of ASCS
     instance.
    :vartype instance_sid: str
    :ivar sap_product: This is the SAP Application Component; e.g. SAP S/4HANA 2022, SAP ERP
     ENHANCE PACKAGE.
    :vartype sap_product: str
    :ivar sap_product_version: Provide the product version of the SAP product.
    :vartype sap_product_version: str
    :ivar operating_system: This is Operating System on which the host server is running. Known
     values are: "IBMAIX", "RedHat", "SUSE", "Solaris", "Unix", and "WindowsServer".
    :vartype operating_system: str or ~azure.mgmt.migrationdiscoverysap.models.OperatingSystem
    :ivar configuration_data: Configuration data for this server instance.
    :vartype configuration_data: ~azure.mgmt.migrationdiscoverysap.models.ConfigurationData
    :ivar performance_data: Configuration data for this server instance.
    :vartype performance_data: ~azure.mgmt.migrationdiscoverysap.models.PerformanceData
    :ivar provisioning_state: Defines the provisioning states. Known values are: "Succeeded",
     "Updating", "Failed", "Creating", "Canceled", "Accepted", "Deleting", and "Unknown".
    :vartype provisioning_state: str or ~azure.mgmt.migrationdiscoverysap.models.ProvisioningState
    :ivar errors: Defines the errors related to SAP Instance resource.
    :vartype errors: ~azure.mgmt.migrationdiscoverysap.models.SAPMigrateError
    """

    _validation = {
        "server_name": {"readonly": True},
        "sap_instance_type": {"readonly": True},
        "instance_sid": {"readonly": True},
        "sap_product": {"readonly": True},
        "sap_product_version": {"readonly": True},
        "operating_system": {"readonly": True},
        "configuration_data": {"readonly": True},
        "performance_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "errors": {"readonly": True},
    }

    _attribute_map = {
        "server_name": {"key": "serverName", "type": "str"},
        "sap_instance_type": {"key": "sapInstanceType", "type": "str"},
        "instance_sid": {"key": "instanceSid", "type": "str"},
        "sap_product": {"key": "sapProduct", "type": "str"},
        "sap_product_version": {"key": "sapProductVersion", "type": "str"},
        "operating_system": {"key": "operatingSystem", "type": "str"},
        "configuration_data": {"key": "configurationData", "type": "ConfigurationData"},
        "performance_data": {"key": "performanceData", "type": "PerformanceData"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "errors": {"key": "errors", "type": "SAPMigrateError"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.server_name = None
        self.sap_instance_type = None
        self.instance_sid = None
        self.sap_product = None
        self.sap_product_version = None
        self.operating_system = None
        self.configuration_data = None
        self.performance_data = None
        self.provisioning_state = None
        self.errors = None


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.migrationdiscoverysap.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.migrationdiscoverysap.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.migrationdiscoverysap.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.migrationdiscoverysap.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UpdateServerInstanceRequest(_serialization.Model):
    """Defines the request body for updating Server Instances resource.

    :ivar properties: Server instances properties.
    :vartype properties: ~azure.mgmt.migrationdiscoverysap.models.ServerInstanceProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "ServerInstanceProperties"},
    }

    def __init__(self, *, properties: Optional["_models.ServerInstanceProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Server instances properties.
        :paramtype properties: ~azure.mgmt.migrationdiscoverysap.models.ServerInstanceProperties
        """
        super().__init__(**kwargs)
        self.properties = properties
