/*
     This file is part of GNUnet.
     (C) 2010, 2011 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/lib/trayicon.c
 * @brief trayicon support
 * @author Christian Grothoff
 */
#include "gnunet_gtk_config.h"
#include "gnunet_gtk.h"


/**
 * Our tray icon.
 */
static GtkStatusIcon *tray_icon;

/**
 * The main window.
 */
static GtkWindow *main_window;


/**
 * We got a click on our tray icon. Toggle visibility of the main
 * window.
 */
static void
tray_icon_on_click (GtkStatusIcon * status_icon, gpointer user_data)
{
  if (gtk_window_is_active (main_window))
    gtk_widget_hide (GTK_WIDGET (main_window));
  else
    gtk_window_present (main_window);
}


/**
 * We got a right-click on the tray icon. Display the context
 * menu (which should have a 'quit' button).
 */
static int
tray_icon_on_menu (GtkWidget * widget, GdkEvent * event, gpointer user_data)
{
  GtkMenu *tray_menu;
  GdkEventButton *event_button;
  GtkBuilder *builder;

  if (event->type == GDK_BUTTON_PRESS)
  {
    event_button = (GdkEventButton *) event;
    if (event_button->button == 3)
    {
      builder = GNUNET_GTK_get_new_builder ("gnunet_gtk_status_bar_menu.glade", NULL);
      tray_menu =
          GTK_MENU (gtk_builder_get_object
                    (builder, "GNUNET_GTK_status_bar_popup_menu"));
      gtk_menu_popup (tray_menu, NULL, NULL, NULL, NULL, event_button->button,
                      event_button->time);
      g_object_unref (builder);
    }
  }
  return FALSE;
}


/**
 * Create our tray icon.
 *
 * @param main handle to the main window (show or hide)
 * @param icon_name name of the tray icon file
 * @param tooltip tooltip for the tray icon
 */
void
GNUNET_GTK_tray_icon_create (GtkWindow * main, const char *icon_name,
                             const char *tooltip)
{
  if (NULL != tray_icon)
  {
    GNUNET_break (0);
    return;
  }
  main_window = main;
  tray_icon = gtk_status_icon_new ();
  g_signal_connect (G_OBJECT (tray_icon), "activate",
                    G_CALLBACK (tray_icon_on_click), NULL);
  g_signal_connect (G_OBJECT (tray_icon), "button_press_event",
                    G_CALLBACK (tray_icon_on_menu), tray_icon);
  gtk_status_icon_set_from_icon_name (tray_icon, icon_name);
  gtk_status_icon_set_tooltip_text (tray_icon, tooltip);
  gtk_status_icon_set_visible (tray_icon, TRUE);
}


/**
 * Destroy the tray icon.
 */
void
GNUNET_GTK_tray_icon_destroy ()
{
  if (tray_icon == NULL)
    return;
  g_object_unref (G_OBJECT (tray_icon));
  tray_icon = NULL;
  main_window = NULL;
}

/* end of trayicon.c */
