# Test cases used by `./ryu_printf_spec.cr`

# The following two lists store: {value, fixed_precision, exp_precision}
# Iterate over them via macros only, otherwise the entire array literal will be
# materialized!
# The original specs contain also the full expected results which would have
# increased the file size by over 18x. Here we assume that `BigFloat#to_s` and
# `BigDecimal#to_s` are always correct, so that we don't have to write the long
# results in the source code.

# These values test every power of ten that's within the range of doubles.
ALL_POWERS_OF_TEN = [
  {1e-323, 1073, 749},
  {1e-322, 1072, 749},
  {1e-321, 1073, 751},
  {1e-320, 1071, 750},
  {1e-319, 1070, 750},
  {1e-318, 1073, 754},
  {1e-317, 1074, 757},
  {1e-316, 1074, 757},
  {1e-315, 1074, 758},
  {1e-314, 1074, 759},
  {1e-313, 1074, 761},
  {1e-312, 1074, 761},
  {1e-311, 1074, 762},
  {1e-310, 1074, 763},
  {1e-309, 1074, 765},
  {1e-308, 1073, 764},
  {1e-307, 1072, 764},
  {1e-306, 1069, 763},
  {1e-305, 1066, 760},
  {1e-304, 1062, 757},
  {1e-303, 1059, 755},
  {1e-302, 1054, 751},
  {1e-301, 1052, 751},
  {1e-300, 1049, 749},
  {1e-299, 1046, 746},
  {1e-298, 1042, 743},
  {1e-297, 1039, 742},
  {1e-296, 1035, 739},
  {1e-295, 1032, 737},
  {1e-294, 1029, 735},
  {1e-293, 1022, 729},
  {1e-292, 1021, 729},
  {1e-291, 1019, 727},
  {1e-290, 1015, 725},
  {1e-289, 1012, 723},
  {1e-288, 1009, 721},
  {1e-287, 1006, 719},
  {1e-286, 1003, 717},
  {1e-285, 999, 714},
  {1e-284, 996, 712},
  {1e-283, 993, 709},
  {1e-282, 986, 704},
  {1e-281, 985, 704},
  {1e-280, 981, 700},
  {1e-279, 979, 700},
  {1e-278, 976, 697},
  {1e-277, 973, 695},
  {1e-276, 957, 681},
  {1e-275, 966, 690},
  {1e-274, 963, 688},
  {1e-273, 954, 681},
  {1e-272, 956, 683},
  {1e-271, 953, 681},
  {1e-270, 948, 678},
  {1e-269, 944, 674},
  {1e-268, 943, 674},
  {1e-267, 935, 667},
  {1e-266, 934, 667},
  {1e-265, 933, 667},
  {1e-264, 925, 661},
  {1e-263, 924, 661},
  {1e-262, 923, 661},
  {1e-261, 920, 658},
  {1e-260, 916, 655},
  {1e-259, 909, 650},
  {1e-258, 910, 651},
  {1e-257, 904, 646},
  {1e-256, 903, 646},
  {1e-255, 898, 643},
  {1e-254, 894, 639},
  {1e-253, 890, 637},
  {1e-252, 890, 637},
  {1e-251, 886, 635},
  {1e-250, 881, 631},
  {1e-249, 880, 631},
  {1e-248, 876, 627},
  {1e-247, 872, 625},
  {1e-246, 870, 623},
  {1e-245, 863, 617},
  {1e-244, 862, 617},
  {1e-243, 860, 616},
  {1e-242, 850, 607},
  {1e-241, 849, 607},
  {1e-240, 848, 607},
  {1e-239, 845, 606},
  {1e-238, 840, 601},
  {1e-237, 839, 601},
  {1e-236, 835, 599},
  {1e-235, 829, 593},
  {1e-234, 828, 593},
  {1e-233, 827, 593},
  {1e-232, 823, 591},
  {1e-231, 819, 587},
  {1e-230, 817, 587},
  {1e-229, 813, 584},
  {1e-228, 810, 582},
  {1e-227, 807, 579},
  {1e-226, 803, 576},
  {1e-225, 799, 573},
  {1e-224, 796, 572},
  {1e-223, 792, 568},
  {1e-222, 790, 568},
  {1e-221, 787, 566},
  {1e-220, 783, 562},
  {1e-219, 777, 558},
  {1e-218, 776, 558},
  {1e-217, 773, 556},
  {1e-216, 768, 552},
  {1e-215, 767, 552},
  {1e-214, 763, 548},
  {1e-213, 758, 544},
  {1e-212, 757, 544},
  {1e-211, 753, 542},
  {1e-210, 747, 537},
  {1e-209, 746, 537},
  {1e-208, 740, 532},
  {1e-207, 740, 532},
  {1e-206, 737, 531},
  {1e-205, 731, 526},
  {1e-204, 730, 526},
  {1e-203, 723, 520},
  {1e-202, 722, 520},
  {1e-201, 720, 518},
  {1e-200, 715, 514},
  {1e-199, 714, 514},
  {1e-198, 709, 510},
  {1e-197, 706, 508},
  {1e-196, 703, 507},
  {1e-195, 699, 504},
  {1e-194, 697, 503},
  {1e-193, 693, 500},
  {1e-192, 689, 497},
  {1e-191, 684, 493},
  {1e-190, 683, 493},
  {1e-189, 680, 491},
  {1e-188, 676, 487},
  {1e-187, 672, 485},
  {1e-186, 669, 482},
  {1e-185, 666, 480},
  {1e-184, 663, 479},
  {1e-183, 660, 477},
  {1e-182, 655, 473},
  {1e-181, 654, 473},
  {1e-180, 647, 467},
  {1e-179, 646, 467},
  {1e-178, 641, 462},
  {1e-177, 640, 462},
  {1e-176, 632, 455},
  {1e-175, 631, 455},
  {1e-174, 630, 455},
  {1e-173, 624, 451},
  {1e-172, 623, 451},
  {1e-171, 618, 446},
  {1e-170, 617, 446},
  {1e-169, 614, 445},
  {1e-168, 610, 442},
  {1e-167, 607, 440},
  {1e-166, 604, 438},
  {1e-165, 600, 435},
  {1e-164, 597, 432},
  {1e-163, 594, 430},
  {1e-162, 591, 428},
  {1e-161, 587, 426},
  {1e-160, 582, 421},
  {1e-159, 581, 421},
  {1e-158, 577, 419},
  {1e-157, 574, 416},
  {1e-156, 571, 415},
  {1e-155, 567, 412},
  {1e-154, 563, 408},
  {1e-153, 561, 408},
  {1e-152, 557, 405},
  {1e-151, 553, 401},
  {1e-150, 551, 401},
  {1e-149, 547, 397},
  {1e-148, 544, 395},
  {1e-147, 540, 392},
  {1e-146, 538, 392},
  {1e-145, 534, 388},
  {1e-144, 527, 382},
  {1e-143, 526, 382},
  {1e-142, 521, 379},
  {1e-141, 520, 379},
  {1e-140, 517, 376},
  {1e-139, 514, 375},
  {1e-138, 511, 373},
  {1e-137, 508, 370},
  {1e-136, 504, 368},
  {1e-135, 499, 364},
  {1e-134, 498, 364},
  {1e-133, 493, 360},
  {1e-132, 487, 354},
  {1e-131, 486, 354},
  {1e-130, 482, 352},
  {1e-129, 477, 347},
  {1e-128, 478, 350},
  {1e-127, 473, 346},
  {1e-126, 470, 343},
  {1e-125, 468, 343},
  {1e-124, 464, 339},
  {1e-123, 459, 336},
  {1e-122, 458, 336},
  {1e-121, 452, 330},
  {1e-120, 451, 330},
  {1e-119, 448, 329},
  {1e-118, 444, 325},
  {1e-117, 441, 324},
  {1e-116, 437, 320},
  {1e-115, 431, 316},
  {1e-114, 430, 316},
  {1e-113, 428, 314},
  {1e-112, 424, 311},
  {1e-111, 421, 310},
  {1e-110, 417, 307},
  {1e-109, 414, 304},
  {1e-108, 411, 303},
  {1e-107, 407, 300},
  {1e-106, 405, 298},
  {1e-105, 401, 295},
  {1e-104, 398, 293},
  {1e-103, 395, 291},
  {1e-102, 391, 288},
  {1e-101, 388, 287},
  {1e-100, 381, 281},
  {1e-99, 380, 281},
  {1e-98, 378, 279},
  {1e-97, 375, 278},
  {1e-96, 370, 273},
  {1e-95, 368, 272},
  {1e-94, 364, 269},
  {1e-93, 360, 266},
  {1e-92, 358, 265},
  {1e-91, 355, 264},
  {1e-90, 351, 260},
  {1e-89, 348, 259},
  {1e-88, 345, 256},
  {1e-87, 342, 255},
  {1e-86, 338, 252},
  {1e-85, 334, 248},
  {1e-84, 328, 244},
  {1e-83, 327, 244},
  {1e-82, 320, 237},
  {1e-81, 319, 237},
  {1e-80, 318, 237},
  {1e-79, 313, 233},
  {1e-78, 312, 233},
  {1e-77, 306, 228},
  {1e-76, 305, 228},
  {1e-75, 299, 223},
  {1e-74, 298, 223},
  {1e-73, 295, 221},
  {1e-72, 291, 218},
  {1e-71, 287, 215},
  {1e-70, 285, 214},
  {1e-69, 280, 210},
  {1e-68, 278, 210},
  {1e-67, 275, 207},
  {1e-66, 271, 204},
  {1e-65, 268, 202},
  {1e-64, 265, 200},
  {1e-63, 262, 199},
  {1e-62, 255, 193},
  {1e-61, 254, 193},
  {1e-60, 251, 190},
  {1e-59, 245, 186},
  {1e-58, 244, 186},
  {1e-57, 242, 184},
  {1e-56, 238, 182},
  {1e-55, 235, 179},
  {1e-54, 230, 176},
  {1e-53, 229, 176},
  {1e-52, 221, 169},
  {1e-51, 220, 169},
  {1e-50, 219, 169},
  {1e-49, 215, 165},
  {1e-48, 209, 160},
  {1e-47, 208, 160},
  {1e-46, 205, 159},
  {1e-45, 202, 156},
  {1e-44, 199, 154},
  {1e-43, 195, 152},
  {1e-42, 192, 150},
  {1e-41, 189, 148},
  {1e-40, 183, 142},
  {1e-39, 182, 142},
  {1e-38, 177, 138},
  {1e-37, 175, 138},
  {1e-36, 171, 134},
  {1e-35, 169, 134},
  {1e-34, 165, 130},
  {1e-33, 160, 127},
  {1e-32, 159, 127},
  {1e-31, 148, 117},
  {1e-30, 147, 117},
  {1e-29, 149, 119},
  {1e-28, 146, 117},
  {1e-27, 138, 111},
  {1e-26, 137, 111},
  {1e-25, 136, 111},
  {1e-24, 132, 107},
  {1e-23, 129, 105},
  {1e-22, 125, 103},
  {1e-21, 122, 100},
  {1e-20, 119, 98},
  {1e-19, 114, 94},
  {1e-18, 110, 92},
  {1e-17, 109, 92},
  {1e-16, 104, 87},
  {1e-15, 101, 86},
  {1e-14, 99, 84},
  {1e-13, 95, 82},
  {1e-12, 92, 79},
  {1e-11, 89, 77},
  {1e-10, 86, 76},
  {1e-9, 82, 73},
  {1e-8, 78, 70},
  {1e-7, 73, 65},
  {1e-6, 72, 65},
  {1e-5, 69, 64},
  {1e-4, 66, 62},
  {1e-3, 60, 57},
  {1e-2, 59, 57},
  {1e-1, 55, 54},
  {1e0, 0, 0},
  {1e1, 0, 0},
  {1e2, 0, 0},
  {1e3, 0, 0},
  {1e4, 0, 0},
  {1e5, 0, 0},
  {1e6, 0, 0},
  {1e7, 0, 0},
  {1e8, 0, 0},
  {1e9, 0, 0},
  {1e10, 0, 0},
  {1e11, 0, 0},
  {1e12, 0, 0},
  {1e13, 0, 0},
  {1e14, 0, 0},
  {1e15, 0, 0},
  {1e16, 0, 0},
  {1e17, 0, 0},
  {1e18, 0, 0},
  {1e19, 0, 0},
  {1e20, 0, 0},
  {1e21, 0, 0},
  {1e22, 0, 0},
  {1e23, 0, 22},
  {1e24, 0, 23},
  {1e25, 0, 25},
  {1e26, 0, 26},
  {1e27, 0, 27},
  {1e28, 0, 27},
  {1e29, 0, 28},
  {1e30, 0, 30},
  {1e31, 0, 30},
  {1e32, 0, 32},
  {1e33, 0, 32},
  {1e34, 0, 32},
  {1e35, 0, 34},
  {1e36, 0, 36},
  {1e37, 0, 36},
  {1e38, 0, 37},
  {1e39, 0, 38},
  {1e40, 0, 40},
  {1e41, 0, 41},
  {1e42, 0, 42},
  {1e43, 0, 43},
  {1e44, 0, 44},
  {1e45, 0, 44},
  {1e46, 0, 45},
  {1e47, 0, 47},
  {1e48, 0, 47},
  {1e49, 0, 48},
  {1e50, 0, 49},
  {1e51, 0, 50},
  {1e52, 0, 50},
  {1e53, 0, 50},
  {1e54, 0, 54},
  {1e55, 0, 55},
  {1e56, 0, 56},
  {1e57, 0, 57},
  {1e58, 0, 57},
  {1e59, 0, 58},
  {1e60, 0, 59},
  {1e61, 0, 59},
  {1e62, 0, 62},
  {1e63, 0, 63},
  {1e64, 0, 64},
  {1e65, 0, 64},
  {1e66, 0, 65},
  {1e67, 0, 66},
  {1e68, 0, 67},
  {1e69, 0, 68},
  {1e70, 0, 68},
  {1e71, 0, 71},
  {1e72, 0, 71},
  {1e73, 0, 72},
  {1e74, 0, 73},
  {1e75, 0, 74},
  {1e76, 0, 76},
  {1e77, 0, 76},
  {1e78, 0, 78},
  {1e79, 0, 78},
  {1e80, 0, 80},
  {1e81, 0, 80},
  {1e82, 0, 81},
  {1e83, 0, 83},
  {1e84, 0, 84},
  {1e85, 0, 85},
  {1e86, 0, 85},
  {1e87, 0, 86},
  {1e88, 0, 86},
  {1e89, 0, 88},
  {1e90, 0, 89},
  {1e91, 0, 90},
  {1e92, 0, 92},
  {1e93, 0, 92},
  {1e94, 0, 94},
  {1e95, 0, 94},
  {1e96, 0, 96},
  {1e97, 0, 97},
  {1e98, 0, 97},
  {1e99, 0, 98},
  {1e100, 0, 100},
  {1e101, 0, 100},
  {1e102, 0, 100},
  {1e103, 0, 103},
  {1e104, 0, 103},
  {1e105, 0, 104},
  {1e106, 0, 106},
  {1e107, 0, 106},
  {1e108, 0, 108},
  {1e109, 0, 108},
  {1e110, 0, 110},
  {1e111, 0, 110},
  {1e112, 0, 111},
  {1e113, 0, 113},
  {1e114, 0, 113},
  {1e115, 0, 113},
  {1e116, 0, 113},
  {1e117, 0, 117},
  {1e118, 0, 117},
  {1e119, 0, 118},
  {1e120, 0, 119},
  {1e121, 0, 121},
  {1e122, 0, 122},
  {1e123, 0, 122},
  {1e124, 0, 123},
  {1e125, 0, 124},
  {1e126, 0, 124},
  {1e127, 0, 126},
  {1e128, 0, 126},
  {1e129, 0, 128},
  {1e130, 0, 130},
  {1e131, 0, 130},
  {1e132, 0, 131},
  {1e133, 0, 133},
  {1e134, 0, 133},
  {1e135, 0, 134},
  {1e136, 0, 136},
  {1e137, 0, 137},
  {1e138, 0, 137},
  {1e139, 0, 137},
  {1e140, 0, 140},
  {1e141, 0, 141},
  {1e142, 0, 142},
  {1e143, 0, 143},
  {1e144, 0, 143},
  {1e145, 0, 144},
  {1e146, 0, 145},
  {1e147, 0, 146},
  {1e148, 0, 148},
  {1e149, 0, 148},
  {1e150, 0, 149},
  {1e151, 0, 151},
  {1e152, 0, 152},
  {1e153, 0, 152},
  {1e154, 0, 154},
  {1e155, 0, 155},
  {1e156, 0, 155},
  {1e157, 0, 155},
  {1e158, 0, 157},
  {1e159, 0, 158},
  {1e160, 0, 160},
  {1e161, 0, 161},
  {1e162, 0, 161},
  {1e163, 0, 161},
  {1e164, 0, 164},
  {1e165, 0, 164},
  {1e166, 0, 165},
  {1e167, 0, 167},
  {1e168, 0, 167},
  {1e169, 0, 167},
  {1e170, 0, 170},
  {1e171, 0, 170},
  {1e172, 0, 172},
  {1e173, 0, 173},
  {1e174, 0, 174},
  {1e175, 0, 174},
  {1e176, 0, 176},
  {1e177, 0, 176},
  {1e178, 0, 178},
  {1e179, 0, 178},
  {1e180, 0, 180},
  {1e181, 0, 180},
  {1e182, 0, 182},
  {1e183, 0, 182},
  {1e184, 0, 184},
  {1e185, 0, 184},
  {1e186, 0, 184},
  {1e187, 0, 186},
  {1e188, 0, 188},
  {1e189, 0, 188},
  {1e190, 0, 190},
  {1e191, 0, 190},
  {1e192, 0, 192},
  {1e193, 0, 193},
  {1e194, 0, 193},
  {1e195, 0, 194},
  {1e196, 0, 195},
  {1e197, 0, 195},
  {1e198, 0, 198},
  {1e199, 0, 199},
  {1e200, 0, 199},
  {1e201, 0, 201},
  {1e202, 0, 200},
  {1e203, 0, 202},
  {1e204, 0, 202},
  {1e205, 0, 205},
  {1e206, 0, 206},
  {1e207, 0, 206},
  {1e208, 0, 207},
  {1e209, 0, 209},
  {1e210, 0, 209},
  {1e211, 0, 210},
  {1e212, 0, 211},
  {1e213, 0, 212},
  {1e214, 0, 213},
  {1e215, 0, 214},
  {1e216, 0, 216},
  {1e217, 0, 216},
  {1e218, 0, 217},
  {1e219, 0, 218},
  {1e220, 0, 219},
  {1e221, 0, 221},
  {1e222, 0, 221},
  {1e223, 0, 221},
  {1e224, 0, 223},
  {1e225, 0, 224},
  {1e226, 0, 225},
  {1e227, 0, 225},
  {1e228, 0, 227},
  {1e229, 0, 228},
  {1e230, 0, 230},
  {1e231, 0, 231},
  {1e232, 0, 231},
  {1e233, 0, 232},
  {1e234, 0, 234},
  {1e235, 0, 235},
  {1e236, 0, 235},
  {1e237, 0, 235},
  {1e238, 0, 238},
  {1e239, 0, 238},
  {1e240, 0, 240},
  {1e241, 0, 241},
  {1e242, 0, 241},
  {1e243, 0, 243},
  {1e244, 0, 243},
  {1e245, 0, 245},
  {1e246, 0, 246},
  {1e247, 0, 246},
  {1e248, 0, 248},
  {1e249, 0, 247},
  {1e250, 0, 247},
  {1e251, 0, 251},
  {1e252, 0, 252},
  {1e253, 0, 252},
  {1e254, 0, 252},
  {1e255, 0, 254},
  {1e256, 0, 256},
  {1e257, 0, 256},
  {1e258, 0, 258},
  {1e259, 0, 258},
  {1e260, 0, 260},
  {1e261, 0, 258},
  {1e262, 0, 262},
  {1e263, 0, 262},
  {1e264, 0, 264},
  {1e265, 0, 265},
  {1e266, 0, 266},
  {1e267, 0, 266},
  {1e268, 0, 266},
  {1e269, 0, 269},
  {1e270, 0, 269},
  {1e271, 0, 270},
  {1e272, 0, 272},
  {1e273, 0, 272},
  {1e274, 0, 273},
  {1e275, 0, 274},
  {1e276, 0, 276},
  {1e277, 0, 277},
  {1e278, 0, 277},
  {1e279, 0, 279},
  {1e280, 0, 280},
  {1e281, 0, 280},
  {1e282, 0, 280},
  {1e283, 0, 282},
  {1e284, 0, 284},
  {1e285, 0, 284},
  {1e286, 0, 286},
  {1e287, 0, 287},
  {1e288, 0, 288},
  {1e289, 0, 289},
  {1e290, 0, 289},
  {1e291, 0, 290},
  {1e292, 0, 292},
  {1e293, 0, 292},
  {1e294, 0, 294},
  {1e295, 0, 294},
  {1e296, 0, 294},
  {1e297, 0, 297},
  {1e298, 0, 297},
  {1e299, 0, 299},
  {1e300, 0, 299},
  {1e301, 0, 299},
  {1e302, 0, 302},
  {1e303, 0, 303},
  {1e304, 0, 303},
  {1e305, 0, 303},
  {1e306, 0, 306},
  {1e307, 0, 306},
  {1e308, 0, 308},
] of _

# These values test every binary exponent (which would be more obvious with hexfloats).
# The mantissas were randomly generated.
ALL_BINARY_EXPONENTS = [
  {8.667315560151837e-309, 1074, 765},
  {3.402496288854889e-308, 1072, 764},
  {5.674095874064163e-308, 1068, 760},
  {1.5540526173622352e-307, 1072, 765},
  {1.990320005135143e-307, 1071, 764},
  {5.107418539046847e-307, 1070, 763},
  {9.580341507134765e-307, 1068, 761},
  {2.7686246461533843e-306, 1067, 761},
  {4.123539674247709e-306, 1066, 760},
  {1.0292523314007669e-305, 1065, 760},
  {1.869562966771459e-305, 1065, 760},
  {2.83258275754601e-305, 1063, 758},
  {6.143575467580988e-305, 1061, 756},
  {1.4317575812076783e-304, 1062, 758},
  {1.8736954404407843e-304, 1061, 757},
  {3.8678085703767116e-304, 1060, 756},
  {7.635297514304952e-304, 1058, 754},
  {1.9931833457401843e-303, 1056, 753},
  {5.7104439440441904e-303, 1057, 754},
  {5.845773229837182e-303, 1056, 753},
  {1.6446596413123796e-302, 1054, 752},
  {3.571334515579776e-302, 1054, 752},
  {5.226450761688444e-302, 1053, 751},
  {1.0747997253788843e-301, 1051, 750},
  {1.90892926200005e-301, 1051, 750},
  {6.786272682763782e-301, 1047, 746},
  {1.2172372613102281e-300, 1044, 744},
  {1.7966676643662128e-300, 1042, 742},
  {5.462819694528703e-300, 1047, 747},
  {6.961706248722051e-300, 1043, 743},
  {1.5112507155402445e-299, 1045, 746},
  {2.673980873749012e-299, 1044, 745},
  {8.503369157355244e-299, 1043, 744},
  {1.3233106901096892e-298, 1042, 744},
  {2.129178977672023e-298, 1041, 743},
  {4.178648615235546e-298, 1036, 738},
  {9.216189377840373e-298, 1038, 740},
  {2.0166542228894894e-297, 1036, 739},
  {3.5449747515908894e-297, 1034, 737},
  {8.064939085743458e-297, 1036, 739},
  {2.1182119864764602e-296, 1035, 739},
  {3.820427653349436e-296, 1034, 738},
  {9.166969936802109e-296, 1033, 737},
  {1.0587007370833377e-295, 1031, 736},
  {2.5617734189585968e-295, 1030, 735},
  {6.117667163341597e-295, 1030, 735},
  {1.2442918509206014e-294, 1028, 734},
  {3.100051235126117e-294, 1027, 733},
  {5.514599643126014e-294, 1026, 732},
  {8.019518080011996e-294, 1025, 731},
  {2.2148549407571022e-293, 1022, 729},
  {4.20911452464387e-293, 1024, 731},
  {6.673970944986261e-293, 1022, 729},
  {1.746546364023377e-292, 1021, 729},
  {2.5532945426002905e-292, 1021, 729},
  {7.167199051004838e-292, 1020, 728},
  {1.4331413352279302e-291, 1018, 727},
  {1.6537479214140957e-291, 1018, 727},
  {4.290843909020547e-291, 1017, 726},
  {9.634563122144926e-291, 1014, 723},
  {2.1086057222075156e-290, 1010, 720},
  {3.4206800637910767e-290, 1013, 723},
  {6.629016758967737e-290, 1013, 723},
  {1.352094685757577e-289, 1011, 722},
  {3.065153212531983e-289, 1011, 722},
  {5.074022975467963e-289, 1006, 717},
  {1.5066401531008766e-288, 1009, 721},
  {2.8015937941494583e-288, 1008, 720},
  {5.38303645298669e-288, 1007, 719},
  {8.441234238050258e-288, 1006, 718},
  {1.7229963037415354e-287, 1004, 717},
  {4.998022788892795e-287, 1004, 717},
  {8.728697912491584e-287, 1003, 716},
  {1.9042271010497776e-286, 1002, 716},
  {2.9003728382951163e-286, 1000, 714},
  {6.030230011480532e-286, 999, 713},
  {1.2707290656410452e-285, 997, 712},
  {3.3470583063356332e-285, 998, 713},
  {6.5966578537292035e-285, 997, 712},
  {7.427398668320939e-285, 995, 710},
  {2.5312725644714646e-284, 994, 710},
  {4.7441324100905746e-284, 994, 710},
  {7.352811059453878e-284, 992, 708},
  {1.2773195914029405e-283, 990, 707},
  {3.1336514683809336e-283, 991, 708},
  {4.624339948076099e-283, 990, 707},
  {8.894087772740341e-283, 989, 706},
  {2.3953652083727512e-282, 988, 706},
  {3.761567466326268e-282, 985, 703},
  {1.2928212167160486e-281, 985, 704},
  {2.2480352182123753e-281, 982, 701},
  {3.154850939942071e-281, 983, 702},
  {6.071363984983044e-281, 982, 701},
  {2.1910202165183368e-280, 981, 701},
  {4.3370603492214e-280, 980, 700},
  {6.968471572869319e-280, 980, 700},
  {1.473331115243779e-279, 979, 700},
  {2.66044060949483e-279, 971, 692},
  {5.683973436284207e-279, 976, 697},
  {1.4089452631685327e-278, 976, 698},
  {2.2755564362864927e-278, 973, 695},
  {3.821906858286435e-278, 973, 695},
  {8.103117627864485e-278, 973, 695},
  {1.832473425427903e-277, 970, 693},
  {2.727222054531752e-277, 970, 693},
  {7.882910515028218e-277, 964, 687},
  {1.479332526434952e-276, 966, 690},
  {2.2180410620430226e-276, 968, 692},
  {5.690649743658698e-276, 966, 690},
  {1.4121156100358157e-275, 966, 691},
  {2.6685811370633676e-275, 965, 690},
  {4.6692815012344967e-275, 963, 688},
  {9.834548098669551e-275, 958, 683},
  {1.8600057734718372e-274, 962, 688},
  {2.811775675630843e-274, 961, 687},
  {6.27142702954425e-274, 959, 685},
  {1.0250975871333601e-273, 959, 686},
  {2.5253325080332935e-273, 958, 685},
  {6.913296125147658e-273, 957, 684},
  {9.747372287629775e-273, 956, 683},
  {1.9721670909138485e-272, 953, 681},
  {4.469048372679605e-272, 953, 681},
  {1.0205638445192075e-271, 952, 681},
  {1.5594946591458144e-271, 952, 681},
  {2.3721122629194564e-271, 949, 678},
  {5.551135919284155e-271, 944, 673},
  {1.0734739674446298e-270, 947, 677},
  {2.4398554262702667e-270, 948, 678},
  {6.8642158764630495e-270, 942, 672},
  {1.2055339469240307e-269, 941, 672},
  {1.5235738192618518e-269, 945, 676},
  {4.043876497442965e-269, 944, 675},
  {8.743556251142875e-269, 941, 672},
  {1.4649312749107113e-268, 941, 673},
  {3.98040680032538e-268, 941, 673},
  {8.586286660615516e-268, 938, 670},
  {1.657418018730156e-267, 939, 672},
  {3.613106834542997e-267, 937, 670},
  {5.9183241751764955e-267, 936, 669},
  {1.1798475245572565e-266, 935, 669},
  {3.084511928870661e-266, 934, 668},
  {4.1367697432326765e-266, 930, 664},
  {1.1356367562498619e-265, 933, 668},
  {1.5494624584252724e-265, 928, 663},
  {3.028575537095104e-265, 931, 666},
  {9.42740333348115e-265, 930, 665},
  {1.729174836691517e-264, 929, 665},
  {2.1531241335994103e-264, 928, 664},
  {7.094381157920946e-264, 927, 663},
  {1.037244238361319e-263, 922, 659},
  {1.6682266784627316e-263, 925, 662},
  {5.516139500818587e-263, 924, 661},
  {1.1456020464232508e-262, 919, 657},
  {2.066981873698563e-262, 919, 657},
  {2.7219184652406806e-262, 921, 659},
  {5.081283542674735e-262, 918, 656},
  {1.6876650530578208e-261, 917, 656},
  {2.276883127404377e-261, 916, 655},
  {6.29191834725416e-261, 917, 656},
  {9.114070309202437e-261, 915, 654},
  {2.5433112499173348e-260, 909, 649},
  {4.8383034142174994e-260, 914, 654},
  {9.557162041008455e-260, 913, 653},
  {2.3218163991190385e-259, 912, 653},
  {4.4322942901196377e-259, 911, 652},
  {7.248624545665186e-259, 904, 645},
  {1.4667081257360905e-258, 909, 651},
  {3.832202635359104e-258, 908, 650},
  {6.943148025853397e-258, 905, 647},
  {9.18729939902564e-258, 906, 648},
  {3.0584908958671776e-257, 905, 648},
  {3.332730679024704e-257, 901, 644},
  {7.495951055510854e-257, 902, 645},
  {1.6420266726944826e-256, 900, 644},
  {3.9297951542678785e-256, 900, 644},
  {8.581799124622545e-256, 896, 640},
  {1.3408011506316038e-255, 899, 644},
  {3.074598537137766e-255, 898, 643},
  {8.304947313449564e-255, 893, 638},
  {1.4474411243713317e-254, 893, 639},
  {1.9586457971591685e-254, 895, 641},
  {4.686715367492042e-254, 894, 640},
  {1.3394037849881335e-253, 893, 640},
  {2.3636119615931954e-253, 892, 639},
  {2.941610445695594e-253, 891, 638},
  {5.910628843543644e-253, 890, 637},
  {1.6810396848558274e-252, 889, 637},
  {3.105977744955943e-252, 887, 635},
  {5.296557380144569e-252, 886, 634},
  {1.4534181673457758e-251, 886, 635},
  {2.3938479247234097e-251, 885, 634},
  {5.13191114201037e-251, 884, 633},
  {8.74142907505523e-251, 883, 632},
  {2.0810847152471556e-250, 881, 631},
  {3.470210840000035e-250, 879, 629},
  {7.63186683615216e-250, 879, 629},
  {1.5834019337617896e-249, 872, 623},
  {2.760497402953147e-249, 876, 627},
  {4.645119455324602e-249, 877, 628},
  {9.91990200069646e-249, 874, 625},
  {2.5293584256227207e-248, 874, 626},
  {6.890528046616735e-248, 874, 626},
  {9.9700406511611e-248, 870, 622},
  {2.0741563200652303e-247, 872, 625},
  {4.6848861238967826e-247, 869, 622},
  {7.812879056117969e-247, 870, 623},
  {1.16023447415079e-246, 868, 622},
  {2.6285314099653654e-246, 867, 621},
  {7.24619526711458e-246, 866, 620},
  {1.513557579372713e-245, 864, 619},
  {2.2022598987138438e-245, 864, 619},
  {4.1410759136055036e-245, 864, 619},
  {1.0252325908734784e-244, 863, 619},
  {2.0526028348315092e-244, 861, 617},
  {3.9232668413253934e-244, 861, 617},
  {7.579615073559597e-244, 859, 615},
  {2.042372149921196e-243, 859, 616},
  {2.9353293314833334e-243, 858, 615},
  {6.372363858570045e-243, 855, 612},
  {1.575234414235322e-242, 854, 612},
  {3.3434436478293493e-242, 855, 613},
  {5.199566493700135e-242, 853, 611},
  {1.151222665835575e-241, 853, 612},
  {1.5543636774561637e-241, 850, 609},
  {4.079493099457495e-241, 850, 609},
  {8.503783454502844e-241, 850, 609},
  {2.0072820595479573e-240, 845, 605},
  {3.536438208901198e-240, 845, 605},
  {8.722809014595794e-240, 845, 605},
  {1.3749379101340066e-239, 846, 607},
  {3.05119881849728e-239, 845, 606},
  {6.2081425746751336e-239, 844, 605},
  {1.5212878641555803e-238, 841, 603},
  {2.521616635184641e-238, 842, 604},
  {4.498289788351931e-238, 841, 603},
  {7.28128014416453e-238, 834, 596},
  {2.0208837171448896e-237, 839, 602},
  {4.2234650668214423e-237, 837, 600},
  {8.084125743595665e-237, 836, 599},
  {1.6733590187416607e-236, 835, 599},
  {2.744824473945537e-236, 835, 599},
  {6.9330212812845956e-236, 832, 596},
  {9.887608848404935e-236, 831, 595},
  {1.8140520866375598e-235, 832, 597},
  {3.4634694166405886e-235, 831, 596},
  {1.0308725436052673e-234, 830, 596},
  {1.3123008280909585e-234, 829, 595},
  {3.87322423781539e-234, 825, 591},
  {9.2010739647813e-234, 827, 593},
  {1.1992483584063614e-233, 817, 584},
  {2.3452909097606e-233, 823, 590},
  {6.55832259537843e-233, 824, 591},
  {1.01023596160976e-232, 822, 590},
  {2.5973213970621353e-232, 822, 590},
  {4.955980006523515e-232, 821, 589},
  {1.1244377262803144e-231, 820, 589},
  {2.4089050126555283e-231, 819, 588},
  {3.1957993198054626e-231, 815, 584},
  {6.380419758740376e-231, 816, 585},
  {1.6095894110621704e-230, 816, 586},
  {4.032612821947131e-230, 813, 583},
  {6.0387918131443855e-230, 811, 581},
  {8.974323011245674e-230, 813, 583},
  {1.8798157375327938e-229, 812, 583},
  {6.1019603119906395e-229, 810, 581},
  {1.1326182622927228e-228, 808, 580},
  {1.3463284210193606e-228, 808, 580},
  {4.951126320251196e-228, 806, 578},
  {8.472853590985601e-228, 806, 578},
  {1.268665118648964e-227, 802, 575},
  {2.688551806792703e-227, 805, 578},
  {4.421464033750511e-227, 803, 576},
  {1.6504299596692555e-226, 803, 577},
  {2.290009142698998e-226, 799, 573},
  {4.095081668886285e-226, 800, 574},
  {1.15703960191472e-225, 799, 574},
  {1.8221726162720878e-225, 799, 574},
  {3.7536981380660996e-225, 798, 573},
  {7.40644242989838e-225, 797, 572},
  {1.5302655517853282e-224, 796, 572},
  {3.266244852085614e-224, 794, 570},
  {6.839580807204396e-224, 794, 570},
  {1.1596240640257126e-223, 792, 569},
  {2.137739829010208e-223, 792, 569},
  {5.154905434635419e-223, 790, 567},
  {7.890896642961214e-223, 790, 567},
  {2.4268259861629554e-222, 788, 566},
  {5.1376518013281177e-222, 788, 566},
  {6.49233931232799e-222, 785, 563},
  {1.5726294053843144e-221, 784, 563},
  {2.5630401696102993e-221, 783, 562},
  {7.564140571297787e-221, 784, 563},
  {1.572950734084536e-220, 783, 563},
  {3.270170075841635e-220, 782, 562},
  {3.794310430010385e-220, 781, 561},
  {7.2152364285788e-220, 780, 560},
  {2.6272169024527132e-219, 779, 560},
  {4.969214075705504e-219, 778, 559},
  {5.88301228914231e-219, 777, 558},
  {1.4743436359705467e-218, 776, 558},
  {3.4783661139951837e-218, 774, 556},
  {5.813216384022507e-218, 774, 556},
  {1.4584641434878504e-217, 769, 552},
  {2.3948318645722384e-217, 771, 554},
  {6.217084198272334e-217, 771, 554},
  {1.2105626076543997e-216, 770, 554},
  {2.7486687055906063e-216, 768, 552},
  {3.502765745049966e-216, 768, 552},
  {9.371878794082114e-216, 765, 549},
  {2.2015678401956502e-215, 766, 551},
  {3.05741111150528e-215, 765, 550},
  {5.373256321068217e-215, 764, 549},
  {1.0390415242853729e-214, 763, 549},
  {2.5621446229095083e-214, 761, 547},
  {6.657612640369708e-214, 759, 545},
  {1.0096315129023046e-213, 760, 547},
  {2.385050068827949e-213, 759, 546},
  {4.872323574333538e-213, 756, 543},
  {1.1263700063301884e-212, 757, 545},
  {1.7927923533931953e-212, 755, 543},
  {4.1945272696274144e-212, 755, 543},
  {7.22363072585383e-212, 752, 540},
  {9.64175435706941e-212, 753, 541},
  {2.805853499967036e-211, 752, 541},
  {7.509881594270143e-211, 750, 539},
  {1.4162133808983744e-210, 750, 540},
  {2.760873558001602e-210, 749, 539},
  {5.239340425140705e-210, 748, 538},
  {1.1985208897227799e-209, 747, 538},
  {1.7811558999586524e-209, 743, 534},
  {4.196264296353732e-209, 745, 536},
  {9.615178102174303e-209, 744, 535},
  {1.8427321798270692e-208, 742, 534},
  {2.9126998289538513e-208, 742, 534},
  {4.61528401072508e-208, 740, 532},
  {1.3913867725663096e-207, 735, 528},
  {1.7692162295985285e-207, 736, 529},
  {3.3309984084439476e-207, 738, 531},
  {6.851070184689407e-207, 736, 529},
  {2.3088921688496224e-206, 736, 530},
  {4.569104830644564e-206, 735, 529},
  {9.727078311637122e-206, 733, 527},
  {1.0256959546160606e-205, 733, 528},
  {3.8508135367330314e-205, 725, 520},
  {5.362873934497765e-205, 731, 526},
  {1.178267040698183e-204, 727, 523},
  {1.9633198540986484e-204, 727, 523},
  {5.684033913906095e-204, 728, 524},
  {1.0645321758200814e-203, 727, 524},
  {1.6758731287663245e-203, 726, 523},
  {4.3010538577728234e-203, 724, 521},
  {8.557459533511549e-203, 721, 518},
  {1.1995252022699291e-202, 723, 521},
  {3.224746096518046e-202, 719, 517},
  {5.329245319538759e-202, 720, 518},
  {8.264074174120558e-202, 719, 517},
  {2.6560666151344703e-201, 718, 517},
  {4.349521497293475e-201, 718, 517},
  {1.049722365714753e-200, 717, 517},
  {2.110793667228417e-200, 716, 516},
  {4.12255833883331e-200, 713, 513},
  {7.981480278624725e-200, 714, 514},
  {1.7718621999986475e-199, 711, 512},
  {4.0389599243158305e-199, 712, 513},
  {5.111949257928288e-199, 711, 512},
  {1.0079029980377604e-198, 710, 512},
  {3.3000803685506845e-198, 709, 511},
  {5.525608163454049e-198, 708, 510},
  {1.3309156466126676e-197, 706, 509},
  {2.537666484635188e-197, 704, 507},
  {4.1725845639630823e-197, 702, 505},
  {8.054891565255361e-197, 700, 503},
  {1.5502849382509784e-196, 701, 505},
  {3.36121320874639e-196, 702, 506},
  {7.484551181550847e-196, 700, 504},
  {8.735452590688936e-196, 699, 503},
  {2.178462933634283e-195, 698, 503},
  {3.537794875075355e-195, 698, 503},
  {1.2853400648125002e-194, 694, 500},
  {2.4171125083478186e-194, 694, 500},
  {5.266324045366901e-194, 691, 497},
  {8.478256274282183e-194, 692, 498},
  {1.1953794466200875e-193, 693, 500},
  {2.260950903334843e-193, 691, 498},
  {6.350686450423479e-193, 690, 497},
  {1.6719092307496788e-192, 690, 498},
  {2.8861375664964044e-192, 686, 494},
  {6.643795862244709e-192, 687, 495},
  {1.2021435877944513e-191, 687, 496},
  {1.7389964555399593e-191, 686, 495},
  {5.506102911439653e-191, 684, 493},
  {6.118268064240606e-191, 682, 491},
  {2.0188412709311976e-190, 683, 493},
  {3.623294624463911e-190, 681, 491},
  {6.109098683649796e-190, 681, 491},
  {1.0644449452139396e-189, 680, 491},
  {2.2861786222533955e-189, 679, 490},
  {5.1576905486221095e-189, 678, 489},
  {1.4282019181687436e-188, 677, 489},
  {2.5645102658000638e-188, 676, 488},
  {5.24708561795544e-188, 675, 487},
  {1.0885720130033328e-187, 674, 487},
  {2.155560898279388e-187, 673, 486},
  {3.40475602113904e-187, 669, 482},
  {8.113439450169649e-187, 669, 482},
  {1.2501335652550157e-186, 669, 483},
  {2.921645514519799e-186, 667, 481},
  {4.02036891910035e-186, 668, 482},
  {1.1406014918543049e-185, 667, 482},
  {2.234456407425393e-185, 666, 481},
  {3.119559897062789e-185, 665, 480},
  {7.840889282617378e-185, 663, 478},
  {1.913574910036887e-184, 663, 479},
  {4.522727919382536e-184, 662, 478},
  {8.399922966296771e-184, 661, 477},
  {1.6000703209667126e-183, 660, 477},
  {2.579345132582455e-183, 656, 473},
  {5.82883665073076e-183, 657, 474},
  {1.1477041919553152e-182, 655, 473},
  {2.162629407013832e-182, 653, 471},
  {3.534083085250713e-182, 655, 473},
  {1.1362518681203582e-181, 654, 473},
  {1.374874967440177e-181, 652, 471},
  {2.435650549099599e-181, 652, 471},
  {7.063226461599998e-181, 651, 470},
  {1.502554163537965e-180, 650, 470},
  {2.3571270014353365e-180, 648, 468},
  {6.74887905042332e-180, 647, 467},
  {8.516860687556732e-180, 645, 465},
  {3.055786593521296e-179, 642, 463},
  {4.069012575835782e-179, 645, 466},
  {1.0237088948578388e-178, 644, 466},
  {1.54322893356522e-178, 643, 465},
  {4.787867741637937e-178, 641, 463},
  {6.628678990891977e-178, 639, 461},
  {1.6597719647556535e-177, 638, 461},
  {3.9129616361835475e-177, 638, 461},
  {4.917433318520185e-177, 637, 460},
  {1.4065772131663602e-176, 637, 461},
  {2.9943788764426967e-176, 636, 460},
  {5.798827328485947e-176, 633, 457},
  {6.383737379183111e-176, 629, 453},
  {1.702914739406024e-175, 631, 456},
  {3.8762215209996965e-175, 632, 457},
  {6.878988216191751e-175, 631, 456},
  {1.4887562197711447e-174, 629, 455},
  {3.5651743098904664e-174, 628, 454},
  {4.061595423920378e-174, 628, 454},
  {1.080598113210515e-173, 626, 453},
  {2.610049033590998e-173, 626, 453},
  {5.479224332391463e-173, 625, 452},
  {1.045438016267349e-172, 624, 452},
  {1.6069032799845684e-172, 623, 451},
  {3.231763455627856e-172, 621, 449},
  {8.881611379300798e-172, 621, 449},
  {2.034516015869994e-171, 620, 449},
  {2.1811364732319512e-171, 618, 447},
  {8.077406891608053e-171, 618, 447},
  {1.3085617726519542e-170, 617, 447},
  {1.8431087174635782e-170, 616, 446},
  {4.132806492532133e-170, 613, 443},
  {1.2069870317233675e-169, 613, 444},
  {2.5119843525307734e-169, 610, 441},
  {4.9132134419173275e-169, 612, 443},
  {7.82202882219777e-169, 611, 442},
  {1.4528932941845978e-168, 605, 437},
  {2.1572028357831315e-168, 608, 440},
  {6.050734210571264e-168, 607, 439},
  {1.4678367854256142e-167, 605, 438},
  {3.164114305557189e-167, 606, 439},
  {5.701265996213117e-167, 605, 438},
  {1.0449784962477288e-166, 603, 437},
  {1.412310305063278e-166, 603, 437},
  {3.0165478216464075e-166, 602, 436},
  {6.935268655974538e-166, 601, 435},
  {1.5523915631659218e-165, 599, 434},
  {3.204088122440647e-165, 599, 434},
  {5.708706599661439e-165, 596, 431},
  {1.3233342513427447e-164, 594, 430},
  {2.902749268222377e-164, 594, 430},
  {4.005031318533225e-164, 594, 430},
  {1.370839408075575e-163, 593, 430},
  {2.5492926252346404e-163, 592, 429},
  {4.5041091507036546e-163, 592, 429},
  {6.727683165794e-163, 591, 428},
  {1.2036075452964588e-162, 590, 428},
  {3.694027105345616e-162, 588, 426},
  {8.037749748602946e-162, 588, 426},
  {1.5950567846572765e-161, 587, 426},
  {3.2198008776677366e-161, 581, 420},
  {4.1052288903310634e-161, 585, 424},
  {1.1247015311011619e-160, 584, 424},
  {2.8199919854660424e-160, 581, 421},
  {3.44065016480784e-160, 582, 422},
  {1.0582157294697289e-159, 581, 422},
  {1.3388582036266356e-159, 580, 421},
  {3.9808070524262983e-159, 578, 419},
  {6.84874465910972e-159, 577, 418},
  {1.5742030359655316e-158, 577, 419},
  {2.9202734088397783e-158, 576, 418},
  {4.963143223862366e-158, 575, 417},
  {1.2414975541479183e-157, 574, 417},
  {1.7875996042719942e-157, 573, 416},
  {4.442886865786028e-157, 572, 415},
  {9.640850940808092e-157, 570, 413},
  {1.3646071402129266e-156, 566, 410},
  {3.95713245503973e-156, 567, 411},
  {7.069217936658262e-156, 568, 412},
  {1.203556015715792e-155, 566, 411},
  {2.317281696978397e-155, 566, 411},
  {6.4262723679026235e-155, 565, 410},
  {9.730107236224658e-155, 563, 408},
  {2.2224325771347584e-154, 558, 404},
  {5.423112811224111e-154, 562, 408},
  {7.326435394881725e-154, 558, 404},
  {2.3801222320149625e-153, 560, 407},
  {3.0618730536691986e-153, 559, 406},
  {8.347194867235908e-153, 555, 402},
  {1.3657896771381836e-152, 555, 403},
  {2.7059739547586404e-152, 555, 403},
  {7.577545297109583e-152, 555, 403},
  {1.1796090875694487e-151, 553, 402},
  {2.794960489625111e-151, 551, 400},
  {3.2753828239853734e-151, 548, 397},
  {9.593803205082154e-151, 549, 398},
  {1.582863447572883e-150, 549, 399},
  {2.6064697688781666e-150, 546, 396},
  {9.557214378356368e-150, 546, 396},
  {1.191935964515715e-149, 546, 397},
  {2.433444775335062e-149, 545, 396},
  {6.832519569622276e-149, 535, 386},
  {8.70223166700988e-149, 544, 395},
  {2.9861508065908777e-148, 543, 395},
  {4.817811775899338e-148, 540, 392},
  {9.297672441478371e-148, 540, 392},
  {2.4845337797454605e-147, 535, 388},
  {2.885736152741721e-147, 536, 389},
  {7.338298742534727e-147, 538, 391},
  {1.6347598189352822e-146, 537, 391},
  {3.7793226434705114e-146, 536, 390},
  {4.216777346143084e-146, 535, 389},
  {1.5906736035433479e-145, 534, 389},
  {2.8672951771554432e-145, 527, 382},
  {3.4379041633188434e-145, 532, 387},
  {9.483896231013576e-145, 531, 386},
  {2.1982900216496952e-144, 530, 386},
  {4.601395928544956e-144, 528, 384},
  {7.926089617836489e-144, 528, 384},
  {1.126604874345762e-143, 527, 384},
  {3.7906989762760977e-143, 526, 383},
  {6.436458682719877e-143, 525, 382},
  {1.4199943377251188e-142, 521, 379},
  {2.9387007315399e-142, 523, 381},
  {4.321275750819566e-142, 520, 378},
  {7.47956749010095e-142, 520, 378},
  {1.598743985708575e-141, 520, 379},
  {3.8772543479398746e-141, 519, 378},
  {8.857290458084179e-141, 518, 377},
  {1.4852721614344735e-140, 517, 377},
  {3.2114166221217845e-140, 516, 376},
  {6.843053332100658e-140, 515, 375},
  {1.565107103951972e-139, 514, 375},
  {2.0617783292012132e-139, 513, 374},
  {5.660205412204873e-139, 511, 372},
  {9.624163455997459e-139, 509, 370},
  {2.1752909285251192e-138, 509, 371},
  {4.3072629120188103e-138, 509, 371},
  {8.87808969808457e-138, 507, 369},
  {1.2102860505856427e-137, 506, 369},
  {4.0538881189604875e-137, 506, 369},
  {4.942621032233825e-137, 503, 366},
  {1.5411744957634479e-136, 502, 366},
  {2.217010614359645e-136, 502, 366},
  {6.356757540897539e-136, 499, 363},
  {9.59982670654558e-136, 501, 365},
  {2.6352597315051092e-135, 500, 365},
  {4.4355852076232534e-135, 497, 362},
  {5.742999336614182e-135, 498, 363},
  {1.5533843624429324e-134, 497, 363},
  {2.38869404724781e-134, 496, 362},
  {4.887121523587299e-134, 492, 358},
  {1.2048289504187996e-133, 494, 361},
  {2.6488657681982224e-133, 491, 358},
  {5.6050315915746605e-133, 489, 356},
  {1.2786580967537967e-132, 489, 357},
  {2.084833548391119e-132, 490, 358},
  {3.2003528362030217e-132, 488, 356},
  {1.0296499233307166e-131, 488, 357},
  {2.24263947672835e-131, 486, 355},
  {2.4568729171490547e-131, 485, 354},
  {6.620060796036904e-131, 483, 352},
  {1.4197241995605936e-130, 484, 354},
  {3.6028982430553334e-130, 482, 352},
  {4.887939370696328e-130, 481, 351},
  {7.31748922552339e-130, 481, 351},
  {2.342962029692207e-129, 479, 350},
  {3.2020192787585524e-129, 479, 350},
  {6.424759263634416e-129, 478, 349},
  {1.2342695551721854e-128, 476, 348},
  {4.4587660431030846e-128, 476, 348},
  {8.593040354013083e-128, 471, 343},
  {1.2304010474281754e-127, 474, 347},
  {2.5763001930484683e-127, 473, 346},
  {3.839904229353329e-127, 469, 342},
  {1.1107053483914007e-126, 470, 344},
  {2.62113368468091e-126, 469, 343},
  {3.9436012113465104e-126, 468, 342},
  {1.1279031828486725e-125, 467, 342},
  {1.359122081875358e-125, 467, 342},
  {4.718684877818967e-125, 466, 341},
  {9.34382880965103e-125, 464, 339},
  {1.3234786366979427e-124, 463, 339},
  {3.421581321410546e-124, 463, 339},
  {7.366599240502793e-124, 461, 337},
  {1.2895722651891138e-123, 460, 337},
  {2.921936515059182e-123, 455, 332},
  {3.2696466282687586e-123, 454, 331},
  {6.399893206284219e-123, 458, 335},
  {1.4998583170769895e-122, 456, 334},
  {3.302628563203096e-122, 456, 334},
  {5.784701017386636e-122, 454, 332},
  {1.2327531669436545e-121, 454, 333},
  {3.625335804997574e-121, 451, 330},
  {6.509903526347757e-121, 451, 330},
  {1.0362549937904696e-120, 448, 328},
  {2.8372763744588855e-120, 448, 328},
  {4.695776279670974e-120, 449, 329},
  {9.262841373599042e-120, 448, 328},
  {1.864465441767582e-119, 445, 326},
  {4.010086210363826e-119, 444, 325},
  {9.843181783316012e-119, 445, 326},
  {1.8986595125046417e-118, 438, 320},
  {3.508320544508897e-118, 443, 325},
  {4.943071564858405e-118, 440, 322},
  {1.4386748780689463e-117, 441, 324},
  {2.1750535480226044e-117, 440, 323},
  {3.5554120237464135e-117, 439, 322},
  {1.2023735450313651e-116, 432, 316},
  {2.4073250149223044e-116, 437, 321},
  {4.1701370789218156e-116, 434, 318},
  {1.0102559419519476e-115, 435, 320},
  {1.5737569358633548e-115, 433, 318},
  {3.5846791147293954e-115, 433, 318},
  {6.392064227463433e-115, 428, 313},
  {1.5412187845587149e-114, 429, 315},
  {2.3399657115069453e-114, 430, 316},
  {6.407770724945315e-114, 429, 315},
  {1.1069178065391464e-113, 427, 314},
  {1.573395880167279e-113, 426, 313},
  {2.951264303968299e-113, 425, 312},
  {8.761895839903948e-113, 425, 312},
  {1.4581718353001727e-112, 421, 309},
  {3.964464541482814e-112, 423, 311},
  {7.87961036169431e-112, 422, 310},
  {1.4076373030698913e-111, 421, 310},
  {3.164529578942993e-111, 418, 307},
  {4.67946374062146e-111, 419, 308},
  {1.1022787950727772e-110, 417, 307},
  {1.670185551585791e-110, 416, 306},
  {3.270479232134614e-110, 416, 306},
  {8.778772927538465e-110, 413, 303},
  {1.4356894911231068e-109, 412, 303},
  {3.2111903570682556e-109, 407, 298},
  {4.416972490924674e-109, 412, 303},
  {1.6902188100294219e-108, 411, 303},
  {2.7486157518272163e-108, 407, 299},
  {5.3211348201503956e-108, 408, 300},
  {8.333478562393578e-108, 408, 300},
  {1.8401463566583057e-107, 407, 300},
  {5.376784423862267e-107, 405, 298},
  {6.333829374806563e-107, 405, 298},
  {1.7514400642486577e-106, 403, 297},
  {2.3358765579576565e-106, 403, 297},
  {4.724398661049588e-106, 402, 296},
  {1.2692169671992972e-105, 400, 295},
  {1.963131601289876e-105, 398, 293},
  {4.342989487256073e-105, 397, 292},
  {8.812616575391183e-105, 397, 292},
  {1.692966213667821e-104, 397, 293},
  {4.242001623031538e-104, 393, 289},
  {6.030529809392781e-104, 395, 291},
  {1.5137520077480203e-103, 394, 291},
  {4.1339493171608476e-103, 393, 290},
  {6.201035931513464e-103, 392, 289},
  {1.3967279728811321e-102, 391, 289},
  {2.6059428457609154e-102, 390, 288},
  {5.292565718610749e-102, 389, 287},
  {1.2698160651847153e-101, 388, 287},
  {2.547070634124935e-101, 384, 283},
  {4.084116507906642e-101, 384, 283},
  {6.852426249982067e-101, 380, 279},
  {1.8083260374699235e-100, 382, 282},
  {4.1041218769683544e-100, 382, 282},
  {6.059640250896112e-100, 381, 281},
  {1.4091162264655094e-99, 381, 282},
  {2.1541940438019325e-99, 380, 281},
  {4.956208739898403e-99, 379, 280},
  {8.634882168235289e-99, 374, 275},
  {2.426134041499035e-98, 377, 279},
  {5.688034203287511e-98, 375, 277},
  {7.42082070481487e-98, 371, 273},
  {1.4938910681786228e-97, 371, 274},
  {3.3198659912779945e-97, 370, 273},
  {5.663431628653758e-97, 370, 273},
  {1.7437369721819611e-96, 371, 275},
  {3.535005437982104e-96, 370, 274},
  {5.461560619344413e-96, 366, 270},
  {1.1364847491964382e-95, 362, 267},
  {2.3020007806568932e-95, 366, 271},
  {3.7529890242406666e-95, 366, 271},
  {7.38338448129336e-95, 365, 270},
  {1.3934768122159904e-94, 360, 266},
  {2.504286566562723e-94, 362, 268},
  {5.356123085643122e-94, 360, 266},
  {1.3829457207184735e-93, 357, 264},
  {2.922539729701329e-93, 358, 265},
  {4.873642795487652e-93, 359, 266},
  {1.1847214117665038e-92, 358, 266},
  {1.6641279667471598e-92, 356, 264},
  {5.8818504424690985e-92, 356, 264},
  {8.169815841110726e-92, 353, 261},
  {1.5452699464889383e-91, 354, 263},
  {3.659395376290149e-91, 353, 262},
  {8.251660766595778e-91, 350, 259},
  {1.4826450102010818e-90, 351, 261},
  {3.280747503211524e-90, 350, 260},
  {5.042127927662887e-90, 349, 259},
  {1.1071352931313988e-89, 348, 259},
  {1.8434860272299224e-89, 346, 257},
  {4.503629714546149e-89, 343, 254},
  {7.978949976696619e-89, 345, 256},
  {2.5118610569922107e-88, 344, 256},
  {2.574328439038412e-88, 342, 254},
  {7.991143060138612e-88, 341, 253},
  {1.584115281757909e-87, 341, 254},
  {2.47707398648512e-87, 340, 253},
  {5.1571453461558415e-87, 339, 252},
  {9.677861708438445e-87, 338, 251},
  {3.06005556558652e-86, 337, 251},
  {4.078986710839316e-86, 336, 250},
  {8.39906286351288e-86, 332, 246},
  {1.992717826656166e-85, 332, 247},
  {4.771839231117578e-85, 332, 247},
  {9.178454461057711e-85, 332, 247},
  {1.363704451806317e-84, 330, 246},
  {3.8533883620323424e-84, 325, 241},
  {6.032190925744832e-84, 328, 244},
  {1.5705072660535393e-83, 326, 243},
  {2.2134072641839148e-83, 326, 243},
  {4.218896315696479e-83, 326, 243},
  {1.0992259537194823e-82, 322, 240},
  {2.4840542381260296e-82, 322, 240},
  {2.689980129196105e-82, 321, 239},
  {7.169144283915297e-82, 320, 238},
  {1.1408995211686882e-81, 318, 237},
  {3.6501624740693436e-81, 320, 239},
  {6.558396567940629e-81, 319, 238},
  {9.973540436014331e-81, 317, 236},
  {2.1285263571540236e-80, 316, 236},
  {5.738667020230138e-80, 315, 235},
  {1.2858099560631301e-79, 315, 236},
  {1.5440597737151946e-79, 314, 235},
  {5.085041310658149e-79, 312, 233},
  {7.85989179025863e-79, 310, 231},
  {1.5008325529570412e-78, 308, 230},
  {3.3480454826799275e-78, 306, 228},
  {8.497568581224052e-78, 309, 231},
  {1.6394772414307023e-77, 308, 231},
  {2.901315501375183e-77, 302, 225},
  {3.82611804506936e-77, 305, 228},
  {7.235982721954788e-77, 304, 227},
  {2.6324142915079567e-76, 301, 225},
  {3.0439003831515616e-76, 302, 226},
  {8.685053970949932e-76, 299, 223},
  {1.2427314157729456e-75, 301, 226},
  {3.398379710807704e-75, 295, 220},
  {7.841658923587687e-75, 292, 217},
  {1.3291407760196483e-74, 297, 223},
  {2.902089657903194e-74, 297, 223},
  {6.8493063311021444e-74, 295, 221},
  {1.0308144847135354e-73, 295, 222},
  {1.827277123300593e-73, 292, 219},
  {4.9351506696419103e-73, 292, 219},
  {1.0781250168794166e-72, 292, 220},
  {1.7181272168700196e-72, 289, 217},
  {4.2659307529076217e-72, 290, 218},
  {8.264425689667123e-72, 289, 217},
  {1.6273802065732598e-71, 288, 217},
  {1.8350586944381438e-71, 287, 216},
  {4.348286154284214e-71, 286, 215},
  {8.6134539761559e-71, 285, 214},
  {2.5905952437250456e-70, 284, 214},
  {3.406827648187512e-70, 279, 209},
  {6.61570075213638e-70, 281, 211},
  {1.7253632008143088e-69, 281, 212},
  {3.3892588392445133e-69, 280, 211},
  {4.939790429145187e-69, 278, 209},
  {1.47761815700755e-68, 278, 210},
  {3.538839275393052e-68, 277, 209},
  {4.821856338577311e-68, 276, 208},
  {1.0037463923948035e-67, 275, 208},
  {1.8046301120677578e-67, 272, 205},
  {5.037756265273766e-67, 273, 206},
  {7.294226364184892e-67, 271, 204},
  {1.7260576914043516e-66, 271, 205},
  {2.413521126424911e-66, 270, 204},
  {6.085503028299745e-66, 268, 202},
  {1.357171943220921e-65, 267, 202},
  {3.0836891319146543e-65, 267, 202},
  {6.537134301197315e-65, 263, 198},
  {8.131245964149248e-65, 265, 200},
  {1.8559814129506474e-64, 261, 197},
  {3.449567762615896e-64, 263, 199},
  {7.688715671540768e-64, 262, 198},
  {2.007143911426273e-63, 259, 196},
  {3.990126450920154e-63, 258, 195},
  {6.173618951228879e-63, 258, 195},
  {1.4822815568311571e-62, 258, 196},
  {3.8189270099686454e-62, 256, 194},
  {4.82120756263091e-62, 254, 192},
  {1.3790405547409109e-61, 255, 194},
  {2.6993809501677147e-61, 254, 193},
  {5.23202189544879e-61, 253, 192},
  {8.267169964142634e-61, 249, 188},
  {1.9276428005917082e-60, 251, 191},
  {2.7720738716829783e-60, 246, 186},
  {6.309714925893337e-60, 248, 188},
  {1.4603881466067395e-59, 243, 184},
  {2.390974995457393e-59, 247, 188},
  {7.148682183253571e-59, 246, 187},
  {9.322651868323872e-59, 245, 186},
  {2.202049881264495e-58, 242, 184},
  {5.387261159597293e-58, 242, 184},
  {8.629622859499133e-58, 240, 182},
  {2.1518906041456637e-57, 239, 182},
  {3.3393236367487655e-57, 238, 181},
  {8.670831372094515e-57, 238, 181},
  {1.8197046818766603e-56, 234, 178},
  {2.2260313359925405e-56, 237, 181},
  {4.302660672241003e-56, 234, 178},
  {1.0540262429918154e-55, 233, 178},
  {3.0681879985386226e-55, 232, 177},
  {5.481823354294243e-55, 233, 178},
  {1.0702958332703833e-54, 231, 177},
  {2.0733146515683786e-54, 225, 171},
  {3.663911049484028e-54, 230, 176},
  {7.133428824499037e-54, 227, 173},
  {1.155049021815273e-53, 226, 173},
  {2.1292639261534582e-53, 227, 174},
  {7.116291893522144e-53, 225, 172},
  {1.563247190926505e-52, 224, 172},
  {2.8724553500903598e-52, 223, 171},
  {6.558170706952157e-52, 221, 169},
  {1.1006685169756963e-51, 220, 169},
  {1.7539896072768475e-51, 220, 169},
  {3.7433921715043595e-51, 218, 167},
  {9.95642899800938e-51, 219, 168},
  {1.1636497924322522e-50, 218, 168},
  {3.715838411594935e-50, 217, 167},
  {6.580569634177383e-50, 212, 162},
  {1.3361521745438593e-49, 206, 157},
  {1.758805859472407e-49, 213, 164},
  {3.5728259387967836e-49, 213, 164},
  {1.3532863609445875e-48, 212, 164},
  {2.3787372002095833e-48, 211, 163},
  {2.962627533001959e-48, 210, 162},
  {9.002988068912365e-48, 208, 160},
  {1.6528407152844145e-47, 208, 161},
  {2.475761918536981e-47, 206, 159},
  {4.442389874949008e-47, 200, 153},
  {1.597036901212251e-46, 205, 159},
  {2.7344299616431544e-46, 203, 157},
  {4.923161560346421e-46, 203, 157},
  {1.0179995696026282e-45, 202, 157},
  {2.0723091166540274e-45, 201, 156},
  {4.7196310508913905e-45, 199, 154},
  {8.839991027458473e-45, 198, 153},
  {1.793400495465429e-44, 197, 153},
  {4.229568359105647e-44, 197, 153},
  {6.736360002384042e-44, 196, 152},
  {1.777871026025537e-43, 194, 151},
  {3.3315696595658846e-43, 194, 151},
  {4.002301960990423e-43, 191, 148},
  {1.1156841616796605e-42, 192, 150},
  {2.1966221825446394e-42, 191, 149},
  {5.676537374800469e-42, 188, 146},
  {1.1265477503439073e-41, 189, 148},
  {2.1310740108629267e-41, 188, 147},
  {3.47261690499443e-41, 187, 146},
  {5.986279457346766e-41, 186, 145},
  {1.256777780832933e-40, 185, 145},
  {3.178582703527919e-40, 182, 142},
  {4.8131885839189464e-40, 182, 142},
  {1.050509091106282e-39, 180, 141},
  {2.3469216079446797e-39, 181, 142},
  {3.701509845820645e-39, 179, 140},
  {7.539508429995885e-39, 172, 133},
  {1.6455979868696784e-38, 176, 138},
  {2.8896506750036806e-38, 176, 138},
  {7.637447758897944e-38, 176, 138},
  {1.742931242211031e-37, 171, 134},
  {3.658831567832271e-37, 171, 134},
  {6.4153225021810435e-37, 173, 136},
  {1.2882866599344565e-36, 172, 136},
  {2.2438898905531304e-36, 171, 135},
  {5.427246992721223e-36, 170, 134},
  {1.0773562313702051e-35, 168, 133},
  {1.8138709823870135e-35, 167, 132},
  {3.486395423440646e-35, 167, 132},
  {7.444961768380648e-35, 166, 131},
  {1.5947728558224363e-34, 164, 130},
  {3.6958300841764796e-34, 163, 129},
  {4.902792957147279e-34, 162, 128},
  {1.3763280779744356e-33, 162, 129},
  {2.4567652907408955e-33, 161, 128},
  {5.775941398121507e-33, 160, 127},
  {6.76218542428814e-33, 158, 125},
  {1.9564777034032247e-32, 156, 124},
  {3.7630713133101953e-32, 153, 121},
  {5.69811750812064e-32, 156, 124},
  {1.6901389263110543e-31, 154, 123},
  {2.416607441957109e-31, 154, 123},
  {5.310587796480732e-31, 152, 121},
  {1.272832974790223e-30, 150, 120},
  {2.758607109138819e-30, 151, 121},
  {6.158392474838414e-30, 147, 117},
  {9.79111897583252e-30, 149, 119},
  {2.1005583908999636e-29, 146, 117},
  {3.268892213509477e-29, 147, 118},
  {9.861264878636652e-29, 146, 117},
  {1.9807195772041245e-28, 145, 117},
  {2.459477005766037e-28, 143, 115},
  {7.134230712364223e-28, 141, 113},
  {1.3485130668183938e-27, 142, 115},
  {1.7558778301243823e-27, 140, 113},
  {4.603883324842795e-27, 139, 112},
  {6.787292759429055e-27, 139, 112},
  {2.338893604866531e-26, 138, 112},
  {5.0522652313759764e-26, 136, 110},
  {5.453193492635159e-26, 136, 110},
  {1.0432046065743156e-25, 134, 109},
  {3.459820865051479e-25, 134, 109},
  {4.919945865610923e-25, 133, 108},
  {1.1905894569192663e-24, 131, 107},
  {3.1044959876029037e-24, 129, 105},
  {5.874569663977718e-24, 125, 101},
  {1.0765469843178544e-23, 128, 105},
  {1.6374325809042254e-23, 128, 105},
  {5.135092112079404e-23, 127, 104},
  {9.161408014517678e-23, 126, 103},
  {1.1058854487286022e-22, 125, 103},
  {2.4417307811691994e-22, 124, 102},
  {6.962426049274539e-22, 121, 99},
  {1.3365747882614801e-21, 121, 100},
  {3.1416350487962487e-21, 118, 97},
  {6.17210332953516e-21, 120, 99},
  {7.67358493865774e-21, 114, 93},
  {1.5483757149089377e-20, 118, 98},
  {4.124682451133355e-20, 117, 97},
  {9.516929012310325e-20, 115, 95},
  {1.828195094563647e-19, 115, 96},
  {4.2349766597973143e-19, 114, 95},
  {5.027552313830036e-19, 106, 87},
  {1.4064120230650801e-18, 112, 94},
  {1.9740440391270057e-18, 111, 93},
  {5.043775268437966e-18, 110, 92},
  {1.133834572888795e-17, 109, 92},
  {2.5020470223212867e-17, 108, 91},
  {3.702836080714707e-17, 107, 90},
  {6.060941731133067e-17, 104, 87},
  {1.4669586812661773e-16, 105, 89},
  {3.686977051305637e-16, 104, 88},
  {4.80324090949893e-16, 101, 85},
  {1.3780266196844444e-15, 97, 82},
  {2.1377242939848385e-15, 101, 86},
  {6.212619127432843e-15, 99, 84},
  {1.1594451093913135e-14, 98, 84},
  {2.602091364932322e-14, 98, 84},
  {3.756321509921839e-14, 97, 83},
  {8.208072800557448e-14, 96, 82},
  {1.922432441672551e-13, 95, 82},
  {3.3711192675176746e-13, 92, 79},
  {7.644553608444343e-13, 91, 78},
  {1.2428666212744918e-12, 92, 80},
  {2.218814409588626e-12, 91, 79},
  {5.927330708414901e-12, 90, 78},
  {1.1828210767544923e-11, 86, 75},
  {2.0300112761836498e-11, 88, 77},
  {2.9825408935925034e-11, 85, 74},
  {7.41800536873849e-11, 86, 75},
  {2.3280428024704825e-10, 83, 73},
  {3.067358161655257e-10, 83, 73},
  {8.26606194612068e-10, 78, 68},
  {1.1606565070959597e-9, 82, 73},
  {2.25770689068302e-9, 79, 70},
  {4.2174650747812235e-9, 78, 69},
  {1.4887528604095427e-8, 78, 70},
  {2.245874199067278e-8, 78, 70},
  {3.8693071250734114e-8, 77, 69},
  {9.867450456369697e-8, 76, 68},
  {1.2770978278302815e-7, 72, 65},
  {3.9274196153024064e-7, 69, 62},
  {7.032112886574409e-7, 71, 64},
  {1.334954758379263e-6, 72, 66},
  {3.4751715684057034e-6, 71, 65},
  {5.621298897168876e-6, 62, 56},
  {9.338413843761515e-6, 69, 63},
  {2.834895459445889e-5, 68, 63},
  {4.8806263333083725e-5, 63, 58},
  {6.981573871413016e-5, 64, 59},
  {1.5709595512811012e-4, 64, 60},
  {4.8573351579579444e-4, 60, 56},
  {9.689777316624939e-4, 63, 59},
  {1.6816816128152761e-3, 62, 59},
  {2.6297079760909843e-3, 58, 55},
  {7.23583892421345e-3, 55, 52},
  {1.0321932464352318e-2, 59, 57},
  {2.643880607664138e-2, 58, 56},
  {4.7182495515037774e-2, 57, 55},
  {1.190207776709587e-1, 54, 53},
  {2.0454888297013502e-1, 54, 53},
  {4.470011069997743e-1, 54, 53},
  {7.22094745351015e-1, 53, 52},
  {1.3799513502451215e+0, 51, 51},
  {3.417399494666547e+0, 51, 51},
  {5.281345514239382e+0, 49, 49},
  {1.3580697413368053e+1, 48, 49},
  {1.854546242122947e+1, 48, 49},
  {4.1257609000643654e+1, 46, 47},
  {1.1980413676630091e+2, 46, 48},
  {2.3573434179257086e+2, 45, 47},
  {4.514328266785161e+2, 43, 45},
  {8.043055296192766e+2, 43, 45},
  {1.24858959528734e+3, 42, 45},
  {3.5482738915027107e+3, 41, 44},
  {4.3128420357200675e+3, 40, 43},
  {1.5941359869713324e+4, 38, 42},
  {2.497338563971861e+4, 37, 41},
  {4.518139121214868e+4, 35, 39},
  {7.552218526149612e+4, 36, 40},
  {1.711305224325764e+5, 31, 36},
  {2.882980788973542e+5, 30, 35},
  {9.050663149996944e+5, 33, 38},
  {2.0409610459455398e+6, 32, 38},
  {2.6947477926234123e+6, 31, 37},
  {6.216317612802105e+6, 29, 35},
  {1.2602046337445939e+7, 29, 36},
  {2.2551536557625037e+7, 28, 35},
  {3.5688575294042416e+7, 27, 34},
  {7.100154148679338e+7, 26, 33},
  {2.3023209155038175e+8, 25, 33},
  {5.343589913228248e+8, 24, 32},
  {6.370971111337817e+8, 22, 30},
  {1.1648983464144683e+9, 21, 30},
  {3.62429343510599e+9, 21, 30},
  {7.923089394878991e+9, 20, 29},
  {1.1994134449184855e+10, 19, 29},
  {2.6327568489536655e+10, 18, 28},
  {5.744587213490791e+10, 16, 26},
  {8.696933735612083e+10, 16, 26},
  {1.6199492099573203e+11, 15, 26},
  {4.646500235357022e+11, 14, 25},
  {9.038018345501305e+11, 13, 24},
  {2.0751822109812212e+12, 11, 23},
  {2.4783388817039565e+12, 11, 23},
  {4.627429732435399e+12, 10, 22},
  {9.300399090639615e+12, 9, 21},
  {3.2555272280322004e+13, 8, 21},
  {5.961096741057368e+13, 7, 20},
  {9.42651077771202e+13, 6, 19},
  {2.553913921435299e+14, 5, 19},
  {4.472244273086706e+14, 3, 17},
  {5.835513905481408e+14, 2, 16},
  {2.0680691881101218e+15, 2, 17},
  {3.328555513255053e+15, 0, 15},
  {6.456802203838757e+15, 0, 15},
  {1.7045704215755864e+16, 0, 16},
  {2.84788661041812e+16, 0, 14},
  {5.025270207504599e+16, 0, 16},
  {1.0675866324035571e+17, 0, 17},
  {2.113981699080119e+17, 0, 17},
  {4.2645533513929344e+17, 0, 16},
  {6.872142041884154e+17, 0, 16},
  {1.1799694815132618e+18, 0, 18},
  {3.082431250837574e+18, 0, 18},
  {4.656624004411896e+18, 0, 18},
  {1.2710318822043552e+19, 0, 19},
  {2.122367359171886e+19, 0, 19},
  {5.243529562420319e+19, 0, 19},
  {1.2577828348716568e+20, 0, 20},
  {2.5306784987647436e+20, 0, 20},
  {4.170387336967606e+20, 0, 20},
  {6.974057652717262e+20, 0, 20},
  {1.9037873644969454e+21, 0, 21},
  {3.8919116102079354e+21, 0, 21},
  {7.985405687712874e+21, 0, 21},
  {1.2304624807151021e+22, 0, 22},
  {2.877579059642156e+22, 0, 22},
  {5.820875799468994e+22, 0, 22},
  {1.3414090792760231e+23, 0, 23},
  {2.8913245990717846e+23, 0, 23},
  {5.891246287064668e+23, 0, 23},
  {1.0714737361583606e+24, 0, 24},
  {1.9464410087794222e+24, 0, 24},
  {4.038971174128977e+24, 0, 24},
  {9.574063461859928e+24, 0, 24},
  {1.8851337402710216e+25, 0, 25},
  {3.1247728753733907e+25, 0, 24},
  {7.618322003647741e+25, 0, 25},
  {1.2658076075629417e+26, 0, 26},
  {2.035966265810824e+26, 0, 25},
  {3.819893374231787e+26, 0, 26},
  {1.0086763820538085e+27, 0, 27},
  {1.8722435720189532e+27, 0, 27},
  {4.199164189291375e+27, 0, 27},
  {5.655595157253245e+27, 0, 27},
  {1.300173405645727e+28, 0, 27},
  {3.435085557417992e+28, 0, 28},
  {5.665464211510795e+28, 0, 28},
  {1.0145707014004108e+29, 0, 29},
  {2.891228424386253e+29, 0, 29},
  {5.286890236526336e+29, 0, 29},
  {1.0225186710420342e+30, 0, 30},
  {2.0108243842273892e+30, 0, 29},
  {4.3265449624459286e+30, 0, 28},
  {8.843189919417627e+30, 0, 30},
  {1.9480726537977613e+31, 0, 31},
  {3.002386285018348e+31, 0, 30},
  {5.643671566392372e+31, 0, 31},
  {1.01957610305534e+32, 0, 32},
  {1.6310534536755234e+32, 0, 32},
  {3.545708028358011e+32, 0, 32},
  {1.2833888390368551e+33, 0, 33},
  {1.392377581640218e+33, 0, 33},
  {3.364225166474354e+33, 0, 33},
  {5.629829199100142e+33, 0, 33},
  {1.5854951477853974e+34, 0, 33},
  {2.9422458257062698e+34, 0, 34},
  {5.271105157627402e+34, 0, 34},
  {1.0730605396566132e+35, 0, 35},
  {2.7860337216506062e+35, 0, 35},
  {4.6519994160495565e+35, 0, 35},
  {9.613291858434125e+35, 0, 35},
  {2.4445443869856408e+36, 0, 36},
  {4.961465895993372e+36, 0, 36},
  {9.540055986377937e+36, 0, 35},
  {1.1787368324472862e+37, 0, 37},
  {2.2217886245582568e+37, 0, 37},
  {7.482803782461342e+37, 0, 37},
  {1.221681695558803e+38, 0, 38},
  {1.9229409068293893e+38, 0, 38},
  {3.977549408655239e+38, 0, 38},
  {7.032764985693427e+38, 0, 38},
  {2.579787897255991e+39, 0, 39},
  {2.997970965091339e+39, 0, 39},
  {1.0000548245536084e+40, 0, 40},
  {1.54316993761888e+40, 0, 40},
  {4.2448087869444726e+40, 0, 40},
  {7.226422026835713e+40, 0, 40},
  {1.5440832081521699e+41, 0, 39},
  {1.9018305301016465e+41, 0, 41},
  {3.769840630981528e+41, 0, 41},
  {7.966617882916526e+41, 0, 40},
  {1.6479249230626738e+42, 0, 42},
  {5.4563711872283434e+42, 0, 42},
  {8.479619741110214e+42, 0, 42},
  {2.179088893187299e+43, 0, 43},
  {2.4514764141293366e+43, 0, 43},
  {7.969690106218293e+43, 0, 41},
  {1.0174451327093896e+44, 0, 44},
  {2.3728120049330384e+44, 0, 44},
  {5.065733073087785e+44, 0, 44},
  {1.1484248148943394e+45, 0, 45},
  {1.4749512803946582e+45, 0, 45},
  {3.184462066193894e+45, 0, 45},
  {6.322074926642195e+45, 0, 45},
  {1.7884100129279887e+46, 0, 46},
  {2.325073960940094e+46, 0, 45},
  {7.785030375679882e+46, 0, 46},
  {1.4448801732473917e+47, 0, 47},
  {2.6558108692875686e+47, 0, 46},
  {4.372023657618532e+47, 0, 47},
  {1.1801773326503515e+48, 0, 48},
  {2.3529994342524252e+48, 0, 48},
  {3.427891103047345e+48, 0, 48},
  {9.31630524930085e+48, 0, 46},
  {1.9116211540697205e+49, 0, 49},
  {3.069617131966241e+49, 0, 49},
  {5.496151148596413e+49, 0, 49},
  {1.7035934506961495e+50, 0, 50},
  {2.833139550712863e+50, 0, 50},
  {6.133786732856586e+50, 0, 50},
  {1.0621093207976587e+51, 0, 51},
  {2.8455345909273967e+51, 0, 51},
  {5.385580087774829e+51, 0, 51},
  {1.0385481005999035e+52, 0, 52},
  {1.7051361668200266e+52, 0, 50},
  {4.0348216442512827e+52, 0, 52},
  {9.203615836914227e+52, 0, 52},
  {1.4419377590076046e+53, 0, 53},
  {3.7517809629812945e+53, 0, 53},
  {6.921465596389916e+53, 0, 53},
  {1.1246377895743686e+54, 0, 54},
  {1.9141569906490816e+54, 0, 54},
  {4.804705186047788e+54, 0, 54},
  {8.071435564947533e+54, 0, 54},
  {2.3128140200050004e+55, 0, 55},
  {4.439935895842503e+55, 0, 55},
  {6.395351593160262e+55, 0, 55},
  {1.6961369224103472e+56, 0, 56},
  {2.0665317001185354e+56, 0, 55},
  {4.267199288089499e+56, 0, 54},
  {1.1913532457592459e+57, 0, 57},
  {2.148060287120407e+57, 0, 57},
  {4.2134227293218824e+57, 0, 57},
  {7.35889330966464e+57, 0, 57},
  {2.4387563351268132e+58, 0, 58},
  {2.755962153622423e+58, 0, 58},
  {7.777910645414689e+58, 0, 57},
  {1.9082027100674306e+59, 0, 59},
  {2.9725481934856135e+59, 0, 59},
  {6.272978739898479e+59, 0, 59},
  {1.6068731094294698e+60, 0, 60},
  {2.976043223039824e+60, 0, 60},
  {3.489997472879309e+60, 0, 60},
  {1.0670380970822516e+61, 0, 61},
  {2.1280541721170622e+61, 0, 61},
  {4.118037303766816e+61, 0, 61},
  {9.480559641663617e+61, 0, 60},
  {1.596797376905473e+62, 0, 62},
  {2.860736632381932e+62, 0, 62},
  {6.175504515676743e+62, 0, 61},
  {1.508691188244575e+63, 0, 63},
  {2.660508539901083e+63, 0, 63},
  {4.809861739392637e+63, 0, 63},
  {1.1682993418673642e+64, 0, 64},
  {2.3441185866765202e+64, 0, 64},
  {3.485421002254914e+64, 0, 64},
  {7.273116277037653e+64, 0, 64},
  {1.354521653245005e+65, 0, 64},
  {3.8672800363603606e+65, 0, 65},
  {5.066109744077407e+65, 0, 65},
  {1.4793086587583503e+66, 0, 66},
  {2.795839034978864e+66, 0, 66},
  {6.432840401396406e+66, 0, 66},
  {7.648199062043261e+66, 0, 65},
  {1.773601417088583e+67, 0, 67},
  {4.060845372454403e+67, 0, 67},
  {5.9366267010857e+67, 0, 67},
  {2.0059924456841817e+68, 0, 68},
  {4.1783323703661896e+68, 0, 68},
  {7.479841058470886e+68, 0, 68},
  {1.1009811776563666e+69, 0, 69},
  {3.2783442635024616e+69, 0, 69},
  {6.563409273861358e+69, 0, 69},
  {1.0567882407580983e+70, 0, 70},
  {1.5374031618797994e+70, 0, 70},
  {5.338524581842552e+70, 0, 69},
  {1.0972432160602172e+71, 0, 71},
  {1.5001044647337975e+71, 0, 70},
  {2.8316543156525084e+71, 0, 71},
  {8.3236641225376745e+71, 0, 71},
  {1.405812739508858e+72, 0, 72},
  {3.4886185525806396e+72, 0, 72},
  {3.6195137423664015e+72, 0, 72},
  {9.41094888383514e+72, 0, 72},
  {1.6890382785900104e+73, 0, 73},
  {4.5033691214168135e+73, 0, 73},
  {6.278199128750284e+73, 0, 73},
  {1.1565059569236081e+74, 0, 74},
  {4.353326831627433e+74, 0, 74},
  {8.277733334111089e+74, 0, 74},
  {1.4048499964520923e+75, 0, 75},
  {2.322541569987462e+75, 0, 75},
  {4.557727968952481e+75, 0, 75},
  {1.215633227097655e+76, 0, 74},
  {1.5116664880436698e+76, 0, 76},
  {5.765280163648591e+76, 0, 76},
  {7.214835817706474e+76, 0, 76},
  {2.1100734325357315e+77, 0, 77},
  {3.9254415593380374e+77, 0, 77},
  {6.516897273419297e+77, 0, 76},
  {1.7597137621226992e+78, 0, 76},
  {3.434875728114805e+78, 0, 78},
  {4.496894013184632e+78, 0, 77},
  {1.0023515028874743e+79, 0, 79},
  {2.0460627987672047e+79, 0, 77},
  {3.676686386898502e+79, 0, 79},
  {6.987059926149719e+79, 0, 79},
  {1.795081604158087e+80, 0, 80},
  {3.8104574251556824e+80, 0, 80},
  {5.627357082833958e+80, 0, 80},
  {1.8281571967861733e+81, 0, 81},
  {3.3545136086293428e+81, 0, 81},
  {4.116922864713555e+81, 0, 81},
  {1.075543470816983e+82, 0, 82},
  {1.8609826393606468e+82, 0, 82},
  {3.903192479447499e+82, 0, 81},
  {6.473791115981879e+82, 0, 82},
  {1.538865780906402e+83, 0, 83},
  {4.6154122259230323e+83, 0, 83},
  {5.213671588000098e+83, 0, 82},
  {1.7231285500027554e+84, 0, 84},
  {3.3263411825363985e+84, 0, 82},
  {6.7438490624371245e+84, 0, 84},
  {1.5324966500321058e+85, 0, 85},
  {2.9031045606668695e+85, 0, 85},
  {4.0285461203337304e+85, 0, 85},
  {6.347438261947277e+85, 0, 85},
  {1.4849990568686154e+86, 0, 86},
  {3.144137214709148e+86, 0, 84},
  {7.35111663943684e+86, 0, 86},
  {1.5577475663863448e+87, 0, 87},
  {2.2732058810982127e+87, 0, 87},
  {4.947293841380347e+87, 0, 87},
  {1.5322047885180557e+88, 0, 87},
  {2.2054038951762965e+88, 0, 87},
  {3.4979111598588176e+88, 0, 88},
  {1.1594354499619093e+89, 0, 89},
  {1.868122415575413e+89, 0, 89},
  {3.482810444725715e+89, 0, 89},
  {7.257639265994533e+89, 0, 89},
  {1.1535270490147722e+90, 0, 90},
  {2.4967979092938603e+90, 0, 90},
  {7.0072237787891005e+90, 0, 90},
  {1.1095288700912677e+91, 0, 91},
  {2.9607930405769014e+91, 0, 91},
  {5.652005070494756e+91, 0, 91},
  {1.1255100772707936e+92, 0, 92},
  {1.7318608033666267e+92, 0, 92},
  {4.919954612222507e+92, 0, 92},
  {6.919660091186515e+92, 0, 92},
  {1.0987955187264384e+93, 0, 93},
  {2.315894257968477e+93, 0, 93},
  {5.072050876594695e+93, 0, 92},
  {1.036357099998561e+94, 0, 94},
  {3.1561899942152433e+94, 0, 94},
  {5.80588996039864e+94, 0, 94},
  {8.543176492274635e+94, 0, 94},
  {1.3894319871042075e+95, 0, 95},
  {4.778618490169982e+95, 0, 95},
  {1.0203895888996092e+96, 0, 96},
  {1.5960456887763758e+96, 0, 96},
  {3.249173807353552e+96, 0, 96},
  {4.96163817638071e+96, 0, 96},
  {1.3169653838480804e+97, 0, 96},
  {2.7600802833290057e+97, 0, 97},
  {3.678975869510067e+97, 0, 97},
  {9.316977605792739e+97, 0, 97},
  {2.636218658095782e+98, 0, 98},
  {2.8795801629202426e+98, 0, 98},
  {1.0271479449330235e+99, 0, 99},
  {1.7364389499462398e+99, 0, 99},
  {2.8311014904498133e+99, 0, 99},
  {8.717780031735018e+99, 0, 98},
  {1.2937429393963081e+100, 0, 100},
  {3.076211787425004e+100, 0, 99},
  {6.075000204770712e+100, 0, 100},
  {1.0051913192324967e+101, 0, 101},
  {1.6040435699970458e+101, 0, 101},
  {3.2033279820176996e+101, 0, 101},
  {6.504689809313382e+101, 0, 101},
  {1.3085843965991656e+102, 0, 102},
  {4.2878646530008384e+102, 0, 102},
  {6.562953660628769e+102, 0, 101},
  {1.2236285152807308e+103, 0, 103},
  {2.414637776562117e+103, 0, 103},
  {6.180397605502719e+103, 0, 103},
  {8.952357506110561e+103, 0, 102},
  {2.6739842993463814e+104, 0, 104},
  {4.9051642185904874e+104, 0, 104},
  {1.1379543402482949e+105, 0, 105},
  {1.41259541205596e+105, 0, 104},
  {3.1114274318600263e+105, 0, 105},
  {8.750317145527779e+105, 0, 104},
  {1.1436652181690534e+106, 0, 106},
  {3.411483086538129e+106, 0, 106},
  {4.073577415899245e+106, 0, 106},
  {1.1569270331282534e+107, 0, 107},
  {1.8083251599082483e+107, 0, 106},
  {3.791515819931573e+107, 0, 107},
  {9.49764100015205e+107, 0, 107},
  {1.4509958077289753e+108, 0, 108},
  {4.424174112983774e+108, 0, 108},
  {7.455899165473143e+108, 0, 108},
  {1.8319982128819878e+109, 0, 109},
  {3.0467669457405913e+109, 0, 107},
  {6.37361253846025e+109, 0, 109},
  {8.38955229182671e+109, 0, 109},
  {2.8651611621506035e+110, 0, 110},
  {6.001453332972219e+110, 0, 110},
  {8.11448033384131e+110, 0, 109},
  {2.2581394399876124e+111, 0, 110},
  {3.136912645074335e+111, 0, 110},
  {8.75100561003784e+111, 0, 111},
  {1.7339706643869121e+112, 0, 112},
  {1.934331254218702e+112, 0, 110},
  {6.254524509233588e+112, 0, 112},
  {9.375622388315127e+112, 0, 112},
  {2.4189606341952683e+113, 0, 112},
  {5.2244400989180614e+113, 0, 113},
  {6.794474678720091e+113, 0, 111},
  {2.046778382742435e+114, 0, 113},
  {4.195175792183929e+114, 0, 114},
  {7.880516976947723e+114, 0, 114},
  {1.1711035514327282e+115, 0, 115},
  {2.338338695923868e+115, 0, 115},
  {5.385799521445425e+115, 0, 115},
  {1.2991906643558943e+116, 0, 116},
  {1.7757658123869845e+116, 0, 116},
  {6.1954646341609976e+116, 0, 116},
  {8.320622375414998e+116, 0, 116},
  {1.3055545505825232e+117, 0, 117},
  {3.836650434819978e+117, 0, 116},
  {8.752670682427704e+117, 0, 117},
  {1.371103427759537e+118, 0, 118},
  {3.047042188071979e+118, 0, 117},
  {7.589006090032981e+118, 0, 117},
  {1.0473293912342299e+119, 0, 119},
  {2.0986207045386187e+119, 0, 119},
  {3.236179661386884e+119, 0, 118},
  {7.972193856244527e+119, 0, 119},
  {1.8299315060253445e+120, 0, 120},
  {4.6151785414218586e+120, 0, 120},
  {5.923044070696605e+120, 0, 120},
  {1.361457289463494e+121, 0, 120},
  {2.7540713949104843e+121, 0, 121},
  {6.706809109602002e+121, 0, 121},
  {1.6292678335806155e+122, 0, 121},
  {2.171602703883232e+122, 0, 121},
  {5.723756099896326e+122, 0, 122},
  {6.89498173085618e+122, 0, 121},
  {2.1357574596497743e+123, 0, 123},
  {2.961187277322293e+123, 0, 123},
  {9.093166616854773e+123, 0, 123},
  {1.2290156989602755e+124, 0, 122},
  {3.2889389033303796e+124, 0, 124},
  {7.62000449356734e+124, 0, 123},
  {1.6491192862717743e+125, 0, 123},
  {2.1235620018124726e+125, 0, 124},
  {5.0830874862362334e+125, 0, 125},
  {1.3230337364814056e+126, 0, 126},
  {1.8514824347085014e+126, 0, 124},
  {4.297255645889242e+126, 0, 126},
  {9.214123983353544e+126, 0, 125},
  {1.6005984240937532e+127, 0, 126},
  {4.0927181564650246e+127, 0, 127},
  {6.9786454159176675e+127, 0, 127},
  {8.88030935259018e+127, 0, 127},
  {2.0038549597024574e+128, 0, 128},
  {6.439948347184869e+128, 0, 128},
  {9.745603385424579e+128, 0, 128},
  {1.682287066188509e+129, 0, 129},
  {5.159777854912e+129, 0, 128},
  {1.0427009479036798e+130, 0, 130},
  {1.8648218159777694e+130, 0, 130},
  {2.7990719302881793e+130, 0, 130},
  {7.540407358942798e+130, 0, 130},
  {9.729616533270472e+130, 0, 130},
  {2.3271929702892176e+131, 0, 130},
  {4.8467161954318766e+131, 0, 130},
  {8.654197708736783e+131, 0, 131},
  {2.486253574248309e+132, 0, 132},
  {4.520706326672799e+132, 0, 132},
  {8.587398813646014e+132, 0, 131},
  {1.7982783689310961e+133, 0, 133},
  {3.51092292749737e+133, 0, 133},
  {8.854772868346543e+133, 0, 133},
  {1.2604934227155403e+134, 0, 132},
  {2.7086719929942504e+134, 0, 134},
  {5.9197489271133586e+134, 0, 134},
  {8.607845504713468e+134, 0, 134},
  {2.3984166963813072e+135, 0, 134},
  {3.250007960862918e+135, 0, 135},
  {7.443610248681703e+135, 0, 135},
  {1.9390729656615215e+136, 0, 136},
  {3.6046982835224656e+136, 0, 136},
  {8.883580710031506e+136, 0, 136},
  {1.0473820665170049e+137, 0, 136},
  {2.7139682262053297e+137, 0, 137},
  {4.3539205936145105e+137, 0, 137},
  {1.299944829366617e+138, 0, 137},
  {2.4557929966471053e+138, 0, 138},
  {3.448376481821885e+138, 0, 136},
  {6.779013852180732e+138, 0, 138},
  {1.801148096883475e+139, 0, 139},
  {3.791452902390207e+139, 0, 138},
  {6.474870054646572e+139, 0, 139},
  {1.6231677484748648e+140, 0, 139},
  {3.527980476981338e+140, 0, 140},
  {4.747525868091625e+140, 0, 140},
  {9.241043811243549e+140, 0, 139},
  {1.7472268158903568e+141, 0, 141},
  {5.1503502855445634e+141, 0, 141},
  {1.0693743613454128e+142, 0, 142},
  {1.727103927590088e+142, 0, 142},
  {4.6987106320234365e+142, 0, 142},
  {9.644313300615438e+142, 0, 142},
  {1.430838540572183e+143, 0, 143},
  {2.27786457822541e+143, 0, 143},
  {4.212849184362802e+143, 0, 143},
  {8.237715226546193e+143, 0, 143},
  {2.6654737215359226e+144, 0, 143},
  {6.019079138812162e+144, 0, 144},
  {1.2409084690292542e+145, 0, 145},
  {1.549900904806159e+145, 0, 145},
  {3.1738661663567816e+145, 0, 145},
  {6.996909564666351e+145, 0, 145},
  {1.4136130050003495e+146, 0, 146},
  {2.98468447673297e+146, 0, 146},
  {5.072484297164673e+146, 0, 146},
  {9.172861001485728e+146, 0, 146},
  {3.1827325058993567e+147, 0, 147},
  {4.205587083947037e+147, 0, 147},
  {8.648615720577233e+147, 0, 147},
  {2.4309692254959333e+148, 0, 148},
  {4.466309998082111e+148, 0, 148},
  {7.497564003947889e+148, 0, 148},
  {1.9029191895593583e+149, 0, 149},
  {3.8006641833677102e+149, 0, 149},
  {6.913824994082101e+149, 0, 147},
  {8.712815483801716e+149, 0, 149},
  {2.3780639727460607e+150, 0, 150},
  {4.467392649638729e+150, 0, 150},
  {8.066185078159116e+150, 0, 148},
  {1.8852448369964825e+151, 0, 150},
  {3.566152723739795e+151, 0, 151},
  {5.924851411681645e+151, 0, 151},
  {1.5060587321219467e+152, 0, 152},
  {2.8583520249281916e+152, 0, 152},
  {4.535449894907774e+152, 0, 152},
  {1.012602649962377e+153, 0, 153},
  {2.0189450716998492e+153, 0, 153},
  {6.095760398208723e+153, 0, 152},
  {1.0839728287028179e+154, 0, 154},
  {2.0160697875193073e+154, 0, 154},
  {4.539520336739885e+154, 0, 153},
  {7.982163447075079e+154, 0, 154},
  {1.1108659309948223e+155, 0, 155},
  {2.938991096845654e+155, 0, 155},
  {7.734832320107849e+155, 0, 155},
  {1.0600772804334342e+156, 0, 154},
  {2.560225316421402e+156, 0, 156},
  {6.4957894162689224e+156, 0, 153},
  {1.0469685229597166e+157, 0, 157},
  {1.8049425471684504e+157, 0, 157},
  {3.7963414617308416e+157, 0, 157},
  {9.092676802446734e+157, 0, 156},
  {2.1420954571874796e+158, 0, 158},
  {3.5406074604903996e+158, 0, 158},
  {6.059179837113682e+158, 0, 158},
  {1.7129340266632835e+159, 0, 159},
  {1.9501271083673803e+159, 0, 159},
  {5.17312771823294e+159, 0, 158},
  {9.785122654459946e+159, 0, 159},
  {2.070565985519521e+160, 0, 160},
  {5.5612314177003026e+160, 0, 160},
  {7.487464053324147e+160, 0, 160},
  {1.72170539588904e+161, 0, 161},
  {3.101655447037901e+161, 0, 160},
  {7.190773969829955e+161, 0, 160},
  {1.6233719112674835e+162, 0, 162},
  {2.8766398779168217e+162, 0, 161},
  {5.119867078891217e+162, 0, 162},
  {1.0829229605647497e+163, 0, 163},
  {2.588897361986241e+163, 0, 163},
  {4.8574461844070457e+163, 0, 162},
  {7.897885248231481e+163, 0, 162},
  {1.7757792408248608e+164, 0, 164},
  {4.5181869438995584e+164, 0, 164},
  {6.04440676037902e+164, 0, 164},
  {9.436631806093061e+164, 0, 164},
  {3.252849304270332e+165, 0, 165},
  {4.971119941681659e+165, 0, 165},
  {7.72793435885625e+165, 0, 165},
  {2.49887461307668e+166, 0, 166},
  {4.138019138142108e+166, 0, 165},
  {7.671967953519936e+166, 0, 166},
  {1.4213879533988813e+167, 0, 166},
  {4.6541532390763674e+167, 0, 166},
  {5.769302991727879e+167, 0, 167},
  {1.7540289541978555e+168, 0, 167},
  {3.454961038953494e+168, 0, 168},
  {3.923334972089952e+168, 0, 168},
  {1.270785497029221e+169, 0, 169},
  {2.376127169235011e+169, 0, 169},
  {5.282087226424358e+169, 0, 169},
  {9.538748971891788e+169, 0, 169},
  {2.1105330303243357e+170, 0, 170},
  {2.595142529235477e+170, 0, 169},
  {6.194530882320718e+170, 0, 170},
  {1.7393845792769813e+171, 0, 171},
  {2.5114408497872505e+171, 0, 171},
  {6.964312528803397e+171, 0, 171},
  {1.229619287434228e+172, 0, 171},
  {2.2726320991720394e+172, 0, 172},
  {6.1180092244552894e+172, 0, 172},
  {7.849033701858734e+172, 0, 172},
  {1.876016568195346e+173, 0, 173},
  {3.504523456271905e+173, 0, 173},
  {7.263516584915379e+173, 0, 173},
  {1.9020249607206747e+174, 0, 174},
  {3.954563518862104e+174, 0, 174},
  {4.179264564957457e+174, 0, 174},
  {1.3433838372088608e+175, 0, 175},
  {2.3932438386350752e+175, 0, 175},
  {4.2972187544143625e+175, 0, 174},
  {8.694788966088642e+175, 0, 175},
  {1.5650872395957953e+176, 0, 176},
  {2.6609127251749555e+176, 0, 176},
  {7.304131091528228e+176, 0, 176},
  {1.8749367638301195e+177, 0, 177},
  {2.525113715353648e+177, 0, 177},
  {5.287208897505958e+177, 0, 177},
  {1.2213351108095344e+178, 0, 178},
  {2.1111997723509844e+178, 0, 178},
  {5.015156723398377e+178, 0, 178},
  {7.845248843802528e+178, 0, 178},
  {1.5083269248992405e+179, 0, 179},
  {5.03076797664753e+179, 0, 178},
  {6.133803460001548e+179, 0, 179},
  {1.7956317799329456e+180, 0, 180},
  {2.805357599815183e+180, 0, 178},
  {6.516381475942179e+180, 0, 180},
  {1.0735479295792078e+181, 0, 181},
  {1.8311493838142104e+181, 0, 181},
  {5.233651721774458e+181, 0, 181},
  {7.965462598423407e+181, 0, 180},
  {1.5936468405690223e+182, 0, 181},
  {4.823391413011241e+182, 0, 182},
  {8.068434006659677e+182, 0, 182},
  {1.1652548548873181e+183, 0, 182},
  {3.145002956331295e+183, 0, 183},
  {6.761293527838664e+183, 0, 182},
  {1.4932090269565783e+184, 0, 184},
  {2.8283859855362886e+184, 0, 184},
  {4.215793138787126e+184, 0, 184},
  {1.2070899708662365e+185, 0, 185},
  {2.2700631068240273e+185, 0, 185},
  {4.0401294303115837e+185, 0, 185},
  {6.426088010351117e+185, 0, 185},
  {1.706800695515592e+186, 0, 186},
  {4.104631682494189e+186, 0, 185},
  {5.818142413455796e+186, 0, 186},
  {1.521111645270472e+187, 0, 187},
  {2.605426852604142e+187, 0, 187},
  {4.105785371952793e+187, 0, 187},
  {1.371762624713214e+188, 0, 188},
  {2.7195986230515428e+188, 0, 188},
  {4.8243077416927026e+188, 0, 187},
  {9.498678712086855e+188, 0, 188},
  {1.5645616537346162e+189, 0, 189},
  {4.111969199449788e+189, 0, 189},
  {8.157644542642784e+189, 0, 188},
  {9.397820074087553e+189, 0, 189},
  {3.0139458754847525e+190, 0, 190},
  {6.799079050215055e+190, 0, 189},
  {1.0012275116878429e+191, 0, 191},
  {1.450477696477974e+191, 0, 191},
  {3.5956024160941395e+191, 0, 191},
  {7.905240079936544e+191, 0, 191},
  {1.5954884853337538e+192, 0, 192},
  {3.104998331330946e+192, 0, 192},
  {8.903071845176859e+192, 0, 192},
  {1.3587214394332288e+193, 0, 191},
  {1.86599842632827e+193, 0, 192},
  {6.954412455796678e+193, 0, 193},
  {1.0832755189816974e+194, 0, 193},
  {1.7216892018906268e+194, 0, 193},
  {2.9919164363027124e+194, 0, 193},
  {7.751180767767667e+194, 0, 194},
  {1.4469419386503595e+195, 0, 195},
  {4.3846223856409726e+195, 0, 195},
  {5.38120316360689e+195, 0, 195},
  {1.1192297812198031e+196, 0, 196},
  {3.6733861060912077e+196, 0, 196},
  {5.367174654182726e+196, 0, 196},
  {1.1985977495349634e+197, 0, 197},
  {2.7706336697369672e+197, 0, 197},
  {3.81638203242153e+197, 0, 197},
  {7.793902438347514e+197, 0, 197},
  {1.762580890481988e+198, 0, 197},
  {4.590880368222411e+198, 0, 198},
  {8.941282866369577e+198, 0, 198},
  {1.8668922163822093e+199, 0, 199},
  {3.3015541406240128e+199, 0, 199},
  {6.66780077867008e+199, 0, 199},
  {8.582818157212463e+199, 0, 199},
  {1.7299550663482326e+200, 0, 199},
  {3.174260421239594e+200, 0, 200},
  {1.0577387790503058e+201, 0, 200},
  {1.869752072792986e+201, 0, 200},
  {2.955061165839854e+201, 0, 201},
  {9.330031602327955e+201, 0, 201},
  {1.9362841443169072e+202, 0, 200},
  {3.825314140412424e+202, 0, 202},
  {5.636134524042645e+202, 0, 202},
  {1.0455633800468254e+203, 0, 203},
  {2.394954328277626e+203, 0, 203},
  {4.637958398638087e+203, 0, 203},
  {8.55447002868069e+203, 0, 203},
  {2.2442269843101123e+204, 0, 204},
  {3.3453762259499943e+204, 0, 204},
  {6.28195345463042e+204, 0, 204},
  {1.568756700441443e+205, 0, 205},
  {2.7948083967253507e+205, 0, 203},
  {5.0694600816666435e+205, 0, 205},
  {1.5167731946556582e+206, 0, 206},
  {1.608485680821464e+206, 0, 206},
  {3.555480059704267e+206, 0, 206},
  {7.943813334385863e+206, 0, 206},
  {1.3580600028505664e+207, 0, 205},
  {5.1194339355719443e+207, 0, 207},
  {6.055737748179178e+207, 0, 207},
  {1.5368136201009418e+208, 0, 207},
  {2.3929799628231875e+208, 0, 208},
  {5.905063752643223e+208, 0, 207},
  {1.2410164169914757e+209, 0, 209},
  {2.1964388171812186e+209, 0, 209},
  {5.643355654143248e+209, 0, 209},
  {1.2832349330194718e+210, 0, 210},
  {2.4701961710739764e+210, 0, 210},
  {4.055943573502299e+210, 0, 209},
  {9.344204033720965e+210, 0, 209},
  {1.5562829932078268e+211, 0, 211},
  {4.0777821620060193e+211, 0, 210},
  {7.651488357127853e+211, 0, 210},
  {1.4653017873373999e+212, 0, 210},
  {3.1057366810904798e+212, 0, 212},
  {3.494919053072309e+212, 0, 211},
  {1.0912691038049118e+213, 0, 213},
  {1.9415837118656972e+213, 0, 213},
  {5.063717719666344e+213, 0, 213},
  {8.227221790228981e+213, 0, 213},
  {1.227440354851669e+214, 0, 214},
  {2.336960786523524e+214, 0, 214},
  {4.516795524723723e+214, 0, 214},
  {9.603333317066072e+214, 0, 214},
  {1.9527229344211296e+215, 0, 213},
  {5.881603409821294e+215, 0, 215},
  {1.3688597232290091e+216, 0, 216},
  {2.295764284659215e+216, 0, 216},
  {3.873452666452653e+216, 0, 215},
  {8.054654093095746e+216, 0, 216},
  {2.1236865355155596e+217, 0, 217},
  {2.2954536079504795e+217, 0, 217},
  {5.09388995969254e+217, 0, 217},
  {8.87462625679e+217, 0, 217},
  {2.3307227637493686e+218, 0, 218},
  {3.6312540549690455e+218, 0, 216},
  {1.0992397195630485e+219, 0, 219},
  {2.5896743857569935e+219, 0, 219},
  {5.2383553757590477e+219, 0, 219},
  {8.90027956004149e+219, 0, 219},
  {2.2251161587610878e+220, 0, 220},
  {2.6761461913428335e+220, 0, 219},
  {5.829314115768354e+220, 0, 220},
  {1.0417852442068364e+221, 0, 221},
  {2.1607520560286885e+221, 0, 221},
  {6.6122291466551174e+221, 0, 221},
  {1.0456456707732716e+222, 0, 222},
  {2.1319581917624135e+222, 0, 222},
  {3.02173423868133e+222, 0, 222},
  {8.957564546729514e+222, 0, 222},
  {1.6091267209523208e+223, 0, 223},
  {3.7212585176976675e+223, 0, 223},
  {7.024301672009426e+223, 0, 223},
  {1.3922688598771826e+224, 0, 224},
  {2.7509119604975913e+224, 0, 224},
  {6.578680864102577e+224, 0, 224},
  {8.127797721199312e+224, 0, 223},
  {2.8202379495294703e+225, 0, 225},
  {3.4957237382552115e+225, 0, 225},
  {6.721082912592893e+225, 0, 225},
  {2.196269058711357e+226, 0, 225},
  {4.702863683113725e+226, 0, 226},
  {9.307324517542515e+226, 0, 226},
  {9.775137400232788e+226, 0, 226},
  {3.311384964585959e+227, 0, 227},
  {4.296740089682654e+227, 0, 227},
  {1.3512844888942569e+228, 0, 228},
  {2.5091984687837548e+228, 0, 228},
  {4.20961732885855e+228, 0, 228},
  {6.135661532855286e+228, 0, 228},
  {1.835960873424025e+229, 0, 228},
  {4.582242303370038e+229, 0, 229},
  {5.018545601421532e+229, 0, 229},
  {1.5236616837822261e+230, 0, 229},
  {2.5667407186328553e+230, 0, 230},
  {6.564151959920961e+230, 0, 230},
  {9.49846077230578e+230, 0, 230},
  {2.2123883505536183e+231, 0, 230},
  {5.172961691829432e+231, 0, 231},
  {1.1249841891755881e+232, 0, 232},
  {1.2896696221903866e+232, 0, 232},
  {4.778497687103402e+232, 0, 232},
  {9.071740946235158e+232, 0, 232},
  {1.36899006488196e+233, 0, 233},
  {3.258574493508666e+233, 0, 233},
  {7.68435010871856e+233, 0, 233},
  {1.0486551202848853e+234, 0, 234},
  {2.5823121007464567e+234, 0, 234},
  {3.773798625179518e+234, 0, 234},
  {8.43646796917978e+234, 0, 234},
  {1.8696054522844014e+235, 0, 235},
  {2.951623859521488e+235, 0, 235},
  {5.731246293623385e+235, 0, 235},
  {1.0607775243868116e+236, 0, 235},
  {2.2867476796644975e+236, 0, 236},
  {6.151644498588618e+236, 0, 236},
  {1.5549079171535267e+237, 0, 237},
  {2.990844031338328e+237, 0, 237},
  {4.227499559860197e+237, 0, 237},
  {6.92155672717332e+237, 0, 237},
  {1.5461124618479105e+238, 0, 238},
  {2.8916888598976405e+238, 0, 238},
  {8.571703697432337e+238, 0, 238},
  {1.5154374230926383e+239, 0, 239},
  {3.991365102553957e+239, 0, 239},
  {8.307426908068283e+239, 0, 239},
  {1.2399350584739399e+240, 0, 240},
  {2.2885616582924817e+240, 0, 240},
  {5.712118804366146e+240, 0, 239},
  {1.1908490153821645e+241, 0, 241},
  {1.6045249823083896e+241, 0, 241},
  {4.212493492663987e+241, 0, 241},
  {7.52651047700803e+241, 0, 241},
  {1.9963765370119968e+242, 0, 242},
  {3.5635374969254025e+242, 0, 242},
  {5.447736670805847e+242, 0, 242},
  {1.1156495207540661e+243, 0, 243},
  {2.3644722323729203e+243, 0, 242},
  {4.9029985515120055e+243, 0, 241},
  {7.61131574093882e+243, 0, 243},
  {1.5041965738192946e+244, 0, 244},
  {3.35946042057764e+244, 0, 244},
  {5.625581093732572e+244, 0, 242},
  {1.730191634549964e+245, 0, 245},
  {3.761446787869432e+245, 0, 244},
  {8.60775465603473e+245, 0, 244},
  {1.1562529259815605e+246, 0, 246},
  {2.246394864375404e+246, 0, 246},
  {6.325983032753727e+246, 0, 246},
  {7.123352302648312e+246, 0, 246},
  {1.523998978888332e+247, 0, 247},
  {4.281781595885279e+247, 0, 247},
  {7.835530851123771e+247, 0, 247},
  {1.506816682188537e+248, 0, 248},
  {4.2240545805625663e+248, 0, 248},
  {6.21305241046745e+248, 0, 248},
  {1.548221225307829e+249, 0, 249},
  {1.8642201656825735e+249, 0, 249},
  {6.106758858401295e+249, 0, 249},
  {1.2843929885114427e+250, 0, 250},
  {1.9018081890692326e+250, 0, 250},
  {4.9450566101263624e+250, 0, 248},
  {1.0162079024060942e+251, 0, 251},
  {1.7447831757371136e+251, 0, 250},
  {4.270366017096213e+251, 0, 250},
  {6.868063596101005e+251, 0, 251},
  {1.822171630415365e+252, 0, 251},
  {1.9952782556234112e+252, 0, 252},
  {7.158784748789308e+252, 0, 252},
  {1.2301580219420288e+253, 0, 253},
  {2.8298450670726808e+253, 0, 253},
  {3.975680900562017e+253, 0, 252},
  {8.709330821451115e+253, 0, 253},
  {2.0174005971626055e+254, 0, 254},
  {2.394882217848989e+254, 0, 254},
  {7.067225914874603e+254, 0, 253},
  {1.8724413449264554e+255, 0, 255},
  {2.8751146201193473e+255, 0, 255},
  {6.421888796776797e+255, 0, 255},
  {7.523354749558753e+255, 0, 254},
  {2.2569755092325087e+256, 0, 254},
  {5.3636854859010334e+256, 0, 256},
  {7.261725338002667e+256, 0, 256},
  {1.8966691176866934e+257, 0, 257},
  {4.4518263636702484e+257, 0, 256},
  {9.255196758728659e+257, 0, 257},
  {1.8593264122501495e+258, 0, 258},
  {3.6316167357983088e+258, 0, 258},
  {6.877505680971994e+258, 0, 258},
  {8.77084305549325e+258, 0, 258},
  {1.722353804283124e+259, 0, 259},
  {3.422411361841639e+259, 0, 259},
  {7.034346313302069e+259, 0, 259},
  {2.1022143522712643e+260, 0, 258},
  {3.9689033579839334e+260, 0, 260},
  {5.348655415676104e+260, 0, 260},
  {1.6669857056073904e+261, 0, 261},
  {2.5268130061515184e+261, 0, 261},
  {7.013556395550645e+261, 0, 261},
  {1.115205775476797e+262, 0, 261},
  {1.8218885128879403e+262, 0, 262},
  {4.882195462759247e+262, 0, 262},
  {1.1647232869439797e+263, 0, 263},
  {2.4733296974221884e+263, 0, 263},
  {3.825561477223162e+263, 0, 263},
  {5.295052253043566e+263, 0, 263},
  {1.7290409059596491e+264, 0, 264},
  {2.8917911522817363e+264, 0, 264},
  {5.3515050581631755e+264, 0, 263},
  {1.0862117360156829e+265, 0, 265},
  {2.312878548854693e+265, 0, 265},
  {5.710434640774437e+265, 0, 265},
  {1.1391963969865948e+266, 0, 266},
  {1.93471671572856e+266, 0, 265},
  {4.71279659258191e+266, 0, 266},
  {9.710448034768053e+266, 0, 266},
  {1.7049690600947821e+267, 0, 267},
  {2.1264667446960467e+267, 0, 267},
  {7.398129672423321e+267, 0, 267},
  {9.763305417386079e+267, 0, 267},
  {2.0663273080075778e+268, 0, 268},
  {5.79917895558858e+268, 0, 268},
  {7.426275326973986e+268, 0, 268},
  {2.1266018116022865e+269, 0, 268},
  {4.31743642311704e+269, 0, 269},
  {8.537997866147938e+269, 0, 269},
  {1.498071428134464e+270, 0, 268},
  {2.2911327982233443e+270, 0, 269},
  {8.038363677318397e+270, 0, 270},
  {1.6367042236629719e+271, 0, 271},
  {1.7563972945923824e+271, 0, 271},
  {4.380651719659702e+271, 0, 271},
  {1.0481984706425231e+272, 0, 272},
  {2.1003524500133663e+272, 0, 272},
  {5.0546833046720617e+272, 0, 272},
  {5.467994685893837e+272, 0, 272},
  {1.2485068025844776e+273, 0, 272},
  {2.8248640371828673e+273, 0, 272},
  {8.391364185949281e+273, 0, 273},
  {1.4139675630970964e+274, 0, 273},
  {2.907211624912509e+274, 0, 274},
  {4.372977278689428e+274, 0, 274},
  {1.2067462091729205e+275, 0, 275},
  {2.224391242910452e+275, 0, 275},
  {4.317611102271228e+275, 0, 275},
  {5.865999613363234e+275, 0, 275},
  {1.8057130538588834e+276, 0, 276},
  {2.684819410822478e+276, 0, 276},
  {6.918394090981146e+276, 0, 276},
  {9.614934849906353e+276, 0, 276},
  {3.489094951176538e+277, 0, 277},
  {6.096297720785519e+277, 0, 276},
  {7.672262077744885e+277, 0, 277},
  {1.7454649363112346e+278, 0, 278},
  {4.3709703490882645e+278, 0, 278},
  {1.0726114671866103e+279, 0, 279},
  {1.3228423831361687e+279, 0, 279},
  {3.696652073770945e+279, 0, 279},
  {5.506752176655332e+279, 0, 278},
  {1.4487895211141177e+280, 0, 280},
  {2.9868446101560017e+280, 0, 279},
  {5.1539637484359395e+280, 0, 280},
  {1.3665660611345062e+281, 0, 281},
  {2.7298170376572543e+281, 0, 280},
  {4.090888763436566e+281, 0, 280},
  {7.150463385743894e+281, 0, 281},
  {1.5175210833272951e+282, 0, 282},
  {4.186412589165422e+282, 0, 282},
  {6.374560719497041e+282, 0, 282},
  {1.5603097675062575e+283, 0, 283},
  {2.303138994294191e+283, 0, 283},
  {6.845537430162203e+283, 0, 283},
  {8.140470197133932e+283, 0, 283},
  {2.8387070865957636e+284, 0, 284},
  {4.7222972051563225e+284, 0, 283},
  {7.735866498835463e+284, 0, 284},
  {1.456494620618158e+285, 0, 285},
  {3.765187536411294e+285, 0, 285},
  {5.407406833340397e+285, 0, 284},
  {1.6691777225183443e+286, 0, 286},
  {2.842291093748383e+286, 0, 285},
  {3.9527246153864666e+286, 0, 286},
  {9.117687890595329e+286, 0, 286},
  {2.6403715176860095e+287, 0, 287},
  {4.672760871330719e+287, 0, 287},
  {9.585177496788628e+287, 0, 285},
  {1.823719730845468e+288, 0, 287},
  {3.3099160671433535e+288, 0, 288},
  {8.394239974695799e+288, 0, 287},
  {1.3765053672754183e+289, 0, 289},
  {3.643679829326757e+289, 0, 289},
  {6.662084711556889e+289, 0, 289},
  {1.4882800748283324e+290, 0, 290},
  {1.8128485634074353e+290, 0, 290},
  {3.59863757645859e+290, 0, 289},
  {1.1306303530723758e+291, 0, 291},
  {1.9883184243838977e+291, 0, 291},
  {3.152458971727972e+291, 0, 291},
  {5.55344865848389e+291, 0, 289},
  {1.9381607498203374e+292, 0, 291},
  {3.364847896300297e+292, 0, 292},
  {6.842765724941906e+292, 0, 291},
  {1.249825938708993e+293, 0, 293},
  {2.392791615385826e+293, 0, 293},
  {4.152722646899415e+293, 0, 293},
  {6.790906283978802e+293, 0, 293},
  {1.3561785760749324e+294, 0, 294},
  {3.341059095259842e+294, 0, 293},
  {9.977930881477503e+294, 0, 294},
  {1.515106038250912e+295, 0, 294},
  {3.002184910089352e+295, 0, 295},
  {5.876579596327993e+295, 0, 295},
  {1.4003917488295084e+296, 0, 296},
  {3.1684232621942047e+296, 0, 296},
  {3.4747005896842154e+296, 0, 296},
  {7.669723855021269e+296, 0, 296},
  {1.3614131925096533e+297, 0, 297},
  {3.191738550947262e+297, 0, 297},
  {8.888378843987562e+297, 0, 297},
  {1.5112090835975456e+298, 0, 298},
  {2.3682327923940456e+298, 0, 298},
  {5.099780421145732e+298, 0, 298},
  {1.0673033377644726e+299, 0, 298},
  {2.378013021177001e+299, 0, 299},
  {6.554057728282088e+299, 0, 299},
  {8.318933161474208e+299, 0, 299},
  {1.3614082701057758e+300, 0, 300},
  {5.35086581101499e+300, 0, 300},
  {8.494089296675853e+300, 0, 299},
  {1.0890134027784214e+301, 0, 301},
  {2.358927877102592e+301, 0, 301},
  {8.117690363105265e+301, 0, 301},
  {9.341511426794588e+301, 0, 301},
  {2.64210043201936e+302, 0, 302},
  {6.847933389378864e+302, 0, 302},
  {1.1002556200184007e+303, 0, 303},
  {2.5611530892094995e+303, 0, 303},
  {5.076344585537476e+303, 0, 303},
  {8.304487832500949e+303, 0, 303},
  {1.1230804446665463e+304, 0, 304},
  {4.2777559220816043e+304, 0, 304},
  {6.283260967439312e+304, 0, 304},
  {1.3747215164191865e+305, 0, 305},
  {3.3096929273918684e+305, 0, 305},
  {6.171133478197849e+305, 0, 305},
  {1.2292521010494213e+306, 0, 306},
  {2.2862202954633178e+306, 0, 305},
  {3.5065941308845355e+306, 0, 306},
  {1.0940422247589228e+307, 0, 307},
  {2.0068458193014486e+307, 0, 306},
  {2.7914963723745636e+307, 0, 307},
  {6.123699292104195e+307, 0, 307},
  {1.7026387749989901e+308, 0, 308},
] of _

# For brevity, we avoid testing all possible combinations of P and X. Instead, we test:
# * All values of P where some X can be affected by rounding. (For double, this is [1, 15].)
# * P == 25, which is arbitrary.
# * P == numeric_limits::max_exponent10 + 1. This selects fixed notation for numeric_limits::max(),
#   so it's the largest interesting value of P.
# * Finally, we test the transitions around X == P - 1, ensuring that we can recognize every value of X.
GEN_TRANSITIONS = [
  {"0x1.8e757928e0c9dp-14", 1, "9e-5"},
  {"0x1.8e757928e0c9ep-14", 1, "0.0001"},
  {"0x1.f212d77318fc5p-11", 1, "0.0009"},
  {"0x1.f212d77318fc6p-11", 1, "0.001"},
  {"0x1.374bc6a7ef9dbp-7", 1, "0.009"},
  {"0x1.374bc6a7ef9dcp-7", 1, "0.01"},
  {"0x1.851eb851eb851p-4", 1, "0.09"},
  {"0x1.851eb851eb852p-4", 1, "0.1"},
  {"0x1.e666666666666p-1", 1, "0.9"},
  {"0x1.e666666666667p-1", 1, "1"},
  {"0x1.2ffffffffffffp+3", 1, "9"},
  {"0x1.3000000000000p+3", 1, "1e+1"},
  {"0x1.a1554fbdad751p-14", 2, "9.9e-5"},
  {"0x1.a1554fbdad752p-14", 2, "0.0001"},
  {"0x1.04d551d68c692p-10", 2, "0.00099"},
  {"0x1.04d551d68c693p-10", 2, "0.001"},
  {"0x1.460aa64c2f837p-7", 2, "0.0099"},
  {"0x1.460aa64c2f838p-7", 2, "0.01"},
  {"0x1.978d4fdf3b645p-4", 2, "0.099"},
  {"0x1.978d4fdf3b646p-4", 2, "0.1"},
  {"0x1.fd70a3d70a3d7p-1", 2, "0.99"},
  {"0x1.fd70a3d70a3d8p-1", 2, "1"},
  {"0x1.3e66666666666p+3", 2, "9.9"},
  {"0x1.3e66666666667p+3", 2, "10"},
  {"0x1.8dfffffffffffp+6", 2, "99"},
  {"0x1.8e00000000000p+6", 2, "1e+2"},
  {"0x1.a3387ecc8eb96p-14", 3, "9.99e-5"},
  {"0x1.a3387ecc8eb97p-14", 3, "0.0001"},
  {"0x1.06034f3fd933ep-10", 3, "0.000999"},
  {"0x1.06034f3fd933fp-10", 3, "0.001"},
  {"0x1.4784230fcf80dp-7", 3, "0.00999"},
  {"0x1.4784230fcf80ep-7", 3, "0.01"},
  {"0x1.99652bd3c3611p-4", 3, "0.0999"},
  {"0x1.99652bd3c3612p-4", 3, "0.1"},
  {"0x1.ffbe76c8b4395p-1", 3, "0.999"},
  {"0x1.ffbe76c8b4396p-1", 3, "1"},
  {"0x1.3fd70a3d70a3dp+3", 3, "9.99"},
  {"0x1.3fd70a3d70a3ep+3", 3, "10"},
  {"0x1.8fcccccccccccp+6", 3, "99.9"},
  {"0x1.8fccccccccccdp+6", 3, "100"},
  {"0x1.f3bffffffffffp+9", 3, "999"},
  {"0x1.f3c0000000000p+9", 3, "1e+3"},
  {"0x1.a368d04e0ba6ap-14", 4, "9.999e-5"},
  {"0x1.a368d04e0ba6bp-14", 4, "0.0001"},
  {"0x1.06218230c7482p-10", 4, "0.0009999"},
  {"0x1.06218230c7483p-10", 4, "0.001"},
  {"0x1.47a9e2bcf91a3p-7", 4, "0.009999"},
  {"0x1.47a9e2bcf91a4p-7", 4, "0.01"},
  {"0x1.99945b6c3760bp-4", 4, "0.09999"},
  {"0x1.99945b6c3760cp-4", 4, "0.1"},
  {"0x1.fff972474538ep-1", 4, "0.9999"},
  {"0x1.fff972474538fp-1", 4, "1"},
  {"0x1.3ffbe76c8b439p+3", 4, "9.999"},
  {"0x1.3ffbe76c8b43ap+3", 4, "10"},
  {"0x1.8ffae147ae147p+6", 4, "99.99"},
  {"0x1.8ffae147ae148p+6", 4, "100"},
  {"0x1.f3f9999999999p+9", 4, "999.9"},
  {"0x1.f3f999999999ap+9", 4, "1000"},
  {"0x1.387bfffffffffp+13", 4, "9999"},
  {"0x1.387c000000000p+13", 4, "1e+4"},
  {"0x1.a36da54164f19p-14", 5, "9.9999e-5"},
  {"0x1.a36da54164f1ap-14", 5, "0.0001"},
  {"0x1.06248748df16fp-10", 5, "0.00099999"},
  {"0x1.06248748df170p-10", 5, "0.001"},
  {"0x1.47ada91b16dcbp-7", 5, "0.0099999"},
  {"0x1.47ada91b16dccp-7", 5, "0.01"},
  {"0x1.99991361dc93ep-4", 5, "0.099999"},
  {"0x1.99991361dc93fp-4", 5, "0.1"},
  {"0x1.ffff583a53b8ep-1", 5, "0.99999"},
  {"0x1.ffff583a53b8fp-1", 5, "1"},
  {"0x1.3fff972474538p+3", 5, "9.9999"},
  {"0x1.3fff972474539p+3", 5, "10"},
  {"0x1.8fff7ced91687p+6", 5, "99.999"},
  {"0x1.8fff7ced91688p+6", 5, "100"},
  {"0x1.f3ff5c28f5c28p+9", 5, "999.99"},
  {"0x1.f3ff5c28f5c29p+9", 5, "1000"},
  {"0x1.387f999999999p+13", 5, "9999.9"},
  {"0x1.387f99999999ap+13", 5, "10000"},
  {"0x1.869f7ffffffffp+16", 5, "99999"},
  {"0x1.869f800000000p+16", 5, "1e+5"},
  {"0x1.a36e20f35445dp-14", 6, "9.99999e-5"},
  {"0x1.a36e20f35445ep-14", 6, "0.0001"},
  {"0x1.0624d49814abap-10", 6, "0.000999999"},
  {"0x1.0624d49814abbp-10", 6, "0.001"},
  {"0x1.47ae09be19d69p-7", 6, "0.00999999"},
  {"0x1.47ae09be19d6ap-7", 6, "0.01"},
  {"0x1.99998c2da04c3p-4", 6, "0.0999999"},
  {"0x1.99998c2da04c4p-4", 6, "0.1"},
  {"0x1.ffffef39085f4p-1", 6, "0.999999"},
  {"0x1.ffffef39085f5p-1", 6, "1"},
  {"0x1.3ffff583a53b8p+3", 6, "9.99999"},
  {"0x1.3ffff583a53b9p+3", 6, "10"},
  {"0x1.8ffff2e48e8a7p+6", 6, "99.9999"},
  {"0x1.8ffff2e48e8a8p+6", 6, "100"},
  {"0x1.f3ffef9db22d0p+9", 6, "999.999"},
  {"0x1.f3ffef9db22d1p+9", 6, "1000"},
  {"0x1.387ff5c28f5c2p+13", 6, "9999.99"},
  {"0x1.387ff5c28f5c3p+13", 6, "10000"},
  {"0x1.869ff33333333p+16", 6, "99999.9"},
  {"0x1.869ff33333334p+16", 6, "100000"},
  {"0x1.e847effffffffp+19", 6, "999999"},
  {"0x1.e847f00000000p+19", 6, "1e+6"},
  {"0x1.a36e2d51ec34bp-14", 7, "9.999999e-5"},
  {"0x1.a36e2d51ec34cp-14", 7, "0.0001"},
  {"0x1.0624dc5333a0ep-10", 7, "0.0009999999"},
  {"0x1.0624dc5333a0fp-10", 7, "0.001"},
  {"0x1.47ae136800892p-7", 7, "0.009999999"},
  {"0x1.47ae136800893p-7", 7, "0.01"},
  {"0x1.9999984200ab7p-4", 7, "0.09999999"},
  {"0x1.9999984200ab8p-4", 7, "0.1"},
  {"0x1.fffffe5280d65p-1", 7, "0.9999999"},
  {"0x1.fffffe5280d66p-1", 7, "1"},
  {"0x1.3ffffef39085fp+3", 7, "9.999999"},
  {"0x1.3ffffef390860p+3", 7, "10"},
  {"0x1.8ffffeb074a77p+6", 7, "99.99999"},
  {"0x1.8ffffeb074a78p+6", 7, "100"},
  {"0x1.f3fffe5c91d14p+9", 7, "999.9999"},
  {"0x1.f3fffe5c91d15p+9", 7, "1000"},
  {"0x1.387ffef9db22dp+13", 7, "9999.999"},
  {"0x1.387ffef9db22ep+13", 7, "10000"},
  {"0x1.869ffeb851eb8p+16", 7, "99999.99"},
  {"0x1.869ffeb851eb9p+16", 7, "100000"},
  {"0x1.e847fe6666666p+19", 7, "999999.9"},
  {"0x1.e847fe6666667p+19", 7, "1000000"},
  {"0x1.312cfefffffffp+23", 7, "9999999"},
  {"0x1.312cff0000000p+23", 7, "1e+7"},
  {"0x1.a36e2e8e94ffcp-14", 8, "9.9999999e-5"},
  {"0x1.a36e2e8e94ffdp-14", 8, "0.0001"},
  {"0x1.0624dd191d1fdp-10", 8, "0.00099999999"},
  {"0x1.0624dd191d1fep-10", 8, "0.001"},
  {"0x1.47ae145f6467dp-7", 8, "0.0099999999"},
  {"0x1.47ae145f6467ep-7", 8, "0.01"},
  {"0x1.999999773d81cp-4", 8, "0.099999999"},
  {"0x1.999999773d81dp-4", 8, "0.1"},
  {"0x1.ffffffd50ce23p-1", 8, "0.99999999"},
  {"0x1.ffffffd50ce24p-1", 8, "1"},
  {"0x1.3fffffe5280d6p+3", 8, "9.9999999"},
  {"0x1.3fffffe5280d7p+3", 8, "10"},
  {"0x1.8fffffde7210bp+6", 8, "99.999999"},
  {"0x1.8fffffde7210cp+6", 8, "100"},
  {"0x1.f3ffffd60e94ep+9", 8, "999.99999"},
  {"0x1.f3ffffd60e94fp+9", 8, "1000"},
  {"0x1.387fffe5c91d1p+13", 8, "9999.9999"},
  {"0x1.387fffe5c91d2p+13", 8, "10000"},
  {"0x1.869fffdf3b645p+16", 8, "99999.999"},
  {"0x1.869fffdf3b646p+16", 8, "100000"},
  {"0x1.e847ffd70a3d7p+19", 8, "999999.99"},
  {"0x1.e847ffd70a3d8p+19", 8, "1000000"},
  {"0x1.312cffe666666p+23", 8, "9999999.9"},
  {"0x1.312cffe666667p+23", 8, "10000000"},
  {"0x1.7d783fdffffffp+26", 8, "99999999"},
  {"0x1.7d783fe000000p+26", 8, "1e+8"},
  {"0x1.a36e2eae3f7a7p-14", 9, "9.99999999e-5"},
  {"0x1.a36e2eae3f7a8p-14", 9, "0.0001"},
  {"0x1.0624dd2ce7ac8p-10", 9, "0.000999999999"},
  {"0x1.0624dd2ce7ac9p-10", 9, "0.001"},
  {"0x1.47ae14782197bp-7", 9, "0.00999999999"},
  {"0x1.47ae14782197cp-7", 9, "0.01"},
  {"0x1.9999999629fd9p-4", 9, "0.0999999999"},
  {"0x1.9999999629fdap-4", 9, "0.1"},
  {"0x1.fffffffbb47d0p-1", 9, "0.999999999"},
  {"0x1.fffffffbb47d1p-1", 9, "1"},
  {"0x1.3ffffffd50ce2p+3", 9, "9.99999999"},
  {"0x1.3ffffffd50ce3p+3", 9, "10"},
  {"0x1.8ffffffca501ap+6", 9, "99.9999999"},
  {"0x1.8ffffffca501bp+6", 9, "100"},
  {"0x1.f3fffffbce421p+9", 9, "999.999999"},
  {"0x1.f3fffffbce422p+9", 9, "1000"},
  {"0x1.387ffffd60e94p+13", 9, "9999.99999"},
  {"0x1.387ffffd60e95p+13", 9, "10000"},
  {"0x1.869ffffcb923ap+16", 9, "99999.9999"},
  {"0x1.869ffffcb923bp+16", 9, "100000"},
  {"0x1.e847fffbe76c8p+19", 9, "999999.999"},
  {"0x1.e847fffbe76c9p+19", 9, "1000000"},
  {"0x1.312cfffd70a3dp+23", 9, "9999999.99"},
  {"0x1.312cfffd70a3ep+23", 9, "10000000"},
  {"0x1.7d783ffccccccp+26", 9, "99999999.9"},
  {"0x1.7d783ffcccccdp+26", 9, "100000000"},
  {"0x1.dcd64ffbfffffp+29", 9, "999999999"},
  {"0x1.dcd64ffc00000p+29", 9, "1e+9"},
  {"0x1.a36e2eb16a205p-14", 10, "9.999999999e-5"},
  {"0x1.a36e2eb16a206p-14", 10, "0.0001"},
  {"0x1.0624dd2ee2543p-10", 10, "0.0009999999999"},
  {"0x1.0624dd2ee2544p-10", 10, "0.001"},
  {"0x1.47ae147a9ae94p-7", 10, "0.009999999999"},
  {"0x1.47ae147a9ae95p-7", 10, "0.01"},
  {"0x1.9999999941a39p-4", 10, "0.09999999999"},
  {"0x1.9999999941a3ap-4", 10, "0.1"},
  {"0x1.ffffffff920c8p-1", 10, "0.9999999999"},
  {"0x1.ffffffff920c9p-1", 10, "1"},
  {"0x1.3fffffffbb47dp+3", 10, "9.999999999"},
  {"0x1.3fffffffbb47ep+3", 10, "10"},
  {"0x1.8fffffffaa19cp+6", 10, "99.99999999"},
  {"0x1.8fffffffaa19dp+6", 10, "100"},
  {"0x1.f3ffffff94a03p+9", 10, "999.9999999"},
  {"0x1.f3ffffff94a04p+9", 10, "1000"},
  {"0x1.387fffffbce42p+13", 10, "9999.999999"},
  {"0x1.387fffffbce43p+13", 10, "10000"},
  {"0x1.869fffffac1d2p+16", 10, "99999.99999"},
  {"0x1.869fffffac1d3p+16", 10, "100000"},
  {"0x1.e847ffff97247p+19", 10, "999999.9999"},
  {"0x1.e847ffff97248p+19", 10, "1000000"},
  {"0x1.312cffffbe76cp+23", 10, "9999999.999"},
  {"0x1.312cffffbe76dp+23", 10, "10000000"},
  {"0x1.7d783fffae147p+26", 10, "99999999.99"},
  {"0x1.7d783fffae148p+26", 10, "100000000"},
  {"0x1.dcd64fff99999p+29", 10, "999999999.9"},
  {"0x1.dcd64fff9999ap+29", 10, "1000000000"},
  {"0x1.2a05f1ffbffffp+33", 10, "9999999999"},
  {"0x1.2a05f1ffc0000p+33", 10, "1e+10"},
  {"0x1.a36e2eb1bb30fp-14", 11, "9.9999999999e-5"},
  {"0x1.a36e2eb1bb310p-14", 11, "0.0001"},
  {"0x1.0624dd2f14fe9p-10", 11, "0.00099999999999"},
  {"0x1.0624dd2f14feap-10", 11, "0.001"},
  {"0x1.47ae147ada3e3p-7", 11, "0.0099999999999"},
  {"0x1.47ae147ada3e4p-7", 11, "0.01"},
  {"0x1.9999999990cdcp-4", 11, "0.099999999999"},
  {"0x1.9999999990cddp-4", 11, "0.1"},
  {"0x1.fffffffff5014p-1", 11, "0.99999999999"},
  {"0x1.fffffffff5015p-1", 11, "1"},
  {"0x1.3ffffffff920cp+3", 11, "9.9999999999"},
  {"0x1.3ffffffff920dp+3", 11, "10"},
  {"0x1.8ffffffff768fp+6", 11, "99.999999999"},
  {"0x1.8ffffffff7690p+6", 11, "100"},
  {"0x1.f3fffffff5433p+9", 11, "999.99999999"},
  {"0x1.f3fffffff5434p+9", 11, "1000"},
  {"0x1.387ffffff94a0p+13", 11, "9999.9999999"},
  {"0x1.387ffffff94a1p+13", 11, "10000"},
  {"0x1.869ffffff79c8p+16", 11, "99999.999999"},
  {"0x1.869ffffff79c9p+16", 11, "100000"},
  {"0x1.e847fffff583ap+19", 11, "999999.99999"},
  {"0x1.e847fffff583bp+19", 11, "1000000"},
  {"0x1.312cfffff9724p+23", 11, "9999999.9999"},
  {"0x1.312cfffff9725p+23", 11, "10000000"},
  {"0x1.7d783ffff7cedp+26", 11, "99999999.999"},
  {"0x1.7d783ffff7ceep+26", 11, "100000000"},
  {"0x1.dcd64ffff5c28p+29", 11, "999999999.99"},
  {"0x1.dcd64ffff5c29p+29", 11, "1000000000"},
  {"0x1.2a05f1fff9999p+33", 11, "9999999999.9"},
  {"0x1.2a05f1fff999ap+33", 11, "10000000000"},
  {"0x1.74876e7ff7fffp+36", 11, "99999999999"},
  {"0x1.74876e7ff8000p+36", 11, "1e+11"},
  {"0x1.a36e2eb1c34c3p-14", 12, "9.99999999999e-5"},
  {"0x1.a36e2eb1c34c4p-14", 12, "0.0001"},
  {"0x1.0624dd2f1a0fap-10", 12, "0.000999999999999"},
  {"0x1.0624dd2f1a0fbp-10", 12, "0.001"},
  {"0x1.47ae147ae0938p-7", 12, "0.00999999999999"},
  {"0x1.47ae147ae0939p-7", 12, "0.01"},
  {"0x1.9999999998b86p-4", 12, "0.0999999999999"},
  {"0x1.9999999998b87p-4", 12, "0.1"},
  {"0x1.fffffffffee68p-1", 12, "0.999999999999"},
  {"0x1.fffffffffee69p-1", 12, "1"},
  {"0x1.3fffffffff501p+3", 12, "9.99999999999"},
  {"0x1.3fffffffff502p+3", 12, "10"},
  {"0x1.8fffffffff241p+6", 12, "99.9999999999"},
  {"0x1.8fffffffff242p+6", 12, "100"},
  {"0x1.f3fffffffeed1p+9", 12, "999.999999999"},
  {"0x1.f3fffffffeed2p+9", 12, "1000"},
  {"0x1.387fffffff543p+13", 12, "9999.99999999"},
  {"0x1.387fffffff544p+13", 12, "10000"},
  {"0x1.869fffffff294p+16", 12, "99999.9999999"},
  {"0x1.869fffffff295p+16", 12, "100000"},
  {"0x1.e847fffffef39p+19", 12, "999999.999999"},
  {"0x1.e847fffffef3ap+19", 12, "1000000"},
  {"0x1.312cffffff583p+23", 12, "9999999.99999"},
  {"0x1.312cffffff584p+23", 12, "10000000"},
  {"0x1.7d783fffff2e4p+26", 12, "99999999.9999"},
  {"0x1.7d783fffff2e5p+26", 12, "100000000"},
  {"0x1.dcd64ffffef9dp+29", 12, "999999999.999"},
  {"0x1.dcd64ffffef9ep+29", 12, "1000000000"},
  {"0x1.2a05f1ffff5c2p+33", 12, "9999999999.99"},
  {"0x1.2a05f1ffff5c3p+33", 12, "10000000000"},
  {"0x1.74876e7fff333p+36", 12, "99999999999.9"},
  {"0x1.74876e7fff334p+36", 12, "100000000000"},
  {"0x1.d1a94a1ffefffp+39", 12, "999999999999"},
  {"0x1.d1a94a1fff000p+39", 12, "1e+12"},
  {"0x1.a36e2eb1c41bbp-14", 13, "9.999999999999e-5"},
  {"0x1.a36e2eb1c41bcp-14", 13, "0.0001"},
  {"0x1.0624dd2f1a915p-10", 13, "0.0009999999999999"},
  {"0x1.0624dd2f1a916p-10", 13, "0.001"},
  {"0x1.47ae147ae135ap-7", 13, "0.009999999999999"},
  {"0x1.47ae147ae135bp-7", 13, "0.01"},
  {"0x1.9999999999831p-4", 13, "0.09999999999999"},
  {"0x1.9999999999832p-4", 13, "0.1"},
  {"0x1.ffffffffffe3dp-1", 13, "0.9999999999999"},
  {"0x1.ffffffffffe3ep-1", 13, "1"},
  {"0x1.3fffffffffee6p+3", 13, "9.999999999999"},
  {"0x1.3fffffffffee7p+3", 13, "10"},
  {"0x1.8fffffffffea0p+6", 13, "99.99999999999"},
  {"0x1.8fffffffffea1p+6", 13, "100"},
  {"0x1.f3ffffffffe48p+9", 13, "999.9999999999"},
  {"0x1.f3ffffffffe49p+9", 13, "1000"},
  {"0x1.387fffffffeedp+13", 13, "9999.999999999"},
  {"0x1.387fffffffeeep+13", 13, "10000"},
  {"0x1.869fffffffea8p+16", 13, "99999.99999999"},
  {"0x1.869fffffffea9p+16", 13, "100000"},
  {"0x1.e847ffffffe52p+19", 13, "999999.9999999"},
  {"0x1.e847ffffffe53p+19", 13, "1000000"},
  {"0x1.312cffffffef3p+23", 13, "9999999.999999"},
  {"0x1.312cffffffef4p+23", 13, "10000000"},
  {"0x1.7d783fffffeb0p+26", 13, "99999999.99999"},
  {"0x1.7d783fffffeb1p+26", 13, "100000000"},
  {"0x1.dcd64fffffe5cp+29", 13, "999999999.9999"},
  {"0x1.dcd64fffffe5dp+29", 13, "1000000000"},
  {"0x1.2a05f1ffffef9p+33", 13, "9999999999.999"},
  {"0x1.2a05f1ffffefap+33", 13, "10000000000"},
  {"0x1.74876e7fffeb8p+36", 13, "99999999999.99"},
  {"0x1.74876e7fffeb9p+36", 13, "100000000000"},
  {"0x1.d1a94a1fffe66p+39", 13, "999999999999.9"},
  {"0x1.d1a94a1fffe67p+39", 13, "1000000000000"},
  {"0x1.2309ce53ffeffp+43", 13, "9999999999999"},
  {"0x1.2309ce53fff00p+43", 13, "1e+13"},
  {"0x1.a36e2eb1c4307p-14", 14, "9.9999999999999e-5"},
  {"0x1.a36e2eb1c4308p-14", 14, "0.0001"},
  {"0x1.0624dd2f1a9e4p-10", 14, "0.00099999999999999"},
  {"0x1.0624dd2f1a9e5p-10", 14, "0.001"},
  {"0x1.47ae147ae145ep-7", 14, "0.0099999999999999"},
  {"0x1.47ae147ae145fp-7", 14, "0.01"},
  {"0x1.9999999999975p-4", 14, "0.099999999999999"},
  {"0x1.9999999999976p-4", 14, "0.1"},
  {"0x1.fffffffffffd2p-1", 14, "0.99999999999999"},
  {"0x1.fffffffffffd3p-1", 14, "1"},
  {"0x1.3ffffffffffe3p+3", 14, "9.9999999999999"},
  {"0x1.3ffffffffffe4p+3", 14, "10"},
  {"0x1.8ffffffffffdcp+6", 14, "99.999999999999"},
  {"0x1.8ffffffffffddp+6", 14, "100"},
  {"0x1.f3fffffffffd4p+9", 14, "999.99999999999"},
  {"0x1.f3fffffffffd5p+9", 14, "1000"},
  {"0x1.387ffffffffe4p+13", 14, "9999.9999999999"},
  {"0x1.387ffffffffe5p+13", 14, "10000"},
  {"0x1.869ffffffffddp+16", 14, "99999.999999999"},
  {"0x1.869ffffffffdep+16", 14, "100000"},
  {"0x1.e847fffffffd5p+19", 14, "999999.99999999"},
  {"0x1.e847fffffffd6p+19", 14, "1000000"},
  {"0x1.312cfffffffe5p+23", 14, "9999999.9999999"},
  {"0x1.312cfffffffe6p+23", 14, "10000000"},
  {"0x1.7d783ffffffdep+26", 14, "99999999.999999"},
  {"0x1.7d783ffffffdfp+26", 14, "100000000"},
  {"0x1.dcd64ffffffd6p+29", 14, "999999999.99999"},
  {"0x1.dcd64ffffffd7p+29", 14, "1000000000"},
  {"0x1.2a05f1fffffe5p+33", 14, "9999999999.9999"},
  {"0x1.2a05f1fffffe6p+33", 14, "10000000000"},
  {"0x1.74876e7ffffdfp+36", 14, "99999999999.999"},
  {"0x1.74876e7ffffe0p+36", 14, "100000000000"},
  {"0x1.d1a94a1ffffd7p+39", 14, "999999999999.99"},
  {"0x1.d1a94a1ffffd8p+39", 14, "1000000000000"},
  {"0x1.2309ce53fffe6p+43", 14, "9999999999999.9"},
  {"0x1.2309ce53fffe7p+43", 14, "10000000000000"},
  {"0x1.6bcc41e8fffdfp+46", 14, "99999999999999"},
  {"0x1.6bcc41e8fffe0p+46", 14, "1e+14"},
  {"0x1.a36e2eb1c4328p-14", 15, "9.99999999999999e-5"},
  {"0x1.a36e2eb1c4329p-14", 15, "0.0001"},
  {"0x1.0624dd2f1a9f9p-10", 15, "0.000999999999999999"},
  {"0x1.0624dd2f1a9fap-10", 15, "0.001"},
  {"0x1.47ae147ae1477p-7", 15, "0.00999999999999999"},
  {"0x1.47ae147ae1478p-7", 15, "0.01"},
  {"0x1.9999999999995p-4", 15, "0.0999999999999999"},
  {"0x1.9999999999996p-4", 15, "0.1"},
  {"0x1.ffffffffffffbp-1", 15, "0.999999999999999"},
  {"0x1.ffffffffffffcp-1", 15, "1"},
  {"0x1.3fffffffffffdp+3", 15, "9.99999999999999"},
  {"0x1.3fffffffffffep+3", 15, "10"},
  {"0x1.8fffffffffffcp+6", 15, "99.9999999999999"},
  {"0x1.8fffffffffffdp+6", 15, "100"},
  {"0x1.f3ffffffffffbp+9", 15, "999.999999999999"},
  {"0x1.f3ffffffffffcp+9", 15, "1000"},
  {"0x1.387fffffffffdp+13", 15, "9999.99999999999"},
  {"0x1.387fffffffffep+13", 15, "10000"},
  {"0x1.869fffffffffcp+16", 15, "99999.9999999999"},
  {"0x1.869fffffffffdp+16", 15, "100000"},
  {"0x1.e847ffffffffbp+19", 15, "999999.999999999"},
  {"0x1.e847ffffffffcp+19", 15, "1000000"},
  {"0x1.312cffffffffdp+23", 15, "9999999.99999999"},
  {"0x1.312cffffffffep+23", 15, "10000000"},
  {"0x1.7d783fffffffcp+26", 15, "99999999.9999999"},
  {"0x1.7d783fffffffdp+26", 15, "100000000"},
  {"0x1.dcd64fffffffbp+29", 15, "999999999.999999"},
  {"0x1.dcd64fffffffcp+29", 15, "1000000000"},
  {"0x1.2a05f1ffffffdp+33", 15, "9999999999.99999"},
  {"0x1.2a05f1ffffffep+33", 15, "10000000000"},
  {"0x1.74876e7fffffcp+36", 15, "99999999999.9999"},
  {"0x1.74876e7fffffdp+36", 15, "100000000000"},
  {"0x1.d1a94a1fffffbp+39", 15, "999999999999.999"},
  {"0x1.d1a94a1fffffcp+39", 15, "1000000000000"},
  {"0x1.2309ce53ffffdp+43", 15, "9999999999999.99"},
  {"0x1.2309ce53ffffep+43", 15, "10000000000000"},
  {"0x1.6bcc41e8ffffcp+46", 15, "99999999999999.9"},
  {"0x1.6bcc41e8ffffdp+46", 15, "100000000000000"},
  {"0x1.c6bf52633fffbp+49", 15, "999999999999999"},
  {"0x1.c6bf52633fffcp+49", 15, "1e+15"},
  {"0x1.1c37937e07fffp+53", 16, "9999999999999998"},
  {"0x1.1c37937e08000p+53", 16, "1e+16"},
  {"0x1.6345785d89fffp+56", 17, "99999999999999984"},
  {"0x1.6345785d8a000p+56", 17, "1e+17"},
  {"0x1.bc16d674ec7ffp+59", 18, "999999999999999872"},
  {"0x1.bc16d674ec800p+59", 18, "1e+18"},
  {"0x1.158e460913cffp+63", 19, "9999999999999997952"},
  {"0x1.158e460913d00p+63", 19, "1e+19"},
  {"0x1.5af1d78b58c3fp+66", 20, "99999999999999983616"},
  {"0x1.5af1d78b58c40p+66", 20, "1e+20"},
  {"0x1.b1ae4d6e2ef4fp+69", 21, "999999999999999868928"},
  {"0x1.b1ae4d6e2ef50p+69", 21, "1e+21"},
  {"0x1.0f0cf064dd591p+73", 22, "9999999999999997902848"},
  {"0x1.0f0cf064dd592p+73", 22, "1e+22"},
  {"0x1.52d02c7e14af6p+76", 23, "99999999999999991611392"},
  {"0x1.52d02c7e14af7p+76", 23, "1.0000000000000000838861e+23"},
  {"0x1.a784379d99db4p+79", 24, "999999999999999983222784"},
  {"0x1.a784379d99db5p+79", 24, "1.00000000000000011744051e+24"},
  {"0x1.a36e2eb1c432cp-14", 25, "9.999999999999999123964645e-5"},
  {"0x1.a36e2eb1c432dp-14", 25, "0.0001000000000000000047921736"},
  {"0x1.0624dd2f1a9fbp-10", 25, "0.0009999999999999998039762472"},
  {"0x1.0624dd2f1a9fcp-10", 25, "0.001000000000000000020816682"},
  {"0x1.47ae147ae147ap-7", 25, "0.009999999999999998473443341"},
  {"0x1.47ae147ae147bp-7", 25, "0.01000000000000000020816682"},
  {"0x1.9999999999999p-4", 25, "0.09999999999999999167332732"},
  {"0x1.999999999999ap-4", 25, "0.1000000000000000055511151"},
  {"0x1.fffffffffffffp-1", 25, "0.9999999999999998889776975"},
  {"0x1.0000000000000p+0", 25, "1"},
  {"0x1.3ffffffffffffp+3", 25, "9.999999999999998223643161"},
  {"0x1.4000000000000p+3", 25, "10"},
  {"0x1.8ffffffffffffp+6", 25, "99.99999999999998578914528"},
  {"0x1.9000000000000p+6", 25, "100"},
  {"0x1.f3fffffffffffp+9", 25, "999.9999999999998863131623"},
  {"0x1.f400000000000p+9", 25, "1000"},
  {"0x1.387ffffffffffp+13", 25, "9999.999999999998181010596"},
  {"0x1.3880000000000p+13", 25, "10000"},
  {"0x1.869ffffffffffp+16", 25, "99999.99999999998544808477"},
  {"0x1.86a0000000000p+16", 25, "100000"},
  {"0x1.e847fffffffffp+19", 25, "999999.9999999998835846782"},
  {"0x1.e848000000000p+19", 25, "1000000"},
  {"0x1.312cfffffffffp+23", 25, "9999999.999999998137354851"},
  {"0x1.312d000000000p+23", 25, "10000000"},
  {"0x1.7d783ffffffffp+26", 25, "99999999.99999998509883881"},
  {"0x1.7d78400000000p+26", 25, "100000000"},
  {"0x1.dcd64ffffffffp+29", 25, "999999999.9999998807907104"},
  {"0x1.dcd6500000000p+29", 25, "1000000000"},
  {"0x1.2a05f1fffffffp+33", 25, "9999999999.999998092651367"},
  {"0x1.2a05f20000000p+33", 25, "10000000000"},
  {"0x1.74876e7ffffffp+36", 25, "99999999999.99998474121094"},
  {"0x1.74876e8000000p+36", 25, "100000000000"},
  {"0x1.d1a94a1ffffffp+39", 25, "999999999999.9998779296875"},
  {"0x1.d1a94a2000000p+39", 25, "1000000000000"},
  {"0x1.2309ce53fffffp+43", 25, "9999999999999.998046875"},
  {"0x1.2309ce5400000p+43", 25, "10000000000000"},
  {"0x1.6bcc41e8fffffp+46", 25, "99999999999999.984375"},
  {"0x1.6bcc41e900000p+46", 25, "100000000000000"},
  {"0x1.c6bf52633ffffp+49", 25, "999999999999999.875"},
  {"0x1.c6bf526340000p+49", 25, "1000000000000000"},
  {"0x1.1c37937e07fffp+53", 25, "9999999999999998"},
  {"0x1.1c37937e08000p+53", 25, "10000000000000000"},
  {"0x1.6345785d89fffp+56", 25, "99999999999999984"},
  {"0x1.6345785d8a000p+56", 25, "100000000000000000"},
  {"0x1.bc16d674ec7ffp+59", 25, "999999999999999872"},
  {"0x1.bc16d674ec800p+59", 25, "1000000000000000000"},
  {"0x1.158e460913cffp+63", 25, "9999999999999997952"},
  {"0x1.158e460913d00p+63", 25, "10000000000000000000"},
  {"0x1.5af1d78b58c3fp+66", 25, "99999999999999983616"},
  {"0x1.5af1d78b58c40p+66", 25, "100000000000000000000"},
  {"0x1.b1ae4d6e2ef4fp+69", 25, "999999999999999868928"},
  {"0x1.b1ae4d6e2ef50p+69", 25, "1000000000000000000000"},
  {"0x1.0f0cf064dd591p+73", 25, "9999999999999997902848"},
  {"0x1.0f0cf064dd592p+73", 25, "10000000000000000000000"},
  {"0x1.52d02c7e14af6p+76", 25, "99999999999999991611392"},
  {"0x1.52d02c7e14af7p+76", 25, "100000000000000008388608"},
  {"0x1.a784379d99db4p+79", 25, "999999999999999983222784"},
  {"0x1.a784379d99db5p+79", 25, "1000000000000000117440512"},
  {"0x1.08b2a2c280290p+83", 25, "9999999999999998758486016"},
  {"0x1.08b2a2c280291p+83", 25, "1.000000000000000090596966e+25"},
  {"0x1.4adf4b7320334p+86", 26, "99999999999999987584860160"},
  {"0x1.4adf4b7320335p+86", 26, "1.0000000000000000476472934e+26"},
  {"0x1.9d971e4fe8401p+89", 27, "999999999999999875848601600"},
  {"0x1.9d971e4fe8402p+89", 27, "1.00000000000000001328755507e+27"},
  {"0x1.027e72f1f1281p+93", 28, "9999999999999999583119736832"},
  {"0x1.027e72f1f1282p+93", 28, "1.000000000000000178214299238e+28"},
  {"0x1.431e0fae6d721p+96", 29, "99999999999999991433150857216"},
  {"0x1.431e0fae6d722p+96", 29, "1.0000000000000000902533690163e+29"},
  {"0x1.93e5939a08ce9p+99", 30, "999999999999999879147136483328"},
  {"0x1.93e5939a08ceap+99", 30, "1.00000000000000001988462483866e+30"},
  {"0x1.f8def8808b024p+102", 31, "9999999999999999635896294965248"},
  {"0x1.f8def8808b025p+102", 31, "1.000000000000000076179620180787e+31"},
  {"0x1.3b8b5b5056e16p+106", 32, "99999999999999987351763694911488"},
  {"0x1.3b8b5b5056e17p+106", 32, "1.0000000000000000536616220439347e+32"},
  {"0x1.8a6e32246c99cp+109", 33, "999999999999999945575230987042816"},
  {"0x1.8a6e32246c99dp+109", 33, "1.00000000000000008969041906289869e+33"},
  {"0x1.ed09bead87c03p+112", 34, "9999999999999999455752309870428160"},
  {"0x1.ed09bead87c04p+112", 34, "1.000000000000000060867381447727514e+34"},
  {"0x1.3426172c74d82p+116", 35, "99999999999999996863366107917975552"},
  {"0x1.3426172c74d83p+116", 35, "1.0000000000000001531011018162752717e+35"},
  {"0x1.812f9cf7920e2p+119", 36, "999999999999999894846684784341549056"},
  {"0x1.812f9cf7920e3p+119", 36, "1.00000000000000004242063737401796198e+36"},
  {"0x1.e17b84357691bp+122", 37, "9999999999999999538762658202121142272"},
  {"0x1.e17b84357691cp+122", 37, "1.00000000000000007193542789195324457e+37"},
  {"0x1.2ced32a16a1b1p+126", 38, "99999999999999997748809823456034029568"},
  {"0x1.2ced32a16a1b2p+126", 38, "1.0000000000000001663827575493461488435e+38"},
  {"0x1.78287f49c4a1dp+129", 39, "999999999999999939709166371603178586112"},
  {"0x1.78287f49c4a1ep+129", 39, "1.00000000000000009082489382343182542438e+39"},
  {"0x1.d6329f1c35ca4p+132", 40, "9999999999999999094860208812374492184576"},
  {"0x1.d6329f1c35ca5p+132", 40, "1.000000000000000030378602842700366689075e+40"},
  {"0x1.25dfa371a19e6p+136", 41, "99999999999999981277195531206711524196352"},
  {"0x1.25dfa371a19e7p+136", 41, "1.0000000000000000062000864504077831949517e+41"},
  {"0x1.6f578c4e0a060p+139", 42, "999999999999999890143207767403382423158784"},
  {"0x1.6f578c4e0a061p+139", 42, "1.00000000000000004488571267807591678554931e+42"},
  {"0x1.cb2d6f618c878p+142", 43, "9999999999999998901432077674033824231587840"},
  {"0x1.cb2d6f618c879p+142", 43, "1.000000000000000013937211695941409913071206e+43"},
  {"0x1.1efc659cf7d4bp+146", 44, "99999999999999989014320776740338242315878400"},
  {"0x1.1efc659cf7d4cp+146", 44, "1.0000000000000000882136140530642264070186598e+44"},
  {"0x1.66bb7f0435c9ep+149", 45, "999999999999999929757289024535551219930759168"},
  {"0x1.66bb7f0435c9fp+149", 45, "1.00000000000000008821361405306422640701865984e+45"},
  {"0x1.c06a5ec5433c6p+152", 46, "9999999999999999931398190359470212947659194368"},
  {"0x1.c06a5ec5433c7p+152", 46, "1.000000000000000119904879058769961444436239974e+46"},
  {"0x1.18427b3b4a05bp+156", 47, "99999999999999984102174700855949311516153479168"},
  {"0x1.18427b3b4a05cp+156", 47, "1.0000000000000000438458430450761973546340476518e+47"},
  {"0x1.5e531a0a1c872p+159", 48, "999999999999999881586566215862833963056037363712"},
  {"0x1.5e531a0a1c873p+159", 48, "1.00000000000000004384584304507619735463404765184e+48"},
  {"0x1.b5e7e08ca3a8fp+162", 49, "9999999999999999464902769475481793196872414789632"},
  {"0x1.b5e7e08ca3a90p+162", 49, "1.000000000000000076297698410918870032949649709466e+49"},
  {"0x1.11b0ec57e6499p+166", 50, "99999999999999986860582406952576489172979654066176"},
  {"0x1.11b0ec57e649ap+166", 50, "1.0000000000000000762976984109188700329496497094656e+50"},
  {"0x1.561d276ddfdc0p+169", 51, "999999999999999993220948674361627976461708441944064"},
  {"0x1.561d276ddfdc1p+169", 51, "1.00000000000000015937444814747611208943759097698714e+51"},
  {"0x1.aba4714957d30p+172", 52, "9999999999999999932209486743616279764617084419440640"},
  {"0x1.aba4714957d31p+172", 52, "1.000000000000000126143748252853215266842414469978522e+52"},
  {"0x1.0b46c6cdd6e3ep+176", 53, "99999999999999999322094867436162797646170844194406400"},
  {"0x1.0b46c6cdd6e3fp+176", 53, "1.0000000000000002058974279999481676410708380867991962e+53"},
  {"0x1.4e1878814c9cdp+179", 54, "999999999999999908150356944127012110618056584002011136"},
  {"0x1.4e1878814c9cep+179", 54, "1.00000000000000007829154040459624384230536029988611686e+54"},
  {"0x1.a19e96a19fc40p+182", 55, "9999999999999998741221202520331657642805958408251899904"},
  {"0x1.a19e96a19fc41p+182", 55, "1.000000000000000010235067020408551149630438813532474573e+55"},
  {"0x1.05031e2503da8p+186", 56, "99999999999999987412212025203316576428059584082518999040"},
  {"0x1.05031e2503da9p+186", 56, "1.0000000000000000919028350814337823808403445971568453222e+56"},
  {"0x1.4643e5ae44d12p+189", 57, "999999999999999874122120252033165764280595840825189990400"},
  {"0x1.4643e5ae44d13p+189", 57, "1.00000000000000004834669211555365905752839484589051425587e+57"},
  {"0x1.97d4df19d6057p+192", 58, "9999999999999999438119489974413630815797154428513196965888"},
  {"0x1.97d4df19d6058p+192", 58, "1.000000000000000083191606488257757716177954646903579108966e+58"},
  {"0x1.fdca16e04b86dp+195", 59, "99999999999999997168788049560464200849936328366177157906432"},
  {"0x1.fdca16e04b86ep+195", 59, "1.0000000000000000831916064882577577161779546469035791089664e+59"},
  {"0x1.3e9e4e4c2f344p+199", 60, "999999999999999949387135297074018866963645011013410073083904"},
  {"0x1.3e9e4e4c2f345p+199", 60, "1.00000000000000012779309688531900399924939119220030212092723e+60"},
  {"0x1.8e45e1df3b015p+202", 61, "9999999999999999493871352970740188669636450110134100730839040"},
  {"0x1.8e45e1df3b016p+202", 61, "1.000000000000000092111904567670006972792241955962923711358566e+61"},
  {"0x1.f1d75a5709c1ap+205", 62, "99999999999999992084218144295482124579792562202350734542897152"},
  {"0x1.f1d75a5709c1bp+205", 62, "1.0000000000000000350219968594316117304608031779831182560487014e+62"},
  {"0x1.3726987666190p+209", 63, "999999999999999875170255276364105051932774599639662981181079552"},
  {"0x1.3726987666191p+209", 63, "1.00000000000000005785795994272696982739337868917504043817264742e+63"},
  {"0x1.84f03e93ff9f4p+212", 64, "9999999999999998751702552763641050519327745996396629811810795520"},
  {"0x1.84f03e93ff9f5p+212", 64, "1.00000000000000002132041900945439687230125787126796494677433385e+64"},
  {"0x1.e62c4e38ff872p+215", 65, "99999999999999999209038626283633850822756121694230455365568299008"},
  {"0x1.e62c4e38ff873p+215", 65, "1.0000000000000001090105172493085719645223478342449461261302864282e+65"},
  {"0x1.2fdbb0e39fb47p+219", 66, "999999999999999945322333868247445125709646570021247924665841614848"},
  {"0x1.2fdbb0e39fb48p+219", 66, "1.00000000000000013239454344660301865578130515770547444062520711578e+66"},
  {"0x1.7bd29d1c87a19p+222", 67, "9999999999999999827367757839185598317239782875580932278577147150336"},
  {"0x1.7bd29d1c87a1ap+222", 67, "1.000000000000000132394543446603018655781305157705474440625207115776e+67"},
  {"0x1.dac74463a989fp+225", 68, "99999999999999995280522225138166806691251291352861698530421623488512"},
  {"0x1.dac74463a98a0p+225", 68, "1.000000000000000072531436381529235126158374409646521955518210155479e+68"},
  {"0x1.28bc8abe49f63p+229", 69, "999999999999999880969493773293127831364996015857874003175819882528768"},
  {"0x1.28bc8abe49f64p+229", 69, "1.00000000000000007253143638152923512615837440964652195551821015547904e+69"},
  {"0x1.72ebad6ddc73cp+232", 70, "9999999999999999192818822949403492903236716946156035936442979371188224"},
  {"0x1.72ebad6ddc73dp+232", 70, "1.00000000000000007253143638152923512615837440964652195551821015547904e+70"},
  {"0x1.cfa698c95390bp+235", 71, "99999999999999991928188229494034929032367169461560359364429793711882240"},
  {"0x1.cfa698c95390cp+235", 71, "1.0000000000000000418815255642114579589914338666403382831434277118069965e+71"},
  {"0x1.21c81f7dd43a7p+239", 72, "999999999999999943801810948794571024057224129020550531544123892056457216"},
  {"0x1.21c81f7dd43a8p+239", 72, "1.00000000000000013996124017962834489392564360426012603474273153155753574e+72"},
  {"0x1.6a3a275d49491p+242", 73, "9999999999999999830336967949613257980309080240684656321838454199566729216"},
  {"0x1.6a3a275d49492p+242", 73, "1.000000000000000139961240179628344893925643604260126034742731531557535744e+73"},
  {"0x1.c4c8b1349b9b5p+245", 74, "99999999999999995164818811802792197885196090803013355167206819763650035712"},
  {"0x1.c4c8b1349b9b6p+245", 74, "1.000000000000000077190222825761537255567749372183461873719177086917190615e+74"},
  {"0x1.1afd6ec0e1411p+249", 75, "999999999999999926539781176481198923508803215199467887262646419780362305536"},
  {"0x1.1afd6ec0e1412p+249", 75, "1.00000000000000012740703670885498336625406475784479320253802064262946671821e+75"},
  {"0x1.61bcca7119915p+252", 76, "9999999999999998863663300700064420349597509066704028242075715752105414230016"},
  {"0x1.61bcca7119916p+252", 76, "1.000000000000000047060134495905469589155960140786663076427870953489824953139e+76"},
  {"0x1.ba2bfd0d5ff5bp+255", 77, "99999999999999998278261272554585856747747644714015897553975120217811154108416"},
  {"0x1.ba2bfd0d5ff5cp+255", 77, "1.0000000000000001113376562662650806108344438344331671773159907048015383651942e+77"},
  {"0x1.145b7e285bf98p+259", 78, "999999999999999802805551768538947706777722104929947493053015898505313987330048"},
  {"0x1.145b7e285bf99p+259", 78, "1.00000000000000000849362143368970297614886992459876061589499910270279690590618e+78"},
  {"0x1.59725db272f7fp+262", 79, "9999999999999999673560075006595519222746403606649979913266024618633003221909504"},
  {"0x1.59725db272f80p+262", 79, "1.000000000000000131906463232780156137771558616400048489600189025221286657051853e+79"},
  {"0x1.afcef51f0fb5ep+265", 80, "99999999999999986862573406138718939297648940722396769236245052384850852127440896"},
  {"0x1.afcef51f0fb5fp+265", 80, "1.0000000000000000002660986470836727653740240118120080909813197745348975891631309e+80"},
  {"0x1.0de1593369d1bp+269", 81, "999999999999999921281879895665782741935503249059183851809998224123064148429897728"},
  {"0x1.0de1593369d1cp+269", 81, "1.0000000000000001319064632327801561377715586164000484896001890252212866570518528e+81"},
  {"0x1.5159af8044462p+272", 82, "9999999999999999634067965630886574211027143225273567793680363843427086501542887424"},
  {"0x1.5159af8044463p+272", 82, "1.0000000000000001319064632327801561377715586164000484896001890252212866570518528e+82"},
  {"0x1.a5b01b605557ap+275", 83, "99999999999999989600692989521205793443517660497828009527517532799127744739526311936"},
  {"0x1.a5b01b605557bp+275", 83, "1.0000000000000000308066632309652569077702520400764334634608974406941398529133143654e+83"},
  {"0x1.078e111c3556cp+279", 84, "999999999999999842087036560910778345101146430939018748000886482910132485188042620928"},
  {"0x1.078e111c3556dp+279", 84, "1.00000000000000005776660989811589670243726712709606413709804186323471233401692461466e+84"},
  {"0x1.4971956342ac7p+282", 85, "9999999999999998420870365609107783451011464309390187480008864829101324851880426209280"},
  {"0x1.4971956342ac8p+282", 85, "1.00000000000000001463069523067487303097004298786465505927861078716979636425114821591e+85"},
  {"0x1.9bcdfabc13579p+285", 86, "99999999999999987659576829486359728227492574232414601025643134376206526100066373992448"},
  {"0x1.9bcdfabc1357ap+285", 86, "1.0000000000000000146306952306748730309700429878646550592786107871697963642511482159104e+86"},
  {"0x1.0160bcb58c16cp+289", 87, "999999999999999959416724456350362731491996089648451439669739009806703922950954425516032"},
  {"0x1.0160bcb58c16dp+289", 87, "1.0000000000000001802726075536484039294041836825132659181052261192590736881517295870935e+87"},
  {"0x1.41b8ebe2ef1c7p+292", 88, "9999999999999999594167244563503627314919960896484514396697390098067039229509544255160320"},
  {"0x1.41b8ebe2ef1c8p+292", 88, "1.00000000000000013610143093418879568982174616394030302241812869736859973511157455477801e+88"},
  {"0x1.922726dbaae39p+295", 89, "99999999999999999475366575191804932315794610450682175621941694731908308538307845136842752"},
  {"0x1.922726dbaae3ap+295", 89, "1.0000000000000001361014309341887956898217461639403030224181286973685997351115745547780096e+89"},
  {"0x1.f6b0f092959c7p+298", 90, "999999999999999966484112715463900049825186092620125502979674597309179755437379230686511104"},
  {"0x1.f6b0f092959c8p+298", 90, "1.00000000000000007956232486128049714315622614016691051593864399734879307522017611341417677e+90"},
  {"0x1.3a2e965b9d81cp+302", 91, "9999999999999998986371854279739417938265620640920544952042929572854117635677011010499117056"},
  {"0x1.3a2e965b9d81dp+302", 91, "1.000000000000000079562324861280497143156226140166910515938643997348793075220176113414176768e+91"},
  {"0x1.88ba3bf284e23p+305", 92, "99999999999999989863718542797394179382656206409205449520429295728541176356770110104991170560"},
  {"0x1.88ba3bf284e24p+305", 92, "1.0000000000000000433772969746191860732902933249519393117917737893361168128896811109413237555e+92"},
  {"0x1.eae8caef261acp+308", 93, "999999999999999927585207737302990649719308316264031458521789123695552773432097103028194115584"},
  {"0x1.eae8caef261adp+308", 93, "1.00000000000000004337729697461918607329029332495193931179177378933611681288968111094132375552e+93"},
  {"0x1.32d17ed577d0bp+312", 94, "9999999999999998349515363474500343108625203093137051759058013911831015418660298966976904036352"},
  {"0x1.32d17ed577d0cp+312", 94, "1.000000000000000020218879127155946988576096323214357741137776856208004004998164309358697827533e+94"},
  {"0x1.7f85de8ad5c4ep+315", 95, "99999999999999987200500490339121684640523551209383568895219648418808203449245677922989188841472"},
  {"0x1.7f85de8ad5c4fp+315", 95, "1.0000000000000000202188791271559469885760963232143577411377768562080040049981643093586978275328e+95"},
  {"0x1.df67562d8b362p+318", 96, "999999999999999931290554592897108903273579836542044509826428632996050822694739791281414264061952"},
  {"0x1.df67562d8b363p+318", 96, "1.00000000000000004986165397190889301701026848543846215157489293061198839909930581538445901535642e+96"},
  {"0x1.2ba095dc7701dp+322", 97, "9999999999999998838621148412923952577789043769834774531270429139496757921329133816401963635441664"},
  {"0x1.2ba095dc7701ep+322", 97, "1.000000000000000073575873847711249839757606215217745679924585790135175914380219020205067965615309e+97"},
  {"0x1.7688bb5394c25p+325", 98, "99999999999999999769037024514370800696612547992403838920556863966097586548129676477911932478685184"},
  {"0x1.7688bb5394c26p+325", 98, "1.0000000000000001494613774502787916725490869505114529706436029406093759632791412756310166064437658e+98"},
  {"0x1.d42aea2879f2ep+328", 99, "999999999999999967336168804116691273849533185806555472917961779471295845921727862608739868455469056"},
  {"0x1.d42aea2879f2fp+328", 99, "1.00000000000000008875297456822475820631590236227648713806838922023001592416000347129025769378100019e+99"},
  {"0x1.249ad2594c37cp+332", 100, "9999999999999998216360018871870109548898901740426374747374488505608317520357971321909184780648316928"},
  {"0x1.249ad2594c37dp+332", 100, "1.00000000000000001590289110975991804683608085639452813897813275577478387721703810608134699858568151e+100"},
  {"0x1.6dc186ef9f45cp+335", 101, "99999999999999997704951326524533662844684271992415000612999597473199345218078991130326129448151154688"},
  {"0x1.6dc186ef9f45dp+335", 101, "1.000000000000000132463024643303662302003795265805662537522543098903155152325782690415604110898191401e+101"},
  {"0x1.c931e8ab87173p+338", 102, "999999999999999977049513265245336628446842719924150006129995974731993452180789911303261294481511546880"},
  {"0x1.c931e8ab87174p+338", 102, "1.00000000000000010138032236769199716729240475662936003124403367406892281229678413459313554761485543014e+102"},
  {"0x1.1dbf316b346e7p+342", 103, "9999999999999998029863805218200118740630558685368559709703431956602923480183979986974373400948301103104"},
  {"0x1.1dbf316b346e8p+342", 103, "1.000000000000000001915675085734668736215955127265192011152803514599379324203988755961236145108180323533e+103"},
  {"0x1.652efdc6018a1p+345", 104, "99999999999999984277223943460294324649363572028252317900683525944810974325551615015019710109750015295488"},
  {"0x1.652efdc6018a2p+345", 104, "1.0000000000000000019156750857346687362159551272651920111528035145993793242039887559612361451081803235328e+104"},
  {"0x1.be7abd3781ecap+348", 105, "999999999999999938258300825281978540327027364472124478294416212538871491824599713636820527503908255301632"},
  {"0x1.be7abd3781ecbp+348", 105, "1.00000000000000006557304934618735893210488289005825954401119081665988715658337779828565176271245239176397e+105"},
  {"0x1.170cb642b133ep+352", 106, "9999999999999998873324014169198263836158851542376704520077063708904652259210884797772880334204906007166976"},
  {"0x1.170cb642b133fp+352", 106, "1.000000000000000091035999050368435010460453995175486557154545737484090289535133415215418009754161219056435e+106"},
  {"0x1.5ccfe3d35d80ep+355", 107, "99999999999999996881384047029926983435371269061279689406644211752791525136670645395254002395395884805259264"},
  {"0x1.5ccfe3d35d80fp+355", 107, "1.0000000000000001317767185770581567358293677633630497781839136108028153022579424023030440050208953427243827e+107"},
  {"0x1.b403dcc834e11p+358", 108, "999999999999999903628689227595715073763450661512695740419453520217955231010212074612338431527184250183876608"},
  {"0x1.b403dcc834e12p+358", 108, "1.00000000000000003399899171300282459494397471971289804771343071483787527172320083329274161638073344592130867e+108"},
  {"0x1.108269fd210cbp+362", 109, "9999999999999999818508707188399807864717650964328171247958398369899072554380053298205803424393137676263358464"},
  {"0x1.108269fd210ccp+362", 109, "1.000000000000000190443354695491356020360603589553140816466203348381779320578787343709225438204992480806227149e+109"},
  {"0x1.54a3047c694fdp+365", 110, "99999999999999985669538033284915564613846200056062290979362173015478401635353612148739328497990653971840106496"},
  {"0x1.54a3047c694fep+365", 110, "1.0000000000000000235693675141702558332495327950568818631299125392682816684661617325983093615924495102623141069e+110"},
  {"0x1.a9cbc59b83a3dp+368", 111, "999999999999999956819772641641815758405104477258378281795396215622882607621111488153942930947432322044748890112"},
  {"0x1.a9cbc59b83a3ep+368", 111, "1.00000000000000009031896238669869590809396111285538544446442886291368072931121197704267579223746669847987932365e+111"},
  {"0x1.0a1f5b8132466p+372", 112, "9999999999999999301199346926304397284673331501389768492615896861647229832830913903761963586894254467577228034048"},
  {"0x1.0a1f5b8132467p+372", 112, "1.000000000000000143718638284721447967969503767094188309532041921829999977987252172598168936753480449053931497062e+112"},
  {"0x1.4ca732617ed7fp+375", 113, "99999999999999984468045325579403643266646490335689226515340879189861218540142707748740732746380344583923932594176"},
  {"0x1.4ca732617ed80p+375", 113, "1.0000000000000000155594161294668430242682013969210614333697705804308337811647557032649853899150474476762062808678e+113"},
  {"0x1.9fd0fef9de8dfp+378", 114, "999999999999999878856245830528597750986812202069726098796681149605056504554092802642922939954052246206632716926976"},
  {"0x1.9fd0fef9de8e0p+378", 114, "1.00000000000000001555941612946684302426820139692106143336977058043083378116475570326498538991504744767620628086784e+114"},
  {"0x1.03e29f5c2b18bp+382", 115, "9999999999999997968343436511656505870179786851589248980528274911095901385876950622696854699774551253248885785624576"},
  {"0x1.03e29f5c2b18cp+382", 115, "1.00000000000000001555941612946684302426820139692106143336977058043083378116475570326498538991504744767620628086784e+115"},
  {"0x1.44db473335deep+385", 116, "99999999999999984057935814682588907446802322751135220511621610897383886710310719046874545396497358979515211902353408"},
  {"0x1.44db473335defp+385", 116, "1.00000000000000001555941612946684302426820139692106143336977058043083378116475570326498538991504744767620628086784e+116"},
  {"0x1.961219000356ap+388", 117, "999999999999999910571381339882270654388094495275235896417637897556636832727766595587241428345003132947573783761256448"},
  {"0x1.961219000356bp+388", 117, "1.00000000000000005055542772599503381422823703080300327902048147472223276397708540582423337710506221925241711323670118e+117"},
  {"0x1.fb969f40042c5p+391", 118, "9999999999999999665649998943273759183241515094863428494587753284228752052274941196820382078490267674695111155514343424"},
  {"0x1.fb969f40042c6p+391", 118, "1.000000000000000078552237003217586446196265537908556755541050190155351950226949167871631766857074036513385779131790131e+118"},
  {"0x1.3d3e2388029bbp+395", 119, "99999999999999994416755247254933381274972870380190006824232035607637985622760311004411949604741731366073618283536318464"},
  {"0x1.3d3e2388029bcp+395", 119, "1.0000000000000001233471318467736706573451111492774423179739601348483426482267311871474691904602929441309356445639324467e+119"},
  {"0x1.8c8dac6a0342ap+398", 120, "999999999999999980003468347394201181668805192897008518188648311830772414627428725464789434929992439754776075181077037056"},
  {"0x1.8c8dac6a0342bp+398", 120, "1.00000000000000012334713184677367065734511114927744231797396013484834264822673118714746919046029294413093564456393244672e+120"},
  {"0x1.efb1178484134p+401", 121, "9999999999999999226660029476424133913982828103448349982745235826237443211877077407917175327178722380043122474279348731904"},
  {"0x1.efb1178484135p+401", 121, "1.000000000000000037340933747145988971939327575449182038102773041037800508067149710137861337142112641505239902934219200922e+121"},
  {"0x1.35ceaeb2d28c0p+405", 122, "99999999999999983092605830803955292696544699826135736641192401589249937168415416531480248917847991520357012302290741100544"},
  {"0x1.35ceaeb2d28c1p+405", 122, "1.0000000000000000144059475872452738558311186224283126301371231493549892706912613162686325762572645608050543718329623353754e+122"},
  {"0x1.83425a5f872f1p+408", 123, "999999999999999977709969731404129670057984297594921577392083322662491290889839886077866558841507631684757522070951350501376"},
  {"0x1.83425a5f872f2p+408", 123, "1.00000000000000012449388115476870641315052159692848578837224262943248321009552560684093062850453534816594492111899528999731e+123"},
  {"0x1.e412f0f768fadp+411", 124, "9999999999999999483531874467312143214394768377282087351960514613084929070487027419252537449089020883885200422613425626021888"},
  {"0x1.e412f0f768faep+411", 124, "1.000000000000000065780316585422875715913506677195060103980178906724486442413251318535705000639324261573469961499777714198938e+124"},
  {"0x1.2e8bd69aa19ccp+415", 125, "99999999999999992486776161899288204254467086983483846143922597222529419997579302660316349376281765375153005841365553228283904"},
  {"0x1.2e8bd69aa19cdp+415", 125, "1.0000000000000001127511682408995402737031186129818006514938298848908838565590707491798855029314931308474499291951517748376371e+125"},
  {"0x1.7a2ecc414a03fp+418", 126, "999999999999999924867761618992882042544670869834838461439225972225294199975793026603163493762817653751530058413655532282839040"},
  {"0x1.7a2ecc414a040p+418", 126, "1.0000000000000000751744869165182086274714290643524082134829091023577659252424152046645411010977580354282659550388525263266775e+126"},
  {"0x1.d8ba7f519c84fp+421", 127, "9999999999999999549291066784979473595300225087383524118479625982517885450291174622154390152298057300868772377386949310916067328"},
  {"0x1.d8ba7f519c850p+421", 127, "1.000000000000000075174486916518208627471429064352408213482909102357765925242415204664541101097758035428265955038852526326677504e+127"},
  {"0x1.27748f9301d31p+425", 128, "99999999999999988278187853568579059876517857536991893086699469578820211690113881674597776370903434688204400735860037395056427008"},
  {"0x1.27748f9301d32p+425", 128, "1.000000000000000075174486916518208627471429064352408213482909102357765925242415204664541101097758035428265955038852526326677504e+128"},
  {"0x1.7151b377c247ep+428", 129, "999999999999999998217443564185241415988928868759412500436543339729940401905904649497115766142268560009777175966751665376232210432"},
  {"0x1.7151b377c247fp+428", 129, "1.00000000000000015213153026885117583895392925994540392652927486498559144857892575983196643605324751084675473411095338727712279757e+129"},
  {"0x1.cda62055b2d9dp+431", 130, "9999999999999999366518088823188676468029287122850159299994507296276799832366962053631754981778769796749861527090709766158759755776"},
  {"0x1.cda62055b2d9ep+431", 130, "1.000000000000000059783078246051615185174929025233809070873635949832200820575113093631056034106660140344568199224432354136588445286e+130"},
  {"0x1.2087d4358fc82p+435", 131, "99999999999999991202555500957231813912852864969525730182461368558677581576901282770959939099212034754106974340599870111173348163584"},
  {"0x1.2087d4358fc83p+435", 131, "1.0000000000000001090355859915447142005237291504133263272233100379140091555104798489382082484781734046124010178305769051448734331699e+131"},
  {"0x1.68a9c942f3ba3p+438", 132, "999999999999999990829567402361276563686608849982484911984092226517669151665599636201042933986541570369602253175829982724989462249472"},
  {"0x1.68a9c942f3ba4p+438", 132, "1.00000000000000014843759218793919341280276925055694013230304930837945582345877325318393001997538401602666727271549254595150142347674e+132"},
  {"0x1.c2d43b93b0a8bp+441", 133, "9999999999999998962647525310145264542169126096378117797927179774005971485896954660113106823932361029753632414520324447890822855131136"},
  {"0x1.c2d43b93b0a8cp+441", 133, "1.000000000000000022351172359476859933509840930097375956047883642890026486024234359597620351184310059501015257083762495370291854494925e+133"},
  {"0x1.19c4a53c4e697p+445", 134, "99999999999999992148203649670699315007549827372972461504375111049848301607660324472857261615145089428049364457837845490532419930947584"},
  {"0x1.19c4a53c4e698p+445", 134, "1.0000000000000001232203082222467267169441835864650272970520161752815699559718654744666680862171692247215368695891465358352595096803738e+134"},
  {"0x1.6035ce8b6203dp+448", 135, "999999999999999961829690841814939863449235336276785151445404123455100404055655690676191710164594560368702289580532071091311261383655424"},
  {"0x1.6035ce8b6203ep+448", 135, "1.00000000000000012322030822224672671694418358646502729705201617528156995597186547446666808621716922472153686958914653583525950968037376e+135"},
  {"0x1.b843422e3a84cp+451", 136, "9999999999999999295515673657285824927502456862391367223240817130898064936724137339180964349540796274981353735788091781425216117243117568"},
  {"0x1.b843422e3a84dp+451", 136, "1.000000000000000058664061270074011975546204286389730438809371354550982135205381560950477535796139358980403037585700749937680210361686426e+136"},
  {"0x1.132a095ce492fp+455", 137, "99999999999999982626157224225223890651347880611866174913584999992086598044603947229219155428043184231232124237329592070639473281441202176"},
  {"0x1.132a095ce4930p+455", 137, "1.0000000000000000328415624892049260789870125663596116955123134262587470068987879955440013156277274126839495047843224355786484906342114918e+137"},
  {"0x1.57f48bb41db7bp+458", 138, "999999999999999867577570291642776341008185558166851738411142685188442185736589176942553506549890956386646894855501223680845484378371915776"},
  {"0x1.57f48bb41db7cp+458", 138, "1.00000000000000003284156248920492607898701256635961169551231342625874700689878799554400131562772741268394950478432243557864849063421149184e+138"},
  {"0x1.adf1aea12525ap+461", 139, "9999999999999999006303687311552062886039509598054037298313768334025031499690289406628430683654582476461074168412654660604060856295398309888"},
  {"0x1.adf1aea12525bp+461", 139, "1.00000000000000003284156248920492607898701256635961169551231342625874700689878799554400131562772741268394950478432243557864849063421149184e+139"},
  {"0x1.0cb70d24b7378p+465", 140, "99999999999999984774589122793531837245072631718372054355900219626000560719712531871037976946055058163097058166404267825310912362767116664832"},
  {"0x1.0cb70d24b7379p+465", 140, "1.0000000000000000592838012408148700370636248876704532886485007448299957782847398065202329650801812456915179223729338294822969716351458240102e+140"},
  {"0x1.4fe4d06de5056p+468", 141, "999999999999999847745891227935318372450726317183720543559002196260005607197125318710379769460550581630970581664042678253109123627671166648320"},
  {"0x1.4fe4d06de5057p+468", 141, "1.00000000000000001697621923823895970414104517357310673963060103511599774406721690895826232595625511287940845423115559923645940203365089253786e+141"},
  {"0x1.a3de04895e46cp+471", 142, "9999999999999999154380224320567749051268538597394750219876417318024024619451619548095327920588323941303457306908878466464492349900630570041344"},
  {"0x1.a3de04895e46dp+471", 142, "1.000000000000000050822284840299687970479108944850983978844920802887196171441235227007838837255396019129096028744578183433129457714846837715763e+142"},
  {"0x1.066ac2d5daec3p+475", 143, "99999999999999980713061250546244445284504979165026785650181847493456749434830333705088795590158149413134549224793557721710505681023603243483136"},
  {"0x1.066ac2d5daec4p+475", 143, "1.0000000000000000237454323586511053574086579278286821874734649886702374295420205725681776282160832941293459691338401160757934131698900815734374e+143"},
  {"0x1.4805738b51a74p+478", 144, "999999999999999850453576476100176633757771418885950722696147777681701481387046784154345890364481854130945587625116484988842728082166842262552576"},
  {"0x1.4805738b51a75p+478", 144, "1.00000000000000002374543235865110535740865792782868218747346498867023742954202057256817762821608329412934596913384011607579341316989008157343744e+144"},
  {"0x1.9a06d06e26112p+481", 145, "9999999999999999890870611821409196126784806260401358945180015464725302399110258148854112806457630061296658928320953898584032761523454337112604672"},
  {"0x1.9a06d06e26113p+481", 145, "1.000000000000000127720545888181662591599189833194321066339855315263358998435004845616476670927044158128386198039074294727963824222524025159968358e+145"},
  {"0x1.00444244d7cabp+485", 146, "99999999999999993363366729972462242111019694317846182578926003895619873650143420259298512453325054533017777074930382791057905692427399713177731072"},
  {"0x1.00444244d7cacp+485", 146, "1.0000000000000001554472428293898111873833316746251581007042260690215247501398006517626897489833003885281302590804700757018759338365597434497099366e+146"},
  {"0x1.405552d60dbd6p+488", 147, "999999999999999977996382405657660174364823889467801080772253244969263939229107492426926049423260513969768268415537077468838432306731146395363835904"},
  {"0x1.405552d60dbd7p+488", 147, "1.00000000000000015544724282938981118738333167462515810070422606902152475013980065176268974898330038852813025908047007570187593383655974344970993664e+147"},
  {"0x1.906aa78b912cbp+491", 148, "9999999999999999070160382361647997691574207754048582727994641153483596148648302286926205695992445641464234721495638781756234316947997075736253956096"},
  {"0x1.906aa78b912ccp+491", 148, "1.000000000000000048976726575150520579572227003530743888745042374590168263593384756161231529247276463793113064681510276762053432918662585217102276198e+148"},
  {"0x1.f485516e7577ep+494", 149, "99999999999999993540817590396194393124038202103003539598857976719672134461054113418634276152885094407576139065595315789290943193957228310232077172736"},
  {"0x1.f485516e7577fp+494", 149, "1.0000000000000000489767265751505205795722270035307438887450423745901682635933847561612315292472764637931130646815102767620534329186625852171022761984e+149"},
  {"0x1.38d352e5096afp+498", 150, "999999999999999980835596172437374590573120014030318793091164810154100112203678582976298268616221151962702060266176005440567032331208403948233373515776"},
  {"0x1.38d352e5096b0p+498", 150, "1.00000000000000016254527724633909722790407198603145238150150498198361518257622837813612029696570198351046473870706739563119743389775288733188378066944e+150"},
  {"0x1.8708279e4bc5ap+501", 151, "9999999999999998718097875280963410081745488308296386400449607070563910699801487058804050516065326530340444532016411713261887913912817139180431292235776"},
  {"0x1.8708279e4bc5bp+501", 151, "1.000000000000000017177532387217719118039310408430545510773232844520003126278188542008262674286117318272254595954354283478693112644517300624963454946509e+151"},
  {"0x1.e8ca3185deb71p+504", 152, "99999999999999992995688547174489225212045346187000138833626956204183589249936464033154810067836651912932851030272641618719051989257594860081125951275008"},
  {"0x1.e8ca3185deb72p+504", 152, "1.000000000000000046251081359041994740012262723950726884918887272012725537537796509233834198822034251319896624504896905909193976895164417966347520091095e+152"},
  {"0x1.317e5ef3ab327p+508", 153, "999999999999999999733403004123153744855539019118436686285840188024369679522423761672919759564567158443669378824028710020392594094129030220133015859757056"},
  {"0x1.317e5ef3ab328p+508", 153, "1.00000000000000018580411642379851772548243383844759748081802852397779311158391475191657751659443552994857836154750149357559812529827058120499103278510899e+153"},
  {"0x1.7dddf6b095ff0p+511", 154, "9999999999999998880909749523179353564794021275209402095665271864523156202855291675267251053466461355407239891899450398872692753716440996292182057045458944"},
  {"0x1.7dddf6b095ff1p+511", 154, "1.000000000000000036947545688058226540980917982984268845192277855215054365934721959721651310970540832744651175368723266731433700334957340417104619244827443e+154"},
  {"0x1.dd55745cbb7ecp+514", 155, "99999999999999988809097495231793535647940212752094020956652718645231562028552916752672510534664613554072398918994503988726927537164409962921820570454589440"},
  {"0x1.dd55745cbb7edp+514", 155, "1.0000000000000000071762315409101683040806148118916031180671277214625066168048834012826660698457618933038657381329676213626008153422946922595273365367711334e+155"},
  {"0x1.2a5568b9f52f4p+518", 156, "999999999999999983359180223191721714560372275017470536367007614460468417501012554531477876945938741751237388344363105067534507348164573733465510370326085632"},
  {"0x1.2a5568b9f52f5p+518", 156, "1.0000000000000001738955907649392944307223125700105311899679684704767740119319793285409834201445239541722641866531992354280649713012055219419601197018864681e+156"},
  {"0x1.74eac2e8727b1p+521", 157, "9999999999999999833591802231917217145603722750174705363670076144604684175010125545314778769459387417512373883443631050675345073481645737334655103703260856320"},
  {"0x1.74eac2e8727b2p+521", 157, "1.000000000000000135788308656589779887489924511011919059247776299273512893045785973739082311504806911688058826991432009355958878510597332300261197835574391603e+157"},
  {"0x1.d22573a28f19dp+524", 158, "99999999999999995287335453651211007997446182781858083179085387749785952239205787068995699003416510776387310061494932420984963311567802202010637287727642443776"},
  {"0x1.d22573a28f19ep+524", 158, "1.0000000000000000748166572832305566183181036166141396500954688253482951028278766060560405376812596437133302515326044476405891300456242288735429228494750692147e+158"},
  {"0x1.2357684599702p+528", 159, "999999999999999928484693987168420772305733470059469068129930887927772406304894123616740280504746200573981670431418299523701733729688780649419062882836695482368"},
  {"0x1.2357684599703p+528", 159, "1.0000000000000001235939783819179352336555603321323631774173148044884693350022041002024739567400974580931131118996664970128849288176027116149175428383545271255e+159"},
  {"0x1.6c2d4256ffcc2p+531", 160, "9999999999999998504409802292686149877658027252303114244149773213034936348259701329824468100106056975663290938441190205280284556945232082632196709006295628251136"},
  {"0x1.6c2d4256ffcc3p+531", 160, "1.000000000000000006528407745068226556845664214888626711844884454552051177783818114251033750998886703581634247018717578519375011764854353035618454865043828139622e+160"},
  {"0x1.c73892ecbfbf3p+534", 161, "99999999999999991287595123558845961539774732109363753938694017460291665200910932548988158640591809997245115511395844372456707812265566617217918448639526895091712"},
  {"0x1.c73892ecbfbf4p+534", 161, "1.0000000000000000377458932482281488706616365128202897693308658812017626863753877105047511391965429047846952776536372901176443229789205819900982116579266812025242e+161"},
  {"0x1.1c835bd3f7d78p+538", 162, "999999999999999937849939638116397466450525159438967985375725315922685858882365002492855496964043060934899979621894213003182527093908649335762989920701551401238528"},
  {"0x1.1c835bd3f7d79p+538", 162, "1.00000000000000013764184685833990027487274786620161155328600644648083951386841041851664678142904274863449057568538036723210611886393251464443343339515181100380979e+162"},
  {"0x1.63a432c8f5cd6p+541", 163, "9999999999999999378499396381163974664505251594389679853757253159226858588823650024928554969640430609348999796218942130031825270939086493357629899207015514012385280"},
  {"0x1.63a432c8f5cd7p+541", 163, "1.000000000000000097683465414295199713188303324849082839703950220369208782871201335311888524536042811094572456472683136386321400509927741582699344700261759083295539e+163"},
  {"0x1.bc8d3f7b3340bp+544", 164, "99999999999999987391652932764487656775541389327492204364443535414407668928683046936524228593524316087103098888157864364992697772750101243698844800887746832841572352"},
  {"0x1.bc8d3f7b3340cp+544", 164, "1.0000000000000000017833499485879183651456364256030139271070152777012950284778995356204687079928429609987689703622097823564380764603162862345375318325256344740613325e+164"},
  {"0x1.15d847ad00087p+548", 165, "999999999999999899489893451833484927233458399740540420336951338855520357125044282616287570346763120896578585177704871391229197474064067196498264773607101557544845312"},
  {"0x1.15d847ad00088p+548", 165, "1.00000000000000010407680644534235180305781445146548743387707921654706969983075478862464984563892280110095935554671469332164695544656850527257679889144416739057781965e+165"},
  {"0x1.5b4e5998400a9p+551", 166, "9999999999999999404072760505352583023983296100855298230449769143938302256661863838179600254051950569374547392515068357773127490685649548117139715971745147241514401792"},
  {"0x1.5b4e5998400aap+551", 166, "1.000000000000000104076806445342351803057814451465487433877079216547069699830754788624649845638922801100959355546714693321646955446568505272576798891444167390577819648e+166"},
  {"0x1.b221effe500d3p+554", 167, "99999999999999990767336997157383960226643264180953830087855645396318233083327270285662206135844950810475381599246526426844590779296424471954140613832058419086616428544"},
  {"0x1.b221effe500d4p+554", 167, "1.0000000000000000386089942874195144027940205149135043895442382956857739101649274267019739175454317034355575090286315503039132728953670850882316679737363063240072678605e+167"},
  {"0x1.0f5535fef2084p+558", 168, "999999999999999933860494834742974562371950216430331518611692822307700646699603647625692432595845947170914554599698521475539380813444812793279458505403728617494385000448"},
  {"0x1.0f5535fef2085p+558", 168, "1.00000000000000014335749374009605424321609081339667726047678376906384717363025120577825540249501745970020046345756457913228716497728935738318387744206888403052015072051e+168"},
  {"0x1.532a837eae8a5p+561", 169, "9999999999999999338604948347429745623719502164303315186116928223077006466996036476256924325958459471709145545996985214755393808134448127932794585054037286174943850004480"},
  {"0x1.532a837eae8a6p+561", 169, "1.000000000000000101458093959025438307047262694003408112103765579712617868244121694147742808515183157194343281685991367600937608144520448465202993654735852947914997576499e+169"},
  {"0x1.a7f5245e5a2cep+564", 170, "99999999999999990034097500988648181343688772091571619991327827082671720239070003832128235741197850516622880918243995225045973534722968565889475147553730375141026248523776"},
  {"0x1.a7f5245e5a2cfp+564", 170, "1.0000000000000000344190543093124528091771377029741774747069364767506509796263144755389226581474482731849717908514742291507783172120901941964335795950030032157467525460787e+170"},
  {"0x1.08f936baf85c1p+568", 171, "999999999999999953972206729656870211732987713739100709830741553196290713284945813208338477706166412373726001850053663010587168093173889073910282723323583537144858509574144"},
  {"0x1.08f936baf85c2p+568", 171, "1.00000000000000016849713360873842380491738768503263874950059468267458475686192891275656295888291804120371477252050850605109689907695070273397240771446870268008324260691968e+171"},
  {"0x1.4b378469b6731p+571", 172, "9999999999999999110672213538405594930961077194803931018967709273006319045695491932986935814708160866077282477159626944024852218964185263418978577250945597085571816901050368"},
  {"0x1.4b378469b6732p+571", 172, "1.000000000000000082687162857105802367643627696515223533632653430883267139431135672937273166412217389671719264252326568834893006683439977269947557718010655022907888967981466e+172"},
  {"0x1.9e056584240fdp+574", 173, "99999999999999987674323305318751091818660372407342701554959442658410485759723189737097766448253582599493004440868991951600366493901423615628791772651134064568704023452975104"},
  {"0x1.9e056584240fep+574", 173, "1.0000000000000000140391862557997052178246197057012913609383004294502130454865010810818413324356568684461228576377810190619298927686313968987276777208442168971676060568308941e+173"},
  {"0x1.02c35f729689ep+578", 174, "999999999999999849284042412665072058259000527747854146471853226010883220019378060628804930891911617504691481762871699606818419373090804007799965727644765395390927070069522432"},
  {"0x1.02c35f729689fp+578", 174, "1.0000000000000000689575675368445829376798260983524370990937828305966563206422087545661867996169052854265999829294174588803003839004782611957035817185773673977598323857513513e+174"},
  {"0x1.4374374f3c2c6p+581", 175, "9999999999999999371534524623368764100273307559896873275206250678451924602685103382037576783819090846734548822294900033162112051840457868829614121240178061963384891963422539776"},
  {"0x1.4374374f3c2c7p+581", 175, "1.000000000000000112892272561680485113563991212473353689618168751513810940766774893353663173361904019010981683162726610734996776805955752633284304916763887798233613448887717069e+175"},
  {"0x1.945145230b377p+584", 176, "99999999999999986685792442259943292861266657339622078268160759437774506806920451614379548038991111093844416185619536034869697653528180058283225500691937355558043949532406874112"},
  {"0x1.945145230b378p+584", 176, "1.0000000000000000074489805020743198914419949385831538723596425413126398524678161602637198763739070584084656026027846462837254338328097731830905692411162388370965388973604392141e+176"},
  {"0x1.f965966bce055p+587", 177, "999999999999999894976135638494410321178532246433607400617214583764724024948926844967780359586710300432448450005513217535702667994787395102883917853758746611883659375731342835712"},
  {"0x1.f965966bce056p+587", 177, "1.00000000000000000744898050207431989144199493858315387235964254131263985246781616026371987637390705840846560260278464628372543383280977318309056924111623883709653889736043921408e+177"},
  {"0x1.3bdf7e0360c35p+591", 178, "9999999999999998724815666657784284071258397080036981062687289922551408594451489819085924562292709488372450194860589317860981148271829194868425875762872481668410834714055235600384"},
  {"0x1.3bdf7e0360c36p+591", 178, "1.000000000000000052438118447506283719547380015442972461056613724331806183475371886382095683088785761598872463641693217782934540168018724415173229796059235727181690706012077765427e+178"},
  {"0x1.8ad75d8438f43p+594", 179, "99999999999999998045549773481514159457876389246726271914145983150114005386328272459269439234497983649422148597943950338419997003168440244384097290815044070304544781216945608327168"},
  {"0x1.8ad75d8438f44p+594", 179, "1.0000000000000001244207391601974258445159961384186822029717676171624723130874610481714969738325916867035234413039469321816691103043530463865054866839680307513179335998546994475827e+179"},
  {"0x1.ed8d34e547313p+597", 180, "999999999999999894076352879585771044616424544896411028843275160104340698328775730445412843452412726368640312784735046105718485868083216078242264642659886674081956339558310064685056"},
  {"0x1.ed8d34e547314p+597", 180, "1.00000000000000000924854601989159844456621034165754661590752138863340650570811838930845490864250220653608187704434098914369379808621813123237387566331395871269994496970650475613389e+180"},
  {"0x1.3478410f4c7ecp+601", 181, "9999999999999999171107915076469365246063817042486381462561244058101538598046442622180212564904306224021286256366562347133135483117101991090685868467907010818055540655879490029748224"},
  {"0x1.3478410f4c7edp+601", 181, "1.000000000000000101386300532136260364526038979066455085558918371456659151611592516398888560794573790670035128452025743574074047860726063355679164479837216343594335873825060509292954e+181"},
  {"0x1.819651531f9e7p+604", 182, "99999999999999991711079150764693652460638170424863814625612440581015385980464426221802125649043062240212862563665623471331354831171019910906858684679070108180555406558794900297482240"},
  {"0x1.819651531f9e8p+604", 182, "1.0000000000000000645311987272383955965421075241028916976983595783273580932502028655627150999337451570164538278889518418019219479509228905063570489532279132912365795121776382080293274e+182"},
  {"0x1.e1fbe5a7e7861p+607", 183, "999999999999999946594872951565228338993526868219488856544571440313594706493755982886960025179093529324993666087115356131035228239552737388526279268078143523691759154905886843985723392"},
  {"0x1.e1fbe5a7e7862p+607", 183, "1.00000000000000006453119872723839559654210752410289169769835957832735809325020286556271509993374515701645382788895184180192194795092289050635704895322791329123657951217763820802932736e+183"},
  {"0x1.2d3d6f88f0b3cp+611", 184, "9999999999999998286585471758920610814449462123360860153907833022998313197373091002112049504244419016335335042852788704601485085281825842706955095829283737561469387976341354799421194240"},
  {"0x1.2d3d6f88f0b3dp+611", 184, "1.000000000000000017356668416969128693522675261749530561236844323121852738547624112492413070031884505939869763168217247533567260066374829259224741079168005384218651369268937662411885773e+184"},
  {"0x1.788ccb6b2ce0cp+614", 185, "99999999999999997961704416875371517110712945186684165206763211895744845478556111003617144611039598507860251139162957211888350975873638026151889477992007905860430885494197722591793250304"},
  {"0x1.788ccb6b2ce0dp+614", 185, "1.0000000000000001305755411616153692607693126913975972887444809356150655898338131198611379417963500685236715184979802737776185109892901762523422799769117843610616789122498189718937455821e+185"},
  {"0x1.d6affe45f818fp+617", 186, "999999999999999979617044168753715171107129451866841652067632118957448454785561110036171446110395985078602511391629572118883509758736380261518894779920079058604308854941977225917932503040"},
  {"0x1.d6affe45f8190p+617", 186, "1.00000000000000010038384176304303844283687604349144616140911117228354216282416271789614464265915925183465771707671013344587151074317941705417760293751344330057020490078825062269858296627e+186"},
  {"0x1.262dfeebbb0f9p+621", 187, "9999999999999999071569656121801212080692814968920789464627446869617922299624001453201875281811380250249693879805812353226907091680705581859236698853640605134247712274342131878495422251008"},
  {"0x1.262dfeebbb0fap+621", 187, "1.000000000000000100383841763043038442836876043491446161409111172283542162824162717896144642659159251834657717076710133445871510743179417054177602937513443300570204900788250622698582966272e+187"},
  {"0x1.6fb97ea6a9d37p+624", 188, "99999999999999986851159038200753776111576258757220550347347138989744224339004763080499610528553377966303172216135545569805454885304878641227288327493418395599568449276340570087973407686656"},
  {"0x1.6fb97ea6a9d38p+624", 188, "1.0000000000000000230930913026978715489298382248516992754305645781548421896794576888657617968679507611107823854382585741965991901131358735068760297166536901857120314314466356487589666698035e+188"},
  {"0x1.cba7de5054485p+627", 189, "999999999999999899427890566145604518678577715028104257864890027548922232647929642417149243602017175952581854816736079397763477105066203831193512563278085201938953880500051690455580595453952"},
  {"0x1.cba7de5054486p+627", 189, "1.00000000000000002309309130269787154892983822485169927543056457815484218967945768886576179686795076111078238543825857419659919011313587350687602971665369018571203143144663564875896666980352e+189"},
  {"0x1.1f48eaf234ad3p+631", 190, "9999999999999998746948504188351511126283256130633852543517551174277382412416240331274267329488304589209417486924315804379963345034522698960570091326029642051843383703107348987949033805840384"},
  {"0x1.1f48eaf234ad4p+631", 190, "1.000000000000000072559171597318778361030342428781137282456834398397210172492068907445206818174324195174062597686867572116133475316363741377149036578003932179221262451825269232080321099543347e+190"},
  {"0x1.671b25aec1d88p+634", 191, "99999999999999991426771465453187656230872897620693565997277097362163262749171300799098274999392920617156591849131877877362376266603456419227541462168315779999172318661364176545198692437590016"},
  {"0x1.671b25aec1d89p+634", 191, "1.0000000000000000725591715973187783610303424287811372824568343983972101724920689074452068181743241951740625976868675721161334753163637413771490365780039321792212624518252692320803210995433472e+191"},
  {"0x1.c0e1ef1a724eap+637", 192, "999999999999999914267714654531876562308728976206935659972770973621632627491713007990982749993929206171565918491318778773623762666034564192275414621683157799991723186613641765451986924375900160"},
  {"0x1.c0e1ef1a724ebp+637", 192, "1.00000000000000004090088020876139800128601973826629695796002171344209466349199772755436200453824519737356326184775781344763153278629790594017431218673977730337535459878294373875465426450985779e+192"},
  {"0x1.188d357087712p+641", 193, "9999999999999998636144484328400679867178126713831911407778706776934478130915991201656310481762028096907669811487431649040206546179292274931158555956605099986382706217459209761309199883223171072"},
  {"0x1.188d357087713p+641", 193, "1.000000000000000066227513319607302289081477890678169217557471861406187070692054671467037855447108395613962730519045620382433086810350574289754091699751101204052080881216804133415187732536649318e+193"},
  {"0x1.5eb082cca94d7p+644", 194, "99999999999999994465967438754696170766327875910118237148971115117854351613178134068619377108456504406004528089686414709538562749489776621177115003729674648080379472553427423904462708600804999168"},
  {"0x1.5eb082cca94d8p+644", 194, "1.0000000000000001067501262969607491495542109345371648329133920981487349222121457817273192169012895127986018803931061114781155732488348436490817389205692194451348429331109807648720412813795157606e+194"},
  {"0x1.b65ca37fd3a0dp+647", 195, "999999999999999977077764769429719196041465194188378863774447340572581797347854228894418860247909937807756600796112539971931616645685181699233267813951241073670004367049615544210109925082343145472"},
  {"0x1.b65ca37fd3a0ep+647", 195, "1.00000000000000010675012629696074914955421093453716483291339209814873492221214578172731921690128951279860188039310611147811557324883484364908173892056921944513484293311098076487204128137951576064e+195"},
  {"0x1.11f9e62fe4448p+651", 196, "9999999999999999511432924639235132053389160461186216699466583890573511723749959183278387889172340228095875448767138256706948253250552493092635735926276453993770366538373425000777236538229086224384"},
  {"0x1.11f9e62fe4449p+651", 196, "1.000000000000000158619070907973161130959309230676679220568970001179196172157862402860479359562641342794939992231903540080589155890094708429021127363216410793720778359535526853136813823898384806707e+196"},
  {"0x1.56785fbbdd55ap+654", 197, "99999999999999995114329246392351320533891604611862166994665838905735117237499591832783878891723402280958754487671382567069482532505524930926357359262764539937703665383734250007772365382290862243840"},
  {"0x1.56785fbbdd55bp+654", 197, "1.0000000000000001171239152191632315458352305937650677104445076787548271722012891059539512454335598787978695027608655971986102897770868166050696166090986577148520300183958899825249957898832895698534e+197"},
  {"0x1.ac1677aad4ab0p+657", 198, "999999999999999884751043361827625869140390227060043253747518673178360772444478643277393806310703680414274761723053117059528639544242622390941156386039240473187039308013923507098814799398756243472384"},
  {"0x1.ac1677aad4ab1p+657", 198, "1.00000000000000001753554156601940054153744186517720008614579810493634157230551319337828377152376436520490032803037453428186101110586787622758599079921605032556703399966076149305663250824706100140442e+198"},
  {"0x1.0b8e0acac4eaep+661", 199, "9999999999999998847510433618276258691403902270600432537475186731783607724444786432773938063107036804142747617230531170595286395442426223909411563860392404731870393080139235070988147993987562434723840"},
  {"0x1.0b8e0acac4eafp+661", 199, "1.000000000000000097206240488534465344975672848047494185584765763991130052222133923438817750651600776079275667814767384615260434042843028529572891447122136236995030814648864284631323133556043856163635e+199"},
  {"0x1.4e718d7d7625ap+664", 200, "99999999999999996973312221251036165947450327545502362648241750950346848435554075534196338404706251868027512415973882408182135734368278484639385041047239877871023591066789981811181813306167128854888448"},
  {"0x1.4e718d7d7625bp+664", 200, "1.0000000000000001396972799138758332401427293722449843719522151821536839081776649794711025395197801952122758490331102381264067929425631097572992384593387153897566291159758524401378248003875013787018854e+200"},
  {"0x1.a20df0dcd3af0p+667", 201, "999999999999999901747459131964173027207212836739039328294498440443382314826691065690307721857975448067474834210390258463987183104130654882031695190925872134291678628544718769301415466131339252487684096"},
  {"0x1.a20df0dcd3af1p+667", 201, "1.00000000000000003771878529305655029174179371417100792467033657856355465388439044499361904623614958929307541410908738969965553158323491481075600563001892542312879319279108086692222079999200332461008486e+201"},
  {"0x1.0548b68a044d6p+671", 202, "9999999999999999017474591319641730272072128367390393282944984404433823148266910656903077218579754480674748342103902584639871831041306548820316951909258721342916786285447187693014154661313392524876840960"},
  {"0x1.0548b68a044d7p+671", 202, "1.000000000000000119301580989711976650462542240630189082495839461435658057319010072575605840863054074028435762048305668441056540670697470767990591893474757396431061931338898125494704000308401767883525325e+202"},
  {"0x1.469ae42c8560cp+674", 203, "99999999999999998876910787506329447650934459829549922997503484884029261182361866844442696946000689845185920534555642245481492613075738123641525387194542623914743194966239051177873087980216425864602058752"},
  {"0x1.469ae42c8560dp+674", 203, "1.0000000000000001628124053612615373751136081214084190333361076656341132058174738739526654646640697992206279476158887504364704121840108339451823712339845344488589385918977339967333617071438142709626935706e+203"},
  {"0x1.98419d37a6b8fp+677", 204, "999999999999999988769107875063294476509344598295499229975034848840292611823618668444426969460006898451859205345556422454814926130757381236415253871945426239147431949662390511778730879802164258646020587520"},
  {"0x1.98419d37a6b90p+677", 204, "1.00000000000000012800374586402188879539275541678583507266389310227534908701870283285101776562325721906687419916182228484013931497336014340342894776157671280691663726345066529974243554167548426849935897395e+204"},
  {"0x1.fe52048590672p+680", 205, "9999999999999999052283250816881378851792981072012977243617198967792587267065681698004724917620567060828502090557969050236202928251957239362070375381666542984859087613894256390005080826781722527340175556608"},
  {"0x1.fe52048590673p+680", 205, "1.000000000000000016616035472855013340286026761993566398512806499527303906862635501325745128692656962574862204108809594931879803899277933669817992649871683552701273012420045469371471812176828260616688264806e+205"},
  {"0x1.3ef342d37a407p+684", 206, "99999999999999986067324092522138770313660664528439025470128525568004065464414123719036343698981660348604541103459182906031648839556284004276265549348464259679976306097717770685212259087870984958094927200256"},
  {"0x1.3ef342d37a408p+684", 206, "1.0000000000000000388935775510883884313073724929520201333430238200769129428938489676307996560787770138732646031194121329135317061140943756165401836722126894035443458626261694354456645580765594621932224066355e+206"},
  {"0x1.8eb0138858d09p+687", 207, "999999999999999896317308250394787848770759814817916230429632968559415112294082783278450680807608685563489249451555889830959531939269147157518161129230251958148679621306976052570830984318279772103403898929152"},
  {"0x1.8eb0138858d0ap+687", 207, "1.00000000000000003889357755108838843130737249295202013334302382007691294289384896763079965607877701387326460311941213291353170611409437561654018367221268940354434586262616943544566455807655946219322240663552e+207"},
  {"0x1.f25c186a6f04cp+690", 208, "9999999999999999818630698308109481982927274216983785721776674794699138106539424938898600659703096825493544616522696356805028364441642842329313746550197144253860793660984920822957311285732475861572950035529728"},
  {"0x1.f25c186a6f04dp+690", 208, "1.000000000000000095924085271365828664322017564205661694508380160683912075133755441371739246187244345197174744586554630146560575784024467000148992689405664381702612359153846788595597987579871338229149809718067e+208"},
  {"0x1.37798f428562fp+694", 209, "99999999999999989061425747836704382546929530769255207431309733449871519907009213590435672179676195243109823530484164010765664497227613801915728022751095446033285297165420831725583764136794858449981115862089728"},
  {"0x1.37798f4285630p+694", 209, "1.0000000000000000731118821832548525711161595357042050700422376244411124222377928518753634101438574126676106879996976312533490279160524304467054690825284743904393057605427758473356246157785465878147788484850483e+209"},
  {"0x1.8557f31326bbbp+697", 210, "999999999999999927113782419344605574598668153294882673458925392487194643703632279098558059466181044478400725843812838336795121561031396504666917998514458446354143529431921823271795036250068185162804696593727488"},
  {"0x1.8557f31326bbcp+697", 210, "1.00000000000000007311188218325485257111615953570420507004223762444111242223779285187536341014385741266761068799969763125334902791605243044670546908252847439043930576054277584733562461577854658781477884848504832e+210"},
  {"0x1.e6adefd7f06aap+700", 211, "9999999999999999563134023721266549739021664297767471527755878388779781994104643936539191296017163181162427182749897969201059028320356032930746282153172616351711759756540926280845609521557638656931995269719916544"},
  {"0x1.e6adefd7f06abp+700", 211, "1.00000000000000007311188218325485257111615953570420507004223762444111242223779285187536341014385741266761068799969763125334902791605243044670546908252847439043930576054277584733562461577854658781477884848504832e+211"},
  {"0x1.302cb5e6f642ap+704", 212, "99999999999999990959401044767537593501656918740576398586892792465272451027953301036534141738485988029569553038510666318680865279842887243162229186843277653306392406169861934038413548670665077684456779836676898816"},
  {"0x1.302cb5e6f642bp+704", 212, "1.0000000000000000964715781454804920905589581568896966534955675815537392668032585435196522662522856315778842819446391981199976529328557958774316372559707169414929317175205124911858373485031031322390947127876596531e+212"},
  {"0x1.7c37e360b3d35p+707", 213, "999999999999999984345037526797422397233524775199337052919583787413130412889023223627065756931830180808571031008919677160084252852199641809946030023447952696435527124027376600704816231425231719002378564135125254144"},
  {"0x1.7c37e360b3d36p+707", 213, "1.00000000000000013384709168504151532166743595078648318702089551293394221810800365015051443602577078183432203225654570510663545295974118056659350633347830502317873324868489112134617772086239360331800009567183778611e+213"},
  {"0x1.db45dc38e0c82p+710", 214, "9999999999999999544446266951486038123467425400819078260993214423089680518452271383223760211130420606034208307593944715707740128306913340586165347614418822310868858990958736965765439335377993421392542578277827477504"},
  {"0x1.db45dc38e0c83p+710", 214, "1.000000000000000074046270021743878151893871480551624733380370822725617496020411479541134964388194541424021631757495293928014972916724565063934515809466164092481450798821885313089633125087528849591751483057152773325e+214"},
  {"0x1.290ba9a38c7d1p+714", 215, "99999999999999990660396936451049407652789096389402106318690169014230827417515340183487244380298106827518051036015414262787762879627804165648934234223216948652905993920546904997130825691790753915825536773603473752064"},
  {"0x1.290ba9a38c7d2p+714", 215, "1.0000000000000000979665986870629330198032972686455681148365806988089473848554483477848867530432250375881417919571154583994631649339312112649981120190710204647603637787670876363922509633974747510822509281030267784397e+215"},
  {"0x1.734e940c6f9c5p+717", 216, "999999999999999868331443500000006287872809702943711652856965888408980452039094412644869581954932274412588254040761879473560521568747407734787588406864399290882799171293145332687119715621994096773456255662636329336832"},
  {"0x1.734e940c6f9c6p+717", 216, "1.00000000000000002142154695804195744249313474674494929417670909534229174058333036940488102934712744986295727931833093209082895047886994342159460414833548007346784224294244020182387388080564786631265270395622996207206e+216"},
  {"0x1.d022390f8b837p+720", 217, "9999999999999999601855055748251769806450047292244542376488118125689672251656359867008764503902493796828096692073033110439215789148209291468717978517470477604338250142827222541691722147321863584969741246387925089779712"},
  {"0x1.d022390f8b838p+720", 217, "1.000000000000000082657588341258737904341264764265444350704606378115616256001024752108885608304005520043104889429358553137736322042918957696317410444923912386501859471602158149478575546879109374128331283273667415166157e+217"},
  {"0x1.221563a9b7322p+724", 218, "99999999999999988670225591496504042642724870819986016981533507324097780666440272745607095564199569546663253707407016578763273303796211201720443029584092898479300433989106071698353021544403254911815982945786756526505984"},
  {"0x1.221563a9b7323p+724", 218, "1.0000000000000000826575883412587379043412647642654443507046063781156162560010247521088856083040055200431048894293585531377363220429189576963174104449239123865018594716021581494785755468791093741283312832736674151661568e+218"},
  {"0x1.6a9abc9424febp+727", 219, "999999999999999965084388885482519417592855130626093842171043595190833186399051537317196816706799625297221478016185520727674168639944850288849622355474122345476546392575499689981548348018063279122228410984187505225498624"},
  {"0x1.6a9abc9424fecp+727", 219, "1.00000000000000012184865482651747739992406797547856118688246063909054394586834915703944853883640748495839935990041623060775703984391032683214000647474050906684363049794437763597758461316612473913036557403682738514637619e+219"},
  {"0x1.c5416bb92e3e6p+730", 220, "9999999999999999964372420736895110140590976995965873111133270039707753382929110612616471611327211972294570543930316627036907428807379455975076991793273996897499632136492752791807556010476755711238558435947154812096741376"},
  {"0x1.c5416bb92e3e7p+730", 220, "1.000000000000000121848654826517477399924067975478561186882460639090543945868349157039448538836407484958399359900416230607757039843910326832140006474740509066843630497944377635977584613166124739130365574036827385146376192e+220"},
  {"0x1.1b48e353bce6fp+734", 221, "99999999999999984594354677029595135102113336853821866019036664182705300920238534632828550788829765195472628778417018121881118652493108811594893042483166843723756247249515245102456078650553656951604416706418119648563167232"},
  {"0x1.1b48e353bce70p+734", 221, "1.0000000000000000466018071748206975684050858099493768614209804580186827813230862995727677122141957123210339765959854898653172616660068980913606220974926434405874301273673162218994872058950552383264597357715602427843549594e+221"},
  {"0x1.621b1c28ac20bp+737", 222, "999999999999999886075198851200900594497923856820450300436489405065378963626525536977181948753477264027987825546533242948112401553146250111031268759363863437907536003469585205199546070383440303278127280805657005745376329728"},
  {"0x1.621b1c28ac20cp+737", 222, "1.00000000000000004660180717482069756840508580994937686142098045801868278132308629957276771221419571232103397659598548986531726166600689809136062209749264344058743012736731622189948720589505523832645973577156024278435495936e+222"},
  {"0x1.baa1e332d728ep+740", 223, "9999999999999999181805205159248599892793562474462356126333876156560397271658376894962991014456209536865970557564236923315533735757183797070971394269896194384435148282491314085395342974857632902877937717988376531531720556544"},
  {"0x1.baa1e332d728fp+740", 223, "1.00000000000000004660180717482069756840508580994937686142098045801868278132308629957276771221419571232103397659598548986531726166600689809136062209749264344058743012736731622189948720589505523832645973577156024278435495936e+223"},
  {"0x1.14a52dffc6799p+744", 224, "99999999999999996954903517948319502092964807244749211214842475260109694882873713352688654575305085714037182409224841134505892881183378706080253249519082903930108094789640533388351546084948006950326015738792668900564521713664"},
  {"0x1.14a52dffc679ap+744", 224, "1.0000000000000001750230938337165351475308153724525181102085733003813258354803349096492363229827704709554708974355472873990811497562954164756241047679956674427313454264855010352594401143043471863651256997442828324155378630656e+224"},
  {"0x1.59ce797fb817fp+747", 225, "999999999999999928454223448636526995609414612446486912536395043045051171498417578302416590307106934377352009423588636134254484622941461177838218040629861358615028052178586193608330530158506646130887048916655460323666687950848"},
  {"0x1.59ce797fb8180p+747", 225, "1.00000000000000009283347037202319909689034845245050771098451388126923428081969579920029641209088262542943126809822773697747226137851076470969547585887373208135923963504986275470907025292240033962037948280174037505158080469402e+225"},
  {"0x1.b04217dfa61dfp+750", 226, "9999999999999999613300728333138614158656013804472910722260188106898877933626732224819925546638620725877678611585164563028980399740553218842096696042786355031638703687528415058284784747112853848287855356936724432692495112994816"},
  {"0x1.b04217dfa61e0p+750", 226, "1.000000000000000092833470372023199096890348452450507710984513881269234280819695799200296412090882625429431268098227736977472261378510764709695475858873732081359239635049862754709070252922400339620379482801740375051580804694016e+226"},
  {"0x1.0e294eebc7d2bp+754", 227, "99999999999999988242803431008825880725075313724536108897092176834227990088845967645101024020764974088276981699468968789815350713138205618891818585152157755624664880897462875650012340778461641195382916742883168419985073526276096"},
  {"0x1.0e294eebc7d2cp+754", 227, "1.000000000000000092833470372023199096890348452450507710984513881269234280819695799200296412090882625429431268098227736977472261378510764709695475858873732081359239635049862754709070252922400339620379482801740375051580804694016e+227"},
  {"0x1.51b3a2a6b9c76p+757", 228, "999999999999999924509121522475246865178672200286390413373640190927670776874706901000867474584296317792102107215397297714017257980807797893073643852992008461269166974189675556141912776812173197487139230503413422370196749149011968"},
  {"0x1.51b3a2a6b9c77p+757", 228, "1.000000000000000092833470372023199096890348452450507710984513881269234280819695799200296412090882625429431268098227736977472261378510764709695475858873732081359239635049862754709070252922400339620379482801740375051580804694016e+228"},
  {"0x1.a6208b5068394p+760", 229, "9999999999999999918388610622944277578633427011520373324179896670642961784527024602806390495869308408470337715685294734193992593398889846197223766553446979093051960385337504355687757672562640543404353314227442034427503713670135808"},
  {"0x1.a6208b5068395p+760", 229, "1.000000000000000126498340141932789543232683702883331170506688619337546981608693578840182199592199886956897100274793824830163262058051358073019842260050076805377254167221900194422501748144445768047027533261405765587857615803016806e+229"},
  {"0x1.07d457124123cp+764", 230, "99999999999999988411127779858373832956786989976700226194703050524569553592790956543300452958271560395914310860351799229078805716535908585708440417158039479244754953558323062848579498254571868337516156995181495372666457581821100032"},
  {"0x1.07d457124123dp+764", 230, "1.0000000000000000995664443260051171861588155025370724028889488288828968209774953551282735695911460777349244345335409545480104615144188833823603491391090010261628425414842702426517565519668094253057090928936734531588361669158161613e+230"},
  {"0x1.49c96cd6d16cbp+767", 231, "999999999999999884111277798583738329567869899767002261947030505245695535927909565433004529582715603959143108603517992290788057165359085857084404171580394792447549535583230628485794982545718683375161569951814953726664575818211000320"},
  {"0x1.49c96cd6d16ccp+767", 231, "1.00000000000000005647541102052084141484062638198305837470056516415545656396757819718921976158945998297976816934753636209656598064460692387730516014560327977941978394030406231981856423808259127691959958830530175327240184869629512909e+231"},
  {"0x1.9c3bc80c85c7ep+770", 232, "9999999999999999185841044429711589466224211962102134844977374370276477415358432917842475759840644797632681207523216662519436418612086534611285553663849717898419964165273969667523488336530932020840491736225123136358120303938278260736"},
  {"0x1.9c3bc80c85c7fp+770", 232, "1.000000000000000056475411020520841414840626381983058374700565164155456563967578197189219761589459982979768169347536362096565980644606923877305160145603279779419783940304062319818564238082591276919599588305301753272401848696295129088e+232"},
  {"0x1.01a55d07d39cfp+774", 233, "99999999999999997374062707399103193390970327051935144057886852787877127050853725394623645022622268104986814019040754458979257737456796162759919727807229498567311142603806310797883499542489243201826933949562808949044795771481474727936"},
  {"0x1.01a55d07d39d0p+774", 233, "1.0000000000000001943667175980705238830588315677559032649033928912832653863993131025941919471948554861962682179427510579411883194280051942934817649248215877689975714640807276728847796425120893517551500029880911929089916669987624321024e+233"},
  {"0x1.420eb449c8842p+777", 234, "999999999999999841364972759543336764420226292177420345984153909836074800974071744757463152045042997962028093539001436578955132142505622028069656690022719315678435403212464369035268207172574280176140941400150227439321732144446136385536"},
  {"0x1.420eb449c8843p+777", 234, "1.00000000000000001786584517880693032373952892996666180544377340055967009368669242367582754961994924207914815574087624726007172578525540816077571080742215354233800343364659602096002392484233181596564547219412071017415669957160428424397e+234"},
  {"0x1.9292615c3aa53p+780", 235, "9999999999999999119653217272487741881479473472931169297680017061255129180591200163248089110750054956088761184197513608514017695996055364811520783369824930063422626153861170298051704942404772944919427537177384205332557191153093955289088"},
  {"0x1.9292615c3aa54p+780", 235, "1.000000000000000053166019662659649035603389457524510097335697298704389152229216559459500429134930490902572168181251209396295044513805365387316921630902040387669917039733422351344975068376283323123546378352914806721123693057035913815654e+235"},
  {"0x1.f736f9b3494e8p+783", 236, "99999999999999994020546131433094915763903576933939556328154082464128816489313932495174721468699049466761532837205133056038042458244550226238504699576640248260779350025557809411313140906763850021826347864477369777082931390365469918625792"},
  {"0x1.f736f9b3494e9p+783", 236, "1.0000000000000000531660196626596490356033894575245100973356972987043891522292165594595004291349304909025721681812512093962950445138053653873169216309020403876699170397334223513449750683762833231235463783529148067211236930570359138156544e+236"},
  {"0x1.3a825c100dd11p+787", 237, "999999999999999940205461314330949157639035769339395563281540824641288164893139324951747214686990494667615328372051330560380424582445502262385046995766402482607793500255578094113131409067638500218263478644773697770829313903654699186257920"},
  {"0x1.3a825c100dd12p+787", 237, "1.00000000000000012094235467165686896238200167043557881776819118314224974463086290016415235780369448864354627206677113669784381647262128326227604641198342313070719116342012890568408126396147021686671611817779947209130032054906464259329229e+237"},
  {"0x1.8922f31411455p+790", 238, "9999999999999999040580826428657651966904425891201589123842107529410958489455946099092661860636496958724291396331073693328877462044103460624068471125229983529879139676226679317989414380888721568885729507381685429067351125745727105048510464"},
  {"0x1.8922f31411456p+790", 238, "1.000000000000000048647597328726501040484815309997105515973531039741865112735773470079190300557012891053173894588883214242858459716550970862319646645496614871467432098154308581055701322003937530207335062364589162363111917890900665230478541e+238"},
  {"0x1.eb6bafd91596bp+793", 239, "99999999999999999081179145438220670296706622164632687453780292502155740721970192601122065475966761298087599260657287627887017431169472094235452683230716826407562484594165232135299736843791138087983021771402091458056119576436948334022754304"},
  {"0x1.eb6bafd91596cp+793", 239, "1.0000000000000001064834032030707953780025643983478841574092591544621728182518450141471599463543581691254717965711935522068467451214072207822847664586860614788592393503669648407584052755699636795348399070151574101456626400174318471207295386e+239"},
  {"0x1.33234de7ad7e2p+797", 240, "999999999999999828871535006218182557917368774264146678517764203804695831774701602620905646527100834378441867056103929979702975178097221166452191355376717763378564539746214794185426298453038162762816652692429820789419173810082174047524749312"},
  {"0x1.33234de7ad7e3p+797", 240, "1.00000000000000001394611380411992443797416585698663833111209417090968048942613054363840851307860572420979515339949701146446548847363722091034057475758294690703234774682671482523407894986432184061083215557424821369358148461498195609632794214e+240"},
  {"0x1.7fec216198ddbp+800", 241, "9999999999999999029013665253788793099400876073531433395554961906466896948352731790279067931477027903109831815934611625736079804963132210640075447162592094208400778225784148066048873590175516339020228538451571779510840981320420868670460264448"},
  {"0x1.7fec216198ddcp+800", 241, "1.00000000000000005096102956370027281398552527353113666163096016433067742095641633184190908638890670217606581066817562776141799113274522085911825143802419273576310438824281483144380948014657857618043525615061189227441394677596191250608858071e+241"},
  {"0x1.dfe729b9ff152p+803", 242, "99999999999999993251329913304315801074917514058874200397058898538348724005950180959070725179594357268399970740840405561116998262359962102302968606061220608382468313571129481157267178324335702235770533430624812081575006786082605199485453729792"},
  {"0x1.dfe729b9ff153p+803", 242, "1.0000000000000000509610295637002728139855252735311366616309601643306774209564163318419090863889067021760658106681756277614179911327452208591182514380241927357631043882428148314438094801465785761804352561506118922744139467759619125060885807104e+242"},
  {"0x1.2bf07a143f6d3p+807", 243, "999999999999999885134206960780312089454635087411784140906440513804611167700736000690226517958758320887173266104495426751070779219941381088594259909647411423049314634698686803624216704482068400828613365568502612232284516294771707790360919932928"},
  {"0x1.2bf07a143f6d4p+807", 243, "1.0000000000000000746505756498316957746327953001196155931630344001201154571357992362921494533074993280744790313201299421914675928345743408263359645135065900661507886387491188354180370195272228869449812405194846465661467225589890846083353893929e+243"},
  {"0x1.76ec98994f488p+810", 244, "9999999999999999230374806985905888264902671299533504313577592910677120255877486478106111050285065223246344191476223298391501419428679730361426008304192471516696094355087732099829807674910992980518869405586990190990569575476151831539558138249216"},
  {"0x1.76ec98994f489p+810", 244, "1.000000000000000074650575649831695774632795300119615593163034400120115457135799236292149453307499328074479031320129942191467592834574340826335964513506590066150788638749118835418037019527222886944981240519484646566146722558989084608335389392896e+244"},
  {"0x1.d4a7bebfa31aap+813", 245, "99999999999999992303748069859058882649026712995335043135775929106771202558774864781061110502850652232463441914762232983915014194286797303614260083041924715166960943550877320998298076749109929805188694055869901909905695754761518315395581382492160"},
  {"0x1.d4a7bebfa31abp+813", 245, "1.0000000000000000443279566595834743850042896660863625608019793783096347708261891185958417836517007669245101088856284197210041026562330672682972917768891214832545527981010497103310257691199981691663623805273275210727287695567143043174594742793011e+245"},
  {"0x1.24e8d737c5f0ap+817", 246, "999999999999999874521290314193434603084658115500145579580071256170942927492372459496518833579228824484684143252419893886408557657521935343280724451831297419035632090471862609843762766839539749606096764571247618309588232743975534688554349643169792"},
  {"0x1.24e8d737c5f0bp+817", 246, "1.00000000000000006858605185178205149670709417331296498669082339575801931987387721275288791937633961584448524683322963769737489479890608611472822996618309634957154147061950501040063476944577794338925746852105322146746313195853412855016020637017702e+246"},
  {"0x1.6e230d05b76cdp+820", 247, "9999999999999999521471949292288813605336325386252733424243721120057734844449743607990664678980731410286045846847437914107950925140755956518597266575720169912499958425309195700665115678820350271193610461511698595727381924297989722331966923339726848"},
  {"0x1.6e230d05b76cep+820", 247, "1.00000000000000010739900415929977487543158138487552886811297382367543459835017816340416173653576177411644546754939158645956816222718291626901773106905345613567872334664903349051200916996702558214588960931101434209903811180144584732248137771557847e+247"},
  {"0x1.c9abd04725480p+823", 248, "99999999999999992109683308321470265755404276937522223728665176967184126166393360027804741417053541441103640811181423240104047857145413152842812577527572916236425034170729678597741204746503691611405533351920096306747820855546959721533975525765152768"},
  {"0x1.c9abd04725481p+823", 248, "1.0000000000000000452982804672714174694724018463754266578375331390075701527880966423621236290806863208813091144035324684400589343419399880221545293044608804779072323450017879223338101291330293601352781840470765490885181440527870972867675035629361562e+248"},
  {"0x1.1e0b622c774d0p+827", 249, "999999999999999921096833083214702657554042769375222237286651769671841261663933600278047414170535414411036408111814232401040478571454131528428125775275729162364250341707296785977412047465036916114055333519200963067478208555469597215339755257651527680"},
  {"0x1.1e0b622c774d1p+827", 249, "1.00000000000000011981914889770544635662341729257554931016806196060900748746259446761256935802677686476347273817856341006347000780423150191839037142197197126723302154697848260414764897813382482654801189436380190070114210535117759732962415254610693325e+249"},
  {"0x1.658e3ab795204p+830", 250, "9999999999999999210968330832147026575540427693752222372866517696718412616639336002780474141705354144110364081118142324010404785714541315284281257752757291623642503417072967859774120474650369161140553335192009630674782085554695972153397552576515276800"},
  {"0x1.658e3ab795205p+830", 250, "1.000000000000000080074685734807297616809542387935483895591779922421574242302862294145664969255528574692985472165213574530984101957676027840397922292632722846259267305924245440513601592000067244461220582194881713174409325992035997306767273088415852134e+250"},
  {"0x1.bef1c9657a685p+833", 251, "99999999999999992109683308321470265755404276937522223728665176967184126166393360027804741417053541441103640811181423240104047857145413152842812577527572916236425034170729678597741204746503691611405533351920096306747820855546959721533975525765152768000"},
  {"0x1.bef1c9657a686p+833", 251, "1.0000000000000000482791152044887786249584424642234315639307542918716276461750765553721414582385299426365956593545337061049953772804316485780039629891613241094802639130808557096063636830930611787917875324597455631530231025047227172884817695222629872435e+251"},
  {"0x1.17571ddf6c813p+837", 252, "999999999999999895660376658959887464073162830405580371957831265231883984761705009259228605356936508765924557863270337660249498829658628118512958332498610172941047627432585001251621720339432063578508893731092043050369229765618973200711352404729235767296"},
  {"0x1.17571ddf6c814p+837", 252, "1.00000000000000009915202805299840901192020234216271529458839530075154219997953373740977907586572775392681935985162149558657733676402265539783429787471556208832666934163027927905794433734427088386288041203596340318724106008442396531773857522810757106893e+252"},
  {"0x1.5d2ce55747a18p+840", 253, "9999999999999999363587069377675917736425707327570073564839440723358156278052707548893386994586947577981035182609405692455150664165314335743772262409420005560181719702721238568128862437403998276353831973920663150777435958293799716241167969694049028276224"},
  {"0x1.5d2ce55747a19p+840", 253, "1.000000000000000099152028052998409011920202342162715294588395300751542199979533737409779075865727753926819359851621495586577336764022655397834297874715562088326669341630279279057944337344270883862880412035963403187241060084423965317738575228107571068928e+253"},
  {"0x1.b4781ead1989ep+843", 254, "99999999999999993635870693776759177364257073275700735648394407233581562780527075488933869945869475779810351826094056924551506641653143357437722624094200055601817197027212385681288624374039982763538319739206631507774359582937997162411679696940490282762240"},
  {"0x1.b4781ead1989fp+843", 254, "1.0000000000000000665933638299522455642646760202815737069675050550683968855446811409056910005843211547010761915334853103183648826945244110331428835479608497818649698673586481946089327186234966726173809691071839855653415672334151665790142195763670374206669e+254"},
  {"0x1.10cb132c2ff63p+847", 255, "999999999999999988452569694641453289891412847766833896677368465428848130901034909295879619908945316559292587569958465674654992927728624557883489163749540246356891129106733591931304833693638565628182306078113383272782784390994049606075766012189756664840192"},
  {"0x1.10cb132c2ff64p+847", 255, "1.00000000000000019682802072213689935488678130780614005745106603780097814328409152692204330170994755160404886480603005139121469897251738849190854085497969900771176776444517253240497919350659351759937874082230165605293953863745036153391164218332917201371136e+255"},
  {"0x1.54fdd7f73bf3bp+850", 256, "9999999999999998634272990781441856508941917717432502002131499220055701234712009387201814108283439755324388212283155142447191693008553661974684581490114449895439651479036702276471002178058655944454644452316004196046887318431202624493742403095061074555174912"},
  {"0x1.54fdd7f73bf3cp+850", 256, "1.000000000000000030127659900140542502890486539774695128832107979903274133377646232821112356269145763568243843017172782817966934136686377344688499501995571998627866456174421380026039705656229556022421593026951037828814135240285311991642941246417639734614426e+256"},
  {"0x1.aa3d4df50af0ap+853", 257, "99999999999999989676737124254345702129345072534953918593694153358511092545248999754036759991650433313959982558608696795936872226802156842691246641960827039136074540955782045812288811537593838676085587479067054324951381252255327235782798049688841391133687808"},
  {"0x1.aa3d4df50af0bp+853", 257, "1.0000000000000000301276599001405425028904865397746951288321079799032741333776462328211123562691457635682438430171727828179669341366863773446884995019955719986278664561744213800260397056562295560224215930269510378288141352402853119916429412464176397346144256e+257"},
  {"0x1.0a6650b926d66p+857", 258, "999999999999999843423255779504622828654636399579476808778874955057845642282427503428069697375447760968142218613652642015929437520555644859802053186653349748453896990911180089361627479263821919056229587496158345417793683435460456504301996197076723582025859072"},
  {"0x1.0a6650b926d67p+857", 258, "1.0000000000000000567997176316599595992098937026597263174111412691669067749626774798772613075396740496539726465033899457896865765104193391282437061184730323200812906654977415644066700237122877898747347366742071367446741997838317199184059333963234848992699351e+258"},
  {"0x1.4cffe4e7708c0p+860", 259, "9999999999999999287738405203667575368767393208115766122317814807014700953545274940077463414411382764424743897695475635254322931165011225671787143593812227771048544607458046793796444970432082673836316471673778619485458899748089618699435710767754281089234894848"},
  {"0x1.4cffe4e7708c1p+860", 259, "1.00000000000000009947501000209102695332094516327577621913759453198871900149872747516709962957251930739113873208133740654443800430839207798193203670483696883440676940041505385941567853260198096403843576650981689501005030305350597260122672083617283716271875031e+259"},
  {"0x1.a03fde214caf0p+863", 260, "99999999999999992877384052036675753687673932081157661223178148070147009535452749400774634144113827644247438976954756352543229311650112256717871435938122277710485446074580467937964449704320826738363164716737786194854588997480896186994357107677542810892348948480"},
  {"0x1.a03fde214caf1p+863", 260, "1.0000000000000000653347761057461730700321039947829362977564319217312692202698874789352289719462431012014058636189794379406368620700138868989813722357458196229463864124812040234084717254902264247074749426413290883977494204377665704549700908842933553519596981453e+260"},
  {"0x1.0427ead4cfed6p+867", 261, "999999999999999928773840520366757536876739320811576612231781480701470095354527494007746341441138276442474389769547563525432293116501122567178714359381222777104854460745804679379644497043208267383631647167377861948545889974808961869943571076775428108923489484800"},
  {"0x1.0427ead4cfed7p+867", 261, "1.00000000000000014727133745697382238992532279916575210907122218634914869521910346989171855024930599605676474792863856258975960344212154549806296696156457773045130558352244362982576806255843731910178091992569982426727153871554113560598600276880411169778142334157e+261"},
  {"0x1.4531e58a03e8bp+870", 262, "9999999999999998413748417457239315956573059294699064134960051984423986554086971036541574579178711885967582465059111638997013689862529533948250133185078807957662740116351490992011950708371166466963719380640490770210556304785160923755265983999639546733803159420928"},
  {"0x1.4531e58a03e8cp+870", 262, "1.000000000000000016172839295009583478096172712153246810967557762960541535300357884361335224964405364288190533033183963151163217246749291739532415400254564758443434909856460259558093923249299888070891356270706646876036149471101831364360543753586901544466663027507e+262"},
  {"0x1.967e5eec84e2ep+873", 263, "99999999999999987633444125558106197214507928600657449299031571134602723138702925979559301132717802373504470381136572374999373863835222106376649373485721758830170619127941133127257484131955329497127582170538059099205173427703324017329338747068854404759758535917568"},
  {"0x1.967e5eec84e2fp+873", 263, "1.0000000000000000161728392950095834780961727121532468109675577629605415353003578843613352249644053642881905330331839631511632172467492917395324154002545647584434349098564602595580939232492998880708913562707066468760361494711018313643605437535869015444666630275072e+263"},
  {"0x1.fc1df6a7a61bap+876", 264, "999999999999999932269800471352470574525516656465243420181212531991832952952360709621889896782068959956303035500093019510461530081711049334072862401016156456358397678710230902586782474091451932211122035531511013345645500354660676649720249983847887046345216426508288"},
  {"0x1.fc1df6a7a61bbp+876", 264, "1.0000000000000000441405189028952877792863913973825812745630061732834443960830236092744836676918508323988196988775476110313971129684287058746855997333340341924717806535718700452151977396352492066908144631837718580528330325099155496025739750101665730438404785611735e+264"},
  {"0x1.3d92ba28c7d14p+880", 265, "9999999999999998875215130987353436926211667600983082784284950754751883757000955497608523884181562109792963701491111829020872969270239867178277674680890053619130444887655752455354163678739330224192450644706066754627704874925587274685787599733204126473471115726422016"},
  {"0x1.3d92ba28c7d15p+880", 265, "1.000000000000000066514662589203851220238566345566048845439364901541766684709156189205002421873807206887323031553038529335584229545772237182808147199797609739694457248544197873740880792744008661586752948714224026994270538940966524193144720015430310243339530988106547e+265"},
  {"0x1.8cf768b2f9c59p+883", 266, "99999999999999988752151309873534369262116676009830827842849507547518837570009554976085238841815621097929637014911118290208729692702398671782776746808900536191304448876557524553541636787393302241924506447060667546277048749255872746857875997332041264734711157264220160"},
  {"0x1.8cf768b2f9c5ap+883", 266, "1.0000000000000000307160326911101497147150864284725007320371909363284510229073440613161724151826770077057176992722530600488848430220225870898120712534558888641381746965884733480997879077699935337532513718655005566879705286512849648482315280070083307241410471050136781e+266"},
  {"0x1.f03542dfb8370p+886", 267, "999999999999999973438224854160227305877518561122823750593712591987145964024444656694044404476868689015149167622996309190165824584023146941018349739309135463248122613459314107074039291811569329219648848907543004197890512187794469896370420793533163493423472892065087488"},
  {"0x1.f03542dfb8371p+886", 267, "1.00000000000000008799384052806007212355265429582217771348066928066975608179024346593830042588848532639628623092150981090760386146002202723860579276760264226502822677971763258912553652372841773828685389482345810917805054511477545980009263522048349795485862131796226867e+267"},
  {"0x1.362149cbd3226p+890", 268, "9999999999999999734382248541602273058775185611228237505937125919871459640244446566940444044768686890151491676229963091901658245840231469410183497393091354632481226134593141070740392918115693292196488489075430041978905121877944698963704207935331634934234728920650874880"},
  {"0x1.362149cbd3227p+890", 268, "1.000000000000000156727209932399979014157735736641790091212843293879322152449722751484854038735455308824968468900617911938066683585621355417158258584578746346096289279472623678356434862878526783727176922373007172166146564870964053742325963876653698631719710373500577382e+268"},
  {"0x1.83a99c3ec7eafp+893", 269, "99999999999999990012263082286432662256543169091523721434606031123027548865433341877772055077343404109122144711194766809100548098338386355056238620120129111010885594705399027856108106338478634741663761952135733701058809111452663635798820356028494943810497789949089153024"},
  {"0x1.83a99c3ec7eb0p+893", 269, "1.0000000000000000467538188854561279891896054313304102868413648727440164393945558946103682581803033369390768881340449502893261681846624303314743132774169798163873892798646379355869975202383523110226600782937286713851929332610623034347526380267813775487419678846392834458e+269"},
  {"0x1.e494034e79e5bp+896", 270, "999999999999999929448868435382686895890266438998271828845121223533023678802377913944250092254807900260792535316367124530669618423639576906744771616444428851364562613616119809966264354755499540137842111275831603885509059543833769773341090453584235060232375896520569913344"},
  {"0x1.e494034e79e5cp+896", 270, "1.00000000000000004675381888545612798918960543133041028684136487274401643939455589461036825818030333693907688813404495028932616818466243033147431327741697981638738927986463793558699752023835231102266007829372867138519293326106230343475263802678137754874196788463928344576e+270"},
  {"0x1.2edc82110c2f9p+900", 271, "9999999999999999529098585253973751145501342374646995204443699533752222309208135100774737254399069875964494058799026896824009283758441475916906799486389390443691279468658234350904109878520700943148057046794110173854458342872794765056233999682236635579342942941443126198272"},
  {"0x1.2edc82110c2fap+900", 271, "1.000000000000000140597779245514880863829076625196121053238359792112810647868298279143262790920699686281704370388187210896251407993480713071257946606195020588405650612863452436083584052624634527730514451908046325384940032234845130363881876085339091539549641475134254271693e+271"},
  {"0x1.7a93a2954f3b7p+903", 272, "99999999999999991537227438137387396469434575991841521388557198562770454753131655626431591234374844785939841297824578543963083245231683449577722661712772273556182341366629763489177637489755720763166395523368395578554699469776634573397170474480057796161122485794632428945408"},
  {"0x1.7a93a2954f3b8p+903", 272, "1.0000000000000000655226109574678785641174996701035524401207638566177752810893043715169471647283826068076023845848734024107112161464260868794310399431725879707910415464644008356863148267156087543642309530165922021851423530558188688205784856384929203469035026027382776109466e+272"},
  {"0x1.d9388b3aa30a5p+906", 273, "999999999999999945402341696592674884578976541955442659132610359825718694242914119314842162820675279649039207299571308833846909191138684972507989282336695782607667040225918275050684065261167516978177354790265605065466066369376850351293060923539046438669680406904714953752576"},
  {"0x1.d9388b3aa30a6p+906", 273, "1.00000000000000006552261095746787856411749967010355244012076385661777528108930437151694716472838260680760238458487340241071121614642608687943103994317258797079104154646440083568631482671560875436423095301659220218514235305581886882057848563849292034690350260273827761094656e+273"},
  {"0x1.27c35704a5e67p+910", 274, "9999999999999999213782878444176341486712719163258207029349796604673073768736360688744211624391338142173265718425108901184740478000812045911233791501695173449709921389782217629235579129702792695009666351450002856415308090320884466574359759805482716570229159677380024223137792"},
  {"0x1.27c35704a5e68p+910", 274, "1.000000000000000113570718661817960035932908921362796352516025255334597915827860472397789165491465537671027655498994239841456938928541047642200260207506944846064391348959793859940567131297385249318652392307122841033012867730395676208292655524474469910197031481071702673824154e+274"},
  {"0x1.71b42cc5cf601p+913", 275, "99999999999999995981677400789769932612359931733321583285118877944076548466448094957909476304960015890806678857380756006307062602577317320133875536163700284518967198097453618232695975663570046546450378657742479671982722077174989256760731188933351130765773907040474247261585408"},
  {"0x1.71b42cc5cf602p+913", 275, "1.0000000000000001135707186618179600359329089213627963525160252553345979158278604723977891654914655376710276554989942398414569389285410476422002602075069448460643913489597938599405671312973852493186523923071228410330128677303956762082926555244744699101970314810717026738241536e+275"},
  {"0x1.ce2137f743381p+916", 276, "999999999999999929065985077113647184161737396527299728918221484261998998431805045015355882561227083155474615188770224107393363445219598313166454392463014445014728107377484646804238281703363508693674065431485187857190091380020735839470243162305319587149880588271350432374194176"},
  {"0x1.ce2137f743382p+916", 276, "1.00000000000000005206914080024985575200918507975096414465009066497706494336250866327031140451471938616584330872891956793010241376743389786585565826915896804571450360176569078889512418143271133577699295001524362330773860894693736275201851807041808646918131451680491859334083379e+276"},
  {"0x1.20d4c2fa8a030p+920", 277, "9999999999999998060628293539774386163142897133036353131863523035469330535011014267604003606077347801451059216486208802846843131230052987604772505157670608443149526129892785047133523819740156816103551808477267524066415738131041089269219682541925527051184466597377822714075545600"},
  {"0x1.20d4c2fa8a031p+920", 277, "1.000000000000000002867878510995372324870206006461498378357342992691038565390227215968329195733322464961695831312859830401018793638548178044779976718480586605434593404010408332058769821540972204943665396181740249127519201920170711986999208107172979716368740945391491328954177946e+277"},
  {"0x1.6909f3b92c83dp+923", 278, "99999999999999996350686867959178558315902274782992576532314485486221746301240205812674342870820492799837784938001204037775189753543960218791943147793788145321066524580618236658968633362758090027700335311493754978334367629875739137498376013657689431411868208826074951744485326848"},
  {"0x1.6909f3b92c83ep+923", 278, "1.000000000000000120950908005206132550003755782356216217459937406177501872523702689493086496808675075851649777111403200470819481947873905615361612440108702062106377878623086228466020285281146118943651525382148347160045778784410673823045552018961235923118917516783716763482151977e+278"},
  {"0x1.c34c70a777a4cp+926", 279, "999999999999999932018060814468916189790076140924667674895786344599160581110141931853474815088110898427723463833733808359138380652952741502430995285503717331431522719242801594214419543296867856543673718661495390308003255801626734885371401760100025992318635002556156068237393526784"},
  {"0x1.c34c70a777a4dp+926", 279, "1.00000000000000005797329227496039376326586256854570003660522038565138810871918243694654926956848701671034100601884673643359244818290018424438474005524037381854809282549632468371548670461972003147699225647526402820936493779014936084382083526600749927951882334537452986506723249357e+279"},
  {"0x1.1a0fc668aac6fp+930", 280, "9999999999999998312538756460757341310094469988278417855282391117573785590229095277790152515038100038016294300856434658995751266289947873088679994697143921417382666342399831226135658142385861165970188884104804799869139102108086341186118549553740473625584843283014570307735223533568"},
  {"0x1.1a0fc668aac70p+930", 280, "1.000000000000000032782245982862098248570705283021493564263333577440942603197374335927934378672411793053817497581824150818701634676910695695993991101293042521124778804245620065815273272355149596490328548912510300629092601392444835652130948564826004622078785676810855105701264700211e+280"},
  {"0x1.6093b802d578bp+933", 281, "99999999999999987155954971343300695452169865566657214127525800489409136785780248940879907693753036165206704358487960288340042823857796898629319779603012221761556906824111051125390730586189881257568082051088644411534964844713587442531567367726443881446254459800333664575907082272768"},
  {"0x1.6093b802d578cp+933", 281, "1.0000000000000000327822459828620982485707052830214935642633335774409426031973743359279343786724117930538174975818241508187016346769106956959939911012930425211247788042456200658152732723551495964903285489125103006290926013924448356521309485648260046220787856768108551057012647002112e+281"},
  {"0x1.b8b8a6038ad6ep+936", 282, "999999999999999903804088967318825213331499981137556425872873119403461614925716858712626137284506647932417134384268512470460669526244514328233356457082706278317411015442012422166180499160548969358610366191211215418098239036197666670678728654776751975985792813764840337747509598224384"},
  {"0x1.b8b8a6038ad6fp+936", 282, "1.0000000000000000327822459828620982485707052830214935642633335774409426031973743359279343786724117930538174975818241508187016346769106956959939911012930425211247788042456200658152732723551495964903285489125103006290926013924448356521309485648260046220787856768108551057012647002112e+282"},
  {"0x1.137367c236c65p+940", 283, "9999999999999999553953517735361344274271821018911312812290573026184540102343798495987494338396687059809772796632907678097570555865109868753376103147668407754403581309634554796258176084383892202112976392797308495024959839786965342632596166187964530344229899589832462449290116390191104"},
  {"0x1.137367c236c66p+940", 283, "1.000000000000000161760402998405371283809910584905430702653794035478423591469031813143242620060316938175217860779379789166942599827576877063754625745503378763932146593049227709464366045549750223622046731633809385840086963748692004633583168474875257268171778539856869873655019802198016e+283"},
  {"0x1.585041b2c477ep+943", 284, "99999999999999991412234152856228705615063640528827139694410995604646009398744945688985079659553905954212916344007296353831994673829780883765420722861953317774200043854630103365810792101611701952914782080891514223497778802469744018919490624758069218767323224280852151918381000638332928"},
  {"0x1.585041b2c477fp+943", 284, "1.0000000000000000792143825084576765412568191916997109340838993423344357589751710277254453455720576452975216283329441806240683821311505209883878195732087635685354312082149188175289466707052058222577470946921779713050505718406938164854537477324437355746722631075074204221646165369264538e+284"},
  {"0x1.ae64521f7595ep+946", 285, "999999999999999980159157920520442850193109519852847211800025710561650359982538085224088616186146493844286149397221450372619320895438893697947652166455225334059372746413748147206443420891752540620587530362220273863006901551095990707698442841525909542472844588688081080376132618600579072"},
  {"0x1.ae64521f7595fp+946", 285, "1.00000000000000011223279070443675443827805574898199884151185721959203089197271534189256425536736136244860012131151842404121806920972106341853454204212660964669411736214864237430311442064302358280346694946883053711906512860389309174470551602941634425207206928044720020276077784303507866e+285"},
  {"0x1.0cfeb353a97dap+950", 286, "9999999999999998216707985798208689444911740448978652561458278997251937215943253772219178491686886515191093831000650819703008229183002900332433843156495641588976792075318750746904382211902272900011322274342879579557370290877394694632899550160573878909537749585771381335145583492791795712"},
  {"0x1.0cfeb353a97dbp+950", 286, "1.000000000000000032988611034086967485427088011504507863684758314173802572778608987891478871858632441286011738162940239840058820221151761586182408116723779059113270592707705838045111820792260957493739298004864379165430192372214831122501272116682083426312534465391728729329990708374378906e+286"},
  {"0x1.503e602893dd1p+953", 287, "99999999999999990619792356152730836086553963154052229916140006550463726206803882148974225824466616742587032512521514511820402183944087865441899383607925011898391576160220738003230766103104075699817505566251852643961429440152961412697448185630726610509727876130297437184073129291725930496"},
  {"0x1.503e602893dd2p+953", 287, "1.0000000000000000752521735249401871936142708048258363851925443970635243430154657100253910763966211992393922091755152714140104196817220558967702128769386220391563888697428719907160465407126676909922607121189796634073688250291099034543435355368070225333842863667546468484930771801934187725e+287"},
  {"0x1.a44df832b8d45p+956", 288, "999999999999999872387073568844732594315793396883459481955171199192859845878553443782612494614275161063165948315155119859042742270984643205948750027907375734949421139974074457895559885094715370199357924371226299046063388276013556261500671120207314819439877240212639876510262115462027411456"},
  {"0x1.a44df832b8d46p+956", 288, "1.00000000000000000763047353957503566051477833551171075078008666443996951063649495461113154913583918651398345555539522089568786054480958499982972526059487327108739962648660614644255098884001691739462644953639520862026701277807778772339591406460711996206948332457397785783213882528295498547e+288"},
  {"0x1.06b0bb1fb384bp+960", 289, "9999999999999998453383935746986719810759964091578092281901881061434379129269651416169086837099623559730024468671070996517137186162196548471725549813698762277218254426715681201861616643456550607603042193381925171312226633756007099691216225313273537909139560233403722802458867734978418966528"},
  {"0x1.06b0bb1fb384cp+960", 289, "1.000000000000000061727833527867156886994372310963011258310052850538813376539671558942539170944464796694310458451491261310345907854339561717382115353669872285542591021091618821861347430338137536272733859602462772449948462578903480308154011242367042019121325758318513050360889509211326015078e+289"},
  {"0x1.485ce9e7a065ep+963", 290, "99999999999999988861628156533236896225967158951884963421416105502251300564950642508203478115686284411726404918398393198344015646384363622121446705582987543928597855835557826052119881754415155586279014739104656819496782321626126403692810027353529143655542997033600043426888732064053872033792"},
  {"0x1.485ce9e7a065fp+963", 290, "1.0000000000000000617278335278671568869943723109630112583100528505388133765396715589425391709444647966943104584514912613103459078543395617173821153536698722855425910210916188218613474303381375362727338596024627724499484625789034803081540112423670420191213257583185130503608895092113260150784e+290"},
  {"0x1.9a742461887f6p+966", 291, "999999999999999957860902350346284132153551878096514283852517773229033154005572478626236537071903625148082612890986863714202457020042006419681526374965874177788623543449994485057258262661745948026767632275613049896960078961318150545418464661067991669581788285529005480705688196068853638234112"},
  {"0x1.9a742461887f7p+966", 291, "1.0000000000000000963501439203741144719413124552518435831292312096420734507177045857146400489019851872097197403049927271757270581324387468166156450132378716547939135136388269341293771528969347323547226020447460133009445904514319235623991934361333921356345049159150155735792899469254834740265e+291"},
  {"0x1.008896bcf54f9p+970", 292, "9999999999999997916738124663128877244082391855101191247204616495333847979510139501201523228758057506741180599941798275603729356851659179433605840090394772053822755792233955461707155943795194068332216685526534938121786651731816229250415901309895111103185283290657933692573660950408978352832512"},
  {"0x1.008896bcf54fap+970", 292, "1.000000000000000013256598978357416268068656108958646003563203147794249272690425321461597941803936249972737463856589209098812297465000702578455173830274673168590739531525527464686105818755821461757949620183266235258553883557363659752210756171094151856002874937683409517855128896411505572551066e+292"},
  {"0x1.40aabc6c32a38p+973", 293, "99999999999999992462348437353960485060448933957923525202610654848990348279466077292501969423268405025328970231162545648343655275306678872441733790178059478330735395060467469727994972900530063978805843953102113868000379620369084502134308975505229555772913629423636305841602377586326247764393984"},
  {"0x1.40aabc6c32a39p+973", 293, "1.0000000000000001018897135831752276855328228783380567551002997470985950625861898699981761893751884496921852254015529617141880421769346164324930097587687515538741251124463802320922619085063422837278408008355113318371039709110364744830784225871360081542766135811304559772942340169597486674581914e+293"},
  {"0x1.90d56b873f4c6p+976", 294, "999999999999999924623484373539604850604489339579235252026106548489903482794660772925019694232684050253289702311625456483436552753066788724417337901780594783307353950604674697279949729005300639788058439531021138680003796203690845021343089755052295557729136294236363058416023775863262477643939840"},
  {"0x1.90d56b873f4c7p+976", 294, "1.00000000000000006643646774124810311854715617058629245448546110737685674662788405058354489034668756980440612078356746066803774429216105089087787538737112019976077088007803912512979947260613395493988432857461329320568393596956734859073135602071926563496711812375163739351859196874045142949534106e+294"},
  {"0x1.f50ac6690f1f8p+979", 295, "9999999999999999813486777206230041577815560719820581330098483720446847883279500839884297726782854580737362697004022581572770293687044935910015528960168049498887207223940204684198896264456339658487887951484580004902758521100414464490983962613190835886243290260424727924570510530141380583845003264"},
  {"0x1.f50ac6690f1f9p+979", 295, "1.000000000000000094799064414789802772135689536787703894977332019154247399394528706115249929569488273714629404477955861504957982599979903324169982884489225283051454265972712010699769421326300617970249506383331724110819963922742649304609009273852659650414714489654692260539105607315889219865621299e+295"},
  {"0x1.3926bc01a973bp+983", 296, "99999999999999998134867772062300415778155607198205813300984837204468478832795008398842977267828545807373626970040225815727702936870449359100155289601680494988872072239402046841988962644563396584878879514845800049027585211004144644909839626131908358862432902604247279245705105301413805838450032640"},
  {"0x1.3926bc01a973cp+983", 296, "1.0000000000000001628692964312898819407481696156710913521578222074199849660344758793913420237042099630991652853444880235135665545387451491640710408775726774829490943921199269360676972982547006092431259331242559582831464310103633710179153770813728052874889457678220239413883383398969399167542938829e+296"},
  {"0x1.87706b0213d09p+986", 297, "999999999999999872436306494222877488001587945768638201521064070819504681704034606746682422062730755058478860313950798943503314266680100247159860107083281430052496520558476587831205023360193979812186512362979225814553504769848291707808207769286850569305558980974742103098278680884456943362624192512"},
  {"0x1.87706b0213d0ap+986", 297, "1.0000000000000000176528014627563797143748787807198647768394431391197448238692552430690122228834703590788220728292194112285349344027126247056154504923279794565007954563392017619494511608074472945276562227436175920488499678901058313628617924253298279283972523743983830222433085103906984300584590377e+297"},
  {"0x1.e94c85c298c4cp+989", 298, "9999999999999999595662034753429788238255624467393741467120915117996487670031669885400803025551745174706847878231119663145222863482996149222332143382301002459214758820269116923021527058285459686414683385913622455551313826420028155008403585629126369847605750170289266545852965785882018353801250996224"},
  {"0x1.e94c85c298c4dp+989", 298, "1.00000000000000007573939945016978060492419511470035540696679476643984088073534349759794414321176620068695935783532685614254758245712563448899768664642585866708011503065149183159674961578634862041384410689587293854256855313820884722488322628774701887203392973176783938990132044219319502473679297577e+298"},
  {"0x1.31cfd3999f7afp+993", 299, "99999999999999986662764669548153739894665631237058913850832890808749507601742578129378923002990117089766513181334005445210204946123879926882163649167349350899456456312724758086647517786230384722356772394775369116518164624503799012160606438304513147494189124523779646633247748770420728389479079870464"},
  {"0x1.31cfd3999f7b0p+993", 299, "1.0000000000000000525047602552044202487044685811081591549158541155118024579889081957863713750804478640437044438328838781769425232353604305756447921847867069828483872009265758037378302337947880900593689532349707999450811190389676408800746527427801424945792587888200568428381156694721963868654594005402e+299"},
  {"0x1.7e43c8800759bp+996", 300, "999999999999999903803069407426113968898218766118103141789833949572356552411722264192305659040010509526872994217248819197070144216063125530186267630296136203765329090687113225440746189048800695790727969805197112921161540803823920273299782054992133678869364753954248541633605124057805104488924519071744"},
  {"0x1.7e43c8800759cp+996", 300, "1.00000000000000005250476025520442024870446858110815915491585411551180245798890819578637137508044786404370444383288387817694252323536043057564479218478670698284838720092657580373783023379478809005936895323497079994508111903896764088007465274278014249457925878882005684283811566947219638686545940054016e+300"},
  {"0x1.ddd4baa009302p+999", 301, "9999999999999999335434075769817752248594687291161143444150379827602457335271594505111188022480979804302392841403758309930446200199225865392779725411942503595819407127350057411001629979979981746444561664911518503259454564508526643946547561925497354420113435609274102018745072331406833609642314953654272"},
  {"0x1.ddd4baa009303p+999", 301, "1.00000000000000005250476025520442024870446858110815915491585411551180245798890819578637137508044786404370444383288387817694252323536043057564479218478670698284838720092657580373783023379478809005936895323497079994508111903896764088007465274278014249457925878882005684283811566947219638686545940054016e+301"},
  {"0x1.2aa4f4a405be1p+1003", 302, "99999999999999988595886650569271721532146878831929642021471152965962304374245995240101777311515802698485322026337261211948545873374744892473124468375726771027536211745837771604509610367928220847849105179362427047829119141560667380048679757245757262098417746977035154548906385860807815060374033329553408"},
  {"0x1.2aa4f4a405be2p+1003", 302, "1.0000000000000000762970307908489492534734685515065681170160173420621138028812579448414218896469178407663974757713854876137221038784479993829181561135051983075016764985648898162653636809541460731423515105837345898689082515565906361771586320528262239050928418343985861710308373567384989920457049815751066e+302"},
  {"0x1.754e31cd072d9p+1006", 303, "999999999999999847891233648661470807691068835681842080854450367179124891914700353912936949808806064228544369161770037020638129704807338833093862397807681590830099241237075296001042588224309435545718960035602206600167779387409881325152430676383842364162444596844704620380709158981993982315347403639619584"},
  {"0x1.754e31cd072dap+1006", 303, "1.00000000000000000016176507678645643821266864623165943829549501710111749922573874786526024303421391525377977356818033741602744582056777919964339154160602606861115074612228497617725665004420052727680732706769046211266142750019705122648989826067876339144937608854729232081412795748633065546891912226327757e+303"},
  {"0x1.d2a1be4048f90p+1009", 304, "9999999999999999392535525055364621860040287220117324953190771571323204563013233902843309257440507748436856118056162172578717193742636030530235798840866882774987301441682011041067710253162440905843719802548551599076639682550821832659549112269607949805346034918662572406407604380845959862074904348138143744"},
  {"0x1.d2a1be4048f91p+1009", 304, "1.000000000000000061069977648036450690421308570451586381271912877069914542150154105446189560324377055663873935330744457574183172266871955346263203199125363859723571348076368848247742274772156963969242673880525764317658886745311919187024885294396731802364148685228327400987495476888065324730347809712740762e+304"},
  {"0x1.23a516e82d9bap+1013", 305, "99999999999999993925355250553646218600402872201173249531907715713232045630132339028433092574405077484368561180561621725787171937426360305302357988408668827749873014416820110410677102531624409058437198025485515990766396825508218326595491122696079498053460349186625724064076043808459598620749043481381437440"},
  {"0x1.23a516e82d9bbp+1013", 305, "1.0000000000000001341598327335364437930716764795154987128436143090324709936594525345433047410725728241559869294458214017639700440024369667222069771881485692090584760704212694947323250244457046880001650900559281269636558378394497607396668697348582938954618758012455694971955365001701469278440622346520965939e+305"},
  {"0x1.6c8e5ca239028p+1016", 306, "999999999999999861291040414336469543176969619010226008309262296372260241358071732580741399612641955118765084749534143455432389522994257585350220962461935904874831773666973747856549425664459851618054736334425973085267220421335152276470127823801795414563694568114532338018850013250375609552861714878501486592"},
  {"0x1.6c8e5ca239029p+1016", 306, "1.00000000000000001721606459673645482883108782501323898232889201789238067124457504798792045187545959456860613886169829106031104922553294852069693880571144065012262851466942846035699262496802832955068922417528434673006071608882921425543969463011979454650551241561798214326267086291881636286211915474912726221e+306"},
  {"0x1.c7b1f3cac7433p+1019", 307, "9999999999999999860310597602564577717002641838126363875249660735883565852672743849064846414228960666786379280392654615393353172850252103336275952370615397010730691664689375178569039851073146339641623266071126720011020169553304018596457812688561947201171488461172921822139066929851282122002676667750021070848"},
  {"0x1.c7b1f3cac7434p+1019", 307, "1.000000000000000110771079106176446000223558748615046766740669850804452929176477037232227883233150178238510771328996779623238245047056163081904969511661143497271306559270901287857258544550169416310269916879799370916936813489325651442821434713910594025670603124120052026408963372719880814847673618671502727578e+307"},
  {"0x1.1ccf385ebc89fp+1023", 308, "99999999999999981139503267596847425176765179308926185662298078548582170379439067165044410288854031049481594743364161622187121841818187648603927125262209438639553681654618823985640760188731793867961170022535129351893330180773705244319986644578003569234231285691342840034082734135647456849389933411990123839488"},
  {"0x1.1ccf385ebc8a0p+1023", 308, "1.0000000000000000109790636294404554174049230967731184633681068290315758540491149153716332897849468889906124966972117251561159028374314008832830700919814604603127166450293302718569748969958855904333838446616500117842689762621294517762809119578670745812278397017178441510529180289320787327297488571543022311834e+308"},
  {"0x1.a36e2eb1c432cp-14", 309, "9.99999999999999912396464463171241732197813689708709716796875e-5"},
  {"0x1.a36e2eb1c432dp-14", 309, "0.000100000000000000004792173602385929598312941379845142364501953125"},
  {"0x1.0624dd2f1a9fbp-10", 309, "0.00099999999999999980397624721462079833145253360271453857421875"},
  {"0x1.0624dd2f1a9fcp-10", 309, "0.001000000000000000020816681711721685132943093776702880859375"},
  {"0x1.47ae147ae147ap-7", 309, "0.0099999999999999984734433411404097569175064563751220703125"},
  {"0x1.47ae147ae147bp-7", 309, "0.01000000000000000020816681711721685132943093776702880859375"},
  {"0x1.9999999999999p-4", 309, "0.09999999999999999167332731531132594682276248931884765625"},
  {"0x1.999999999999ap-4", 309, "0.1000000000000000055511151231257827021181583404541015625"},
  {"0x1.fffffffffffffp-1", 309, "0.99999999999999988897769753748434595763683319091796875"},
  {"0x1.0000000000000p+0", 309, "1"},
  {"0x1.3ffffffffffffp+3", 309, "9.9999999999999982236431605997495353221893310546875"},
  {"0x1.4000000000000p+3", 309, "10"},
  {"0x1.8ffffffffffffp+6", 309, "99.9999999999999857891452847979962825775146484375"},
  {"0x1.9000000000000p+6", 309, "100"},
  {"0x1.f3fffffffffffp+9", 309, "999.9999999999998863131622783839702606201171875"},
  {"0x1.f400000000000p+9", 309, "1000"},
  {"0x1.387ffffffffffp+13", 309, "9999.999999999998181010596454143524169921875"},
  {"0x1.3880000000000p+13", 309, "10000"},
  {"0x1.869ffffffffffp+16", 309, "99999.999999999985448084771633148193359375"},
  {"0x1.86a0000000000p+16", 309, "100000"},
  {"0x1.e847fffffffffp+19", 309, "999999.999999999883584678173065185546875"},
  {"0x1.e848000000000p+19", 309, "1000000"},
  {"0x1.312cfffffffffp+23", 309, "9999999.99999999813735485076904296875"},
  {"0x1.312d000000000p+23", 309, "10000000"},
  {"0x1.7d783ffffffffp+26", 309, "99999999.99999998509883880615234375"},
  {"0x1.7d78400000000p+26", 309, "100000000"},
  {"0x1.dcd64ffffffffp+29", 309, "999999999.99999988079071044921875"},
  {"0x1.dcd6500000000p+29", 309, "1000000000"},
  {"0x1.2a05f1fffffffp+33", 309, "9999999999.9999980926513671875"},
  {"0x1.2a05f20000000p+33", 309, "10000000000"},
  {"0x1.74876e7ffffffp+36", 309, "99999999999.9999847412109375"},
  {"0x1.74876e8000000p+36", 309, "100000000000"},
  {"0x1.d1a94a1ffffffp+39", 309, "999999999999.9998779296875"},
  {"0x1.d1a94a2000000p+39", 309, "1000000000000"},
  {"0x1.2309ce53fffffp+43", 309, "9999999999999.998046875"},
  {"0x1.2309ce5400000p+43", 309, "10000000000000"},
  {"0x1.6bcc41e8fffffp+46", 309, "99999999999999.984375"},
  {"0x1.6bcc41e900000p+46", 309, "100000000000000"},
  {"0x1.c6bf52633ffffp+49", 309, "999999999999999.875"},
  {"0x1.c6bf526340000p+49", 309, "1000000000000000"},
  {"0x1.1c37937e07fffp+53", 309, "9999999999999998"},
  {"0x1.1c37937e08000p+53", 309, "10000000000000000"},
  {"0x1.6345785d89fffp+56", 309, "99999999999999984"},
  {"0x1.6345785d8a000p+56", 309, "100000000000000000"},
  {"0x1.bc16d674ec7ffp+59", 309, "999999999999999872"},
  {"0x1.bc16d674ec800p+59", 309, "1000000000000000000"},
  {"0x1.158e460913cffp+63", 309, "9999999999999997952"},
  {"0x1.158e460913d00p+63", 309, "10000000000000000000"},
  {"0x1.5af1d78b58c3fp+66", 309, "99999999999999983616"},
  {"0x1.5af1d78b58c40p+66", 309, "100000000000000000000"},
  {"0x1.b1ae4d6e2ef4fp+69", 309, "999999999999999868928"},
  {"0x1.b1ae4d6e2ef50p+69", 309, "1000000000000000000000"},
  {"0x1.0f0cf064dd591p+73", 309, "9999999999999997902848"},
  {"0x1.0f0cf064dd592p+73", 309, "10000000000000000000000"},
  {"0x1.52d02c7e14af6p+76", 309, "99999999999999991611392"},
  {"0x1.52d02c7e14af7p+76", 309, "100000000000000008388608"},
  {"0x1.a784379d99db4p+79", 309, "999999999999999983222784"},
  {"0x1.a784379d99db5p+79", 309, "1000000000000000117440512"},
  {"0x1.08b2a2c280290p+83", 309, "9999999999999998758486016"},
  {"0x1.08b2a2c280291p+83", 309, "10000000000000000905969664"},
  {"0x1.4adf4b7320334p+86", 309, "99999999999999987584860160"},
  {"0x1.4adf4b7320335p+86", 309, "100000000000000004764729344"},
  {"0x1.9d971e4fe8401p+89", 309, "999999999999999875848601600"},
  {"0x1.9d971e4fe8402p+89", 309, "1000000000000000013287555072"},
  {"0x1.027e72f1f1281p+93", 309, "9999999999999999583119736832"},
  {"0x1.027e72f1f1282p+93", 309, "10000000000000001782142992384"},
  {"0x1.431e0fae6d721p+96", 309, "99999999999999991433150857216"},
  {"0x1.431e0fae6d722p+96", 309, "100000000000000009025336901632"},
  {"0x1.93e5939a08ce9p+99", 309, "999999999999999879147136483328"},
  {"0x1.93e5939a08ceap+99", 309, "1000000000000000019884624838656"},
  {"0x1.f8def8808b024p+102", 309, "9999999999999999635896294965248"},
  {"0x1.f8def8808b025p+102", 309, "10000000000000000761796201807872"},
  {"0x1.3b8b5b5056e16p+106", 309, "99999999999999987351763694911488"},
  {"0x1.3b8b5b5056e17p+106", 309, "100000000000000005366162204393472"},
  {"0x1.8a6e32246c99cp+109", 309, "999999999999999945575230987042816"},
  {"0x1.8a6e32246c99dp+109", 309, "1000000000000000089690419062898688"},
  {"0x1.ed09bead87c03p+112", 309, "9999999999999999455752309870428160"},
  {"0x1.ed09bead87c04p+112", 309, "10000000000000000608673814477275136"},
  {"0x1.3426172c74d82p+116", 309, "99999999999999996863366107917975552"},
  {"0x1.3426172c74d83p+116", 309, "100000000000000015310110181627527168"},
  {"0x1.812f9cf7920e2p+119", 309, "999999999999999894846684784341549056"},
  {"0x1.812f9cf7920e3p+119", 309, "1000000000000000042420637374017961984"},
  {"0x1.e17b84357691bp+122", 309, "9999999999999999538762658202121142272"},
  {"0x1.e17b84357691cp+122", 309, "10000000000000000719354278919532445696"},
  {"0x1.2ced32a16a1b1p+126", 309, "99999999999999997748809823456034029568"},
  {"0x1.2ced32a16a1b2p+126", 309, "100000000000000016638275754934614884352"},
  {"0x1.78287f49c4a1dp+129", 309, "999999999999999939709166371603178586112"},
  {"0x1.78287f49c4a1ep+129", 309, "1000000000000000090824893823431825424384"},
  {"0x1.d6329f1c35ca4p+132", 309, "9999999999999999094860208812374492184576"},
  {"0x1.d6329f1c35ca5p+132", 309, "10000000000000000303786028427003666890752"},
  {"0x1.25dfa371a19e6p+136", 309, "99999999999999981277195531206711524196352"},
  {"0x1.25dfa371a19e7p+136", 309, "100000000000000000620008645040778319495168"},
  {"0x1.6f578c4e0a060p+139", 309, "999999999999999890143207767403382423158784"},
  {"0x1.6f578c4e0a061p+139", 309, "1000000000000000044885712678075916785549312"},
  {"0x1.cb2d6f618c878p+142", 309, "9999999999999998901432077674033824231587840"},
  {"0x1.cb2d6f618c879p+142", 309, "10000000000000000139372116959414099130712064"},
  {"0x1.1efc659cf7d4bp+146", 309, "99999999999999989014320776740338242315878400"},
  {"0x1.1efc659cf7d4cp+146", 309, "100000000000000008821361405306422640701865984"},
  {"0x1.66bb7f0435c9ep+149", 309, "999999999999999929757289024535551219930759168"},
  {"0x1.66bb7f0435c9fp+149", 309, "1000000000000000088213614053064226407018659840"},
  {"0x1.c06a5ec5433c6p+152", 309, "9999999999999999931398190359470212947659194368"},
  {"0x1.c06a5ec5433c7p+152", 309, "10000000000000001199048790587699614444362399744"},
  {"0x1.18427b3b4a05bp+156", 309, "99999999999999984102174700855949311516153479168"},
  {"0x1.18427b3b4a05cp+156", 309, "100000000000000004384584304507619735463404765184"},
  {"0x1.5e531a0a1c872p+159", 309, "999999999999999881586566215862833963056037363712"},
  {"0x1.5e531a0a1c873p+159", 309, "1000000000000000043845843045076197354634047651840"},
  {"0x1.b5e7e08ca3a8fp+162", 309, "9999999999999999464902769475481793196872414789632"},
  {"0x1.b5e7e08ca3a90p+162", 309, "10000000000000000762976984109188700329496497094656"},
  {"0x1.11b0ec57e6499p+166", 309, "99999999999999986860582406952576489172979654066176"},
  {"0x1.11b0ec57e649ap+166", 309, "100000000000000007629769841091887003294964970946560"},
  {"0x1.561d276ddfdc0p+169", 309, "999999999999999993220948674361627976461708441944064"},
  {"0x1.561d276ddfdc1p+169", 309, "1000000000000000159374448147476112089437590976987136"},
  {"0x1.aba4714957d30p+172", 309, "9999999999999999932209486743616279764617084419440640"},
  {"0x1.aba4714957d31p+172", 309, "10000000000000001261437482528532152668424144699785216"},
  {"0x1.0b46c6cdd6e3ep+176", 309, "99999999999999999322094867436162797646170844194406400"},
  {"0x1.0b46c6cdd6e3fp+176", 309, "100000000000000020589742799994816764107083808679919616"},
  {"0x1.4e1878814c9cdp+179", 309, "999999999999999908150356944127012110618056584002011136"},
  {"0x1.4e1878814c9cep+179", 309, "1000000000000000078291540404596243842305360299886116864"},
  {"0x1.a19e96a19fc40p+182", 309, "9999999999999998741221202520331657642805958408251899904"},
  {"0x1.a19e96a19fc41p+182", 309, "10000000000000000102350670204085511496304388135324745728"},
  {"0x1.05031e2503da8p+186", 309, "99999999999999987412212025203316576428059584082518999040"},
  {"0x1.05031e2503da9p+186", 309, "100000000000000009190283508143378238084034459715684532224"},
  {"0x1.4643e5ae44d12p+189", 309, "999999999999999874122120252033165764280595840825189990400"},
  {"0x1.4643e5ae44d13p+189", 309, "1000000000000000048346692115553659057528394845890514255872"},
  {"0x1.97d4df19d6057p+192", 309, "9999999999999999438119489974413630815797154428513196965888"},
  {"0x1.97d4df19d6058p+192", 309, "10000000000000000831916064882577577161779546469035791089664"},
  {"0x1.fdca16e04b86dp+195", 309, "99999999999999997168788049560464200849936328366177157906432"},
  {"0x1.fdca16e04b86ep+195", 309, "100000000000000008319160648825775771617795464690357910896640"},
  {"0x1.3e9e4e4c2f344p+199", 309, "999999999999999949387135297074018866963645011013410073083904"},
  {"0x1.3e9e4e4c2f345p+199", 309, "1000000000000000127793096885319003999249391192200302120927232"},
  {"0x1.8e45e1df3b015p+202", 309, "9999999999999999493871352970740188669636450110134100730839040"},
  {"0x1.8e45e1df3b016p+202", 309, "10000000000000000921119045676700069727922419559629237113585664"},
  {"0x1.f1d75a5709c1ap+205", 309, "99999999999999992084218144295482124579792562202350734542897152"},
  {"0x1.f1d75a5709c1bp+205", 309, "100000000000000003502199685943161173046080317798311825604870144"},
  {"0x1.3726987666190p+209", 309, "999999999999999875170255276364105051932774599639662981181079552"},
  {"0x1.3726987666191p+209", 309, "1000000000000000057857959942726969827393378689175040438172647424"},
  {"0x1.84f03e93ff9f4p+212", 309, "9999999999999998751702552763641050519327745996396629811810795520"},
  {"0x1.84f03e93ff9f5p+212", 309, "10000000000000000213204190094543968723012578712679649467743338496"},
  {"0x1.e62c4e38ff872p+215", 309, "99999999999999999209038626283633850822756121694230455365568299008"},
  {"0x1.e62c4e38ff873p+215", 309, "100000000000000010901051724930857196452234783424494612613028642816"},
  {"0x1.2fdbb0e39fb47p+219", 309, "999999999999999945322333868247445125709646570021247924665841614848"},
  {"0x1.2fdbb0e39fb48p+219", 309, "1000000000000000132394543446603018655781305157705474440625207115776"},
  {"0x1.7bd29d1c87a19p+222", 309, "9999999999999999827367757839185598317239782875580932278577147150336"},
  {"0x1.7bd29d1c87a1ap+222", 309, "10000000000000001323945434466030186557813051577054744406252071157760"},
  {"0x1.dac74463a989fp+225", 309, "99999999999999995280522225138166806691251291352861698530421623488512"},
  {"0x1.dac74463a98a0p+225", 309, "100000000000000007253143638152923512615837440964652195551821015547904"},
  {"0x1.28bc8abe49f63p+229", 309, "999999999999999880969493773293127831364996015857874003175819882528768"},
  {"0x1.28bc8abe49f64p+229", 309, "1000000000000000072531436381529235126158374409646521955518210155479040"},
  {"0x1.72ebad6ddc73cp+232", 309, "9999999999999999192818822949403492903236716946156035936442979371188224"},
  {"0x1.72ebad6ddc73dp+232", 309, "10000000000000000725314363815292351261583744096465219555182101554790400"},
  {"0x1.cfa698c95390bp+235", 309, "99999999999999991928188229494034929032367169461560359364429793711882240"},
  {"0x1.cfa698c95390cp+235", 309, "100000000000000004188152556421145795899143386664033828314342771180699648"},
  {"0x1.21c81f7dd43a7p+239", 309, "999999999999999943801810948794571024057224129020550531544123892056457216"},
  {"0x1.21c81f7dd43a8p+239", 309, "1000000000000000139961240179628344893925643604260126034742731531557535744"},
  {"0x1.6a3a275d49491p+242", 309, "9999999999999999830336967949613257980309080240684656321838454199566729216"},
  {"0x1.6a3a275d49492p+242", 309, "10000000000000001399612401796283448939256436042601260347427315315575357440"},
  {"0x1.c4c8b1349b9b5p+245", 309, "99999999999999995164818811802792197885196090803013355167206819763650035712"},
  {"0x1.c4c8b1349b9b6p+245", 309, "100000000000000007719022282576153725556774937218346187371917708691719061504"},
  {"0x1.1afd6ec0e1411p+249", 309, "999999999999999926539781176481198923508803215199467887262646419780362305536"},
  {"0x1.1afd6ec0e1412p+249", 309, "1000000000000000127407036708854983366254064757844793202538020642629466718208"},
  {"0x1.61bcca7119915p+252", 309, "9999999999999998863663300700064420349597509066704028242075715752105414230016"},
  {"0x1.61bcca7119916p+252", 309, "10000000000000000470601344959054695891559601407866630764278709534898249531392"},
  {"0x1.ba2bfd0d5ff5bp+255", 309, "99999999999999998278261272554585856747747644714015897553975120217811154108416"},
  {"0x1.ba2bfd0d5ff5cp+255", 309, "100000000000000011133765626626508061083444383443316717731599070480153836519424"},
  {"0x1.145b7e285bf98p+259", 309, "999999999999999802805551768538947706777722104929947493053015898505313987330048"},
  {"0x1.145b7e285bf99p+259", 309, "1000000000000000008493621433689702976148869924598760615894999102702796905906176"},
  {"0x1.59725db272f7fp+262", 309, "9999999999999999673560075006595519222746403606649979913266024618633003221909504"},
  {"0x1.59725db272f80p+262", 309, "10000000000000001319064632327801561377715586164000484896001890252212866570518528"},
  {"0x1.afcef51f0fb5ep+265", 309, "99999999999999986862573406138718939297648940722396769236245052384850852127440896"},
  {"0x1.afcef51f0fb5fp+265", 309, "100000000000000000026609864708367276537402401181200809098131977453489758916313088"},
  {"0x1.0de1593369d1bp+269", 309, "999999999999999921281879895665782741935503249059183851809998224123064148429897728"},
  {"0x1.0de1593369d1cp+269", 309, "1000000000000000131906463232780156137771558616400048489600189025221286657051852800"},
  {"0x1.5159af8044462p+272", 309, "9999999999999999634067965630886574211027143225273567793680363843427086501542887424"},
  {"0x1.5159af8044463p+272", 309, "10000000000000001319064632327801561377715586164000484896001890252212866570518528000"},
  {"0x1.a5b01b605557ap+275", 309, "99999999999999989600692989521205793443517660497828009527517532799127744739526311936"},
  {"0x1.a5b01b605557bp+275", 309, "100000000000000003080666323096525690777025204007643346346089744069413985291331436544"},
  {"0x1.078e111c3556cp+279", 309, "999999999999999842087036560910778345101146430939018748000886482910132485188042620928"},
  {"0x1.078e111c3556dp+279", 309, "1000000000000000057766609898115896702437267127096064137098041863234712334016924614656"},
  {"0x1.4971956342ac7p+282", 309, "9999999999999998420870365609107783451011464309390187480008864829101324851880426209280"},
  {"0x1.4971956342ac8p+282", 309, "10000000000000000146306952306748730309700429878646550592786107871697963642511482159104"},
  {"0x1.9bcdfabc13579p+285", 309, "99999999999999987659576829486359728227492574232414601025643134376206526100066373992448"},
  {"0x1.9bcdfabc1357ap+285", 309, "100000000000000001463069523067487303097004298786465505927861078716979636425114821591040"},
  {"0x1.0160bcb58c16cp+289", 309, "999999999999999959416724456350362731491996089648451439669739009806703922950954425516032"},
  {"0x1.0160bcb58c16dp+289", 309, "1000000000000000180272607553648403929404183682513265918105226119259073688151729587093504"},
  {"0x1.41b8ebe2ef1c7p+292", 309, "9999999999999999594167244563503627314919960896484514396697390098067039229509544255160320"},
  {"0x1.41b8ebe2ef1c8p+292", 309, "10000000000000001361014309341887956898217461639403030224181286973685997351115745547780096"},
  {"0x1.922726dbaae39p+295", 309, "99999999999999999475366575191804932315794610450682175621941694731908308538307845136842752"},
  {"0x1.922726dbaae3ap+295", 309, "100000000000000013610143093418879568982174616394030302241812869736859973511157455477800960"},
  {"0x1.f6b0f092959c7p+298", 309, "999999999999999966484112715463900049825186092620125502979674597309179755437379230686511104"},
  {"0x1.f6b0f092959c8p+298", 309, "1000000000000000079562324861280497143156226140166910515938643997348793075220176113414176768"},
  {"0x1.3a2e965b9d81cp+302", 309, "9999999999999998986371854279739417938265620640920544952042929572854117635677011010499117056"},
  {"0x1.3a2e965b9d81dp+302", 309, "10000000000000000795623248612804971431562261401669105159386439973487930752201761134141767680"},
  {"0x1.88ba3bf284e23p+305", 309, "99999999999999989863718542797394179382656206409205449520429295728541176356770110104991170560"},
  {"0x1.88ba3bf284e24p+305", 309, "100000000000000004337729697461918607329029332495193931179177378933611681288968111094132375552"},
  {"0x1.eae8caef261acp+308", 309, "999999999999999927585207737302990649719308316264031458521789123695552773432097103028194115584"},
  {"0x1.eae8caef261adp+308", 309, "1000000000000000043377296974619186073290293324951939311791773789336116812889681110941323755520"},
  {"0x1.32d17ed577d0bp+312", 309, "9999999999999998349515363474500343108625203093137051759058013911831015418660298966976904036352"},
  {"0x1.32d17ed577d0cp+312", 309, "10000000000000000202188791271559469885760963232143577411377768562080040049981643093586978275328"},
  {"0x1.7f85de8ad5c4ep+315", 309, "99999999999999987200500490339121684640523551209383568895219648418808203449245677922989188841472"},
  {"0x1.7f85de8ad5c4fp+315", 309, "100000000000000002021887912715594698857609632321435774113777685620800400499816430935869782753280"},
  {"0x1.df67562d8b362p+318", 309, "999999999999999931290554592897108903273579836542044509826428632996050822694739791281414264061952"},
  {"0x1.df67562d8b363p+318", 309, "1000000000000000049861653971908893017010268485438462151574892930611988399099305815384459015356416"},
  {"0x1.2ba095dc7701dp+322", 309, "9999999999999998838621148412923952577789043769834774531270429139496757921329133816401963635441664"},
  {"0x1.2ba095dc7701ep+322", 309, "10000000000000000735758738477112498397576062152177456799245857901351759143802190202050679656153088"},
  {"0x1.7688bb5394c25p+325", 309, "99999999999999999769037024514370800696612547992403838920556863966097586548129676477911932478685184"},
  {"0x1.7688bb5394c26p+325", 309, "100000000000000014946137745027879167254908695051145297064360294060937596327914127563101660644376576"},
  {"0x1.d42aea2879f2ep+328", 309, "999999999999999967336168804116691273849533185806555472917961779471295845921727862608739868455469056"},
  {"0x1.d42aea2879f2fp+328", 309, "1000000000000000088752974568224758206315902362276487138068389220230015924160003471290257693781000192"},
  {"0x1.249ad2594c37cp+332", 309, "9999999999999998216360018871870109548898901740426374747374488505608317520357971321909184780648316928"},
  {"0x1.249ad2594c37dp+332", 309, "10000000000000000159028911097599180468360808563945281389781327557747838772170381060813469985856815104"},
  {"0x1.6dc186ef9f45cp+335", 309, "99999999999999997704951326524533662844684271992415000612999597473199345218078991130326129448151154688"},
  {"0x1.6dc186ef9f45dp+335", 309, "100000000000000013246302464330366230200379526580566253752254309890315515232578269041560411089819140096"},
  {"0x1.c931e8ab87173p+338", 309, "999999999999999977049513265245336628446842719924150006129995974731993452180789911303261294481511546880"},
  {"0x1.c931e8ab87174p+338", 309, "1000000000000000101380322367691997167292404756629360031244033674068922812296784134593135547614855430144"},
  {"0x1.1dbf316b346e7p+342", 309, "9999999999999998029863805218200118740630558685368559709703431956602923480183979986974373400948301103104"},
  {"0x1.1dbf316b346e8p+342", 309, "10000000000000000019156750857346687362159551272651920111528035145993793242039887559612361451081803235328"},
  {"0x1.652efdc6018a1p+345", 309, "99999999999999984277223943460294324649363572028252317900683525944810974325551615015019710109750015295488"},
  {"0x1.652efdc6018a2p+345", 309, "100000000000000000191567508573466873621595512726519201115280351459937932420398875596123614510818032353280"},
  {"0x1.be7abd3781ecap+348", 309, "999999999999999938258300825281978540327027364472124478294416212538871491824599713636820527503908255301632"},
  {"0x1.be7abd3781ecbp+348", 309, "1000000000000000065573049346187358932104882890058259544011190816659887156583377798285651762712452391763968"},
  {"0x1.170cb642b133ep+352", 309, "9999999999999998873324014169198263836158851542376704520077063708904652259210884797772880334204906007166976"},
  {"0x1.170cb642b133fp+352", 309, "10000000000000000910359990503684350104604539951754865571545457374840902895351334152154180097541612190564352"},
  {"0x1.5ccfe3d35d80ep+355", 309, "99999999999999996881384047029926983435371269061279689406644211752791525136670645395254002395395884805259264"},
  {"0x1.5ccfe3d35d80fp+355", 309, "100000000000000013177671857705815673582936776336304977818391361080281530225794240230304400502089534272438272"},
  {"0x1.b403dcc834e11p+358", 309, "999999999999999903628689227595715073763450661512695740419453520217955231010212074612338431527184250183876608"},
  {"0x1.b403dcc834e12p+358", 309, "1000000000000000033998991713002824594943974719712898047713430714837875271723200833292741616380733445921308672"},
  {"0x1.108269fd210cbp+362", 309, "9999999999999999818508707188399807864717650964328171247958398369899072554380053298205803424393137676263358464"},
  {"0x1.108269fd210ccp+362", 309, "10000000000000001904433546954913560203606035895531408164662033483817793205787873437092254382049924808062271488"},
  {"0x1.54a3047c694fdp+365", 309, "99999999999999985669538033284915564613846200056062290979362173015478401635353612148739328497990653971840106496"},
  {"0x1.54a3047c694fep+365", 309, "100000000000000002356936751417025583324953279505688186312991253926828166846616173259830936159244951026231410688"},
  {"0x1.a9cbc59b83a3dp+368", 309, "999999999999999956819772641641815758405104477258378281795396215622882607621111488153942930947432322044748890112"},
  {"0x1.a9cbc59b83a3ep+368", 309, "1000000000000000090318962386698695908093961112855385444464428862913680729311211977042675792237466698479879323648"},
  {"0x1.0a1f5b8132466p+372", 309, "9999999999999999301199346926304397284673331501389768492615896861647229832830913903761963586894254467577228034048"},
  {"0x1.0a1f5b8132467p+372", 309, "10000000000000001437186382847214479679695037670941883095320419218299999779872521725981689367534804490539314970624"},
  {"0x1.4ca732617ed7fp+375", 309, "99999999999999984468045325579403643266646490335689226515340879189861218540142707748740732746380344583923932594176"},
  {"0x1.4ca732617ed80p+375", 309, "100000000000000001555941612946684302426820139692106143336977058043083378116475570326498538991504744767620628086784"},
  {"0x1.9fd0fef9de8dfp+378", 309, "999999999999999878856245830528597750986812202069726098796681149605056504554092802642922939954052246206632716926976"},
  {"0x1.9fd0fef9de8e0p+378", 309, "1000000000000000015559416129466843024268201396921061433369770580430833781164755703264985389915047447676206280867840"},
  {"0x1.03e29f5c2b18bp+382", 309, "9999999999999997968343436511656505870179786851589248980528274911095901385876950622696854699774551253248885785624576"},
  {"0x1.03e29f5c2b18cp+382", 309, "10000000000000000155594161294668430242682013969210614333697705804308337811647557032649853899150474476762062808678400"},
  {"0x1.44db473335deep+385", 309, "99999999999999984057935814682588907446802322751135220511621610897383886710310719046874545396497358979515211902353408"},
  {"0x1.44db473335defp+385", 309, "100000000000000001555941612946684302426820139692106143336977058043083378116475570326498538991504744767620628086784000"},
  {"0x1.961219000356ap+388", 309, "999999999999999910571381339882270654388094495275235896417637897556636832727766595587241428345003132947573783761256448"},
  {"0x1.961219000356bp+388", 309, "1000000000000000050555427725995033814228237030803003279020481474722232763977085405824233377105062219252417113236701184"},
  {"0x1.fb969f40042c5p+391", 309, "9999999999999999665649998943273759183241515094863428494587753284228752052274941196820382078490267674695111155514343424"},
  {"0x1.fb969f40042c6p+391", 309, "10000000000000000785522370032175864461962655379085567555410501901553519502269491678716317668570740365133857791317901312"},
  {"0x1.3d3e2388029bbp+395", 309, "99999999999999994416755247254933381274972870380190006824232035607637985622760311004411949604741731366073618283536318464"},
  {"0x1.3d3e2388029bcp+395", 309, "100000000000000012334713184677367065734511114927744231797396013484834264822673118714746919046029294413093564456393244672"},
  {"0x1.8c8dac6a0342ap+398", 309, "999999999999999980003468347394201181668805192897008518188648311830772414627428725464789434929992439754776075181077037056"},
  {"0x1.8c8dac6a0342bp+398", 309, "1000000000000000123347131846773670657345111149277442317973960134848342648226731187147469190460292944130935644563932446720"},
  {"0x1.efb1178484134p+401", 309, "9999999999999999226660029476424133913982828103448349982745235826237443211877077407917175327178722380043122474279348731904"},
  {"0x1.efb1178484135p+401", 309, "10000000000000000373409337471459889719393275754491820381027730410378005080671497101378613371421126415052399029342192009216"},
  {"0x1.35ceaeb2d28c0p+405", 309, "99999999999999983092605830803955292696544699826135736641192401589249937168415416531480248917847991520357012302290741100544"},
  {"0x1.35ceaeb2d28c1p+405", 309, "100000000000000001440594758724527385583111862242831263013712314935498927069126131626863257625726456080505437183296233537536"},
  {"0x1.83425a5f872f1p+408", 309, "999999999999999977709969731404129670057984297594921577392083322662491290889839886077866558841507631684757522070951350501376"},
  {"0x1.83425a5f872f2p+408", 309, "1000000000000000124493881154768706413150521596928485788372242629432483210095525606840930628504535348165944921118995289997312"},
  {"0x1.e412f0f768fadp+411", 309, "9999999999999999483531874467312143214394768377282087351960514613084929070487027419252537449089020883885200422613425626021888"},
  {"0x1.e412f0f768faep+411", 309, "10000000000000000657803165854228757159135066771950601039801789067244864424132513185357050006393242615734699614997777141989376"},
  {"0x1.2e8bd69aa19ccp+415", 309, "99999999999999992486776161899288204254467086983483846143922597222529419997579302660316349376281765375153005841365553228283904"},
  {"0x1.2e8bd69aa19cdp+415", 309, "100000000000000011275116824089954027370311861298180065149382988489088385655907074917988550293149313084744992919515177483763712"},
  {"0x1.7a2ecc414a03fp+418", 309, "999999999999999924867761618992882042544670869834838461439225972225294199975793026603163493762817653751530058413655532282839040"},
  {"0x1.7a2ecc414a040p+418", 309, "1000000000000000075174486916518208627471429064352408213482909102357765925242415204664541101097758035428265955038852526326677504"},
  {"0x1.d8ba7f519c84fp+421", 309, "9999999999999999549291066784979473595300225087383524118479625982517885450291174622154390152298057300868772377386949310916067328"},
  {"0x1.d8ba7f519c850p+421", 309, "10000000000000000751744869165182086274714290643524082134829091023577659252424152046645411010977580354282659550388525263266775040"},
  {"0x1.27748f9301d31p+425", 309, "99999999999999988278187853568579059876517857536991893086699469578820211690113881674597776370903434688204400735860037395056427008"},
  {"0x1.27748f9301d32p+425", 309, "100000000000000007517448691651820862747142906435240821348290910235776592524241520466454110109775803542826595503885252632667750400"},
  {"0x1.7151b377c247ep+428", 309, "999999999999999998217443564185241415988928868759412500436543339729940401905904649497115766142268560009777175966751665376232210432"},
  {"0x1.7151b377c247fp+428", 309, "1000000000000000152131530268851175838953929259945403926529274864985591448578925759831966436053247510846754734110953387277122797568"},
  {"0x1.cda62055b2d9dp+431", 309, "9999999999999999366518088823188676468029287122850159299994507296276799832366962053631754981778769796749861527090709766158759755776"},
  {"0x1.cda62055b2d9ep+431", 309, "10000000000000000597830782460516151851749290252338090708736359498322008205751130936310560341066601403445681992244323541365884452864"},
  {"0x1.2087d4358fc82p+435", 309, "99999999999999991202555500957231813912852864969525730182461368558677581576901282770959939099212034754106974340599870111173348163584"},
  {"0x1.2087d4358fc83p+435", 309, "100000000000000010903558599154471420052372915041332632722331003791400915551047984893820824847817340461240101783057690514487343316992"},
  {"0x1.68a9c942f3ba3p+438", 309, "999999999999999990829567402361276563686608849982484911984092226517669151665599636201042933986541570369602253175829982724989462249472"},
  {"0x1.68a9c942f3ba4p+438", 309, "1000000000000000148437592187939193412802769250556940132303049308379455823458773253183930019975384016026667272715492545951501423476736"},
  {"0x1.c2d43b93b0a8bp+441", 309, "9999999999999998962647525310145264542169126096378117797927179774005971485896954660113106823932361029753632414520324447890822855131136"},
  {"0x1.c2d43b93b0a8cp+441", 309, "10000000000000000223511723594768599335098409300973759560478836428900264860242343595976203511843100595010152570837624953702918544949248"},
  {"0x1.19c4a53c4e697p+445", 309, "99999999999999992148203649670699315007549827372972461504375111049848301607660324472857261615145089428049364457837845490532419930947584"},
  {"0x1.19c4a53c4e698p+445", 309, "100000000000000012322030822224672671694418358646502729705201617528156995597186547446666808621716922472153686958914653583525950968037376"},
  {"0x1.6035ce8b6203dp+448", 309, "999999999999999961829690841814939863449235336276785151445404123455100404055655690676191710164594560368702289580532071091311261383655424"},
  {"0x1.6035ce8b6203ep+448", 309, "1000000000000000123220308222246726716944183586465027297052016175281569955971865474466668086217169224721536869589146535835259509680373760"},
  {"0x1.b843422e3a84cp+451", 309, "9999999999999999295515673657285824927502456862391367223240817130898064936724137339180964349540796274981353735788091781425216117243117568"},
  {"0x1.b843422e3a84dp+451", 309, "10000000000000000586640612700740119755462042863897304388093713545509821352053815609504775357961393589804030375857007499376802103616864256"},
  {"0x1.132a095ce492fp+455", 309, "99999999999999982626157224225223890651347880611866174913584999992086598044603947229219155428043184231232124237329592070639473281441202176"},
  {"0x1.132a095ce4930p+455", 309, "100000000000000003284156248920492607898701256635961169551231342625874700689878799554400131562772741268394950478432243557864849063421149184"},
  {"0x1.57f48bb41db7bp+458", 309, "999999999999999867577570291642776341008185558166851738411142685188442185736589176942553506549890956386646894855501223680845484378371915776"},
  {"0x1.57f48bb41db7cp+458", 309, "1000000000000000032841562489204926078987012566359611695512313426258747006898787995544001315627727412683949504784322435578648490634211491840"},
  {"0x1.adf1aea12525ap+461", 309, "9999999999999999006303687311552062886039509598054037298313768334025031499690289406628430683654582476461074168412654660604060856295398309888"},
  {"0x1.adf1aea12525bp+461", 309, "10000000000000000328415624892049260789870125663596116955123134262587470068987879955440013156277274126839495047843224355786484906342114918400"},
  {"0x1.0cb70d24b7378p+465", 309, "99999999999999984774589122793531837245072631718372054355900219626000560719712531871037976946055058163097058166404267825310912362767116664832"},
  {"0x1.0cb70d24b7379p+465", 309, "100000000000000005928380124081487003706362488767045328864850074482999577828473980652023296508018124569151792237293382948229697163514582401024"},
  {"0x1.4fe4d06de5056p+468", 309, "999999999999999847745891227935318372450726317183720543559002196260005607197125318710379769460550581630970581664042678253109123627671166648320"},
  {"0x1.4fe4d06de5057p+468", 309, "1000000000000000016976219238238959704141045173573106739630601035115997744067216908958262325956255112879408454231155599236459402033650892537856"},
  {"0x1.a3de04895e46cp+471", 309, "9999999999999999154380224320567749051268538597394750219876417318024024619451619548095327920588323941303457306908878466464492349900630570041344"},
  {"0x1.a3de04895e46dp+471", 309, "10000000000000000508222848402996879704791089448509839788449208028871961714412352270078388372553960191290960287445781834331294577148468377157632"},
  {"0x1.066ac2d5daec3p+475", 309, "99999999999999980713061250546244445284504979165026785650181847493456749434830333705088795590158149413134549224793557721710505681023603243483136"},
  {"0x1.066ac2d5daec4p+475", 309, "100000000000000002374543235865110535740865792782868218747346498867023742954202057256817762821608329412934596913384011607579341316989008157343744"},
  {"0x1.4805738b51a74p+478", 309, "999999999999999850453576476100176633757771418885950722696147777681701481387046784154345890364481854130945587625116484988842728082166842262552576"},
  {"0x1.4805738b51a75p+478", 309, "1000000000000000023745432358651105357408657927828682187473464988670237429542020572568177628216083294129345969133840116075793413169890081573437440"},
  {"0x1.9a06d06e26112p+481", 309, "9999999999999999890870611821409196126784806260401358945180015464725302399110258148854112806457630061296658928320953898584032761523454337112604672"},
  {"0x1.9a06d06e26113p+481", 309, "10000000000000001277205458881816625915991898331943210663398553152633589984350048456164766709270441581283861980390742947279638242225240251599683584"},
  {"0x1.00444244d7cabp+485", 309, "99999999999999993363366729972462242111019694317846182578926003895619873650143420259298512453325054533017777074930382791057905692427399713177731072"},
  {"0x1.00444244d7cacp+485", 309, "100000000000000015544724282938981118738333167462515810070422606902152475013980065176268974898330038852813025908047007570187593383655974344970993664"},
  {"0x1.405552d60dbd6p+488", 309, "999999999999999977996382405657660174364823889467801080772253244969263939229107492426926049423260513969768268415537077468838432306731146395363835904"},
  {"0x1.405552d60dbd7p+488", 309, "1000000000000000155447242829389811187383331674625158100704226069021524750139800651762689748983300388528130259080470075701875933836559743449709936640"},
  {"0x1.906aa78b912cbp+491", 309, "9999999999999999070160382361647997691574207754048582727994641153483596148648302286926205695992445641464234721495638781756234316947997075736253956096"},
  {"0x1.906aa78b912ccp+491", 309, "10000000000000000489767265751505205795722270035307438887450423745901682635933847561612315292472764637931130646815102767620534329186625852171022761984"},
  {"0x1.f485516e7577ep+494", 309, "99999999999999993540817590396194393124038202103003539598857976719672134461054113418634276152885094407576139065595315789290943193957228310232077172736"},
  {"0x1.f485516e7577fp+494", 309, "100000000000000004897672657515052057957222700353074388874504237459016826359338475616123152924727646379311306468151027676205343291866258521710227619840"},
  {"0x1.38d352e5096afp+498", 309, "999999999999999980835596172437374590573120014030318793091164810154100112203678582976298268616221151962702060266176005440567032331208403948233373515776"},
  {"0x1.38d352e5096b0p+498", 309, "1000000000000000162545277246339097227904071986031452381501504981983615182576228378136120296965701983510464738707067395631197433897752887331883780669440"},
  {"0x1.8708279e4bc5ap+501", 309, "9999999999999998718097875280963410081745488308296386400449607070563910699801487058804050516065326530340444532016411713261887913912817139180431292235776"},
  {"0x1.8708279e4bc5bp+501", 309, "10000000000000000171775323872177191180393104084305455107732328445200031262781885420082626742861173182722545959543542834786931126445173006249634549465088"},
  {"0x1.e8ca3185deb71p+504", 309, "99999999999999992995688547174489225212045346187000138833626956204183589249936464033154810067836651912932851030272641618719051989257594860081125951275008"},
  {"0x1.e8ca3185deb72p+504", 309, "100000000000000004625108135904199474001226272395072688491888727201272553753779650923383419882203425131989662450489690590919397689516441796634752009109504"},
  {"0x1.317e5ef3ab327p+508", 309, "999999999999999999733403004123153744855539019118436686285840188024369679522423761672919759564567158443669378824028710020392594094129030220133015859757056"},
  {"0x1.317e5ef3ab328p+508", 309, "1000000000000000185804116423798517725482433838447597480818028523977793111583914751916577516594435529948578361547501493575598125298270581204991032785108992"},
  {"0x1.7dddf6b095ff0p+511", 309, "9999999999999998880909749523179353564794021275209402095665271864523156202855291675267251053466461355407239891899450398872692753716440996292182057045458944"},
  {"0x1.7dddf6b095ff1p+511", 309, "10000000000000000369475456880582265409809179829842688451922778552150543659347219597216513109705408327446511753687232667314337003349573404171046192448274432"},
  {"0x1.dd55745cbb7ecp+514", 309, "99999999999999988809097495231793535647940212752094020956652718645231562028552916752672510534664613554072398918994503988726927537164409962921820570454589440"},
  {"0x1.dd55745cbb7edp+514", 309, "100000000000000000717623154091016830408061481189160311806712772146250661680488340128266606984576189330386573813296762136260081534229469225952733653677113344"},
  {"0x1.2a5568b9f52f4p+518", 309, "999999999999999983359180223191721714560372275017470536367007614460468417501012554531477876945938741751237388344363105067534507348164573733465510370326085632"},
  {"0x1.2a5568b9f52f5p+518", 309, "1000000000000000173895590764939294430722312570010531189967968470476774011931979328540983420144523954172264186653199235428064971301205521941960119701886468096"},
  {"0x1.74eac2e8727b1p+521", 309, "9999999999999999833591802231917217145603722750174705363670076144604684175010125545314778769459387417512373883443631050675345073481645737334655103703260856320"},
  {"0x1.74eac2e8727b2p+521", 309, "10000000000000001357883086565897798874899245110119190592477762992735128930457859737390823115048069116880588269914320093559588785105973323002611978355743916032"},
  {"0x1.d22573a28f19dp+524", 309, "99999999999999995287335453651211007997446182781858083179085387749785952239205787068995699003416510776387310061494932420984963311567802202010637287727642443776"},
  {"0x1.d22573a28f19ep+524", 309, "100000000000000007481665728323055661831810361661413965009546882534829510282787660605604053768125964371333025153260444764058913004562422887354292284947506921472"},
  {"0x1.2357684599702p+528", 309, "999999999999999928484693987168420772305733470059469068129930887927772406304894123616740280504746200573981670431418299523701733729688780649419062882836695482368"},
  {"0x1.2357684599703p+528", 309, "1000000000000000123593978381917935233655560332132363177417314804488469335002204100202473956740097458093113111899666497012884928817602711614917542838354527125504"},
  {"0x1.6c2d4256ffcc2p+531", 309, "9999999999999998504409802292686149877658027252303114244149773213034936348259701329824468100106056975663290938441190205280284556945232082632196709006295628251136"},
  {"0x1.6c2d4256ffcc3p+531", 309, "10000000000000000065284077450682265568456642148886267118448844545520511777838181142510337509988867035816342470187175785193750117648543530356184548650438281396224"},
  {"0x1.c73892ecbfbf3p+534", 309, "99999999999999991287595123558845961539774732109363753938694017460291665200910932548988158640591809997245115511395844372456707812265566617217918448639526895091712"},
  {"0x1.c73892ecbfbf4p+534", 309, "100000000000000003774589324822814887066163651282028976933086588120176268637538771050475113919654290478469527765363729011764432297892058199009821165792668120252416"},
  {"0x1.1c835bd3f7d78p+538", 309, "999999999999999937849939638116397466450525159438967985375725315922685858882365002492855496964043060934899979621894213003182527093908649335762989920701551401238528"},
  {"0x1.1c835bd3f7d79p+538", 309, "1000000000000000137641846858339900274872747866201611553286006446480839513868410418516646781429042748634490575685380367232106118863932514644433433395151811003809792"},
  {"0x1.63a432c8f5cd6p+541", 309, "9999999999999999378499396381163974664505251594389679853757253159226858588823650024928554969640430609348999796218942130031825270939086493357629899207015514012385280"},
  {"0x1.63a432c8f5cd7p+541", 309, "10000000000000000976834654142951997131883033248490828397039502203692087828712013353118885245360428110945724564726831363863214005099277415826993447002617590832955392"},
  {"0x1.bc8d3f7b3340bp+544", 309, "99999999999999987391652932764487656775541389327492204364443535414407668928683046936524228593524316087103098888157864364992697772750101243698844800887746832841572352"},
  {"0x1.bc8d3f7b3340cp+544", 309, "100000000000000000178334994858791836514563642560301392710701527770129502847789953562046870799284296099876897036220978235643807646031628623453753183252563447406133248"},
  {"0x1.15d847ad00087p+548", 309, "999999999999999899489893451833484927233458399740540420336951338855520357125044282616287570346763120896578585177704871391229197474064067196498264773607101557544845312"},
  {"0x1.15d847ad00088p+548", 309, "1000000000000000104076806445342351803057814451465487433877079216547069699830754788624649845638922801100959355546714693321646955446568505272576798891444167390577819648"},
  {"0x1.5b4e5998400a9p+551", 309, "9999999999999999404072760505352583023983296100855298230449769143938302256661863838179600254051950569374547392515068357773127490685649548117139715971745147241514401792"},
  {"0x1.5b4e5998400aap+551", 309, "10000000000000001040768064453423518030578144514654874338770792165470696998307547886246498456389228011009593555467146933216469554465685052725767988914441673905778196480"},
  {"0x1.b221effe500d3p+554", 309, "99999999999999990767336997157383960226643264180953830087855645396318233083327270285662206135844950810475381599246526426844590779296424471954140613832058419086616428544"},
  {"0x1.b221effe500d4p+554", 309, "100000000000000003860899428741951440279402051491350438954423829568577391016492742670197391754543170343555750902863155030391327289536708508823166797373630632400726786048"},
  {"0x1.0f5535fef2084p+558", 309, "999999999999999933860494834742974562371950216430331518611692822307700646699603647625692432595845947170914554599698521475539380813444812793279458505403728617494385000448"},
  {"0x1.0f5535fef2085p+558", 309, "1000000000000000143357493740096054243216090813396677260476783769063847173630251205778255402495017459700200463457564579132287164977289357383183877442068884030520150720512"},
  {"0x1.532a837eae8a5p+561", 309, "9999999999999999338604948347429745623719502164303315186116928223077006466996036476256924325958459471709145545996985214755393808134448127932794585054037286174943850004480"},
  {"0x1.532a837eae8a6p+561", 309, "10000000000000001014580939590254383070472626940034081121037655797126178682441216941477428085151831571943432816859913676009376081445204484652029936547358529479149975764992"},
  {"0x1.a7f5245e5a2cep+564", 309, "99999999999999990034097500988648181343688772091571619991327827082671720239070003832128235741197850516622880918243995225045973534722968565889475147553730375141026248523776"},
  {"0x1.a7f5245e5a2cfp+564", 309, "100000000000000003441905430931245280917713770297417747470693647675065097962631447553892265814744827318497179085147422915077831721209019419643357959500300321574675254607872"},
  {"0x1.08f936baf85c1p+568", 309, "999999999999999953972206729656870211732987713739100709830741553196290713284945813208338477706166412373726001850053663010587168093173889073910282723323583537144858509574144"},
  {"0x1.08f936baf85c2p+568", 309, "1000000000000000168497133608738423804917387685032638749500594682674584756861928912756562958882918041203714772520508506051096899076950702733972407714468702680083242606919680"},
  {"0x1.4b378469b6731p+571", 309, "9999999999999999110672213538405594930961077194803931018967709273006319045695491932986935814708160866077282477159626944024852218964185263418978577250945597085571816901050368"},
  {"0x1.4b378469b6732p+571", 309, "10000000000000000826871628571058023676436276965152235336326534308832671394311356729372731664122173896717192642523265688348930066834399772699475577180106550229078889679814656"},
  {"0x1.9e056584240fdp+574", 309, "99999999999999987674323305318751091818660372407342701554959442658410485759723189737097766448253582599493004440868991951600366493901423615628791772651134064568704023452975104"},
  {"0x1.9e056584240fep+574", 309, "100000000000000001403918625579970521782461970570129136093830042945021304548650108108184133243565686844612285763778101906192989276863139689872767772084421689716760605683089408"},
  {"0x1.02c35f729689ep+578", 309, "999999999999999849284042412665072058259000527747854146471853226010883220019378060628804930891911617504691481762871699606818419373090804007799965727644765395390927070069522432"},
  {"0x1.02c35f729689fp+578", 309, "1000000000000000068957567536844582937679826098352437099093782830596656320642208754566186799616905285426599982929417458880300383900478261195703581718577367397759832385751351296"},
  {"0x1.4374374f3c2c6p+581", 309, "9999999999999999371534524623368764100273307559896873275206250678451924602685103382037576783819090846734548822294900033162112051840457868829614121240178061963384891963422539776"},
  {"0x1.4374374f3c2c7p+581", 309, "10000000000000001128922725616804851135639912124733536896181687515138109407667748933536631733619040190109816831627266107349967768059557526332843049167638877982336134488877170688"},
  {"0x1.945145230b377p+584", 309, "99999999999999986685792442259943292861266657339622078268160759437774506806920451614379548038991111093844416185619536034869697653528180058283225500691937355558043949532406874112"},
  {"0x1.945145230b378p+584", 309, "100000000000000000744898050207431989144199493858315387235964254131263985246781616026371987637390705840846560260278464628372543383280977318309056924111623883709653889736043921408"},
  {"0x1.f965966bce055p+587", 309, "999999999999999894976135638494410321178532246433607400617214583764724024948926844967780359586710300432448450005513217535702667994787395102883917853758746611883659375731342835712"},
  {"0x1.f965966bce056p+587", 309, "1000000000000000007448980502074319891441994938583153872359642541312639852467816160263719876373907058408465602602784646283725433832809773183090569241116238837096538897360439214080"},
  {"0x1.3bdf7e0360c35p+591", 309, "9999999999999998724815666657784284071258397080036981062687289922551408594451489819085924562292709488372450194860589317860981148271829194868425875762872481668410834714055235600384"},
  {"0x1.3bdf7e0360c36p+591", 309, "10000000000000000524381184475062837195473800154429724610566137243318061834753718863820956830887857615988724636416932177829345401680187244151732297960592357271816907060120777654272"},
  {"0x1.8ad75d8438f43p+594", 309, "99999999999999998045549773481514159457876389246726271914145983150114005386328272459269439234497983649422148597943950338419997003168440244384097290815044070304544781216945608327168"},
  {"0x1.8ad75d8438f44p+594", 309, "100000000000000012442073916019742584451599613841868220297176761716247231308746104817149697383259168670352344130394693218166911030435304638650548668396803075131793359985469944758272"},
  {"0x1.ed8d34e547313p+597", 309, "999999999999999894076352879585771044616424544896411028843275160104340698328775730445412843452412726368640312784735046105718485868083216078242264642659886674081956339558310064685056"},
  {"0x1.ed8d34e547314p+597", 309, "1000000000000000009248546019891598444566210341657546615907521388633406505708118389308454908642502206536081877044340989143693798086218131232373875663313958712699944969706504756133888"},
  {"0x1.3478410f4c7ecp+601", 309, "9999999999999999171107915076469365246063817042486381462561244058101538598046442622180212564904306224021286256366562347133135483117101991090685868467907010818055540655879490029748224"},
  {"0x1.3478410f4c7edp+601", 309, "10000000000000001013863005321362603645260389790664550855589183714566591516115925163988885607945737906700351284520257435740740478607260633556791644798372163435943358738250605092929536"},
  {"0x1.819651531f9e7p+604", 309, "99999999999999991711079150764693652460638170424863814625612440581015385980464426221802125649043062240212862563665623471331354831171019910906858684679070108180555406558794900297482240"},
  {"0x1.819651531f9e8p+604", 309, "100000000000000006453119872723839559654210752410289169769835957832735809325020286556271509993374515701645382788895184180192194795092289050635704895322791329123657951217763820802932736"},
  {"0x1.e1fbe5a7e7861p+607", 309, "999999999999999946594872951565228338993526868219488856544571440313594706493755982886960025179093529324993666087115356131035228239552737388526279268078143523691759154905886843985723392"},
  {"0x1.e1fbe5a7e7862p+607", 309, "1000000000000000064531198727238395596542107524102891697698359578327358093250202865562715099933745157016453827888951841801921947950922890506357048953227913291236579512177638208029327360"},
  {"0x1.2d3d6f88f0b3cp+611", 309, "9999999999999998286585471758920610814449462123360860153907833022998313197373091002112049504244419016335335042852788704601485085281825842706955095829283737561469387976341354799421194240"},
  {"0x1.2d3d6f88f0b3dp+611", 309, "10000000000000000173566684169691286935226752617495305612368443231218527385476241124924130700318845059398697631682172475335672600663748292592247410791680053842186513692689376624118857728"},
  {"0x1.788ccb6b2ce0cp+614", 309, "99999999999999997961704416875371517110712945186684165206763211895744845478556111003617144611039598507860251139162957211888350975873638026151889477992007905860430885494197722591793250304"},
  {"0x1.788ccb6b2ce0dp+614", 309, "100000000000000013057554116161536926076931269139759728874448093561506558983381311986113794179635006852367151849798027377761851098929017625234227997691178436106167891224981897189374558208"},
  {"0x1.d6affe45f818fp+617", 309, "999999999999999979617044168753715171107129451866841652067632118957448454785561110036171446110395985078602511391629572118883509758736380261518894779920079058604308854941977225917932503040"},
  {"0x1.d6affe45f8190p+617", 309, "1000000000000000100383841763043038442836876043491446161409111172283542162824162717896144642659159251834657717076710133445871510743179417054177602937513443300570204900788250622698582966272"},
  {"0x1.262dfeebbb0f9p+621", 309, "9999999999999999071569656121801212080692814968920789464627446869617922299624001453201875281811380250249693879805812353226907091680705581859236698853640605134247712274342131878495422251008"},
  {"0x1.262dfeebbb0fap+621", 309, "10000000000000001003838417630430384428368760434914461614091111722835421628241627178961446426591592518346577170767101334458715107431794170541776029375134433005702049007882506226985829662720"},
  {"0x1.6fb97ea6a9d37p+624", 309, "99999999999999986851159038200753776111576258757220550347347138989744224339004763080499610528553377966303172216135545569805454885304878641227288327493418395599568449276340570087973407686656"},
  {"0x1.6fb97ea6a9d38p+624", 309, "100000000000000002309309130269787154892983822485169927543056457815484218967945768886576179686795076111078238543825857419659919011313587350687602971665369018571203143144663564875896666980352"},
  {"0x1.cba7de5054485p+627", 309, "999999999999999899427890566145604518678577715028104257864890027548922232647929642417149243602017175952581854816736079397763477105066203831193512563278085201938953880500051690455580595453952"},
  {"0x1.cba7de5054486p+627", 309, "1000000000000000023093091302697871548929838224851699275430564578154842189679457688865761796867950761110782385438258574196599190113135873506876029716653690185712031431446635648758966669803520"},
  {"0x1.1f48eaf234ad3p+631", 309, "9999999999999998746948504188351511126283256130633852543517551174277382412416240331274267329488304589209417486924315804379963345034522698960570091326029642051843383703107348987949033805840384"},
  {"0x1.1f48eaf234ad4p+631", 309, "10000000000000000725591715973187783610303424287811372824568343983972101724920689074452068181743241951740625976868675721161334753163637413771490365780039321792212624518252692320803210995433472"},
  {"0x1.671b25aec1d88p+634", 309, "99999999999999991426771465453187656230872897620693565997277097362163262749171300799098274999392920617156591849131877877362376266603456419227541462168315779999172318661364176545198692437590016"},
  {"0x1.671b25aec1d89p+634", 309, "100000000000000007255917159731877836103034242878113728245683439839721017249206890744520681817432419517406259768686757211613347531636374137714903657800393217922126245182526923208032109954334720"},
  {"0x1.c0e1ef1a724eap+637", 309, "999999999999999914267714654531876562308728976206935659972770973621632627491713007990982749993929206171565918491318778773623762666034564192275414621683157799991723186613641765451986924375900160"},
  {"0x1.c0e1ef1a724ebp+637", 309, "1000000000000000040900880208761398001286019738266296957960021713442094663491997727554362004538245197373563261847757813447631532786297905940174312186739777303375354598782943738754654264509857792"},
  {"0x1.188d357087712p+641", 309, "9999999999999998636144484328400679867178126713831911407778706776934478130915991201656310481762028096907669811487431649040206546179292274931158555956605099986382706217459209761309199883223171072"},
  {"0x1.188d357087713p+641", 309, "10000000000000000662275133196073022890814778906781692175574718614061870706920546714670378554471083956139627305190456203824330868103505742897540916997511012040520808812168041334151877325366493184"},
  {"0x1.5eb082cca94d7p+644", 309, "99999999999999994465967438754696170766327875910118237148971115117854351613178134068619377108456504406004528089686414709538562749489776621177115003729674648080379472553427423904462708600804999168"},
  {"0x1.5eb082cca94d8p+644", 309, "100000000000000010675012629696074914955421093453716483291339209814873492221214578172731921690128951279860188039310611147811557324883484364908173892056921944513484293311098076487204128137951576064"},
  {"0x1.b65ca37fd3a0dp+647", 309, "999999999999999977077764769429719196041465194188378863774447340572581797347854228894418860247909937807756600796112539971931616645685181699233267813951241073670004367049615544210109925082343145472"},
  {"0x1.b65ca37fd3a0ep+647", 309, "1000000000000000106750126296960749149554210934537164832913392098148734922212145781727319216901289512798601880393106111478115573248834843649081738920569219445134842933110980764872041281379515760640"},
  {"0x1.11f9e62fe4448p+651", 309, "9999999999999999511432924639235132053389160461186216699466583890573511723749959183278387889172340228095875448767138256706948253250552493092635735926276453993770366538373425000777236538229086224384"},
  {"0x1.11f9e62fe4449p+651", 309, "10000000000000001586190709079731611309593092306766792205689700011791961721578624028604793595626413427949399922319035400805891558900947084290211273632164107937207783595355268531368138238983848067072"},
  {"0x1.56785fbbdd55ap+654", 309, "99999999999999995114329246392351320533891604611862166994665838905735117237499591832783878891723402280958754487671382567069482532505524930926357359262764539937703665383734250007772365382290862243840"},
  {"0x1.56785fbbdd55bp+654", 309, "100000000000000011712391521916323154583523059376506771044450767875482717220128910595395124543355987879786950276086559719861028977708681660506961660909865771485203001839588998252499578988328956985344"},
  {"0x1.ac1677aad4ab0p+657", 309, "999999999999999884751043361827625869140390227060043253747518673178360772444478643277393806310703680414274761723053117059528639544242622390941156386039240473187039308013923507098814799398756243472384"},
  {"0x1.ac1677aad4ab1p+657", 309, "1000000000000000017535541566019400541537441865177200086145798104936341572305513193378283771523764365204900328030374534281861011105867876227585990799216050325567033999660761493056632508247061001404416"},
  {"0x1.0b8e0acac4eaep+661", 309, "9999999999999998847510433618276258691403902270600432537475186731783607724444786432773938063107036804142747617230531170595286395442426223909411563860392404731870393080139235070988147993987562434723840"},
  {"0x1.0b8e0acac4eafp+661", 309, "10000000000000000972062404885344653449756728480474941855847657639911300522221339234388177506516007760792756678147673846152604340428430285295728914471221362369950308146488642846313231335560438561636352"},
  {"0x1.4e718d7d7625ap+664", 309, "99999999999999996973312221251036165947450327545502362648241750950346848435554075534196338404706251868027512415973882408182135734368278484639385041047239877871023591066789981811181813306167128854888448"},
  {"0x1.4e718d7d7625bp+664", 309, "100000000000000013969727991387583324014272937224498437195221518215368390817766497947110253951978019521227584903311023812640679294256310975729923845933871538975662911597585244013782480038750137870188544"},
  {"0x1.a20df0dcd3af0p+667", 309, "999999999999999901747459131964173027207212836739039328294498440443382314826691065690307721857975448067474834210390258463987183104130654882031695190925872134291678628544718769301415466131339252487684096"},
  {"0x1.a20df0dcd3af1p+667", 309, "1000000000000000037718785293056550291741793714171007924670336578563554653884390444993619046236149589293075414109087389699655531583234914810756005630018925423128793192791080866922220799992003324610084864"},
  {"0x1.0548b68a044d6p+671", 309, "9999999999999999017474591319641730272072128367390393282944984404433823148266910656903077218579754480674748342103902584639871831041306548820316951909258721342916786285447187693014154661313392524876840960"},
  {"0x1.0548b68a044d7p+671", 309, "10000000000000001193015809897119766504625422406301890824958394614356580573190100725756058408630540740284357620483056684410565406706974707679905918934747573964310619313388981254947040003084017678835253248"},
  {"0x1.469ae42c8560cp+674", 309, "99999999999999998876910787506329447650934459829549922997503484884029261182361866844442696946000689845185920534555642245481492613075738123641525387194542623914743194966239051177873087980216425864602058752"},
  {"0x1.469ae42c8560dp+674", 309, "100000000000000016281240536126153737511360812140841903333610766563411320581747387395266546466406979922062794761588875043647041218401083394518237123398453444885893859189773399673336170714381427096269357056"},
  {"0x1.98419d37a6b8fp+677", 309, "999999999999999988769107875063294476509344598295499229975034848840292611823618668444426969460006898451859205345556422454814926130757381236415253871945426239147431949662390511778730879802164258646020587520"},
  {"0x1.98419d37a6b90p+677", 309, "1000000000000000128003745864021888795392755416785835072663893102275349087018702832851017765623257219066874199161822284840139314973360143403428947761576712806916637263450665299742435541675484268499358973952"},
  {"0x1.fe52048590672p+680", 309, "9999999999999999052283250816881378851792981072012977243617198967792587267065681698004724917620567060828502090557969050236202928251957239362070375381666542984859087613894256390005080826781722527340175556608"},
  {"0x1.fe52048590673p+680", 309, "10000000000000000166160354728550133402860267619935663985128064995273039068626355013257451286926569625748622041088095949318798038992779336698179926498716835527012730124200454693714718121768282606166882648064"},
  {"0x1.3ef342d37a407p+684", 309, "99999999999999986067324092522138770313660664528439025470128525568004065464414123719036343698981660348604541103459182906031648839556284004276265549348464259679976306097717770685212259087870984958094927200256"},
  {"0x1.3ef342d37a408p+684", 309, "100000000000000003889357755108838843130737249295202013334302382007691294289384896763079965607877701387326460311941213291353170611409437561654018367221268940354434586262616943544566455807655946219322240663552"},
  {"0x1.8eb0138858d09p+687", 309, "999999999999999896317308250394787848770759814817916230429632968559415112294082783278450680807608685563489249451555889830959531939269147157518161129230251958148679621306976052570830984318279772103403898929152"},
  {"0x1.8eb0138858d0ap+687", 309, "1000000000000000038893577551088388431307372492952020133343023820076912942893848967630799656078777013873264603119412132913531706114094375616540183672212689403544345862626169435445664558076559462193222406635520"},
  {"0x1.f25c186a6f04cp+690", 309, "9999999999999999818630698308109481982927274216983785721776674794699138106539424938898600659703096825493544616522696356805028364441642842329313746550197144253860793660984920822957311285732475861572950035529728"},
  {"0x1.f25c186a6f04dp+690", 309, "10000000000000000959240852713658286643220175642056616945083801606839120751337554413717392461872443451971747445865546301465605757840244670001489926894056643817026123591538467885955979875798713382291498097180672"},
  {"0x1.37798f428562fp+694", 309, "99999999999999989061425747836704382546929530769255207431309733449871519907009213590435672179676195243109823530484164010765664497227613801915728022751095446033285297165420831725583764136794858449981115862089728"},
  {"0x1.37798f4285630p+694", 309, "100000000000000007311188218325485257111615953570420507004223762444111242223779285187536341014385741266761068799969763125334902791605243044670546908252847439043930576054277584733562461577854658781477884848504832"},
  {"0x1.8557f31326bbbp+697", 309, "999999999999999927113782419344605574598668153294882673458925392487194643703632279098558059466181044478400725843812838336795121561031396504666917998514458446354143529431921823271795036250068185162804696593727488"},
  {"0x1.8557f31326bbcp+697", 309, "1000000000000000073111882183254852571116159535704205070042237624441112422237792851875363410143857412667610687999697631253349027916052430446705469082528474390439305760542775847335624615778546587814778848485048320"},
  {"0x1.e6adefd7f06aap+700", 309, "9999999999999999563134023721266549739021664297767471527755878388779781994104643936539191296017163181162427182749897969201059028320356032930746282153172616351711759756540926280845609521557638656931995269719916544"},
  {"0x1.e6adefd7f06abp+700", 309, "10000000000000000731118821832548525711161595357042050700422376244411124222377928518753634101438574126676106879996976312533490279160524304467054690825284743904393057605427758473356246157785465878147788484850483200"},
  {"0x1.302cb5e6f642ap+704", 309, "99999999999999990959401044767537593501656918740576398586892792465272451027953301036534141738485988029569553038510666318680865279842887243162229186843277653306392406169861934038413548670665077684456779836676898816"},
  {"0x1.302cb5e6f642bp+704", 309, "100000000000000009647157814548049209055895815688969665349556758155373926680325854351965226625228563157788428194463919811999765293285579587743163725597071694149293171752051249118583734850310313223909471278765965312"},
  {"0x1.7c37e360b3d35p+707", 309, "999999999999999984345037526797422397233524775199337052919583787413130412889023223627065756931830180808571031008919677160084252852199641809946030023447952696435527124027376600704816231425231719002378564135125254144"},
  {"0x1.7c37e360b3d36p+707", 309, "1000000000000000133847091685041515321667435950786483187020895512933942218108003650150514436025770781834322032256545705106635452959741180566593506333478305023178733248684891121346177720862393603318000095671837786112"},
  {"0x1.db45dc38e0c82p+710", 309, "9999999999999999544446266951486038123467425400819078260993214423089680518452271383223760211130420606034208307593944715707740128306913340586165347614418822310868858990958736965765439335377993421392542578277827477504"},
  {"0x1.db45dc38e0c83p+710", 309, "10000000000000000740462700217438781518938714805516247333803708227256174960204114795411349643881945414240216317574952939280149729167245650639345158094661640924814507988218853130896331250875288495917514830571527733248"},
  {"0x1.290ba9a38c7d1p+714", 309, "99999999999999990660396936451049407652789096389402106318690169014230827417515340183487244380298106827518051036015414262787762879627804165648934234223216948652905993920546904997130825691790753915825536773603473752064"},
  {"0x1.290ba9a38c7d2p+714", 309, "100000000000000009796659868706293301980329726864556811483658069880894738485544834778488675304322503758814179195711545839946316493393121126499811201907102046476036377876708763639225096339747475108225092810302677843968"},
  {"0x1.734e940c6f9c5p+717", 309, "999999999999999868331443500000006287872809702943711652856965888408980452039094412644869581954932274412588254040761879473560521568747407734787588406864399290882799171293145332687119715621994096773456255662636329336832"},
  {"0x1.734e940c6f9c6p+717", 309, "1000000000000000021421546958041957442493134746744949294176709095342291740583330369404881029347127449862957279318330932090828950478869943421594604148335480073467842242942440201823873880805647866312652703956229962072064"},
  {"0x1.d022390f8b837p+720", 309, "9999999999999999601855055748251769806450047292244542376488118125689672251656359867008764503902493796828096692073033110439215789148209291468717978517470477604338250142827222541691722147321863584969741246387925089779712"},
  {"0x1.d022390f8b838p+720", 309, "10000000000000000826575883412587379043412647642654443507046063781156162560010247521088856083040055200431048894293585531377363220429189576963174104449239123865018594716021581494785755468791093741283312832736674151661568"},
  {"0x1.221563a9b7322p+724", 309, "99999999999999988670225591496504042642724870819986016981533507324097780666440272745607095564199569546663253707407016578763273303796211201720443029584092898479300433989106071698353021544403254911815982945786756526505984"},
  {"0x1.221563a9b7323p+724", 309, "100000000000000008265758834125873790434126476426544435070460637811561625600102475210888560830400552004310488942935855313773632204291895769631741044492391238650185947160215814947857554687910937412833128327366741516615680"},
  {"0x1.6a9abc9424febp+727", 309, "999999999999999965084388885482519417592855130626093842171043595190833186399051537317196816706799625297221478016185520727674168639944850288849622355474122345476546392575499689981548348018063279122228410984187505225498624"},
  {"0x1.6a9abc9424fecp+727", 309, "1000000000000000121848654826517477399924067975478561186882460639090543945868349157039448538836407484958399359900416230607757039843910326832140006474740509066843630497944377635977584613166124739130365574036827385146376192"},
  {"0x1.c5416bb92e3e6p+730", 309, "9999999999999999964372420736895110140590976995965873111133270039707753382929110612616471611327211972294570543930316627036907428807379455975076991793273996897499632136492752791807556010476755711238558435947154812096741376"},
  {"0x1.c5416bb92e3e7p+730", 309, "10000000000000001218486548265174773999240679754785611868824606390905439458683491570394485388364074849583993599004162306077570398439103268321400064747405090668436304979443776359775846131661247391303655740368273851463761920"},
  {"0x1.1b48e353bce6fp+734", 309, "99999999999999984594354677029595135102113336853821866019036664182705300920238534632828550788829765195472628778417018121881118652493108811594893042483166843723756247249515245102456078650553656951604416706418119648563167232"},
  {"0x1.1b48e353bce70p+734", 309, "100000000000000004660180717482069756840508580994937686142098045801868278132308629957276771221419571232103397659598548986531726166600689809136062209749264344058743012736731622189948720589505523832645973577156024278435495936"},
  {"0x1.621b1c28ac20bp+737", 309, "999999999999999886075198851200900594497923856820450300436489405065378963626525536977181948753477264027987825546533242948112401553146250111031268759363863437907536003469585205199546070383440303278127280805657005745376329728"},
  {"0x1.621b1c28ac20cp+737", 309, "1000000000000000046601807174820697568405085809949376861420980458018682781323086299572767712214195712321033976595985489865317261666006898091360622097492643440587430127367316221899487205895055238326459735771560242784354959360"},
  {"0x1.baa1e332d728ep+740", 309, "9999999999999999181805205159248599892793562474462356126333876156560397271658376894962991014456209536865970557564236923315533735757183797070971394269896194384435148282491314085395342974857632902877937717988376531531720556544"},
  {"0x1.baa1e332d728fp+740", 309, "10000000000000000466018071748206975684050858099493768614209804580186827813230862995727677122141957123210339765959854898653172616660068980913606220974926434405874301273673162218994872058950552383264597357715602427843549593600"},
  {"0x1.14a52dffc6799p+744", 309, "99999999999999996954903517948319502092964807244749211214842475260109694882873713352688654575305085714037182409224841134505892881183378706080253249519082903930108094789640533388351546084948006950326015738792668900564521713664"},
  {"0x1.14a52dffc679ap+744", 309, "100000000000000017502309383371653514753081537245251811020857330038132583548033490964923632298277047095547089743554728739908114975629541647562410476799566744273134542648550103525944011430434718636512569974428283241553786306560"},
  {"0x1.59ce797fb817fp+747", 309, "999999999999999928454223448636526995609414612446486912536395043045051171498417578302416590307106934377352009423588636134254484622941461177838218040629861358615028052178586193608330530158506646130887048916655460323666687950848"},
  {"0x1.59ce797fb8180p+747", 309, "1000000000000000092833470372023199096890348452450507710984513881269234280819695799200296412090882625429431268098227736977472261378510764709695475858873732081359239635049862754709070252922400339620379482801740375051580804694016"},
  {"0x1.b04217dfa61dfp+750", 309, "9999999999999999613300728333138614158656013804472910722260188106898877933626732224819925546638620725877678611585164563028980399740553218842096696042786355031638703687528415058284784747112853848287855356936724432692495112994816"},
  {"0x1.b04217dfa61e0p+750", 309, "10000000000000000928334703720231990968903484524505077109845138812692342808196957992002964120908826254294312680982277369774722613785107647096954758588737320813592396350498627547090702529224003396203794828017403750515808046940160"},
  {"0x1.0e294eebc7d2bp+754", 309, "99999999999999988242803431008825880725075313724536108897092176834227990088845967645101024020764974088276981699468968789815350713138205618891818585152157755624664880897462875650012340778461641195382916742883168419985073526276096"},
  {"0x1.0e294eebc7d2cp+754", 309, "100000000000000009283347037202319909689034845245050771098451388126923428081969579920029641209088262542943126809822773697747226137851076470969547585887373208135923963504986275470907025292240033962037948280174037505158080469401600"},
  {"0x1.51b3a2a6b9c76p+757", 309, "999999999999999924509121522475246865178672200286390413373640190927670776874706901000867474584296317792102107215397297714017257980807797893073643852992008461269166974189675556141912776812173197487139230503413422370196749149011968"},
  {"0x1.51b3a2a6b9c77p+757", 309, "1000000000000000092833470372023199096890348452450507710984513881269234280819695799200296412090882625429431268098227736977472261378510764709695475858873732081359239635049862754709070252922400339620379482801740375051580804694016000"},
  {"0x1.a6208b5068394p+760", 309, "9999999999999999918388610622944277578633427011520373324179896670642961784527024602806390495869308408470337715685294734193992593398889846197223766553446979093051960385337504355687757672562640543404353314227442034427503713670135808"},
  {"0x1.a6208b5068395p+760", 309, "10000000000000001264983401419327895432326837028833311705066886193375469816086935788401821995921998869568971002747938248301632620580513580730198422600500768053772541672219001944225017481444457680470275332614057655878576158030168064"},
  {"0x1.07d457124123cp+764", 309, "99999999999999988411127779858373832956786989976700226194703050524569553592790956543300452958271560395914310860351799229078805716535908585708440417158039479244754953558323062848579498254571868337516156995181495372666457581821100032"},
  {"0x1.07d457124123dp+764", 309, "100000000000000009956644432600511718615881550253707240288894882888289682097749535512827356959114607773492443453354095454801046151441888338236034913910900102616284254148427024265175655196680942530570909289367345315883616691581616128"},
  {"0x1.49c96cd6d16cbp+767", 309, "999999999999999884111277798583738329567869899767002261947030505245695535927909565433004529582715603959143108603517992290788057165359085857084404171580394792447549535583230628485794982545718683375161569951814953726664575818211000320"},
  {"0x1.49c96cd6d16ccp+767", 309, "1000000000000000056475411020520841414840626381983058374700565164155456563967578197189219761589459982979768169347536362096565980644606923877305160145603279779419783940304062319818564238082591276919599588305301753272401848696295129088"},
  {"0x1.9c3bc80c85c7ep+770", 309, "9999999999999999185841044429711589466224211962102134844977374370276477415358432917842475759840644797632681207523216662519436418612086534611285553663849717898419964165273969667523488336530932020840491736225123136358120303938278260736"},
  {"0x1.9c3bc80c85c7fp+770", 309, "10000000000000000564754110205208414148406263819830583747005651641554565639675781971892197615894599829797681693475363620965659806446069238773051601456032797794197839403040623198185642380825912769195995883053017532724018486962951290880"},
  {"0x1.01a55d07d39cfp+774", 309, "99999999999999997374062707399103193390970327051935144057886852787877127050853725394623645022622268104986814019040754458979257737456796162759919727807229498567311142603806310797883499542489243201826933949562808949044795771481474727936"},
  {"0x1.01a55d07d39d0p+774", 309, "100000000000000019436671759807052388305883156775590326490339289128326538639931310259419194719485548619626821794275105794118831942800519429348176492482158776899757146408072767288477964251208935175515000298809119290899166699876243210240"},
  {"0x1.420eb449c8842p+777", 309, "999999999999999841364972759543336764420226292177420345984153909836074800974071744757463152045042997962028093539001436578955132142505622028069656690022719315678435403212464369035268207172574280176140941400150227439321732144446136385536"},
  {"0x1.420eb449c8843p+777", 309, "1000000000000000017865845178806930323739528929966661805443773400559670093686692423675827549619949242079148155740876247260071725785255408160775710807422153542338003433646596020960023924842331815965645472194120710174156699571604284243968"},
  {"0x1.9292615c3aa53p+780", 309, "9999999999999999119653217272487741881479473472931169297680017061255129180591200163248089110750054956088761184197513608514017695996055364811520783369824930063422626153861170298051704942404772944919427537177384205332557191153093955289088"},
  {"0x1.9292615c3aa54p+780", 309, "10000000000000000531660196626596490356033894575245100973356972987043891522292165594595004291349304909025721681812512093962950445138053653873169216309020403876699170397334223513449750683762833231235463783529148067211236930570359138156544"},
  {"0x1.f736f9b3494e8p+783", 309, "99999999999999994020546131433094915763903576933939556328154082464128816489313932495174721468699049466761532837205133056038042458244550226238504699576640248260779350025557809411313140906763850021826347864477369777082931390365469918625792"},
  {"0x1.f736f9b3494e9p+783", 309, "100000000000000005316601966265964903560338945752451009733569729870438915222921655945950042913493049090257216818125120939629504451380536538731692163090204038766991703973342235134497506837628332312354637835291480672112369305703591381565440"},
  {"0x1.3a825c100dd11p+787", 309, "999999999999999940205461314330949157639035769339395563281540824641288164893139324951747214686990494667615328372051330560380424582445502262385046995766402482607793500255578094113131409067638500218263478644773697770829313903654699186257920"},
  {"0x1.3a825c100dd12p+787", 309, "1000000000000000120942354671656868962382001670435578817768191183142249744630862900164152357803694488643546272066771136697843816472621283262276046411983423130707191163420128905684081263961470216866716118177799472091300320549064642593292288"},
  {"0x1.8922f31411455p+790", 309, "9999999999999999040580826428657651966904425891201589123842107529410958489455946099092661860636496958724291396331073693328877462044103460624068471125229983529879139676226679317989414380888721568885729507381685429067351125745727105048510464"},
  {"0x1.8922f31411456p+790", 309, "10000000000000000486475973287265010404848153099971055159735310397418651127357734700791903005570128910531738945888832142428584597165509708623196466454966148714674320981543085810557013220039375302073350623645891623631119178909006652304785408"},
  {"0x1.eb6bafd91596bp+793", 309, "99999999999999999081179145438220670296706622164632687453780292502155740721970192601122065475966761298087599260657287627887017431169472094235452683230716826407562484594165232135299736843791138087983021771402091458056119576436948334022754304"},
  {"0x1.eb6bafd91596cp+793", 309, "100000000000000010648340320307079537800256439834788415740925915446217281825184501414715994635435816912547179657119355220684674512140722078228476645868606147885923935036696484075840527556996367953483990701515741014566264001743184712072953856"},
  {"0x1.33234de7ad7e2p+797", 309, "999999999999999828871535006218182557917368774264146678517764203804695831774701602620905646527100834378441867056103929979702975178097221166452191355376717763378564539746214794185426298453038162762816652692429820789419173810082174047524749312"},
  {"0x1.33234de7ad7e3p+797", 309, "1000000000000000013946113804119924437974165856986638331112094170909680489426130543638408513078605724209795153399497011464465488473637220910340574757582946907032347746826714825234078949864321840610832155574248213693581484614981956096327942144"},
  {"0x1.7fec216198ddbp+800", 309, "9999999999999999029013665253788793099400876073531433395554961906466896948352731790279067931477027903109831815934611625736079804963132210640075447162592094208400778225784148066048873590175516339020228538451571779510840981320420868670460264448"},
  {"0x1.7fec216198ddcp+800", 309, "10000000000000000509610295637002728139855252735311366616309601643306774209564163318419090863889067021760658106681756277614179911327452208591182514380241927357631043882428148314438094801465785761804352561506118922744139467759619125060885807104"},
  {"0x1.dfe729b9ff152p+803", 309, "99999999999999993251329913304315801074917514058874200397058898538348724005950180959070725179594357268399970740840405561116998262359962102302968606061220608382468313571129481157267178324335702235770533430624812081575006786082605199485453729792"},
  {"0x1.dfe729b9ff153p+803", 309, "100000000000000005096102956370027281398552527353113666163096016433067742095641633184190908638890670217606581066817562776141799113274522085911825143802419273576310438824281483144380948014657857618043525615061189227441394677596191250608858071040"},
  {"0x1.2bf07a143f6d3p+807", 309, "999999999999999885134206960780312089454635087411784140906440513804611167700736000690226517958758320887173266104495426751070779219941381088594259909647411423049314634698686803624216704482068400828613365568502612232284516294771707790360919932928"},
  {"0x1.2bf07a143f6d4p+807", 309, "1000000000000000074650575649831695774632795300119615593163034400120115457135799236292149453307499328074479031320129942191467592834574340826335964513506590066150788638749118835418037019527222886944981240519484646566146722558989084608335389392896"},
  {"0x1.76ec98994f488p+810", 309, "9999999999999999230374806985905888264902671299533504313577592910677120255877486478106111050285065223246344191476223298391501419428679730361426008304192471516696094355087732099829807674910992980518869405586990190990569575476151831539558138249216"},
  {"0x1.76ec98994f489p+810", 309, "10000000000000000746505756498316957746327953001196155931630344001201154571357992362921494533074993280744790313201299421914675928345743408263359645135065900661507886387491188354180370195272228869449812405194846465661467225589890846083353893928960"},
  {"0x1.d4a7bebfa31aap+813", 309, "99999999999999992303748069859058882649026712995335043135775929106771202558774864781061110502850652232463441914762232983915014194286797303614260083041924715166960943550877320998298076749109929805188694055869901909905695754761518315395581382492160"},
  {"0x1.d4a7bebfa31abp+813", 309, "100000000000000004432795665958347438500428966608636256080197937830963477082618911859584178365170076692451010888562841972100410265623306726829729177688912148325455279810104971033102576911999816916636238052732752107272876955671430431745947427930112"},
  {"0x1.24e8d737c5f0ap+817", 309, "999999999999999874521290314193434603084658115500145579580071256170942927492372459496518833579228824484684143252419893886408557657521935343280724451831297419035632090471862609843762766839539749606096764571247618309588232743975534688554349643169792"},
  {"0x1.24e8d737c5f0bp+817", 309, "1000000000000000068586051851782051496707094173312964986690823395758019319873877212752887919376339615844485246833229637697374894798906086114728229966183096349571541470619505010400634769445777943389257468521053221467463131958534128550160206370177024"},
  {"0x1.6e230d05b76cdp+820", 309, "9999999999999999521471949292288813605336325386252733424243721120057734844449743607990664678980731410286045846847437914107950925140755956518597266575720169912499958425309195700665115678820350271193610461511698595727381924297989722331966923339726848"},
  {"0x1.6e230d05b76cep+820", 309, "10000000000000001073990041592997748754315813848755288681129738236754345983501781634041617365357617741164454675493915864595681622271829162690177310690534561356787233466490334905120091699670255821458896093110143420990381118014458473224813777155784704"},
  {"0x1.c9abd04725480p+823", 309, "99999999999999992109683308321470265755404276937522223728665176967184126166393360027804741417053541441103640811181423240104047857145413152842812577527572916236425034170729678597741204746503691611405533351920096306747820855546959721533975525765152768"},
  {"0x1.c9abd04725481p+823", 309, "100000000000000004529828046727141746947240184637542665783753313900757015278809664236212362908068632088130911440353246844005893434193998802215452930446088047790723234500178792233381012913302936013527818404707654908851814405278709728676750356293615616"},
  {"0x1.1e0b622c774d0p+827", 309, "999999999999999921096833083214702657554042769375222237286651769671841261663933600278047414170535414411036408111814232401040478571454131528428125775275729162364250341707296785977412047465036916114055333519200963067478208555469597215339755257651527680"},
  {"0x1.1e0b622c774d1p+827", 309, "1000000000000000119819148897705446356623417292575549310168061960609007487462594467612569358026776864763472738178563410063470007804231501918390371421971971267233021546978482604147648978133824826548011894363801900701142105351177597329624152546106933248"},
  {"0x1.658e3ab795204p+830", 309, "9999999999999999210968330832147026575540427693752222372866517696718412616639336002780474141705354144110364081118142324010404785714541315284281257752757291623642503417072967859774120474650369161140553335192009630674782085554695972153397552576515276800"},
  {"0x1.658e3ab795205p+830", 309, "10000000000000000800746857348072976168095423879354838955917799224215742423028622941456649692555285746929854721652135745309841019576760278403979222926327228462592673059242454405136015920000672444612205821948817131744093259920359973067672730884158521344"},
  {"0x1.bef1c9657a685p+833", 309, "99999999999999992109683308321470265755404276937522223728665176967184126166393360027804741417053541441103640811181423240104047857145413152842812577527572916236425034170729678597741204746503691611405533351920096306747820855546959721533975525765152768000"},
  {"0x1.bef1c9657a686p+833", 309, "100000000000000004827911520448877862495844246422343156393075429187162764617507655537214145823852994263659565935453370610499537728043164857800396298916132410948026391308085570960636368309306117879178753245974556315302310250472271728848176952226298724352"},
  {"0x1.17571ddf6c813p+837", 309, "999999999999999895660376658959887464073162830405580371957831265231883984761705009259228605356936508765924557863270337660249498829658628118512958332498610172941047627432585001251621720339432063578508893731092043050369229765618973200711352404729235767296"},
  {"0x1.17571ddf6c814p+837", 309, "1000000000000000099152028052998409011920202342162715294588395300751542199979533737409779075865727753926819359851621495586577336764022655397834297874715562088326669341630279279057944337344270883862880412035963403187241060084423965317738575228107571068928"},
  {"0x1.5d2ce55747a18p+840", 309, "9999999999999999363587069377675917736425707327570073564839440723358156278052707548893386994586947577981035182609405692455150664165314335743772262409420005560181719702721238568128862437403998276353831973920663150777435958293799716241167969694049028276224"},
  {"0x1.5d2ce55747a19p+840", 309, "10000000000000000991520280529984090119202023421627152945883953007515421999795337374097790758657277539268193598516214955865773367640226553978342978747155620883266693416302792790579443373442708838628804120359634031872410600844239653177385752281075710689280"},
  {"0x1.b4781ead1989ep+843", 309, "99999999999999993635870693776759177364257073275700735648394407233581562780527075488933869945869475779810351826094056924551506641653143357437722624094200055601817197027212385681288624374039982763538319739206631507774359582937997162411679696940490282762240"},
  {"0x1.b4781ead1989fp+843", 309, "100000000000000006659336382995224556426467602028157370696750505506839688554468114090569100058432115470107619153348531031836488269452441103314288354796084978186496986735864819460893271862349667261738096910718398556534156723341516657901421957636703742066688"},
  {"0x1.10cb132c2ff63p+847", 309, "999999999999999988452569694641453289891412847766833896677368465428848130901034909295879619908945316559292587569958465674654992927728624557883489163749540246356891129106733591931304833693638565628182306078113383272782784390994049606075766012189756664840192"},
  {"0x1.10cb132c2ff64p+847", 309, "1000000000000000196828020722136899354886781307806140057451066037800978143284091526922043301709947551604048864806030051391214698972517388491908540854979699007711767764445172532404979193506593517599378740822301656052939538637450361533911642183329172013711360"},
  {"0x1.54fdd7f73bf3bp+850", 309, "9999999999999998634272990781441856508941917717432502002131499220055701234712009387201814108283439755324388212283155142447191693008553661974684581490114449895439651479036702276471002178058655944454644452316004196046887318431202624493742403095061074555174912"},
  {"0x1.54fdd7f73bf3cp+850", 309, "10000000000000000301276599001405425028904865397746951288321079799032741333776462328211123562691457635682438430171727828179669341366863773446884995019955719986278664561744213800260397056562295560224215930269510378288141352402853119916429412464176397346144256"},
  {"0x1.aa3d4df50af0ap+853", 309, "99999999999999989676737124254345702129345072534953918593694153358511092545248999754036759991650433313959982558608696795936872226802156842691246641960827039136074540955782045812288811537593838676085587479067054324951381252255327235782798049688841391133687808"},
  {"0x1.aa3d4df50af0bp+853", 309, "100000000000000003012765990014054250289048653977469512883210797990327413337764623282111235626914576356824384301717278281796693413668637734468849950199557199862786645617442138002603970565622955602242159302695103782881413524028531199164294124641763973461442560"},
  {"0x1.0a6650b926d66p+857", 309, "999999999999999843423255779504622828654636399579476808778874955057845642282427503428069697375447760968142218613652642015929437520555644859802053186653349748453896990911180089361627479263821919056229587496158345417793683435460456504301996197076723582025859072"},
  {"0x1.0a6650b926d67p+857", 309, "1000000000000000056799717631659959599209893702659726317411141269166906774962677479877261307539674049653972646503389945789686576510419339128243706118473032320081290665497741564406670023712287789874734736674207136744674199783831719918405933396323484899269935104"},
  {"0x1.4cffe4e7708c0p+860", 309, "9999999999999999287738405203667575368767393208115766122317814807014700953545274940077463414411382764424743897695475635254322931165011225671787143593812227771048544607458046793796444970432082673836316471673778619485458899748089618699435710767754281089234894848"},
  {"0x1.4cffe4e7708c1p+860", 309, "10000000000000000994750100020910269533209451632757762191375945319887190014987274751670996295725193073911387320813374065444380043083920779819320367048369688344067694004150538594156785326019809640384357665098168950100503030535059726012267208361728371627187503104"},
  {"0x1.a03fde214caf0p+863", 309, "99999999999999992877384052036675753687673932081157661223178148070147009535452749400774634144113827644247438976954756352543229311650112256717871435938122277710485446074580467937964449704320826738363164716737786194854588997480896186994357107677542810892348948480"},
  {"0x1.a03fde214caf1p+863", 309, "100000000000000006533477610574617307003210399478293629775643192173126922026988747893522897194624310120140586361897943794063686207001388689898137223574581962294638641248120402340847172549022642470747494264132908839774942043776657045497009088429335535195969814528"},
  {"0x1.0427ead4cfed6p+867", 309, "999999999999999928773840520366757536876739320811576612231781480701470095354527494007746341441138276442474389769547563525432293116501122567178714359381222777104854460745804679379644497043208267383631647167377861948545889974808961869943571076775428108923489484800"},
  {"0x1.0427ead4cfed7p+867", 309, "1000000000000000147271337456973822389925322799165752109071222186349148695219103469891718550249305996056764747928638562589759603442121545498062966961564577730451305583522443629825768062558437319101780919925699824267271538715541135605986002768804111697781423341568"},
  {"0x1.4531e58a03e8bp+870", 309, "9999999999999998413748417457239315956573059294699064134960051984423986554086971036541574579178711885967582465059111638997013689862529533948250133185078807957662740116351490992011950708371166466963719380640490770210556304785160923755265983999639546733803159420928"},
  {"0x1.4531e58a03e8cp+870", 309, "10000000000000000161728392950095834780961727121532468109675577629605415353003578843613352249644053642881905330331839631511632172467492917395324154002545647584434349098564602595580939232492998880708913562707066468760361494711018313643605437535869015444666630275072"},
  {"0x1.967e5eec84e2ep+873", 309, "99999999999999987633444125558106197214507928600657449299031571134602723138702925979559301132717802373504470381136572374999373863835222106376649373485721758830170619127941133127257484131955329497127582170538059099205173427703324017329338747068854404759758535917568"},
  {"0x1.967e5eec84e2fp+873", 309, "100000000000000001617283929500958347809617271215324681096755776296054153530035788436133522496440536428819053303318396315116321724674929173953241540025456475844343490985646025955809392324929988807089135627070664687603614947110183136436054375358690154446666302750720"},
  {"0x1.fc1df6a7a61bap+876", 309, "999999999999999932269800471352470574525516656465243420181212531991832952952360709621889896782068959956303035500093019510461530081711049334072862401016156456358397678710230902586782474091451932211122035531511013345645500354660676649720249983847887046345216426508288"},
  {"0x1.fc1df6a7a61bbp+876", 309, "1000000000000000044140518902895287779286391397382581274563006173283444396083023609274483667691850832398819698877547611031397112968428705874685599733334034192471780653571870045215197739635249206690814463183771858052833032509915549602573975010166573043840478561173504"},
  {"0x1.3d92ba28c7d14p+880", 309, "9999999999999998875215130987353436926211667600983082784284950754751883757000955497608523884181562109792963701491111829020872969270239867178277674680890053619130444887655752455354163678739330224192450644706066754627704874925587274685787599733204126473471115726422016"},
  {"0x1.3d92ba28c7d15p+880", 309, "10000000000000000665146625892038512202385663455660488454393649015417666847091561892050024218738072068873230315530385293355842295457722371828081471997976097396944572485441978737408807927440086615867529487142240269942705389409665241931447200154303102433395309881065472"},
  {"0x1.8cf768b2f9c59p+883", 309, "99999999999999988752151309873534369262116676009830827842849507547518837570009554976085238841815621097929637014911118290208729692702398671782776746808900536191304448876557524553541636787393302241924506447060667546277048749255872746857875997332041264734711157264220160"},
  {"0x1.8cf768b2f9c5ap+883", 309, "100000000000000003071603269111014971471508642847250073203719093632845102290734406131617241518267700770571769927225306004888484302202258708981207125345588886413817469658847334809978790776999353375325137186550055668797052865128496484823152800700833072414104710501367808"},
  {"0x1.f03542dfb8370p+886", 309, "999999999999999973438224854160227305877518561122823750593712591987145964024444656694044404476868689015149167622996309190165824584023146941018349739309135463248122613459314107074039291811569329219648848907543004197890512187794469896370420793533163493423472892065087488"},
  {"0x1.f03542dfb8371p+886", 309, "1000000000000000087993840528060072123552654295822177713480669280669756081790243465938300425888485326396286230921509810907603861460022027238605792767602642265028226779717632589125536523728417738286853894823458109178050545114775459800092635220483497954858621317962268672"},
  {"0x1.362149cbd3226p+890", 309, "9999999999999999734382248541602273058775185611228237505937125919871459640244446566940444044768686890151491676229963091901658245840231469410183497393091354632481226134593141070740392918115693292196488489075430041978905121877944698963704207935331634934234728920650874880"},
  {"0x1.362149cbd3227p+890", 309, "10000000000000001567272099323999790141577357366417900912128432938793221524497227514848540387354553088249684689006179119380666835856213554171582585845787463460962892794726236783564348628785267837271769223730071721661465648709640537423259638766536986317197103735005773824"},
  {"0x1.83a99c3ec7eafp+893", 309, "99999999999999990012263082286432662256543169091523721434606031123027548865433341877772055077343404109122144711194766809100548098338386355056238620120129111010885594705399027856108106338478634741663761952135733701058809111452663635798820356028494943810497789949089153024"},
  {"0x1.83a99c3ec7eb0p+893", 309, "100000000000000004675381888545612798918960543133041028684136487274401643939455589461036825818030333693907688813404495028932616818466243033147431327741697981638738927986463793558699752023835231102266007829372867138519293326106230343475263802678137754874196788463928344576"},
  {"0x1.e494034e79e5bp+896", 309, "999999999999999929448868435382686895890266438998271828845121223533023678802377913944250092254807900260792535316367124530669618423639576906744771616444428851364562613616119809966264354755499540137842111275831603885509059543833769773341090453584235060232375896520569913344"},
  {"0x1.e494034e79e5cp+896", 309, "1000000000000000046753818885456127989189605431330410286841364872744016439394555894610368258180303336939076888134044950289326168184662430331474313277416979816387389279864637935586997520238352311022660078293728671385192933261062303434752638026781377548741967884639283445760"},
  {"0x1.2edc82110c2f9p+900", 309, "9999999999999999529098585253973751145501342374646995204443699533752222309208135100774737254399069875964494058799026896824009283758441475916906799486389390443691279468658234350904109878520700943148057046794110173854458342872794765056233999682236635579342942941443126198272"},
  {"0x1.2edc82110c2fap+900", 309, "10000000000000001405977792455148808638290766251961210532383597921128106478682982791432627909206996862817043703881872108962514079934807130712579466061950205884056506128634524360835840526246345277305144519080463253849400322348451303638818760853390915395496414751342542716928"},
  {"0x1.7a93a2954f3b7p+903", 309, "99999999999999991537227438137387396469434575991841521388557198562770454753131655626431591234374844785939841297824578543963083245231683449577722661712772273556182341366629763489177637489755720763166395523368395578554699469776634573397170474480057796161122485794632428945408"},
  {"0x1.7a93a2954f3b8p+903", 309, "100000000000000006552261095746787856411749967010355244012076385661777528108930437151694716472838260680760238458487340241071121614642608687943103994317258797079104154646440083568631482671560875436423095301659220218514235305581886882057848563849292034690350260273827761094656"},
  {"0x1.d9388b3aa30a5p+906", 309, "999999999999999945402341696592674884578976541955442659132610359825718694242914119314842162820675279649039207299571308833846909191138684972507989282336695782607667040225918275050684065261167516978177354790265605065466066369376850351293060923539046438669680406904714953752576"},
  {"0x1.d9388b3aa30a6p+906", 309, "1000000000000000065522610957467878564117499670103552440120763856617775281089304371516947164728382606807602384584873402410711216146426086879431039943172587970791041546464400835686314826715608754364230953016592202185142353055818868820578485638492920346903502602738277610946560"},
  {"0x1.27c35704a5e67p+910", 309, "9999999999999999213782878444176341486712719163258207029349796604673073768736360688744211624391338142173265718425108901184740478000812045911233791501695173449709921389782217629235579129702792695009666351450002856415308090320884466574359759805482716570229159677380024223137792"},
  {"0x1.27c35704a5e68p+910", 309, "10000000000000001135707186618179600359329089213627963525160252553345979158278604723977891654914655376710276554989942398414569389285410476422002602075069448460643913489597938599405671312973852493186523923071228410330128677303956762082926555244744699101970314810717026738241536"},
  {"0x1.71b42cc5cf601p+913", 309, "99999999999999995981677400789769932612359931733321583285118877944076548466448094957909476304960015890806678857380756006307062602577317320133875536163700284518967198097453618232695975663570046546450378657742479671982722077174989256760731188933351130765773907040474247261585408"},
  {"0x1.71b42cc5cf602p+913", 309, "100000000000000011357071866181796003593290892136279635251602525533459791582786047239778916549146553767102765549899423984145693892854104764220026020750694484606439134895979385994056713129738524931865239230712284103301286773039567620829265552447446991019703148107170267382415360"},
  {"0x1.ce2137f743381p+916", 309, "999999999999999929065985077113647184161737396527299728918221484261998998431805045015355882561227083155474615188770224107393363445219598313166454392463014445014728107377484646804238281703363508693674065431485187857190091380020735839470243162305319587149880588271350432374194176"},
  {"0x1.ce2137f743382p+916", 309, "1000000000000000052069140800249855752009185079750964144650090664977064943362508663270311404514719386165843308728919567930102413767433897865855658269158968045714503601765690788895124181432711335776992950015243623307738608946937362752018518070418086469181314516804918593340833792"},
  {"0x1.20d4c2fa8a030p+920", 309, "9999999999999998060628293539774386163142897133036353131863523035469330535011014267604003606077347801451059216486208802846843131230052987604772505157670608443149526129892785047133523819740156816103551808477267524066415738131041089269219682541925527051184466597377822714075545600"},
  {"0x1.20d4c2fa8a031p+920", 309, "10000000000000000028678785109953723248702060064614983783573429926910385653902272159683291957333224649616958313128598304010187936385481780447799767184805866054345934040104083320587698215409722049436653961817402491275192019201707119869992081071729797163687409453914913289541779456"},
  {"0x1.6909f3b92c83dp+923", 309, "99999999999999996350686867959178558315902274782992576532314485486221746301240205812674342870820492799837784938001204037775189753543960218791943147793788145321066524580618236658968633362758090027700335311493754978334367629875739137498376013657689431411868208826074951744485326848"},
  {"0x1.6909f3b92c83ep+923", 309, "100000000000000012095090800520613255000375578235621621745993740617750187252370268949308649680867507585164977711140320047081948194787390561536161244010870206210637787862308622846602028528114611894365152538214834716004577878441067382304555201896123592311891751678371676348215197696"},
  {"0x1.c34c70a777a4cp+926", 309, "999999999999999932018060814468916189790076140924667674895786344599160581110141931853474815088110898427723463833733808359138380652952741502430995285503717331431522719242801594214419543296867856543673718661495390308003255801626734885371401760100025992318635002556156068237393526784"},
  {"0x1.c34c70a777a4dp+926", 309, "1000000000000000057973292274960393763265862568545700036605220385651388108719182436946549269568487016710341006018846736433592448182900184244384740055240373818548092825496324683715486704619720031476992256475264028209364937790149360843820835266007499279518823345374529865067232493568"},
  {"0x1.1a0fc668aac6fp+930", 309, "9999999999999998312538756460757341310094469988278417855282391117573785590229095277790152515038100038016294300856434658995751266289947873088679994697143921417382666342399831226135658142385861165970188884104804799869139102108086341186118549553740473625584843283014570307735223533568"},
  {"0x1.1a0fc668aac70p+930", 309, "10000000000000000327822459828620982485707052830214935642633335774409426031973743359279343786724117930538174975818241508187016346769106956959939911012930425211247788042456200658152732723551495964903285489125103006290926013924448356521309485648260046220787856768108551057012647002112"},
  {"0x1.6093b802d578bp+933", 309, "99999999999999987155954971343300695452169865566657214127525800489409136785780248940879907693753036165206704358487960288340042823857796898629319779603012221761556906824111051125390730586189881257568082051088644411534964844713587442531567367726443881446254459800333664575907082272768"},
  {"0x1.6093b802d578cp+933", 309, "100000000000000003278224598286209824857070528302149356426333357744094260319737433592793437867241179305381749758182415081870163467691069569599399110129304252112477880424562006581527327235514959649032854891251030062909260139244483565213094856482600462207878567681085510570126470021120"},
  {"0x1.b8b8a6038ad6ep+936", 309, "999999999999999903804088967318825213331499981137556425872873119403461614925716858712626137284506647932417134384268512470460669526244514328233356457082706278317411015442012422166180499160548969358610366191211215418098239036197666670678728654776751975985792813764840337747509598224384"},
  {"0x1.b8b8a6038ad6fp+936", 309, "1000000000000000032782245982862098248570705283021493564263333577440942603197374335927934378672411793053817497581824150818701634676910695695993991101293042521124778804245620065815273272355149596490328548912510300629092601392444835652130948564826004622078785676810855105701264700211200"},
  {"0x1.137367c236c65p+940", 309, "9999999999999999553953517735361344274271821018911312812290573026184540102343798495987494338396687059809772796632907678097570555865109868753376103147668407754403581309634554796258176084383892202112976392797308495024959839786965342632596166187964530344229899589832462449290116390191104"},
  {"0x1.137367c236c66p+940", 309, "10000000000000001617604029984053712838099105849054307026537940354784235914690318131432426200603169381752178607793797891669425998275768770637546257455033787639321465930492277094643660455497502236220467316338093858400869637486920046335831684748752572681717785398568698736550198021980160"},
  {"0x1.585041b2c477ep+943", 309, "99999999999999991412234152856228705615063640528827139694410995604646009398744945688985079659553905954212916344007296353831994673829780883765420722861953317774200043854630103365810792101611701952914782080891514223497778802469744018919490624758069218767323224280852151918381000638332928"},
  {"0x1.585041b2c477fp+943", 309, "100000000000000007921438250845767654125681919169971093408389934233443575897517102772544534557205764529752162833294418062406838213115052098838781957320876356853543120821491881752894667070520582225774709469217797130505057184069381648545374773244373557467226310750742042216461653692645376"},
  {"0x1.ae64521f7595ep+946", 309, "999999999999999980159157920520442850193109519852847211800025710561650359982538085224088616186146493844286149397221450372619320895438893697947652166455225334059372746413748147206443420891752540620587530362220273863006901551095990707698442841525909542472844588688081080376132618600579072"},
  {"0x1.ae64521f7595fp+946", 309, "1000000000000000112232790704436754438278055748981998841511857219592030891972715341892564255367361362448600121311518424041218069209721063418534542042126609646694117362148642374303114420643023582803466949468830537119065128603893091744705516029416344252072069280447200202760777843035078656"},
  {"0x1.0cfeb353a97dap+950", 309, "9999999999999998216707985798208689444911740448978652561458278997251937215943253772219178491686886515191093831000650819703008229183002900332433843156495641588976792075318750746904382211902272900011322274342879579557370290877394694632899550160573878909537749585771381335145583492791795712"},
  {"0x1.0cfeb353a97dbp+950", 309, "10000000000000000329886110340869674854270880115045078636847583141738025727786089878914788718586324412860117381629402398400588202211517615861824081167237790591132705927077058380451118207922609574937392980048643791654301923722148311225012721166820834263125344653917287293299907083743789056"},
  {"0x1.503e602893dd1p+953", 309, "99999999999999990619792356152730836086553963154052229916140006550463726206803882148974225824466616742587032512521514511820402183944087865441899383607925011898391576160220738003230766103104075699817505566251852643961429440152961412697448185630726610509727876130297437184073129291725930496"},
  {"0x1.503e602893dd2p+953", 309, "100000000000000007525217352494018719361427080482583638519254439706352434301546571002539107639662119923939220917551527141401041968172205589677021287693862203915638886974287199071604654071266769099226071211897966340736882502910990345434353553680702253338428636675464684849307718019341877248"},
  {"0x1.a44df832b8d45p+956", 309, "999999999999999872387073568844732594315793396883459481955171199192859845878553443782612494614275161063165948315155119859042742270984643205948750027907375734949421139974074457895559885094715370199357924371226299046063388276013556261500671120207314819439877240212639876510262115462027411456"},
  {"0x1.a44df832b8d46p+956", 309, "1000000000000000007630473539575035660514778335511710750780086664439969510636494954611131549135839186513983455555395220895687860544809584999829725260594873271087399626486606146442550988840016917394626449536395208620267012778077787723395914064607119962069483324573977857832138825282954985472"},
  {"0x1.06b0bb1fb384bp+960", 309, "9999999999999998453383935746986719810759964091578092281901881061434379129269651416169086837099623559730024468671070996517137186162196548471725549813698762277218254426715681201861616643456550607603042193381925171312226633756007099691216225313273537909139560233403722802458867734978418966528"},
  {"0x1.06b0bb1fb384cp+960", 309, "10000000000000000617278335278671568869943723109630112583100528505388133765396715589425391709444647966943104584514912613103459078543395617173821153536698722855425910210916188218613474303381375362727338596024627724499484625789034803081540112423670420191213257583185130503608895092113260150784"},
  {"0x1.485ce9e7a065ep+963", 309, "99999999999999988861628156533236896225967158951884963421416105502251300564950642508203478115686284411726404918398393198344015646384363622121446705582987543928597855835557826052119881754415155586279014739104656819496782321626126403692810027353529143655542997033600043426888732064053872033792"},
  {"0x1.485ce9e7a065fp+963", 309, "100000000000000006172783352786715688699437231096301125831005285053881337653967155894253917094446479669431045845149126131034590785433956171738211535366987228554259102109161882186134743033813753627273385960246277244994846257890348030815401124236704201912132575831851305036088950921132601507840"},
  {"0x1.9a742461887f6p+966", 309, "999999999999999957860902350346284132153551878096514283852517773229033154005572478626236537071903625148082612890986863714202457020042006419681526374965874177788623543449994485057258262661745948026767632275613049896960078961318150545418464661067991669581788285529005480705688196068853638234112"},
  {"0x1.9a742461887f7p+966", 309, "1000000000000000096350143920374114471941312455251843583129231209642073450717704585714640048901985187209719740304992727175727058132438746816615645013237871654793913513638826934129377152896934732354722602044746013300944590451431923562399193436133392135634504915915015573579289946925483474026496"},
  {"0x1.008896bcf54f9p+970", 309, "9999999999999997916738124663128877244082391855101191247204616495333847979510139501201523228758057506741180599941798275603729356851659179433605840090394772053822755792233955461707155943795194068332216685526534938121786651731816229250415901309895111103185283290657933692573660950408978352832512"},
  {"0x1.008896bcf54fap+970", 309, "10000000000000000132565989783574162680686561089586460035632031477942492726904253214615979418039362499727374638565892090988122974650007025784551738302746731685907395315255274646861058187558214617579496201832662352585538835573636597522107561710941518560028749376834095178551288964115055725510656"},
  {"0x1.40aabc6c32a38p+973", 309, "99999999999999992462348437353960485060448933957923525202610654848990348279466077292501969423268405025328970231162545648343655275306678872441733790178059478330735395060467469727994972900530063978805843953102113868000379620369084502134308975505229555772913629423636305841602377586326247764393984"},
  {"0x1.40aabc6c32a39p+973", 309, "100000000000000010188971358317522768553282287833805675510029974709859506258618986999817618937518844969218522540155296171418804217693461643249300975876875155387412511244638023209226190850634228372784080083551133183710397091103647448307842258713600815427661358113045597729423401695974866745819136"},
  {"0x1.90d56b873f4c6p+976", 309, "999999999999999924623484373539604850604489339579235252026106548489903482794660772925019694232684050253289702311625456483436552753066788724417337901780594783307353950604674697279949729005300639788058439531021138680003796203690845021343089755052295557729136294236363058416023775863262477643939840"},
  {"0x1.90d56b873f4c7p+976", 309, "1000000000000000066436467741248103118547156170586292454485461107376856746627884050583544890346687569804406120783567460668037744292161050890877875387371120199760770880078039125129799472606133954939884328574613293205683935969567348590731356020719265634967118123751637393518591968740451429495341056"},
  {"0x1.f50ac6690f1f8p+979", 309, "9999999999999999813486777206230041577815560719820581330098483720446847883279500839884297726782854580737362697004022581572770293687044935910015528960168049498887207223940204684198896264456339658487887951484580004902758521100414464490983962613190835886243290260424727924570510530141380583845003264"},
  {"0x1.f50ac6690f1f9p+979", 309, "10000000000000000947990644147898027721356895367877038949773320191542473993945287061152499295694882737146294044779558615049579825999799033241699828844892252830514542659727120106997694213263006179702495063833317241108199639227426493046090092738526596504147144896546922605391056073158892198656212992"},
  {"0x1.3926bc01a973bp+983", 309, "99999999999999998134867772062300415778155607198205813300984837204468478832795008398842977267828545807373626970040225815727702936870449359100155289601680494988872072239402046841988962644563396584878879514845800049027585211004144644909839626131908358862432902604247279245705105301413805838450032640"},
  {"0x1.3926bc01a973cp+983", 309, "100000000000000016286929643128988194074816961567109135215782220741998496603447587939134202370420996309916528534448802351356655453874514916407104087757267748294909439211992693606769729825470060924312593312425595828314643101036337101791537708137280528748894576782202394138833833989693991675429388288"},
  {"0x1.87706b0213d09p+986", 309, "999999999999999872436306494222877488001587945768638201521064070819504681704034606746682422062730755058478860313950798943503314266680100247159860107083281430052496520558476587831205023360193979812186512362979225814553504769848291707808207769286850569305558980974742103098278680884456943362624192512"},
  {"0x1.87706b0213d0ap+986", 309, "1000000000000000017652801462756379714374878780719864776839443139119744823869255243069012222883470359078822072829219411228534934402712624705615450492327979456500795456339201761949451160807447294527656222743617592048849967890105831362861792425329827928397252374398383022243308510390698430058459037696"},
  {"0x1.e94c85c298c4cp+989", 309, "9999999999999999595662034753429788238255624467393741467120915117996487670031669885400803025551745174706847878231119663145222863482996149222332143382301002459214758820269116923021527058285459686414683385913622455551313826420028155008403585629126369847605750170289266545852965785882018353801250996224"},
  {"0x1.e94c85c298c4dp+989", 309, "10000000000000000757393994501697806049241951147003554069667947664398408807353434975979441432117662006869593578353268561425475824571256344889976866464258586670801150306514918315967496157863486204138441068958729385425685531382088472248832262877470188720339297317678393899013204421931950247367929757696"},
  {"0x1.31cfd3999f7afp+993", 309, "99999999999999986662764669548153739894665631237058913850832890808749507601742578129378923002990117089766513181334005445210204946123879926882163649167349350899456456312724758086647517786230384722356772394775369116518164624503799012160606438304513147494189124523779646633247748770420728389479079870464"},
  {"0x1.31cfd3999f7b0p+993", 309, "100000000000000005250476025520442024870446858110815915491585411551180245798890819578637137508044786404370444383288387817694252323536043057564479218478670698284838720092657580373783023379478809005936895323497079994508111903896764088007465274278014249457925878882005684283811566947219638686545940054016"},
  {"0x1.7e43c8800759bp+996", 309, "999999999999999903803069407426113968898218766118103141789833949572356552411722264192305659040010509526872994217248819197070144216063125530186267630296136203765329090687113225440746189048800695790727969805197112921161540803823920273299782054992133678869364753954248541633605124057805104488924519071744"},
  {"0x1.7e43c8800759cp+996", 309, "1000000000000000052504760255204420248704468581108159154915854115511802457988908195786371375080447864043704443832883878176942523235360430575644792184786706982848387200926575803737830233794788090059368953234970799945081119038967640880074652742780142494579258788820056842838115669472196386865459400540160"},
  {"0x1.ddd4baa009302p+999", 309, "9999999999999999335434075769817752248594687291161143444150379827602457335271594505111188022480979804302392841403758309930446200199225865392779725411942503595819407127350057411001629979979981746444561664911518503259454564508526643946547561925497354420113435609274102018745072331406833609642314953654272"},
  {"0x1.ddd4baa009303p+999", 309, "10000000000000000525047602552044202487044685811081591549158541155118024579889081957863713750804478640437044438328838781769425232353604305756447921847867069828483872009265758037378302337947880900593689532349707999450811190389676408800746527427801424945792587888200568428381156694721963868654594005401600"},
  {"0x1.2aa4f4a405be1p+1003", 309, "99999999999999988595886650569271721532146878831929642021471152965962304374245995240101777311515802698485322026337261211948545873374744892473124468375726771027536211745837771604509610367928220847849105179362427047829119141560667380048679757245757262098417746977035154548906385860807815060374033329553408"},
  {"0x1.2aa4f4a405be2p+1003", 309, "100000000000000007629703079084894925347346855150656811701601734206211380288125794484142188964691784076639747577138548761372210387844799938291815611350519830750167649856488981626536368095414607314235151058373458986890825155659063617715863205282622390509284183439858617103083735673849899204570498157510656"},
  {"0x1.754e31cd072d9p+1006", 309, "999999999999999847891233648661470807691068835681842080854450367179124891914700353912936949808806064228544369161770037020638129704807338833093862397807681590830099241237075296001042588224309435545718960035602206600167779387409881325152430676383842364162444596844704620380709158981993982315347403639619584"},
  {"0x1.754e31cd072dap+1006", 309, "1000000000000000000161765076786456438212668646231659438295495017101117499225738747865260243034213915253779773568180337416027445820567779199643391541606026068611150746122284976177256650044200527276807327067690462112661427500197051226489898260678763391449376088547292320814127957486330655468919122263277568"},
  {"0x1.d2a1be4048f90p+1009", 309, "9999999999999999392535525055364621860040287220117324953190771571323204563013233902843309257440507748436856118056162172578717193742636030530235798840866882774987301441682011041067710253162440905843719802548551599076639682550821832659549112269607949805346034918662572406407604380845959862074904348138143744"},
  {"0x1.d2a1be4048f91p+1009", 309, "10000000000000000610699776480364506904213085704515863812719128770699145421501541054461895603243770556638739353307444575741831722668719553462632031991253638597235713480763688482477422747721569639692426738805257643176588867453119191870248852943967318023641486852283274009874954768880653247303478097127407616"},
  {"0x1.23a516e82d9bap+1013", 309, "99999999999999993925355250553646218600402872201173249531907715713232045630132339028433092574405077484368561180561621725787171937426360305302357988408668827749873014416820110410677102531624409058437198025485515990766396825508218326595491122696079498053460349186625724064076043808459598620749043481381437440"},
  {"0x1.23a516e82d9bbp+1013", 309, "100000000000000013415983273353644379307167647951549871284361430903247099365945253454330474107257282415598692944582140176397004400243696672220697718814856920905847607042126949473232502444570468800016509005592812696365583783944976073966686973485829389546187580124556949719553650017014692784406223465209659392"},
  {"0x1.6c8e5ca239028p+1016", 309, "999999999999999861291040414336469543176969619010226008309262296372260241358071732580741399612641955118765084749534143455432389522994257585350220962461935904874831773666973747856549425664459851618054736334425973085267220421335152276470127823801795414563694568114532338018850013250375609552861714878501486592"},
  {"0x1.6c8e5ca239029p+1016", 309, "1000000000000000017216064596736454828831087825013238982328892017892380671244575047987920451875459594568606138861698291060311049225532948520696938805711440650122628514669428460356992624968028329550689224175284346730060716088829214255439694630119794546505512415617982143262670862918816362862119154749127262208"},
  {"0x1.c7b1f3cac7433p+1019", 309, "9999999999999999860310597602564577717002641838126363875249660735883565852672743849064846414228960666786379280392654615393353172850252103336275952370615397010730691664689375178569039851073146339641623266071126720011020169553304018596457812688561947201171488461172921822139066929851282122002676667750021070848"},
  {"0x1.c7b1f3cac7434p+1019", 309, "10000000000000001107710791061764460002235587486150467667406698508044529291764770372322278832331501782385107713289967796232382450470561630819049695116611434972713065592709012878572585445501694163102699168797993709169368134893256514428214347139105940256706031241200520264089633727198808148476736186715027275776"},
  {"0x1.1ccf385ebc89fp+1023", 309, "99999999999999981139503267596847425176765179308926185662298078548582170379439067165044410288854031049481594743364161622187121841818187648603927125262209438639553681654618823985640760188731793867961170022535129351893330180773705244319986644578003569234231285691342840034082734135647456849389933411990123839488"},
  {"0x1.1ccf385ebc8a0p+1023", 309, "100000000000000001097906362944045541740492309677311846336810682903157585404911491537163328978494688899061249669721172515611590283743140088328307009198146046031271664502933027185697489699588559043338384466165001178426897626212945177628091195786707458122783970171784415105291802893207873272974885715430223118336"},
  {"0x1.fffffffffffffp+1023", 309, "179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368"},
] of _
