#!/usr/bin/env perl

use strict;

# Open both files since I couldn't get dynamic arrays to work.
open(KEYS,"<$ARGV[0]/def-keys") || die("can not open def-keys file");
open(KEYS_O, ">def-keys.h") || die("Can not open def-keys.h\n");
# Print the def-keys.h file header
print KEYS_O "/*\n";
print KEYS_O " * This file is automatically generated editing by hand is strongly\n";
print KEYS_O " * discouraged.  Look at the def-keys file and the mdk.pl conversion\n";
print KEYS_O " * script.\n";
print KEYS_O " */\n";
# Start the array for the keybindings
print KEYS_O "static const char *const def_keys[] = {\n";
while(<KEYS>) {
	next if (/^#/ || /^\s*$/);
	# If the next keybinding matches, then put it in def-keys.h
	if (/^\w+ \d+ [NRFAE]+ \w+.*$/) {
		chomp;
		print KEYS_O "\"$_\\n\", \n";
	}
	else{
		print "Found junk entry in $ARGV[0]/def-keys: $_";
	}
}
# Close the array
print KEYS_O "}; \n";
# Close the files
close(KEYS_O);
close(KEYS);
