.\"
.\" $Id: cpuid.man,v 20151017 2015/10/17 14:04:27 todd $
.\"
.TH CPUID 1 "17 Oct 2015" "20151017"
.SH NAME 
cpuid \- Dump CPUID information for each CPU
.SH SYNOPSIS
.B cpuid
\fI[options...]\fP
.SH DESCRIPTION
.I cpuid
dumps detailed information about the CPU(s) gathered from the CPUID
instruction, and also determines the exact model of CPU(s) from that
information.

It dumps all information available from the CPUID instruction.  The exact
collection of information available varies between manufacturers and
processors.  The following information is available consistently on all
modern CPUs:

.nf
	vendor_id
	version information (1/eax)
	miscellaneous (1/ebx)
	feature information (1/ecx)
.fi

It also produces synthetic fields based on information from multiple CPUID
functions.  Currently, the synthetic fields are the exact model of each CPU
(but see LIMITATIONS below) as (synth); the multiprocessing characteristics
including the number of cores per chip (c) and the number of hyperthreads per
core (t) as (multi-processing synth); and a decoding of the APIC physical ID
as (APIC synth).

The determination of the model is based on the following information:

.nf
	version information (1/eax), processor type
	version information (1/eax), family
	version information (1/eax), model
	version information (1/eax), stepping id
	version information (1/eax), extended family
	version information (1/eax), extended model
	feature information (1/ecx), virtual machine extensions
	brand id (1/ebx)
	brand (0x80000004)
	cache and TLB information (2)
	deterministic cache parameters (4/eax), extra processor cores
	AMD extended brand id (0x80000001/ebx)
	AMD extended processor signature (0x80000001/eax)
	Transmeta processor revision ID (0x80860001/ebx & ecx)
.fi

The determination of the multiprocessing characteristics and decoding of APIC
physical ID is based on the following information:

.nf
	feature information (1/edx), hyper-threading / multi-core supported
	miscellaneous (1/ebx), cpu count
	deterministic cache parameters (4/eax), extra processor cores on this die
	x2APIC features / processor topology (0xb)
	AMD feature flags (0x80000001/ecx)
	AMD Logical CPU cores (0x80000008/ecx), number of logical CPU cores - 1
.fi

In addition, a simpler and coarser determination of the CPU is performed
using only the information listed above under version information (1/eax).
It is provided as (simple synth) under version information (1/eax).  However,
it tends to be unable to distinguish between various modern CPUs.
.SH OPTIONS
.PP
.I cpuid
accepts the following command line arguments:
.TP 8
.I -1, --one-cpu
Display information only for the first CPU.  This cuts down on the output on
a multiprocessor system, and is useful when certain that all CPUs are
identical.
.TP 8
.I -f \fIFILE\fR, --file=\fIFILE\fR
Read raw hex information from FILE instead of from executions of the cpuid 
instruction.
.TP 8
.I -h, -H, --help
Display help information.
.TP 8
.I -i, --inst
Use the CPUID instruction.  The information it provides is reliable.  It is not
necessary to be root to use this option.  (This option is the default.)
.TP 8
.I -k, --kernel
Use the CPUID kernel module.  
The information does not seem to be reliable on all combinations of CPU type
and kernel version.  Typically, it is necessary to be root to use this option.
.TP 8
.I -r, --raw
Display only raw hex information with no decoding.
.TP 8
.I -v, --version
Display cpuid version.
.SH LIMITATIONS
There are numerous cases where there is no way to distinguish between various
CPUs in the (synth) information.  In some cases, the sizes of caches, number
of cores, brand strings, etc., can be used to distinguish multiple CPUs with
the same family and model.  But there are cases where that information is
insufficient.  Whenever
.I cpuid
is unable to distinguish between multiple CPUs, it will list all known
possibilities.

If you believe that a certain processor should be distinguishable from
another and it isn't, please inform the author of this tool.

The (multi-processing synth) information is unreliable on many processors.
It faithfully reports the information provided by the CPUID instruction and
decodes it as recommended by the processor manufacturers, but often that
information is incorrect.  The information seems to indicate the
architecture's capabilities, rather than what the particular chip actually
does.  In particular, it seems commonplace to claim the presence of multiple
hyperthreads when there is only one.
.SH INFORMATION SOURCES
Information on the CPUID instruction and on specific CPUs is available from
the following documents from Intel Corporation
<http://www.intel.com/support/processors/index.htm>, with the specified
Document Numbers:

.RS
.br
241618: Intel Processor Identification and the CPUID Instruction, Application
Note 485
.br
242480: Pentium Processor Specification Update
.br
242689: Pentium Pro Processor Specification Update
.br
243326: 60- and 66-MHz Pentium Processor Specification Update
.br
243337: Intel Pentium II Processor Specification Update
.br
243748: Intel Celeron Processor Specification Update
.br
243776: Intel Pentium II Xeon Processor Specification Update
.br
243887: Mobile Intel Pentium II Processor Specification Update
.br
244444: Mobile Intel Celeron Processor at 466 MHz, 433 MHz, 400 MHz, 366 MHz,
333 MHz, 300 MHz, and 266 MHz Specification Update
.br
244453: Intel Pentium III Processor Specification Update
.br
244460: Intel Pentium III Xeon Processor Specification Update
.br
245306: Mobile Intel Pentium III Processor and Mobile Intel Pentium III 
Processor-M Specification Update
.br
245421: Mobile Intel Celeron Processor (0.18u and 0.13u) Specification Update
.br
249199: Intel Pentium 4 Processor Specification Update
.br
249678: Intel Xeon Processor Specification Update
.br
250721: Mobile Intel Pentium 4 Processor-M Specification Update
.br
251309: Mobile Intel Celeron Processor on .13 Micron Process in Micro-FCPGA
Package Specification Update
.br
252665: Intel Pentium M Processor Specification Update
.br
253176: Mobile Intel Pentium 4 Processor with 533 MHz System Bus
Specification Update
.br
253666: 64 and IA-32 Architectures Software Developer's Manual Volume 2A:
Instruction Set Reference, A-M.
.br
276613: Detecting Multi-Core Processor Topology in an IA-32 Platform
by Khang Nguyen and Shihjong Kuo
.br
290741: Intel Xeon Processor MP Specification Update
.br
290749: Intel Celeron Processor in the 478-Pin Package Specification Update
.br
300303: Intel Celeron M Processor Specification Update
.br
302209: Intel Pentium M Processor on 90nm Process with 2-MB L2 Cache
Specification Update
.br
302352: Intel Pentium 4 Processor on 90 nm Process Specification Update
.br
302354: Intel Celeron D Processor 3xx Sequence Specification Update
.br
302402: Intel Xeon Processor with 800 MHz System Bus
.br
302441: Mobile Intel Pentium 4 Processor supporting Hyper-Threading
Technology on 90-nm process technology Specification Update
.br
306752: 64-bit Intel Xeon Processor MP with 1 MB L2 Cache Specification Update
.br
306757: 64-bit Intel Xeon Processor MP with up to 8 MB L3 Cache Specification
Update
.br
306832: Intel Pentium Processor Extreme Edition and Intel Pentium D Processor
Specification Update
.br
309159: Dual-Core Intel Xeon Processor 2.80 GHz Specification Update
.br
309222: Intel Core Duo Processor and Intel Core Solo Processor on 65 nm Process
Specification Update
.br
309627: Dual-Core Intel Xeon Processor 7000 Sequence Specification Update
.br
311827: Intel Celeron D Processor 300 Sequence Specification Update
.br
313065: Dual-Core Intel Xeon Processor 5000 Series Specification Update
.br
313279: Intel Core 2 Extreme Processor X6800 and Intel Core 2 Duo Desktop 
Processor E6000 Sequence Specification Update
.br
313356: Dual-Core Intel Xeon Processor 5100 Series Specification Update
.br
314554: Dual-Core Intel Xeon Processor 7100 Series Specification Update
.br
314916: Dual-Core Intel Xeon Processor 3000 Series Specification Update
.br
313515: Intel Pentium Dual-Core Processor Specification Update
.br
316134: Quad-Core Intel Xeon Processor 3200 Series Specification Update
.br
316964: Intel Celeron Processor 400 Series Specification Update
.br
316982: Intel Pentium Dual-Core Desktop Processor E2000 Series Specification
Update
.br
317667: Intel Celeron Processor 500 Series Specification Update
.br
318081: Intel Xeon Processor 7200 and 7300 Series Specification Update
.br
318547: Intel Celeron Processor 200 Sequence Specification Update
.br
318585: Intel Xeon Processor 5400 Series Specification Update
.br
318586: Intel Xeon Processor 5200 Series Specification Update
.br
318727: Intel Core 2 Extreme Processor QX9000 Series and Intel Core 2 Quad
Processor Q9000, Q9000S, Q8000, Q8000S Series Specification Update
.br
318733: Intel Core 2 Duo Processor E8000 and E7000 Series Specification Update
.br
318915: Intel Core 2 Duo Processor and Intel Core 2 Extreme Processor on 45-nm 
Process Specification Update
.br
318925: Intel Celeron Dual-Core Processor E1000 Series Specification Update
.br
319006: Dual-Core Intel Xeon Processor 3100 Series Specification Update
.br
319007: Quad-Core Intel Xeon Processor 3300 Series Specification Update
.br
319129: Intel Core 2 Extreme Processor QX9775 Specification Update
.br
319433: Intel Architecture Instruction Set Extensions Programming Reference
.br
319536: Intel Atom Processor Z5xx Series Specification Update
.br
319735: Intel Celeron Dual-Core Processor T1x00 Series Specification Update
.br
319978: Intel Atom Processor 200 Series Specification Update
.br
320047: Intel Atom Processor N270 Series Specification Update
.br
320121: Intel Core 2 Extreme Quad-Core Mobile Processor, 
Intel Core 2 Quad Mobile Processor, 
Intel Core 2 Extreme Mobile Processor, 
Intel Core 2 Duo Mobile Processor, 
Intel Core 2 Solo Mobile Processor and
Intel Celeron Processor on 45-nm Process Specification Update
.br
320257: Intel EP80579 Integrated Processor Product Line Specification Update
.br
320336: Intel Xeon Processor 7400 Series Specification Update
.br
320468: Intel Pentium Dual-Core E6000 and E5000 Series Specification Update
.br
320529: Intel Atom Processor 300 Series Specification Update
.br
320767: Intel Core i7-900 Mobile Processor Extreme Edition Series,
Intel Core i7-800 and i7-700 Mobile Processor Series Specification Update
.br
320836: Intel Core i7-900 Desktop Processor Extreme Edition Series and 
Intel Core i7-900 Desktop Processor Series Specification Update
.br
321324: Intel Xeon Processor 5500 Series Specification Update
.br
321333: Intel Xeon Processor 3500 Series Specification Update
.br
322166: Intel Core i7-800 and i5-700 Desktop Processor Series 
Specification Update
.br
322373: Intel Xeon Processor 3400 Series Specification Update
.br
322568: Intel Celeron Processor E3x00 Series Specification Update
.br
322849: Intel Atom Processor N400 Series Specification Update
.br
322861: Intel Atom Processor D400 Series (Single Core) Specification Update
.br
322862: Intel Atom Processor D500 Series (Dual Core) Specification Update
.br
322814: Intel Core i7-600, i5-500, i5-400 and i3-300 Mobile Processor Series
Specification Update
.br
322911: Intel Core i5-600, i3-500 Desktop Processor Series and
Intel Pentium Processor G6950 Specification Update
.br
323056: Intel Xeon Processor L3406 Specification Update
.br
323179: Intel Core i7-660UE, i7-620LE/UE, i7-610E, i5-520E, i3-330E and
Intel Celeron Processor P4505, U3405 Series
Datasheet Addendum Specification Update
.br
323105: Intel Xeon Processor C5500/C3500 Series Specification Update
.br
323254: Intel Core i7-900 Desktop Processor Extreme Edition Series and 
Intel Core i7-900 Desktop Processor Series on 32-nm Process Specification Update
.br
323338: Intel Xeon Processor 3600 Series Specification Update
.br
323344: Intel Xeon Processor 7500 Series Specification Update
.br
323372: Intel Xeon Processor 5600 Series Specification Update
.br
323874: Intel Pentium P6000 and U5000 Mobile Processor Series 
Specification Update
.br
324209: Intel Atom Processor E6xx Series Specification Update
.br
324341: Intel Atom Processor N500 Series Specification Update
.br
Intel 64 Architecture Processor Topology Enumeration (Whitepaper)
.br
324456: Intel Celeron Mobile Processor P4000 and U3000 Series 
Specification Update
.br
324643: 2nd Generation Intel Core Processor Family Desktop Specification Update
.br
324827: 2nd Generation Intel Core Processor Family Mobile Specification Update
.br
325122: Intel Xeon Processor E7-8800 / 4800 / 2800 Product Families
Specification Update
.br
325307: Intel Atom Processor Z600 Series Specification Update
.br
325462: Intel 64 and IA-32 Architectures Software Developer's Manual Combined
Volumes: 1, 2A, 2B, 2C, 3A, 3B, and 3C
.br
325630: Intel Atom Processor Z6xx Series Specification Update
.br
326140: Intel Atom Processor N2000 and D2000 Series Specification Update
.br
326198: Intel Core i7 Processor Family for the LGA-2011 Socket
Specification Update
.br
326510: Intel Xeon Processor E5 Family Specification Update
.br
326766: Desktop 3rd Generation Intel Core Processor Family Specification Update
.br
326770: Mobile 3rd Generation Intel Core Processor Family Specification Update
.br
326774: Intel Xeon Processor E3-1200 v2 Product Family Specification Update
.br
328205: Intel Xeon Phi Coprocessor x100 Product Family Specification Update
.br
328899: Desktop 4th Generation Intel Core Processor Family Specification Update
.br
328903: Mobile 4th Generation Intel Core Processor Family Specification Update
.br
328908: Intel Xeon Processor E3-1200 v3 Product Family Specification Update
.br
329460: Intel Atom Processor C2000 Product Family Specification Update
.br
330785: Intel Xeon Processor E5 v3 Product Family Specification Update
.br
330836: Intel Core M Processor Family Specification Update
.br
330841: Intel Core i7 Processor Family for LGA2011-v3 Socket Specification Update
.br
332054: Intel Xeon Processor D-1500 Product Family Specification Update
.br
332067: Intel Atom Z8000 Processor Series Specification Update
.br
332095: Intel N-Series Intel Pentium Processors and Intel Celeron Processors
Specification Update
.br
332317: Intel Xeon Processor E7 v3 Product Family Specification Update
.br
332381: Mobile/Desktop 5th Generation Intel Core Processor Family
Specification Update
.RE

Information on the CPUID instruction and on specific CPUs is available from
the following documents from Advanced Micro Devices, Inc.
<http://www.amd.com/us-en/Processors/TechnicalResources>, with the specified
Publication Numbers:

.RS
.br
20734: AMD Processor Recognition Application Note
.br
21266: AMD-K6 Processor Revision Guide Model 6
.br
21641: AMD-K6-2 Processor Revision Guide Model 8
.br
21846: AMD-K6 Processor Revision Guide Model 7
.br
22473: AMD-K6-III Processor Revision Guide Model 9
.br
23614: AMD Athlon Processor Model 4 Revision Guide
.br
23865: AMD Duron Processor Model 3 Revision Guide
.br
24332: AMD Athlon Processor Model 6 Revision Guide
.br
24806: AMD Duron Processor Model 7 Revision Guide
.br
25481: CPUID Specification
.br
25703: AMD Athlon Processor Model 8 Revision Guide
.br
25759: Revision Guide for AMD Athlon 64 and AMD Opteron Processors
.br
26094: BIOS and Kernel Developer's Guide for AMD Athlon 64 and AMD Opteron
Processors
.br
27532: AMD Athlon Processor Model 10 Revision Guide
.br
31177H: AMD Geode NX Processors Data Book
.br
31610: Revision Guide for AMD NPT Family 0Fh Processors
.br
33234F: AMD Geode LX Processors Data Book
.br
41322: Revision Guide for AMD Family 10h Processors
.br
41788: Revision Guide for AMD Family 11h Processors
.br
44739: Revision Guide for AMD Family 12h Processors
.br
47534: Revision Guide for AMD Family 14h Models 00h-0Fh Processors
.br
48063: Revision Guide for AMD Family 15h Models 00h-0Fh Processors
.br
48931: Revision Guide for AMD Family 15h Models 10h-1Fh Processors
.br
51810: Revision Guide for AMD Family 16h Models 00h-0Fh Processors
.RE

Information on the CPUID instruction and on specific CPUs is available
from the following documents from Transmeta Corporation
<http://www.transmeta.com/crusoe_docs/Crusoe_CPUID_5-7-02.pdf>:

.RS
.br
Processor Recognition, 2002/05/07
.RE

Information on generic hypervisor CPUID levels is available from this proposal:
<http://lwn.net/Articles/301888/>.

Information on KVM hypervisor CPUID levels is available from the Linux kernel
under Documentation/kvm/cpuid.txt.

Information on Microsoft hypervisor CPUID levels is available from the
following document from Microsoft:
<http://msdn.microsoft.com/en-us/library/windows/hardware/ff542428%28v=vs.85%29.aspx>.

Also, information is available from the following web sites:

.RS
<http://www.sandpile.org/ia32/cpuid.htm>
.br
<http://en.wikipedia.org/wiki/List_of_Intel_microprocessors>
.br
<http://en.wikipedia.org/wiki/List_of_AMD_microprocessors>
.br
<http://en.wikipedia.org/wiki/Category:X86_microprocessors>
.RE
.SH AUTHOR
Todd Allen <cpuid@etallen.com>
