# Base Io build system
# Written by Jeremy Tregunna <jeremy.tregunna@me.com>
#
# Find libsndfile.

FIND_PATH(LIBSNDFILE_INCLUDE_DIR sndfile.h)

SET(LIBSNDFILE_NAMES ${LIBSNDFILE_NAMES} sndfile libsndfile)
FIND_LIBRARY(LIBSNDFILE_LIBRARY NAMES ${LIBSNDFILE_NAMES} PATH)

IF(LIBSNDFILE_INCLUDE_DIR AND LIBSNDFILE_LIBRARY)
	SET(LIBSNDFILE_FOUND TRUE)
ENDIF(LIBSNDFILE_INCLUDE_DIR AND LIBSNDFILE_LIBRARY)

IF(LIBSNDFILE_FOUND)
	IF(NOT LibSndFile_FIND_QUIETLY)
		MESSAGE(STATUS "Found LibSndFile: ${LIBSNDFILE_LIBRARY}")
	ENDIF (NOT LibSndFile_FIND_QUIETLY)
ELSE(LIBSNDFILE_FOUND)
	IF(LibSndFile_FIND_REQUIRED)
		MESSAGE(FATAL_ERROR "Could not find sndfile")
	ENDIF(LibSndFile_FIND_REQUIRED)
ENDIF (LIBSNDFILE_FOUND)
