/****************************************************************************
 *    lib/c/ActionDefinition.cpp - This file is part of coala				*
 *																			*
 *    Copyright (C) 2009  Torsten Grote										*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/

#include "ActionDefinition.h"

using namespace C;

ActionDefinition::ActionDefinition(int line, Formula* action_list, Types* types) : Statement(line, types) { 
	A_ = action_list;
}

ActionDefinition::~ActionDefinition () {
	delete A_;
}

void ActionDefinition::print(Printer* p) {
	for(vector<Formula*>::iterator n = A_->begin(); n != A_->end(); ++n) {
		FluentAction* a = (FluentAction*) *n;

		string action = a->print(p, p->T+"-1");
		set<Variable*>* vars = a->getVariables();

		if(p->no_direct_enc) {
			p->setSection('b');

			p->add("action(" + action + ")");
			if(!vars->empty()) {
				p->add(" :- ");
				types_.print(p, vars, line_);
			}
			p->add(".\n");
		}
		else {
			p->setSection('c');
			
			if(p->lang != "m") {
				// action_a(T-1) :- not -action_a(T-1)
				p->add(action + " :- not " + p->neg+action);
				if(!vars->empty()) {
					p->add(", ");
					types_.print(p, vars, line_);
				}
				p->add(".\n");
				
				// -action(T-1) :- not action_a(T-1).
				p->add(p->neg+action + " :- not " + action);
				if(!vars->empty()) {
					p->add(", ");
					types_.print(p, vars, line_);
				}
				p->add(".\n");
			}
			
			p->setSection('b');
			
			p->add("#show action_" + a->getName() + "(" + createTempArgs(vars->size()) + ").\n");
			
			// :- f1_action(T-1), neg_f1_action(T-1).
			if(p->fake_neg) {
				p->setSection('c');
				
				p->add(":- " + action + ", " + p->neg + action);
				if(!vars->empty()) {
					p->add(", ");
					types_.print(p, vars, line_);
				}
				p->add(".\n");
				if(p->debug > 1) {
					p->setSection('b');
					p->add("#show " + p->neg + "action_" + a->getName() + "(" + createTempArgs(vars->size()) + ").\n");
				}
			}
			
			p->setSection('c');
			
			// completeness condition
			p->add(":- not " + action + ", not " + p->neg + action);
			if(!vars->empty()) {
				p->add(", ");
				types_.print(p, vars, line_);
			}
			p->add(".\n");

		} // end direct encoding
		delete vars;
	}
}
