/*
//
//  Copyright 1997-2009 Torsten Rohlfing
//
//  Copyright 2004-2012 SRI International
//
//  This file is part of the Computational Morphometry Toolkit.
//
//  http://www.nitrc.org/projects/cmtk/
//
//  The Computational Morphometry Toolkit is free software: you can
//  redistribute it and/or modify it under the terms of the GNU General Public
//  License as published by the Free Software Foundation, either version 3 of
//  the License, or (at your option) any later version.
//
//  The Computational Morphometry Toolkit is distributed in the hope that it
//  will be useful, but WITHOUT ANY WARRANTY; without even the implied
//  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along
//  with the Computational Morphometry Toolkit.  If not, see
//  <http://www.gnu.org/licenses/>.
//
//  $Revision: 4344 $
//
//  $LastChangedDate: 2012-05-11 14:51:08 -0700 (Fri, 11 May 2012) $
//
//  $LastChangedBy: torstenrohlfing $
//
*/

#ifndef __cmtkClassStreamMultiChannelRegistration_h_included_
#define __cmtkClassStreamMultiChannelRegistration_h_included_

#include <IO/cmtkClassStreamInput.h>
#include <IO/cmtkClassStreamOutput.h>

#include <Registration/cmtkAffineMultiChannelRegistrationFunctional.h>
#include <Registration/cmtkSplineWarpMultiChannelRegistrationFunctional.h>

namespace 
cmtk
{

/** \addtogroup IO */
//@{

/** Write file names and transformations from affine multi-channel registration functional. */
template<class TMetricFunctionalType>
ClassStreamOutput& operator << ( ClassStreamOutput& stream, const AffineMultiChannelRegistrationFunctional<TMetricFunctionalType>& functional );

/** Read file names and transformations from archive to multi-channel affine registration functional. */
template<class TMetricFunctionalType>
ClassStreamInput& operator >> ( ClassStreamInput& stream, AffineMultiChannelRegistrationFunctional<TMetricFunctionalType>& functional );

/** Write file names and transformations from spline warp multi-channel registration functional. */
template<class TMetricFunctionalType>
ClassStreamOutput& operator << ( ClassStreamOutput& stream, const SplineWarpMultiChannelRegistrationFunctional<TMetricFunctionalType>& functional );

//@}

} // namespace cmtk

#include "cmtkClassStreamMultiChannelRegistration.txx"

#endif // #ifndef __cmtkClassStreamMultiChannelRegistration_h_included_
