use Test::More tests => 4;

BEGIN {
    use_ok('CipUX');
}

use Date::Manip;

my $epoch        = UnixDate( '2010-02-26T10:49:22', '%s' );
my $c            = CipUX->new;
my $cipux_epoch0 = $c->date_epoch;
ok( $cipux_epoch0 eq q{}, 'date_epoch deliver empty string' );

my $cipux_epoch1 = $c->date_epoch({today => 1});
ok( $cipux_epoch1 > 0, 'date_epoch deliver > 0' );

# 1267174162
#diag($cipux_epoch2);
my $cipux_epoch2 = $c->date_epoch( { today => '2010-02-26T10:49:22' } );
ok( $epoch == $cipux_epoch2, 'date_epoch delivers exact epoch' );
