package charactermanaj.graphics.io;

import java.awt.image.BufferedImage;

/**
 * ロードされたイメージ情報
 * @author seraphy
 */
public final class LoadedImage {

	private final BufferedImage image;
	
	private final long lastModified;
	
	public LoadedImage(BufferedImage image, long lastModified) {
		this.image = image;
		this.lastModified = lastModified;
	}
	
	public BufferedImage getImage() {
		return image;
	}
	
	public long getLastModified() {
		return lastModified;
	}
	
}
