# G.7 Lysander Spooner: right-"libertarian" or libertarian socialist?

Murray Rothbard and others on the "libertarian" right have argued that
Lysander Spooner is another individualist anarchist whose ideas support
"anarcho"-capitalism's claim to be part of the anarchist tradition. It is fair
to say that Spooner's critique of the state, rooted in _"natural rights"_
doctrine, was quoted favourably by Rothbard on many occasions, making Spooner
the 19th century anarchist most likely to be referenced by him. This is
understandable as Spooner was undoubtedly the closest to liberalism of the
individualist anarchists, making him more amenable to appropriation than the
others (particularly those, like Tucker, who called themselves socialists).

As will be shown below, however, any claim that Spooner provides retroactive
support for "anarcho"-capitalist claims of being a form of anarchism is
untrue. This is because, regardless of his closeness to liberalism, Spooner's
vision of a free society was fundamentally anti-capitalist. It is clear that
Spooner was a left-libertarian who was firmly opposed to capitalism. The
ignoring (at best) or outright dismissal (at worst) of Spooner's economic
ideas and vision of a free society by right-"libertarians" should be more than
enough to show that Spooner cannot be easily appropriated by the right
regardless of his (from an anarchist position) unique, even idiosyncratic,
perspective on property rights.

That Spooner was against capitalism can be seen in his opposition to wage
labour, which he wished to eliminate by turning capital over to those who work
it. Like other anarchists, he wanted to create a society of associated
producers -- self-employed farmers, artisans and co-operating workers --
rather than wage-slaves and capitalists. For example, Spooner writes:

> _"every man, woman, and child. . . could . . . go into business for himself,
> or herself -- either singly, or in partnerships -- and be under no necessity
> to act as a servant, or sell his or her labour to others. All the great
> establishments, of every kind, now in the hands of a few proprietors, but
> employing a great number of wage labourers, would be broken up; for few, or
> no persons, who could hire capital, and do business for themselves, would
> consent to labour for wages for another."_ [ **A Letter to Grover
> Cleveland** , p. 41]

Wage-labour, Spooner argued, meant that workers did not labour for their own
benefit _"but only for the benefit of their employers."_ The workers are
_"mere tools and machines in the hands of their employers."_ [ **Op. Cit.** ,
p. 50] Thus he considered that _"it was necessary that every man be his own
employer or work for himself in a direct way, since working for another
resulted in a portion being diverted to the employer. To be one's own
employer, it was necessary for one to have access to one's own capital."_
[James J. Martin, **Men Against the State** , p. 172] This was because wage
labour resulted in exploitation:

> _"When a man knows that he is to have **all** the fruits of his labour, he
> labours with more zeal, skill, and physical energy, than when he knows -- as
> in the case of one labouring for wages -- that a portion of the fruits of
> his labour are going to another. . . In order that each man may have the
> fruits of his own labour, it is important, as a general rule, that each man
> should be his own employer, or work directly for himself, and not for
> another for wages; because, in the latter case, a part of the fruits of his
> labour go to his employer, instead of coming to himself . . . That each man
> may be his own employer, it is necessary that he have materials, or capital,
> upon which to bestow his labour."_ [ **Poverty: Its Illegal Causes and Legal
> Cure** , p. 8]

This preference for a system based on simple commodity production in which
capitalists and wage slaves are replaced by self-employed and co-operating
workers puts Spooner squarely in the **anti-capitalist** camp with other
anarchists. And, we may add, the egalitarianism he expected to result from his
system indicates the left-libertarian nature of his ideas, turning the present
_"wheel of fortune"_ into _"an extended surface, varied somewhat by
inequalities, but still exhibiting a general level, affording a safe position
for all, and creating no necessity, for either force or fraud, on the part of
anyone, to enable him to secure his standing."_ [quoted by Peter Marshall,
**Demanding the Impossible** , pp. 388-9] Thus:

> _"That the principle of allowing each man to have, (so far as it is
> consistent with the principles of natural law that he can have,) all the
> fruits of his own labour, would conduce to a more just and equal
> distribution of wealth than now exists, is a proposition too self-evident
> almost to need illustration. It is an obvious principle of natural justice,
> that each man should have the fruits of his own labour . . . It is also an
> obvious fact, that the property produced by society, is now distributed in
> very unequal proportions among those whose labour produced it, and with very
> little regard to the actual value of each one’s labour in producing it."_ [
> **Poverty: Its Illegal Causes and Legal Cure** , p. 7]

For Spooner, as with other left-libertarians, equality was seen as the
necessary basis for liberty. As he put it, the _"practice of each man's
labouring for himself, instead of labouring for another for wages"_ would _"be
greatly promoted by a greater equality of wealth."_ Not only that, it _"would
also contribute to the increase of labour-saving inventions -- because when a
man is labouring for himself, and is to have all the proceeds of his labour,
he applies his mind, with his hands, much more than when he is labouring for
another."_ [ **Op. Cit.** , p. 42] As he stressed equality will have many
positive outcomes beyond the abolition of wage labour and increased
productiveness:

> _"Extremes of difference, in their pecuniary circumstances, divide society
> into castes; set up barriers to personal acquaintance; prevent or suppress
> sympathy; give to different individuals a widely different experience, and
> thus become the fertile source of alienation, contempt, envy, hatred, and
> wrong. But give to each man all the fruits of his own labour, and a
> comparative equality with others in his pecuniary condition, and caste is
> broken down; education is given more equally to all; and the object is
> promoted of placing each on a social level with all: of introducing each to
> the acquaintance of all; and of giving to each the greatest amount of that
> experience, wealth, being common to all, enables him to sympathise with all,
> and insures to himself the sympathy of all. And thus the social virtues of
> mankind would be greatly increased."_ [ **Op. Cit.** , pp. 46-7]

Independence in producing would lead to independence in all aspects of life,
for it was a case of the _"higher self-respect also, which a man feels, and
the higher social position he enjoys, when he is master of his own industry,
than when he labours for another."_ [ **Op. Cit.** , p. 35] It is quite
apparent, then, that Spooner was against wage labour and, therefore, was no
supporter of capitalism. Perhaps unsurprisingly, Spooner (like William Greene)
had been a member of the **First International**. [George Woodcock,
**Anarchism** , p. 393]

Whether Spooner's ideas are relevant now, given the vast amount of capital
needed to start companies in established sectors of the economy, is another
question. Equally, it seems unlikely that a reversion to pre-industrial forms
of economy is feasible even if we assume that Spooner's claims about the
virtues of a free market in credit are correct. But one thing is clear:
Spooner was opposed to the way America was developing in the 19th century. He
had no illusions about tariffs, for example, seeing them as a means of
accumulating capital as they _"enable[d] the home producers . . . to make
fortunes by robbing everybody else in the prices of their goods."_ Such
protectionism _"originated with the employers"_ as the workers _"could have
had no hope of carrying through such a scheme, if they alone were to profit;
because they could have had no such influence with governments."_ [ **A Letter
to Grover Cleveland** p. 20 and p. 44] He had no illusions that the state was
anything else than a machine run by and for the wealthy.

Spooner viewed the rise of capitalism with disgust and suggested a way for
non-exploitative and non-oppressive economic relationships to become the norm
again in US society, a way based on eliminating a root feature of capitalism
-- wage-labour -- through a system of easy credit, which he believed would
enable artisans and farmers to obtain their own means of production and work
for themselves. As we stressed in [section G.1.2](secG1.md#secg12)
capitalism is based not on property as such but rather property which is not
owned by those who use it (i.e., Proudhon's distinction between property and
possession which was echoed by, among others, Marx). Like more obvious
socialists like Proudhon and Marx, Spooner was well aware that wage labour
resulted in exploitation and, as a result, urged its abolition to secure the
worker the full produce of their labour.

As such, Spooner's analysis of capitalism was close to that of social
anarchists and Marxists. This is confirmed by an analysis of his famous works
**Natural Law** (unless otherwise indicated, all subsequent quotes are from
this work).

Spooner's support of "Natural Law" has also been taken as "evidence" that
Spooner was a proto-right-"libertarian." Most obviously, this ignores the fact
that support for "Natural Law" is not limited to right-"libertarians" and has
been used to justify, among other things, feudalism, slavery, theocracy,
liberty, fascism as well as communism. As such, "natural rights" justification
for property need not imply a support for capitalism or suggest that those who
hold similar views on them will subscribe to the same vision of a good
society. Of course, most anarchists do not find theories of "natural law," be
they those of right-"libertarians", fascists or whatever, to be particularly
compelling. Certainly the ideas of "Natural Law" and "Natural Rights," as
existing independently of human beings in the sense of the ideal Platonic
Forms, are difficult for most anarchists to accept **per se** , because such
ideas are inherently authoritarian as they suggest a duty to perform certain
actions for no other reason than obedience to some higher authority regardless
of their impact on individuals and personal goals. Most anarchists would agree
with Tucker when he called such concepts _"religious"_ (Robert Anton Wilson's
**Natural Law: or don't put a rubber on your willy** is an excellent
discussion of the flaws of such concepts).

Spooner, unfortunately, did subscribe to the cult of _"immutable and
universal"_ Natural Laws. If we look at his "defence" of Natural Law we can
see how weak (and indeed silly) it is. Replacing the word _"rights"_ with the
word _"clothes"_ in the following passage shows the inherent weakness of his
argument:

> _"if there be no such principle as justice, or natural law, then every human
> being came into the world utterly destitute of rights; and coming so into
> the world destitute of rights, he must forever remain so. For if no one
> brings any rights with him into the world, clearly no one can ever have any
> rights of his own, or give any to another. And the consequence would be that
> mankind could never have any rights; and for them to talk of any such things
> as their rights, would be to talk of things that had, never will, and never
> can have any existence."_

And, we add, unlike the "Natural Laws" of _"gravitation, . . . of light, the
principles of mathematics"_ to which Spooner compares them, he is perfectly
aware that his "Natural Law" can be _"trampled upon"_ by other humans.
However, unlike gravity (which does not need enforcing) it is obvious that
Spooner's "Natural Law" has to be enforced by human beings as it is within
human nature to steal. In other words, it is a moral code, **not** a "Natural
Law" like gravity. Appeals to make this specific moral code to be considered
the universal one required by nature are unconvincing, particularly as such
absolutist schemes generally end up treating the rights in question (usually
property related ones) as more important than actual people. Hence we find,
for example, supporters of "natural rights" to property (like Murray Rothbard)
willing to deny economic power, the restrictions of liberty it creates and its
similarity to the state in the social relations it creates simply because
property is sacred (see [section F.1](secF1.md)).

Interestingly, Spooner did come close to a **rational,** non-metaphysical
source for rights when he pointed out that _"Men living in contact with each
other, and having intercourse together, cannot avoid learning natural law."_
This indicates the **social** nature of rights, of our sense of right and
wrong, and so rights and ethics can exist without believing in religious
concepts as "Natural Law." In addition, we can say that his support for juries
indicates an unconscious recognition of the **social** nature (and so
evolution) of any concepts of human rights. In other words, by arguing
strongly for juries to judge human conflict, he implicitly recognises that the
concepts of right and wrong in society are **not** indelibly inscribed in law
tomes as the "true law," but instead change and develop as society does (as
reflected in the decisions of the juries). In addition, he states that
_"[h]onesty, justice, natural law, is usually a very plain and simple
matter,"_ which is _"made up of a few simple elementary principles, of the
truth and justice of which every ordinary mind has an almost intuitive
perception,"_ thus indicating that what is right and wrong exists in "ordinary
people" and not in "prosperous judges" or any other small group claiming to
speak on behalf of "truth."

As can be seen, Spooner's account of how "natural law" will be administered is
radically different from, say, Murray Rothbard's and indicates a strong
egalitarian context foreign to right-libertarianism. As we noted in [section
G.3](secG3.md), Rothbard explicitly rejected Spooner's ideas on the
importance of jury driven law (for Spooner, _"the jurors were to judge the
law, and the justice of the law."_ [ **Trial by Jury** , p. 134]). As far as
"anarcho"-capitalism goes, one wonders how Spooner would regard the
"anarcho"-capitalist "protection firm," given his comment that _"[a]ny number
of scoundrels, having money enough to start with, can establish themselves as
a 'government'; because, with money, they can hire soldiers, and with soldiers
extort more money; and also compel general obedience to their will."_ [ **No
Treason** , p. 22] This is the use of private police to break strikes and
unions in a nutshell. Compare this to Spooner's description of his voluntary
justice associations:

> _"it is evidently desirable that men should associate, so far as they freely
> and voluntarily can do so, for the maintenance of justice among themselves,
> and for mutual protection against other wrong-doers. It is also in the
> highest degree desirable that they should agree upon some plan or system of
> judicial proceedings"_

At first glance, one may be tempted to interpret Spooner's justice
organisations as a subscription to "anarcho"-capitalist style protection
firms. A more careful reading suggests that Spooner's actual conception is
more based on the concept of mutual aid, whereby people provide such services
for themselves and for others rather than buying them on a fee-per-service
basis. A very different concept. As he put it elsewhere, _"[a]ll legitimate
government is a mutual insurance company"_ in which _"insured persons are
shareholders of a company."_ It is likely that this would be a co-operative as
the _"free administration of justice . . . must necessarily be a part of every
system of government which is not designed to be an engine in the hands of the
rich for the oppression of the poor."_ It seems unlikely that Spooner would
have supported unequal voting rights based on wealth particularly as _"all
questions as to the **rights** of the corporation itself, must be determined
by members of the corporation itself . . . by the unanimous verdict of a
tribunal fairly representing the whole people"_ such as a jury [ **Trial by
Jury** , p. 223, p. 172 and p. 214]

These comments are particularly important when we consider Spooner's
criticisms of finance capitalists, like the Rothschilds. Here he departs even
more strikingly from right-"libertarian" positions. For he believes that sheer
wealth has intrinsic power, even to the extent of allowing the wealthy to
coerce the government into behaving at their behest. For Spooner, governments
are _"the merest hangers on, the servile, obsequious, fawning dependants and
tools of these blood-money loan-mongers, on whom they rely for the means to
carry on their crimes."_ Thus the wealthy can _"make [governments] and use
them"_ as well as being able to _"unmake them . . . the moment they refuse to
commit any crime we require of them, or to pay over to us such share of the
proceeds of their robberies as we see fit to demand."_ Indeed, Spooner
considers _"these soulless blood-money loan-mongers"_ as _"the real rulers,"_
not the government (who are simply their agents). Thus governments are
_"little or nothing else than mere tools, employed by the wealthy to rob,
enslave, and (if need be) murder those who have less wealth, or none at all."_
[ **No Treason** , p. 50, p. 51, p. 52 and p. 47] This is an extremely class
conscious analysis of the state, one which mirrors the standard socialist one
closely.

If one grants that highly concentrated wealth has intrinsic power and may be
used in such a Machiavellian manner as Spooner claims, then simple opposition
to the state is not sufficient. Logically, any political theory claiming to
promote liberty should also seek to limit or abolish the institutions that
facilitate large concentrations of wealth. As shown above, Spooner regarded
wage labour under capitalism as one of these institutions, because without it
_"large fortunes could rarely be made at all by one individual."_ Hence for
Spooner, as for social anarchists, to be anti-statist also necessitates being
anti-capitalist.

This can be clearly seen for his analysis of history, when he asks: _"Why is
it that [Natural Law] has not, ages ago, been established throughout the world
as the one only law that any man, or all men, could rightfully be compelled to
obey?"_ Spooner's answer is given in his interpretation of how the State
evolved, where he postulates that it was formed through the initial ascendancy
of a land-holding, slave-holding class by military conquest and oppressive
enslavement of the peasantry:

> _"These tyrants, living solely on plunder, and on the labour of their
> slaves, and applying all their energies to the seizure of still more
> plunder, and the enslavement of still other defenceless persons; increasing,
> too, their numbers, perfecting their organisations, and multiplying their
> weapons of war, they extend their conquests until, in order to hold what
> they have already got, it becomes necessary for them to act systematically,
> and co-operate with each other in holding their slaves in subjection._

> _"But all this they can do only by establishing what they call a government,
> and making what they call laws . . . Thus substantially all the legislation
> of the world has had its origin in the desires of one class of persons to
> plunder and enslave others, **and hold them as property.** "_

Nothing too provocative here, simply Spooner's view of government as a tool of
the wealth-holding, slave-owning class. What is more interesting is Spooner's
view of the subsequent development of (post-slavery) socio-economic systems:

> _"In process of time, the robber, or slaveholding, class -- who had seized
> all the lands, and held all the means of creating wealth -- began to
> discover that the easiest mode of managing their slaves, and making them
> profitable, was **not** for each slaveholder to hold his specified number of
> slaves, as he had done before, and as he would hold so many cattle, but to
> give them so much liberty as would throw upon themselves (the slaves) the
> responsibility of their own subsistence, and yet compel them to sell their
> labour to the land-holding class -- their former owners -- for just what the
> latter might choose to give them."_

Here Spooner echoes the standard anarchist critique of capitalism. Note that
he is no longer talking about slavery but rather about economic relations
between a wealth-holding class and a 'freed' class of workers and tenant
farmers. Clearly he does **not** view this relation --wage labour -- as a
voluntary association, because the former slaves have little option but to be
employed by members of the wealth-owning class. As he put it elsewhere, their
wealth ensures that they have _"control of those great armies of servants --
the wage labourers -- from whom all their wealth is derived, and whom they can
now coerce by the alternative of starvation, to labour for them."_ [ **A
Letter to Grover Cleveland** , p. 48] Thus we have the standard socialist
analysis that economic power, wealth itself, is a source of coercion.

Spooner points out that by monopolising the means of wealth creation while at
the same time requiring the newly 'liberated' slaves to provide for
themselves, the robber class thus continues to receive the benefits of the
labour of the former slaves while accepting none of the responsibility for
their welfare. _"Of course,"_ Spooner continued _"these liberated slaves, as
some have erroneously called them, having no lands, or other property, and no
means of obtaining an independent subsistence, had no alternative -- to save
themselves from starvation -- but to sell their labour to the landholders, in
exchange only for the coarsest necessaries of life; not always for so much
even as that."_ Thus while technically "free," the apparently liberated
working class lack the ability to provide for their own needs and hence remain
dependent on the wealth-owning class. This echoes not right-"libertarian"
analysis of capitalism, but left-libertarian and other socialist viewpoints:

> _"These liberated slaves, as they were called, were now scarcely less slaves
> than they were before. Their means of subsistence were perhaps even more
> precarious than when each had his own owner, who had an interest to preserve
> his life."_

This is an interesting comment. Spooner suggests that the liberated slave
class were perhaps **better off as slaves.** Most anarchists would not go so
far, although we would agree that employees are subject to the power of those
who employ them and so are no long self-governing individuals -- in other
words, that capitalist social relationships deny self-ownership and freedom.
Spooner denounced the power of the economically dominant class, noting that
the workers _"were liable, at the caprice or interest of the landholders, to
be thrown out of home, employment, and the opportunity of even earning a
subsistence by their labour."_ Lest the reader doubt that Spooner is actually
discussing employment here (and not slavery), he explicitly includes being
made unemployed as an example of the arbitrary nature of wage labour and
indicates that this is a source of class conflict and danger for the ruling
class: _"They were, therefore, in large numbers, driven to the necessity of
begging, stealing, or starving; and became, of course, dangerous to the
property and quiet of their late masters."_ And so the _"consequence was, that
these late owners found it necessary, for their own safety and the safety of
their property, to organise themselves more perfectly as a government **and
make laws for keeping these dangerous people in subjection.** "_

In other words, the robber class creates legislation which will protect its
power, namely its property, against the dispossessed. Hence we see the
creation of "law code" by the wealthy which serves to protect their interests
while effectively making attempts to change the status quo illegal. This
process is in effect similar to the right-"libertarian" concept of a judge
interpreted and developed "general libertarian law code" which exercises a
monopoly over a given area and which exists to defend the "rights" of property
against "initiation of force," i.e. attempts to change the system into a new
one. Spooner goes on:

> _"The purpose and effect of these laws have been to maintain, in the hands
> of robber, or slave holding class, a monopoly of all lands, and, as far as
> possible, of all other means of creating wealth; and thus to keep the great
> body of labourers in such a state of poverty and dependence, as would compel
> them to sell their labour to their tyrants for the lowest prices at which
> life could be sustained."_

Thus Spooner identified the underlying basis for legislation (as well as the
source of much misery, exploitation and oppression throughout history) as the
result of the monopolisation of the means of wealth creation by an elite
class. We doubt he would have considered that calling these laws "libertarian"
would in any change their oppressive and class-based nature. The state was an
instrument of the wealthy few, not some neutral machine which furthered its
own interests, and so _"the whole business of legislation, which has now grown
to such gigantic proportions, had its origin in the conspiracies, which have
always existed among the few, for the purpose of holding the many in
subjection, and extorting from them their labour, and all the profits of their
labour."_ Characterising employment as extortion may seem rather extreme, but
it makes sense given the exploitative nature of profit under capitalism, as
left libertarians have long recognised (see [section C.2](secC2.md)).

Perhaps unsurprisingly, given Spooner's rhetorical denunciation of the state
as being a gang of murderers and thieves employed by the wealthy few to
oppress and exploit the many, he was not shy in similarly extreme rhetoric in
advocating revolution. In this (as in many other things) Spooner was a very
atypical individualist anarchist and his language could be, at times, as
extreme as Johann Most. Thus we find Spooner in 1880 _"advocat[ing] that the
Irish rise up and kill their British landlords since be believed that when a
person's life, liberty, and property -- his natural rights -- are denied, that
person has a natural right to kill those who would deny these rights. Spooner
called for a class war."_ [Wm. Gary Kline, **The Individualist Anarchists** ,
p. 41] Elsewhere he thundered:

> _" **Who** compose the real governing power in the country? . . . How shall
> we find these men? How shall we know them from others? . . . Who, of our
> neighbours, are members of this secret band of robbers and murderers? How
> can we know which are **their** houses, that we may burn or demolish them?
> Which **their** property, that we may destroy it? Which their persons, that
> we may kill them, and rid the world and ourselves of such tyrants and
> monsters?"_ [ **No Treason** , p. 46]

It should be noted that this fierce and militant rhetoric is never mentioned
by those who seek to associate social anarchism with violence.

Spooner's analysis of the root causes of social problems grew more radical and
consistent over time. Initially, he argued that there was a _"class of
employers, who now stand between the capitalist and labourer, and, by means of
usury laws, sponge money from the former, and labour from the latter, and put
the plunder into their own pockets."_ These usury laws _"are the contrivances,
not of the retired rich men, who have capital to loan . . . but of those few
'enterprising' 'business men,' as they are called, who, in and out of
legislatures, are more influential than either the rich or the poor; who
control the legislation of the country, and who, by means of usury laws, can
sponge money from those who are richer, and labour from those who are poorer
than themselves -- and thus make fortunes. . . . And they are almost the only
men who do make fortunes . . . large fortunes could rarely be made at all by
one individual, except by his sponging capital and labour from others."_ If
_"free competition in banking were allowed, the rate of interest would be
brought very low, and bank loans would be within the reach of everybody."_ [
**Poverty: Its Illegal Causes and Legal Cure** , p. 35, p. 11 and p. 15]

This is a wonderfully self-contradictory analysis, with Spooner suggesting
that industrial capitalists are both the only wealthy people around and, at
the same time, sponge money off the rich who have more money than them!
Equally, he seemed to believe that allowing interest rates to rise without
legal limit will, first, produce more people willing to take out loans and
then, when it fell below the legal limit, would produce more rich people
willing to loan their cash. And as the aim of these reforms was to promote
equality, how would paying interest payments to the already very wealthy help
achieve that goal? As can be seen, his early work was directed at industrial
capital only and he sought _"the establishment of a sort of partnership
relation between the capitalist and labourer, or lender and borrower -- the
former furnishing capital, the latter labour."_ However, he opposed the idea
that debtors should pay their debts in case of failure, stating _"the
capitalist is made to risk his capital on the final success of the enterprise,
without any claim upon the debtor in case of failure"_ and this _"is the true
relation between capital and labour, (or, what is the same thing, between the
lender and borrower.)"_ [ **Op. Cit.** , pp. 29-30] It is doubtful that rich
lenders would concur with Spooner on that!

However, by the 1880s Spooner had lost his illusions that finance capital was
fundamentally different from industrial capital. Now it was a case, like the
wider individualist anarchist movement he had become aware of and joined, of
attacking the money monopoly. His mature analysis recognised that _"the
employers of wage labour"_ were _"also the monopolists of money"_ and so both
wings of the capitalist class aimed to _"reduce [the public] to the condition
of servants; and to subject them to all the extortions as their employers --
the holders of privileged money -- may choose to practice upon them."_ _"The
holders of this monopoly now rule and rob this nation; and the government, in
all its branches, is simply their tool."_ [ **A Letter to Grover Cleveland** ,
p. 48, p. 39, p. 48] Thus Spooner came to see, like other socialists that both
finance and industrial capital share a common goal in oppressing and
exploiting the working class and that the state is simply an organ of
(minority) class rule. In this, his politics became more in line with other
individualist anarchists. This analysis is, needless to say, a left-
libertarian one rather than right-"libertarian."

Of course, it may be objected that Spooner was a right-"libertarian" because
he supported the market and private property. However, as we argued in
[section G.1.1](secG1.md#secg11) support for the market does not equate to
support for capitalism (no matter how often the ideologues of capitalism
proclaim it so). As noted, markets are not the defining feature of capitalism
as there were markets long before capitalism existed. So the fact that Spooner
retained the concept of markets does not necessarily make him a supporter of
capitalism. As for "property", this question is more complex as Spooner is the
only individualist anarchist to apparently reject the idea of "occupancy and
use." Somewhat ironically, he termed the doctrine that _"which holds that a
man has a right to lay his hands on any thing, which has no other man's hands
upon it, no matter who may have been the producer"_ as _"absolute communism"_
and contrasted this with _"individual property . . . which says that each man
has an absolute dominion, as against all other men, over the products and
acquisitions of his own labour, whether he retains them in his actual
possession or not."_ This Spooner subscribed to Locke's theory and argued that
the _" **natural** wealth of the world belongs to those who **first** take
possession of it . . . There is no limit, fixed by the law of nature, to the
amount of property one may acquire, simply by taking possession of natural
wealth, not already possessed, except the limit fixed by power or ability to
take such possession, without doing violence to the person or property of
others."_ [ **The Law of Intellectual Property** , p. 88 and pp. 21-2] From
this position he argued that the inventor should have intellectual property
rights forever, a position in direct contradiction to the opinions of other
anarchists (and even capitalist law and right-"libertarians" like Murray
Rothbard).

Unsurprisingly, Tucker called Spooner's work on Intellectual Property
_"positively foolish because it is fundamentally foolish, -- because, that is
to say, its discussion of the acquisition of the right of property starts with
a basic proposition that must be looked upon by all consistent Anarchists as
obvious nonsense."_ This was because it _"defines taking possession of a thing
as the bestowing of valuable labour upon it, such, for instance, in the case
of land, as cutting down the trees or building a fence around it. What follows
from this? Evidently that a man may go to a piece of vacant land and fence it
off; that he may then go to a second piece and fence that off; then to a
third, and fence that off; then to a fourth, a fifth, a hundredth, a
thousandth, fencing them all off; that, unable to fence off himself as many as
he wishes, he may hire other men to do the fencing for him; and that then he
may stand back and bar all other men from using these lands, or admit them as
tenants at such rental as he may choose to extract._ According to Tucker,
Spooner _"bases his opposition to . . . landlords on the **sole** ground that
they or their ancestors took their lands **by the sword** from the original
holders . . . I then asked him whether if"_ a landlord _"had found unoccupied
the very lands that he now holds, and had fenced them off, he would have any
objection to raise against [his] title to and leasing of these lands. He
declared emphatically that he would not. Whereupon I protested that his
pamphlet, powerful as it was within its scope, did not go to the bottom of the
land question."_ [ **Liberty** , no. 182, p. 6] For Tucker, the implications
of Spooner's argument were such that he stressed that it was not, in fact,
anarchist at all (he called it _"Archist"_ ) and, as a result, rejected them.

Thus we have a contradiction. Spooner attacked the government for it _"denies
the **natural** right of human beings to live on this planet. This it does by
denying their **natural** right to those things that are indispensable to the
maintenance of life."_ [ **A Letter to Grover Cleveland** , p. 33] Yet what
happens if, by market forces, all the land and capital becomes owned by a few
people? The socio-economic situation of the mass of the population is in
exactly the same situation as under a system founded by stealing the land by
the few. Equally, having to pay for access to the land results in just as much
a deduction from the product of work as wage labour. If property is a "natural
right" then they must be universal and so must be extended to everyone -- like
all rights -- and this implies an end to absolute property rights ( _"Because
the right to live and to develop oneself fully is equal for all,"_ Proudhon
argued, _"and because inequality of conditions is an obstacle to the exercise
of this right."_ [quoted by John Enrenberg, **Proudhon and his Age** , pp.
48-9]). However, saying that it is fair to suggest, given his arguments in
favour of universal self-employment, that Spooner did not think that his
system of property rights would be abused to produce a landlord class and, as
such, did not see the need to resolve the obvious contradictions in his
ideology. Whether he was correct in that assumption is another matter.

Which indicates why Spooner must be considered an anarchist regardless of his
unique position on property rights within the movement. As we argued in
[section A.3.1](secA3.md#seca31), only a system where the users of land or a
workplace own it can it be consistent with anarchist principles. Otherwise, if
there are bosses and landlords, then that society would be inherently
hierarchical and so **_Archist_**. Spooner's vision of a free society, rooted
as it is in self-employment, meets the criteria of being genuinely libertarian
in spite of the property rights used to justify it. Certain
"anarcho"-capitalists may subscribe to a similar theory of property but they
use it to justify an economy rooted in wage labour and so hierarchy.

Somewhat ironically, then, while certain of Spooner's ideas were closer to
Rothbard's than other individualist anarchists (most notably, a "natural
rights" defence of property) in terms of actual outcomes of applying his
ideas, his vision is the exact opposition of that of the "anarcho"-capitalist
guru. For Spooner, rather than being a revolt against nature, equality and
liberty were seen to be mutually self-enforcing; rather than a necessary and
essential aspect of a (so-called) free economy, wage labour was condemned as
producing inequality, servitude and a servile mentality. Moreover, the
argument that capitalists deny workers _"all the fruits"_ of their labour is
identical to the general **socialist** position that capitalism is
exploitative. All of which undoubtedly explains why Rothbard only selectively
quoted from Spooner's critique of the state and ignored the socio-economic
principles that underlay his political analysis and hopes for a free society.
Yet without those aspects of his ideas, Spooner's political analysis is
pressed into service of an ideology it is doubtful he would have agreed with.

As such, we must agree with Peter Marshall, who notes that Spooner
_"recommends that every man should be his own employer, and he depicts an
ideal society of independent farmers and entrepreneurs who have access to easy
credit. If every person received the fruits of his own labour, the just and
equal distribution of wealth would result."_ Because of this, he classifies
Spooner as a **left** libertarian as _"his concern with equality as well as
liberty makes him a left-wing individualist anarchist. Indeed, while his
starting-point is the individual, Spooner goes beyond classical liberalism in
his search for a form of rough equality and a community of interests._ [ **Op.
Cit.** , p. 389] This is also noted by Stephan L. Newman, who writes that
while right-"libertarians" are generally _"sympathic to Spooner's
individualist anarchism, they fail to notice or conveniently overlook its
egalitarian implications . . . They accept inequality as the price of
freedom"_ and _"habour no reservations about the social consequences of
capitalism."_ Spooner _"insist[s] that inequality corrupts freedom. [His]
anarchism is directed as much against inequality as against tyranny."_ Spooner
_"attempt[s] to realise th[e] promise of social harmony by recreating [a]
rough equality of condition"_ and so joins the _"critics of modern capitalism
and champions of the Jeffersonian idea of the autonomous individual --
independent yeoman and the self-employed mechanic."_ [ **Liberalism at Wit's
End** , p. 76, p. 74 and p. 91]

In summary, as can be seen, as with other individualist anarchists, there is a
great deal of commonality between Spooner's ideas and those of social
anarchists. Spooner perceives the same sources of exploitation and oppression
inherent in monopolistic control of the means of production by a wealth-owning
class as do social anarchists. His solutions may differ, but he observes
exactly the same problems. In other words, Spooner is a left libertarian, and
his individualist anarchism is just as anti-capitalist as the ideas of, say,
Bakunin, Kropotkin or Chomsky. Spooner, in spite of his closeness to classical
liberalism, was no more a capitalist than Rothbard was an anarchist.

[‹ G.6 What are the ideas of Max Stirner?](secG6.md "Go to previous page")
[up](secGcon.md "Go to parent page") [Section H - Why do anarchists oppose
state socialism? ›](secHcon.md "Go to next page")

