---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token GitLab personal access token'
---

## Description

The response body contains content that matches the pattern of a GitLab personal access token was identified. Personal access tokens can be used to access GitLab services as the user who created them. In most cases these tokens are given read-write access to all repositories. A malicious actor with access to this token can execute functionality on behalf of the user with the given permissions of the token.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To regenerate a personal access token:

- Sign in to your GitLab account and access the [User settings](../../../../../user/profile/_index.md#access-your-user-settings) left-hand side menu, select "Access tokens"
- Find the access token that was identified in the "Active personal access tokens" table
- Note the permissions that were assigned to this token
- Select the trash icon in the "Action" column of the token
- When prompted, select "Revoke"

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.56 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
