/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.utils.formatting;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.utils.Wildcards;
import org.netbeans.lib.profiler.utils.formatting.Formattable;

public class PlainFormattableMethodName
implements Formattable {
    private static final Logger LOGGER = Logger.getLogger(PlainFormattableMethodName.class.getName());
    private static final String BOOLEAN_TEXT = "boolean";
    private static final String CHAR_TEXT = "char";
    private static final String BYTE_TEXT = "byte";
    private static final String SHORT_TEXT = "short";
    private static final String INT_TEXT = "int";
    private static final String LONG_TEXT = "long";
    private static final String FLOAT_TEXT = "float";
    private static final String DOUBLE_TEXT = "double";
    private static final String VOID_TEXT = "void";
    private static final char BOOLEAN_CODE = 'Z';
    private static final char CHAR_CODE = 'C';
    private static final char BYTE_CODE = 'B';
    private static final char SHORT_CODE = 'S';
    private static final char INT_CODE = 'I';
    private static final char LONG_CODE = 'J';
    private static final char FLOAT_CODE = 'F';
    private static final char DOUBLE_CODE = 'D';
    private static final char VOID_CODE = 'V';
    private String className;
    private String methodName;
    private String params;
    private String returnType;
    private int verbosity;

    PlainFormattableMethodName(String string, String string2, String string3, int n) {
        this.verbosity = n;
        StringBuffer stringBuffer = new StringBuffer();
        this.className = string != null ? string.replace('/', '.') : "<unknown class>";
        if (this.className.length() == 0) {
            this.className = ".*";
        }
        if (this.className.endsWith(".")) {
            this.className = this.className + "*";
        }
        if (string2 == null) {
            this.params = "";
            this.returnType = "";
        } else {
            this.methodName = "".equals(string2) && !this.className.contains("*") ? "<init>" : string2;
            if ("<clinit>".equals(this.methodName) || Wildcards.isMethodWildcard(this.methodName)) {
                this.params = "";
                this.returnType = "";
            } else {
                char c;
                int n2;
                int n3 = string3.lastIndexOf(41) + 1;
                if (n3 > 0 && !"<init>".equals(this.methodName)) {
                    this.returnType = string3.substring(n3);
                    n2 = 0;
                    while (this.returnType.charAt(n2) == '[') {
                        stringBuffer.append("[]");
                        ++n2;
                    }
                    if ((c = this.returnType.charAt(n2++)) == 'Z') {
                        this.returnType = BOOLEAN_TEXT + stringBuffer.toString();
                    } else if (c == 'C') {
                        this.returnType = CHAR_TEXT + stringBuffer.toString();
                    } else if (c == 'B') {
                        this.returnType = BYTE_TEXT + stringBuffer.toString();
                    } else if (c == 'S') {
                        this.returnType = SHORT_TEXT + stringBuffer.toString();
                    } else if (c == 'I') {
                        this.returnType = INT_TEXT + stringBuffer.toString();
                    } else if (c == 'J') {
                        this.returnType = LONG_TEXT + stringBuffer.toString();
                    } else if (c == 'F') {
                        this.returnType = FLOAT_TEXT + stringBuffer.toString();
                    } else if (c == 'D') {
                        this.returnType = DOUBLE_TEXT + stringBuffer.toString();
                    } else if (c == 'V') {
                        this.returnType = VOID_TEXT + stringBuffer.toString();
                    } else {
                        this.returnType = this.returnType.substring(n2, this.returnType.length() - 1);
                        if (this.returnType.startsWith("java/lang/") && this.returnType.indexOf(47, 10) == -1) {
                            this.returnType = this.returnType.substring(10);
                        }
                        this.returnType = this.returnType.replace('$', '.');
                        this.returnType = this.returnType.replace('/', '.') + stringBuffer.toString();
                    }
                } else {
                    this.returnType = "";
                }
                n3 = string3.indexOf(40) + 1;
                int n4 = string3.lastIndexOf(41);
                if (n4 > 0) {
                    String string4 = string3.substring(n3, n4);
                    StringBuffer stringBuffer2 = new StringBuffer();
                    stringBuffer.setLength(0);
                    n2 = 0;
                    while (n2 < string4.length()) {
                        while (string4.charAt(n2) == '[') {
                            stringBuffer.append("[]");
                            ++n2;
                        }
                        if ((c = string4.charAt(n2++)) == 'Z') {
                            stringBuffer2.append(BOOLEAN_TEXT);
                        } else if (c == 'C') {
                            stringBuffer2.append(CHAR_TEXT);
                        } else if (c == 'B') {
                            stringBuffer2.append(BYTE_TEXT);
                        } else if (c == 'S') {
                            stringBuffer2.append(SHORT_TEXT);
                        } else if (c == 'I') {
                            stringBuffer2.append(INT_TEXT);
                        } else if (c == 'J') {
                            stringBuffer2.append(LONG_TEXT);
                        } else if (c == 'F') {
                            stringBuffer2.append(FLOAT_TEXT);
                        } else if (c == 'D') {
                            stringBuffer2.append(DOUBLE_TEXT);
                        } else {
                            int n5 = n2;
                            while (string4.charAt(n2) != ';') {
                                ++n2;
                            }
                            String string5 = string4.substring(n5, n2);
                            if (string5.startsWith("java/lang/") && string5.indexOf(47, 10) == -1) {
                                string5 = string5.substring(10);
                            }
                            string5 = string5.replace('$', '.');
                            string5 = string5.replace('/', '.');
                            stringBuffer2.append(string5);
                            ++n2;
                        }
                        if (stringBuffer.length() > 0) {
                            stringBuffer2.append(stringBuffer.toString());
                        }
                        stringBuffer.setLength(0);
                        if (n2 >= string4.length()) continue;
                        stringBuffer2.append(", ");
                    }
                    this.params = stringBuffer2.toString();
                } else {
                    this.params = "";
                }
            }
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Formattable method name for:");
            LOGGER.finest("Class: " + this.className);
            LOGGER.finest("Method: " + this.methodName);
            LOGGER.finest("Return type: " + this.returnType);
            LOGGER.finest("Parameters: " + this.params);
        }
    }

    public String getFormattedClass() {
        return this.className;
    }

    public String getFormattedClassAndMethod() {
        if (this.methodName == null || this.methodName.length() == 0) {
            return this.getFormattedClass();
        }
        return this.className + "." + this.getFormattedMethod();
    }

    public String getFormattedMethod() {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("Getting formatted method name for " + this.methodName);
        }
        if (this.methodName == null || this.methodName.length() == 0) {
            return "";
        }
        if ("<clinit>".equals(this.methodName)) {
            return this.methodName;
        }
        return this.methodName + "(" + this.getParamsString() + ")";
    }

    public String getFullFormattedClassAndMethod() {
        if (this.methodName == null || this.methodName.length() == 0) {
            return this.getFormattedClass();
        }
        return this.className + "." + this.getFullFormattedMethod();
    }

    public String getFullFormattedMethod() {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("Getting full formatted method name for " + this.methodName);
        }
        if (this.methodName == null || this.methodName.length() == 0) {
            return "";
        }
        if ("<clinit>".equals(this.methodName)) {
            return this.methodName;
        }
        if ("<init>".equals(this.methodName)) {
            return this.methodName + "(" + this.getParamsString() + ")";
        }
        if ("*".equals(this.methodName)) {
            return this.methodName;
        }
        return this.methodName + "(" + this.getParamsString() + ") : " + this.getReturnTypeX();
    }

    public String getParamsString() {
        return this.params;
    }

    public String getReturnTypeX() {
        return this.returnType;
    }

    @Override
    public String toFormatted() {
        switch (this.verbosity) {
            case 1: {
                return this.getFormattedClass();
            }
            case 2: {
                return this.getFormattedMethod();
            }
            case 3: {
                return this.getFormattedClassAndMethod();
            }
            case 4: {
                return this.getFullFormattedMethod();
            }
            case 5: {
                return this.getFullFormattedClassAndMethod();
            }
        }
        return this.getFullFormattedClassAndMethod();
    }

    public String toString() {
        return this.getFullFormattedClassAndMethod();
    }

    private boolean isAllWildCard(String string) {
        return string.equals("<all>") || string.equals("*");
    }
}

