/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.netbeans.lib.profiler.heap.ClassDump;
import org.netbeans.lib.profiler.heap.ClassDumpInstance;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.InstanceDump;
import org.netbeans.lib.profiler.heap.LongBuffer;
import org.netbeans.lib.profiler.heap.LongMap;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;
import org.netbeans.lib.profiler.heap.PrimitiveArrayInstance;

class TreeObject {
    private static final int BUFFER_SIZE = 8192;
    private HprofHeap heap;
    private LongBuffer readBuffer;
    private LongBuffer writeBuffer;

    TreeObject(HprofHeap hprofHeap, LongBuffer longBuffer) {
        this.heap = hprofHeap;
        this.writeBuffer = longBuffer;
    }

    synchronized void computeTrees() {
        try {
            boolean bl;
            this.createBuffers();
            do {
                this.switchBuffers();
            } while (bl = this.computeOneLevel());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.deleteBuffers();
    }

    private boolean computeOneLevel() throws IOException {
        boolean bl = false;
        while (true) {
            List list;
            Instance instance;
            Object object;
            long l = this.readLong();
            long l2 = 0L;
            if (l == 0L) break;
            Instance instance2 = this.heap.getInstanceByID(l);
            if (instance2 instanceof ObjectArrayInstance) {
                object = ((ObjectArrayInstance)instance2).getValues().iterator();
                long l3 = 0L;
                while (object.hasNext() && l3 != -1L) {
                    instance = (Instance)object.next();
                    l3 = this.checkInstance(l, instance);
                    l2 += l3;
                }
                bl |= this.processInstance(instance2, l3, l2);
                continue;
            }
            if (instance2 instanceof PrimitiveArrayInstance) {
                assert (false) : "Error - PrimitiveArrayInstance not allowed " + instance2.getJavaClass().getName() + "#" + instance2.getInstanceNumber();
                continue;
            }
            if (instance2 instanceof ClassDumpInstance) {
                object = ((ClassDumpInstance)instance2).classDump;
                list = ((ClassDump)object).getStaticFieldValues();
            } else if (instance2 instanceof InstanceDump) {
                list = instance2.getFieldValues();
            } else {
                if (instance2 == null) {
                    System.err.println("HeapWalker Warning - null instance for " + l);
                    continue;
                }
                throw new IllegalArgumentException("Illegal type " + instance2.getClass());
            }
            long l4 = 0L;
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && l4 != -1L) {
                FieldValue fieldValue = (FieldValue)iterator.next();
                if (!(fieldValue instanceof ObjectFieldValue)) continue;
                instance = ((ObjectFieldValue)fieldValue).getInstance();
                l4 = this.checkInstance(l, instance);
                l2 += l4;
            }
            bl |= this.processInstance(instance2, l4, l2);
        }
        return bl;
    }

    private boolean processInstance(Instance instance, long l, long l2) throws IOException {
        if (l != -1L) {
            LongMap.Entry entry;
            long l3;
            LongMap.Entry entry2 = this.heap.idToOffsetMap.get(instance.getInstanceId());
            entry2.setRetainedSize((int)((long)instance.getSize() + l2));
            entry2.setTreeObj();
            if (entry2.hasOnlyOneReference() && (l3 = entry2.getNearestGCRootPointer()) != 0L && (entry = this.heap.idToOffsetMap.get(l3)).getRetainedSize() == 0) {
                entry.setRetainedSize(-1);
                this.writeLong(l3);
            }
            return true;
        }
        return false;
    }

    private void createBuffers() {
        this.readBuffer = new LongBuffer(8192);
    }

    private void deleteBuffers() {
        this.readBuffer.delete();
        this.writeBuffer.delete();
    }

    private long readLong() throws IOException {
        return this.readBuffer.readLong();
    }

    private void switchBuffers() {
        LongBuffer longBuffer = this.readBuffer;
        this.readBuffer = this.writeBuffer;
        this.writeBuffer = longBuffer;
        this.readBuffer.startReading();
        this.writeBuffer.reset();
    }

    private void writeLong(long l) throws IOException {
        if (l != 0L) {
            this.writeBuffer.writeLong(l);
        }
    }

    private long checkInstance(long l, Instance instance) throws IOException {
        if (instance != null) {
            LongMap.Entry entry = this.heap.idToOffsetMap.get(instance.getInstanceId());
            if (!entry.hasOnlyOneReference()) {
                return -1L;
            }
            if (!entry.isTreeObj()) {
                this.writeLong(l);
                return -1L;
            }
            return entry.getRetainedSize();
        }
        return 0L;
    }
}

