/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import java.awt.AWTKeyStroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JExtendedTable;
import org.netbeans.lib.profiler.ui.components.table.ClassNameTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.CustomBarCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.ExtendedTableModel;
import org.netbeans.lib.profiler.ui.components.table.LabelBracketTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.SortableTableModel;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;
import org.netbeans.lib.profiler.ui.memory.MemoryResultsPanel;

public abstract class AllocResultsPanel
extends MemoryResultsPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.memory.Bundle");
    private static final String FILTER_MENU_ITEM_NAME = messages.getString("AllocResultsPanel_FilterMenuItemName");
    private static final String CLASS_COLUMN_NAME = messages.getString("AllocResultsPanel_ClassColumnName");
    private static final String BYTES_REL_COLUMN_NAME = messages.getString("AllocResultsPanel_BytesRelColumnName");
    private static final String BYTES_COLUMN_NAME = messages.getString("AllocResultsPanel_BytesColumnName");
    private static final String OBJECTS_COLUMN_NAME = messages.getString("AllocResultsPanel_ObjectsColumnName");
    private static final String CLASS_COLUMN_TOOLTIP = messages.getString("AllocResultsPanel_ClassColumnToolTip");
    private static final String BYTES_REL_COLUMN_TOOLTIP = messages.getString("AllocResultsPanel_BytesRelColumnToolTip");
    private static final String BYTES_COLUMN_TOOLTIP = messages.getString("AllocResultsPanel_BytesColumnToolTip");
    private static final String OBJECTS_COLUMN_TOOLTIP = messages.getString("AllocResultsPanel_ObjectsColumnToolTip");
    private static final String TABLE_ACCESS_NAME = messages.getString("AllocResultsPanel_TableAccessName");
    protected int[] nTotalAllocObjects;
    protected long[] totalAllocObjectsSize;
    protected long nTotalBytes;
    protected long nTotalClasses;
    private int initialSortingColumn;
    private int minNamesColumnWidth;

    public AllocResultsPanel(MemoryResUserActionsHandler memoryResUserActionsHandler) {
        super(memoryResUserActionsHandler);
        this.setDefaultSorting();
        this.initColumnsData();
    }

    public void setDefaultSorting() {
        this.setSorting(1, false);
    }

    public void setSorting(int n, boolean bl) {
        if (n == -1) {
            this.setDefaultSorting();
        } else {
            this.initialSortingColumn = n;
            this.sortBy = this.getSortBy(this.initialSortingColumn);
            this.sortOrder = bl;
        }
    }

    public int getSortingColumn() {
        if (this.resTableModel == null) {
            return -1;
        }
        return this.resTableModel.getRealColumn(this.resTableModel.getSortingColumn());
    }

    public boolean getSortingOrder() {
        if (this.resTableModel == null) {
            return false;
        }
        return this.resTableModel.getSortingOrder();
    }

    @Override
    protected abstract JPopupMenu getPopupMenu();

    protected CustomBarCellRenderer getBarCellRenderer() {
        return new CustomBarCellRenderer(0L, this.maxValue);
    }

    protected void getResultsSortedByAllocObjNumber() {
        this.getResultsSortedByClassName(true);
        int n = this.nInfoLines;
        this.nInfoLines = this.sortResults(this.nTotalAllocObjects, (int[][])null, (long[][])new long[][]{this.totalAllocObjectsSize}, (float[][])null, 0, n, false);
        this.totalAllocations = 0L;
        for (int i = 0; i < this.nInfoLines; ++i) {
            this.totalAllocations += (long)this.nTotalAllocObjects[i];
        }
    }

    protected void getResultsSortedByAllocObjSize() {
        this.getResultsSortedByClassName(true);
        int n = this.nInfoLines;
        this.nInfoLines = this.sortResults(this.totalAllocObjectsSize, (int[][])new int[][]{this.nTotalAllocObjects}, (long[][])null, (float[][])null, 0, n, false);
        this.totalAllocations = 0L;
        for (int i = 0; i < this.nInfoLines; ++i) {
            this.totalAllocations += (long)this.nTotalAllocObjects[i];
        }
    }

    protected void getResultsSortedByClassName(boolean bl) {
        this.nInfoLines = this.sortResultsByClassName(new int[][]{this.nTotalAllocObjects}, new long[][]{this.totalAllocObjectsSize}, null, this.nTrackedItems, this.truncateZeroItems());
        if (!bl) {
            this.totalAllocations = 0L;
            for (int i = 0; i < this.nInfoLines; ++i) {
                this.totalAllocations += (long)this.nTotalAllocObjects[i];
            }
        }
    }

    @Override
    protected JExtendedTable getResultsTable() {
        this.sortResults();
        if (this.resTable == null) {
            this.resTableModel = new ExtendedTableModel(new SortableTableModel(){

                @Override
                public String getColumnName(int n) {
                    return AllocResultsPanel.this.columnNames[n];
                }

                @Override
                public int getRowCount() {
                    return AllocResultsPanel.this.nDisplayedItems;
                }

                @Override
                public int getColumnCount() {
                    return AllocResultsPanel.this.columnNames.length;
                }

                public Class getColumnClass(int n) {
                    return AllocResultsPanel.this.columnTypes[n];
                }

                @Override
                public Object getValueAt(int n, int n2) {
                    return AllocResultsPanel.this.computeValueAt(n, n2);
                }

                @Override
                public String getColumnToolTipText(int n) {
                    return AllocResultsPanel.this.columnToolTips[n];
                }

                @Override
                public void sortByColumn(int n, boolean bl) {
                    AllocResultsPanel.this.sortBy = AllocResultsPanel.this.getSortBy(n);
                    AllocResultsPanel.this.sortOrder = bl;
                    int n2 = AllocResultsPanel.this.resTable.getSelectedRow();
                    String string = null;
                    if (n2 != -1) {
                        string = (String)AllocResultsPanel.this.resTable.getValueAt(n2, 0);
                    }
                    AllocResultsPanel.this.prepareResults();
                    if (string != null) {
                        AllocResultsPanel.this.resTable.selectRowByContents(string, 0, true);
                    }
                }

                @Override
                public boolean getInitialSorting(int n) {
                    switch (n) {
                        case 0: {
                            return true;
                        }
                    }
                    return false;
                }
            });
            this.resTable = new JExtendedTable(this.resTableModel){

                @Override
                public void doLayout() {
                    int n = 0;
                    int n2 = -1;
                    for (int i = 0; i < AllocResultsPanel.this.resTableModel.getColumnCount(); ++i) {
                        int n3 = AllocResultsPanel.this.resTableModel.getRealColumn(i);
                        if (n3 == 0) {
                            n2 = i;
                            continue;
                        }
                        n += this.getColumnModel().getColumn(i).getPreferredWidth();
                    }
                    if (n2 != -1) {
                        this.getColumnModel().getColumn(n2).setPreferredWidth(Math.max(this.getWidth() - n, AllocResultsPanel.this.minNamesColumnWidth));
                    }
                    super.doLayout();
                }
            };
            this.resTable.getAccessibleContext().setAccessibleName(TABLE_ACCESS_NAME);
            this.resTableModel.setTable(this.resTable);
            this.resTableModel.setInitialSorting(this.initialSortingColumn, this.sortOrder);
            this.resTable.setRowSelectionAllowed(true);
            this.resTable.setSelectionMode(0);
            this.resTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
            this.resTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
            this.resTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
            this.resTable.setShowHorizontalLines(false);
            this.resTable.setShowVerticalLines(true);
            this.resTable.setRowMargin(0);
            this.resTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
            HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>(this.resTable.getFocusTraversalKeys(0));
            hashSet.add(KeyStroke.getKeyStroke(9, 0));
            this.resTable.setFocusTraversalKeys(0, hashSet);
            hashSet = new HashSet<AWTKeyStroke>(this.resTable.getFocusTraversalKeys(1));
            hashSet.add(KeyStroke.getKeyStroke(9, 1));
            this.resTable.setFocusTraversalKeys(1, hashSet);
            this.setColumnsData();
        }
        return this.resTable;
    }

    protected Object computeValueAt(int n, int n2) {
        int n3 = (Integer)this.filteredToFullIndexes.get(n);
        switch (n2) {
            case 0: {
                return this.sortedClassNames[n3];
            }
            case 1: {
                return new Long(this.totalAllocObjectsSize[n3]);
            }
            case 2: {
                return this.intFormat.format(this.totalAllocObjectsSize[n3]) + " B (" + (this.nTotalBytes == 0L ? "-%" : this.percentFormat.format((double)this.totalAllocObjectsSize[n3] / (double)this.nTotalBytes)) + ")";
            }
            case 3: {
                return this.intFormat.format(this.nTotalAllocObjects[n3]) + " (" + (this.nTotalClasses == 0L ? "-%" : this.percentFormat.format((double)this.nTotalAllocObjects[n3] / (double)this.nTotalClasses)) + ")";
            }
        }
        return null;
    }

    @Override
    protected void initColumnSelectorItems() {
        this.headerPopup.removeAll();
        for (int i = 0; i < this.columnNames.length; ++i) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this.columnNames[i]);
            jCheckBoxMenuItem.setActionCommand(Integer.valueOf(i).toString());
            this.addMenuItemListener(jCheckBoxMenuItem);
            if (this.resTable != null) {
                jCheckBoxMenuItem.setState(this.resTableModel.isRealColumnVisible(i));
                if (i == 0) {
                    jCheckBoxMenuItem.setEnabled(false);
                }
            } else {
                jCheckBoxMenuItem.setState(true);
            }
            this.headerPopup.add(jCheckBoxMenuItem);
        }
        this.headerPopup.addSeparator();
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(FILTER_MENU_ITEM_NAME);
        jCheckBoxMenuItem.setActionCommand("Filter");
        this.addMenuItemListener(jCheckBoxMenuItem);
        if (this.filterComponent == null) {
            jCheckBoxMenuItem.setState(true);
        } else {
            jCheckBoxMenuItem.setState(this.filterComponent.isVisible());
        }
        this.headerPopup.add(jCheckBoxMenuItem);
        this.headerPopup.pack();
    }

    protected void initColumnsData() {
        int n = this.getFontMetrics(this.getFont()).charWidth('W') * 13;
        this.minNamesColumnWidth = this.getFontMetrics(this.getFont()).charWidth('W') * 30;
        ClassNameTableCellRenderer classNameTableCellRenderer = new ClassNameTableCellRenderer();
        LabelBracketTableCellRenderer labelBracketTableCellRenderer = new LabelBracketTableCellRenderer(11);
        this.columnNames = new String[]{CLASS_COLUMN_NAME, BYTES_REL_COLUMN_NAME, BYTES_COLUMN_NAME, OBJECTS_COLUMN_NAME};
        this.columnToolTips = new String[]{CLASS_COLUMN_TOOLTIP, BYTES_REL_COLUMN_TOOLTIP, BYTES_COLUMN_TOOLTIP, OBJECTS_COLUMN_TOOLTIP};
        this.columnTypes = new Class[]{String.class, Number.class, String.class, String.class};
        this.columnRenderers = new TableCellRenderer[]{classNameTableCellRenderer, null, labelBracketTableCellRenderer, labelBracketTableCellRenderer};
        this.columnWidths = new int[]{n, n, n};
    }

    @Override
    protected boolean passesValueFilter(int n) {
        return (double)this.totalAllocObjectsSize[n] / (double)this.nTotalBytes * 100.0 >= this.valueFilterValue;
    }

    @Override
    protected void performDefaultAction(int n) {
        this.showSourceForClass(n);
    }

    private void setColumnsData() {
        this.barRenderer = this.getBarCellRenderer();
        TableColumnModel tableColumnModel = this.resTable.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(this.minNamesColumnWidth);
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            int n = this.resTableModel.getRealColumn(i);
            if (n == 0) {
                tableColumnModel.getColumn(i).setPreferredWidth(this.minNamesColumnWidth);
            } else {
                tableColumnModel.getColumn(i).setPreferredWidth(this.columnWidths[n - 1]);
            }
            if (n == 1) {
                tableColumnModel.getColumn(i).setCellRenderer(this.barRenderer);
                continue;
            }
            tableColumnModel.getColumn(i).setCellRenderer(this.columnRenderers[n]);
        }
    }

    private int getSortBy(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return 2;
    }

    private void addMenuItemListener(JCheckBoxMenuItem jCheckBoxMenuItem) {
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("Filter")) {
                    AllocResultsPanel.this.filterComponent.setVisible(!AllocResultsPanel.this.filterComponent.isVisible());
                    return;
                }
                AllocResultsPanel.this.saveColumnsData();
                boolean bl = false;
                int n = Integer.parseInt(actionEvent.getActionCommand());
                int n2 = AllocResultsPanel.this.resTableModel.getSortingColumn();
                int n3 = AllocResultsPanel.this.resTableModel.getRealColumn(n2);
                boolean bl2 = AllocResultsPanel.this.resTableModel.isRealColumnVisible(n);
                if (bl2 && n == n3) {
                    n2 = n2 + 1 == AllocResultsPanel.this.resTableModel.getColumnCount() ? n2 - 1 : n2 + 1;
                    n3 = AllocResultsPanel.this.resTableModel.getRealColumn(n2);
                    bl = true;
                }
                AllocResultsPanel.this.resTableModel.setRealColumnVisibility(n, !bl2);
                AllocResultsPanel.this.resTable.createDefaultColumnsFromModel();
                AllocResultsPanel.this.resTableModel.setTable(AllocResultsPanel.this.resTable);
                n2 = AllocResultsPanel.this.resTableModel.getVirtualColumn(n3);
                if (bl) {
                    AllocResultsPanel.this.sortOrder = AllocResultsPanel.this.resTableModel.getInitialSorting(n2);
                    AllocResultsPanel.this.sortBy = AllocResultsPanel.this.getSortBy(n3);
                    AllocResultsPanel.this.sortResults();
                    AllocResultsPanel.this.resTable.repaint();
                }
                AllocResultsPanel.this.resTableModel.setInitialSorting(n2, AllocResultsPanel.this.sortOrder);
                AllocResultsPanel.this.resTable.getTableHeader().repaint();
                AllocResultsPanel.this.setColumnsData();
            }
        });
    }

    private void saveColumnsData() {
        TableColumnModel tableColumnModel = this.resTable.getColumnModel();
        for (int i = 0; i < this.resTableModel.getColumnCount(); ++i) {
            int n = this.resTableModel.getRealColumn(i);
            if (n == 0) continue;
            this.columnWidths[n - 1] = tableColumnModel.getColumn(i).getPreferredWidth();
        }
    }

    private void sortResults() {
        switch (this.sortBy) {
            case 2: {
                this.getResultsSortedByAllocObjSize();
                break;
            }
            case 3: {
                this.getResultsSortedByAllocObjNumber();
                break;
            }
            case 1: {
                this.getResultsSortedByClassName(false);
            }
        }
        this.createFilteredIndexes();
    }
}

