/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.api.icons.Icons;

public class FilterComponent
extends JPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.components.Bundle");
    private static final String DEFAULT_TEXTFIELD_STRING = messages.getString("FilterComponent_DefaultTextFieldString");
    private static final String INVALID_REGEXP_STRING = messages.getString("FilterComponent_InvalidRegExpString");
    private static final String FILTER_TYPE_TOOLTIP = messages.getString("FilterComponent_FilterTypeToolTip");
    private static final String FILTER_VALUE_TOOLTIP = messages.getString("FilterComponent_FilterValueToolTip");
    private static final String SET_FILTER_BUTTON_TOOLTIP = messages.getString("FilterComponent_SetFilterButtonToolTip");
    private static final String CLEAR_FILTER_BUTTON_TOOLTIP = messages.getString("FilterComponent_ClearFilterButtonToolTip");
    private static final String FILTER_STRING_COMBO_ACCESS_NAME = messages.getString("FilterComponent_FilterStringComboAccessName");
    private static final String FILTER_STRING_COMBO_ACCESS_DESCR = messages.getString("FilterComponent_FilterStringComboAccessDescr");
    private static final String ACCESS_NAME = messages.getString("FilterComponent_AccessName");
    private static final String ACCESS_DESCR = messages.getString("FilterComponent_AccessDescr");
    private static final Color DEFAULT_TEXTFIELD_FOREGROUND = Color.GRAY;
    private static final String EMPTY_STRING = "";
    private final Icon setFilterIcon = Icons.getIcon((String)"GeneralIcons.SetFilter");
    private final Icon setFilterRolloverIcon = new ButtonBorderIcon(this.setFilterIcon);
    private final Icon clearFilterIcon = Icons.getIcon((String)"GeneralIcons.ClearFilter");
    private final Icon clearFilterRolloverIcon = new ButtonBorderIcon(this.clearFilterIcon);
    private Color textFieldForeground;
    private JButton clearFilterButton;
    private JButton filterTypeButton;
    private JButton setFilterButton;
    private JFilterStringCombo filterStringCombo;
    private JLabel incorrectRegExpLabel;
    private JMenuItem activeFilterItem;
    private JPanel setClearFilterButtonsPanel;
    private JPanel textFieldRegExpWarningPanel;
    private JPopupMenu filterTypePopup;
    private PopupItemsListener popupItemsListener;
    private String filterString = "";
    private String textFieldEmptyText = DEFAULT_TEXTFIELD_STRING;
    private List<String> filterNames;
    private Collection<String> filterStringsBuffer;
    private List filterTypes;
    private Collection<FilterListener> listeners = new CopyOnWriteArraySet<FilterListener>();
    private List<Icon> rolloverIcons;
    private List<Icon> standardIcons;
    private boolean internalChange = false;
    private boolean textFieldEmptyFlag = true;
    private boolean validRegExpFlag = true;
    private int defaultFilterType = 20;
    private int filterType = 0;
    private int lastFilterType = -1;
    private int nOwnComboItems = 0;

    public FilterComponent() {
        this.popupItemsListener = new PopupItemsListener();
        this.standardIcons = new ArrayList<Icon>();
        this.rolloverIcons = new ArrayList<Icon>();
        this.filterNames = new ArrayList<String>();
        this.filterTypes = new ArrayList();
        this.filterStringsBuffer = new ArrayList<String>();
        this.initComponents();
        this.checkRegExp();
        this.updateSetClearButtons();
    }

    public int getDefaultFilterType() {
        return this.defaultFilterType;
    }

    public void setEmptyFilterText(String string) {
        if (string.length() == 0) {
            return;
        }
        String string2 = this.textFieldEmptyText;
        this.textFieldEmptyText = string;
        if (this.filterStringCombo.getText().equals(string2)) {
            this.filterStringCombo.setText(this.textFieldEmptyText);
        }
    }

    public void setFilterString(String string) {
        this.setFilterString(string, true);
    }

    public String getFilterString() {
        return this.filterString;
    }

    public String[] getFilterStrings() {
        return FilterComponent.getFilterStrings(this.filterString);
    }

    public static String[] getFilterStrings(String string) {
        if (string == null) {
            return null;
        }
        return string.trim().split(" +");
    }

    public void setDefaultFilterType(int n) {
        this.defaultFilterType = n;
    }

    public void setFilterType(int n) {
        this.setFilterType(n, false);
    }

    public int getFilterType() {
        return this.filterType;
    }

    public void setFilterValues(String string, int n) {
        this.setFilterString(string, false);
        this.setFilterType(n, false);
        this.fireFilterChanged();
        this.updateSetClearButtons();
    }

    public JMenuItem addFilterItem(ImageIcon imageIcon, String string, int n) {
        ImageIcon imageIcon2 = imageIcon;
        ButtonBorderIcon buttonBorderIcon = new ButtonBorderIcon(imageIcon);
        this.standardIcons.add(imageIcon2);
        this.rolloverIcons.add(buttonBorderIcon);
        this.filterNames.add(string);
        this.filterTypes.add(n);
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setText(string);
        jMenuItem.setIcon(imageIcon2);
        jMenuItem.setBackground(UIUtils.getProfilerResultsBackground());
        jMenuItem.addActionListener(this.popupItemsListener);
        this.filterTypePopup.add(jMenuItem);
        this.filterTypePopup.pack();
        this.setFilterTypePopupItemActive(jMenuItem, false);
        return jMenuItem;
    }

    public void addFilterListener(FilterListener filterListener) {
        this.listeners.add(filterListener);
    }

    public JSeparator addSeparatorItem() {
        this.standardIcons.add(null);
        this.rolloverIcons.add(null);
        this.filterNames.add(null);
        this.filterTypes.add(null);
        JPopupMenu.Separator separator = new JPopupMenu.Separator();
        separator.setForeground(Color.BLACK);
        separator.setBackground(Color.WHITE);
        this.filterTypePopup.add(separator);
        this.filterTypePopup.pack();
        return separator;
    }

    public void removeFilterListener(FilterListener filterListener) {
        this.listeners.remove(filterListener);
    }

    private JMenuItem getFilterMenuItemByIndex(int n) {
        if (n < this.filterTypePopup.getComponentCount()) {
            return (JMenuItem)this.filterTypePopup.getComponent(n);
        }
        return null;
    }

    private void setFilterString(String string, boolean bl) {
        if (string == null) {
            return;
        }
        if (!this.filterString.equals(string = string.trim())) {
            this.filterString = string;
            this.filterStringCombo.setText(this.filterString);
            this.internalChange = true;
            this.addComboBoxItem(this.filterString);
            this.internalChange = false;
            if (bl) {
                boolean bl2 = this.textFieldEmptyFlag;
                this.textFieldEmptyFlag = false;
                this.fireFilterChanged();
                this.checkRegExp();
                this.updateSetClearButtons();
                this.textFieldEmptyFlag = bl2;
            }
            if (this.filterString.length() > 0) {
                this.doFocusGained();
            } else {
                this.doFocusLost();
            }
        }
    }

    private void setFilterType(int n, boolean bl) {
        if (this.filterType != n) {
            for (int i = 0; i < this.filterTypes.size(); ++i) {
                Integer n2 = (Integer)this.filterTypes.get(i);
                if (n2 == null || n2 != n) continue;
                this.setFilterTypePopupItemActive(i, bl);
                return;
            }
        }
    }

    private void setFilterTypePopupItemActive(JMenuItem jMenuItem, boolean bl) {
        int n = this.filterTypePopup.getComponentIndex(jMenuItem);
        if (n != -1) {
            this.setFilterTypePopupItemActive(n, bl);
        }
    }

    private void setFilterTypePopupItemActive(int n, boolean bl) {
        int n2 = (Integer)this.filterTypes.get(n);
        if (n2 != this.filterType) {
            this.activeFilterItem = this.getFilterMenuItemByIndex(n);
            this.filterType = n2;
            ArrowSignIcon arrowSignIcon = new ArrowSignIcon((ImageIcon)this.standardIcons.get(n));
            ButtonBorderIcon buttonBorderIcon = new ButtonBorderIcon(arrowSignIcon);
            String string = this.filterNames.get(n);
            this.filterTypeButton.setIcon(arrowSignIcon);
            this.filterTypeButton.setRolloverIcon(buttonBorderIcon);
            this.filterTypeButton.setToolTipText(MessageFormat.format(FILTER_TYPE_TOOLTIP, string));
            this.checkRegExp();
            if (bl) {
                this.fireFilterChanged();
            }
            this.updateSetClearButtons();
            this.updateComboItems();
        }
    }

    private int getIndexByCurrentFilterType() {
        return this.getIndexByFilterType(this.filterType);
    }

    private int getIndexByFilterType(int n) {
        for (int i = 0; i < this.filterTypes.size(); ++i) {
            Integer n2 = (Integer)this.filterTypes.get(i);
            if (n2 == null || n2 != n) continue;
            return i;
        }
        return -1;
    }

    private void addComboBoxItem(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.filterStringsBuffer.contains(string)) {
            this.filterStringsBuffer.remove(string);
        }
        this.filterStringsBuffer.add(string);
        this.updateComboItems();
    }

    private void checkRegExp() {
        if (this.filterType != 50 || this.textFieldEmptyFlag) {
            this.validRegExpFlag = true;
        } else {
            try {
                String[] stringArray;
                for (String string : stringArray = FilterComponent.getFilterStrings(this.filterStringCombo.getText())) {
                    EMPTY_STRING.matches(string);
                }
                this.validRegExpFlag = true;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.validRegExpFlag = false;
            }
        }
    }

    private void doFocusGained() {
        this.textFieldEmptyFlag = false;
        this.filterStringCombo.comboEditor.setForeground(this.textFieldForeground);
        if (this.filterStringCombo.getText().equals(this.textFieldEmptyText)) {
            this.filterStringCombo.setText(EMPTY_STRING);
        }
    }

    private void doFocusLost() {
        if (this.filterStringCombo.getText().length() == 0 && this.filterString.length() == 0) {
            this.textFieldEmptyFlag = true;
            this.filterStringCombo.setText(this.textFieldEmptyText);
            this.filterStringCombo.comboEditor.setForeground(DEFAULT_TEXTFIELD_FOREGROUND);
        }
    }

    private void fireFilterChanged() {
        if (this.validRegExpFlag) {
            for (FilterListener filterListener : this.listeners) {
                filterListener.filterChanged();
            }
        }
        this.lastFilterType = this.filterType;
    }

    private void initComponents() {
        SetClearButtonsActionListener setClearButtonsActionListener = new SetClearButtonsActionListener();
        this.filterStringCombo = UIUtils.isMetalLookAndFeel() ? new JFilterStringCombo(){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, this.comboEditor.getPreferredSize().height);
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, this.comboEditor.getPreferredSize().height);
            }

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(super.getMinimumSize().width, this.comboEditor.getPreferredSize().height);
            }
        } : new JFilterStringCombo();
        this.filterStringCombo.setEditable(true);
        Border border = UIUtils.isGTKLookAndFeel() || UIUtils.isNimbusLookAndFeel() ? BorderFactory.createBevelBorder(1) : this.filterStringCombo.getBorder();
        this.filterStringCombo.setBorder(BorderFactory.createEmptyBorder(1, 5, 1, 0));
        this.filterStringCombo.setMaximumRowCount(7);
        this.filterStringCombo.addActionListener(new FilterStringComboActionListener());
        this.filterStringCombo.getAccessibleContext().setAccessibleName(FILTER_STRING_COMBO_ACCESS_NAME);
        this.filterStringCombo.getAccessibleContext().setAccessibleDescription(FILTER_STRING_COMBO_ACCESS_DESCR);
        this.filterStringCombo.setToolTipText(FILTER_VALUE_TOOLTIP);
        JTextComponent jTextComponent = this.filterStringCombo.comboEditor;
        Color color = jTextComponent.getBackground();
        this.textFieldForeground = jTextComponent.getForeground();
        this.filterStringCombo.setBackground(color);
        jTextComponent.setForeground(DEFAULT_TEXTFIELD_FOREGROUND);
        jTextComponent.setText(this.textFieldEmptyText);
        jTextComponent.getDocument().addDocumentListener(new FilterTextFieldDocumentListener());
        jTextComponent.addKeyListener(new FilterTextFieldKeyListener());
        jTextComponent.addFocusListener(new FilterTextFieldFocusListener());
        this.filterTypeButton = new JButton(EMPTY_STRING);
        this.filterTypeButton.setFocusable(false);
        this.filterTypeButton.setBorder(BorderFactory.createEmptyBorder());
        this.filterTypeButton.setBackground(color);
        this.filterTypeButton.setContentAreaFilled(false);
        this.filterTypeButton.addMouseListener(new FilterTypeButtonMouseListener());
        this.incorrectRegExpLabel = new JLabel(INVALID_REGEXP_STRING);
        this.incorrectRegExpLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        this.incorrectRegExpLabel.setBackground(color);
        this.incorrectRegExpLabel.setForeground(Color.RED);
        this.textFieldRegExpWarningPanel = new JPanel(new BorderLayout(0, 0));
        this.textFieldRegExpWarningPanel.setBackground(color);
        this.textFieldRegExpWarningPanel.add((Component)this.filterStringCombo, "Center");
        this.textFieldRegExpWarningPanel.add((Component)this.incorrectRegExpLabel, "East");
        this.setFilterButton = new JButton(EMPTY_STRING);
        this.setFilterButton.setIcon(this.setFilterIcon);
        this.setFilterButton.setRolloverIcon(this.setFilterRolloverIcon);
        this.setFilterButton.setFocusable(false);
        this.setFilterButton.setBorder(BorderFactory.createEmptyBorder());
        this.setFilterButton.setBackground(color);
        this.setFilterButton.setContentAreaFilled(false);
        this.setFilterButton.addActionListener(setClearButtonsActionListener);
        this.setFilterButton.setToolTipText(SET_FILTER_BUTTON_TOOLTIP);
        this.clearFilterButton = new JButton(EMPTY_STRING);
        this.clearFilterButton.setIcon(this.clearFilterIcon);
        this.clearFilterButton.setRolloverIcon(this.clearFilterRolloverIcon);
        this.clearFilterButton.setFocusable(false);
        this.clearFilterButton.setBorder(BorderFactory.createEmptyBorder());
        this.clearFilterButton.setBackground(color);
        this.clearFilterButton.setContentAreaFilled(false);
        this.clearFilterButton.addActionListener(setClearButtonsActionListener);
        this.clearFilterButton.setToolTipText(CLEAR_FILTER_BUTTON_TOOLTIP);
        this.setClearFilterButtonsPanel = new JPanel(new BorderLayout(0, 0));
        this.setClearFilterButtonsPanel.setBackground(color);
        this.setClearFilterButtonsPanel.add((Component)this.setFilterButton, "West");
        this.setClearFilterButtonsPanel.add((Component)this.clearFilterButton, "East");
        this.filterTypePopup = new JPopupMenu(){

            @Override
            public void setVisible(boolean bl) {
                super.setVisible(bl);
                if (bl) {
                    MenuElement[] menuElementArray = FilterComponent.this.activeFilterItem != null ? new MenuElement[]{this, FilterComponent.this.activeFilterItem} : new MenuElement[]{this};
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
                }
            }
        };
        this.filterTypePopup.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.filterTypePopup.setBackground(UIUtils.getProfilerResultsBackground());
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.setBackground(color);
        this.add((Component)this.filterTypeButton, "West");
        this.add((Component)this.textFieldRegExpWarningPanel, "Center");
        this.add((Component)this.setClearFilterButtonsPanel, "East");
        this.getAccessibleContext().setAccessibleName(ACCESS_NAME);
        this.getAccessibleContext().setAccessibleDescription(ACCESS_DESCR);
    }

    private void performClearFilterButtonAction() {
        this.filterString = EMPTY_STRING;
        this.filterStringCombo.setText(this.filterString);
        this.setFilterType(this.defaultFilterType, false);
        this.fireFilterChanged();
        this.updateSetClearButtons();
    }

    private void performSetFilterButtonAction() {
        this.filterStringCombo.setText(this.filterStringCombo.getText().trim());
        String string = this.filterStringCombo.getText();
        if (!string.equals(this.filterString) || this.lastFilterType != this.filterType) {
            this.filterString = string;
            this.addComboBoxItem(this.filterString);
            this.fireFilterChanged();
            this.updateSetClearButtons();
        }
    }

    private void updateComboItems() {
        String string = this.filterStringCombo.getText();
        this.filterStringCombo.removeAllItems();
        for (String string2 : this.filterStringsBuffer) {
            this.filterStringCombo.addItem(string2);
        }
        this.filterStringCombo.setText(string);
    }

    private void updateSetClearButtons() {
        if (this.validRegExpFlag) {
            if (this.incorrectRegExpLabel.isVisible()) {
                this.incorrectRegExpLabel.setVisible(false);
            }
        } else {
            if (!this.incorrectRegExpLabel.isVisible()) {
                this.incorrectRegExpLabel.setVisible(true);
            }
            if (this.clearFilterButton.isVisible()) {
                this.clearFilterButton.setVisible(false);
            }
            if (this.setFilterButton.isVisible()) {
                this.setFilterButton.setVisible(false);
            }
            this.updateSetClearFilterButtonsPanelBorder();
            return;
        }
        if (this.textFieldEmptyFlag) {
            if (this.clearFilterButton.isVisible()) {
                this.clearFilterButton.setVisible(false);
            }
            if (this.setFilterButton.isVisible()) {
                this.setFilterButton.setVisible(false);
            }
            this.updateSetClearFilterButtonsPanelBorder();
            return;
        }
        if (this.filterString.length() == 0) {
            if (this.clearFilterButton.isVisible()) {
                this.clearFilterButton.setVisible(false);
            }
        } else if (!this.clearFilterButton.isVisible()) {
            this.clearFilterButton.setVisible(true);
        }
        if (this.filterStringCombo.getText().equals(this.filterString) && this.lastFilterType == this.filterType || this.filterStringCombo.getText().length() == 0) {
            if (this.setFilterButton.isVisible()) {
                this.setFilterButton.setVisible(false);
            }
        } else if (!this.setFilterButton.isVisible()) {
            if (this.clearFilterButton.isVisible()) {
                ((BorderLayout)this.setClearFilterButtonsPanel.getLayout()).setHgap(1);
            } else {
                ((BorderLayout)this.setClearFilterButtonsPanel.getLayout()).setHgap(0);
            }
            this.setFilterButton.setVisible(true);
        }
        this.updateSetClearFilterButtonsPanelBorder();
    }

    private void updateSetClearFilterButtonsPanelBorder() {
        if (this.clearFilterButton.isVisible() || this.setFilterButton.isVisible()) {
            this.setClearFilterButtonsPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        } else {
            this.setClearFilterButtonsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
    }

    private class SetClearButtonsActionListener
    implements ActionListener {
        private SetClearButtonsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == FilterComponent.this.setFilterButton) {
                FilterComponent.this.performSetFilterButtonAction();
                FilterComponent.this.filterStringCombo.requestFocus();
                return;
            }
            if (actionEvent.getSource() == FilterComponent.this.clearFilterButton) {
                FilterComponent.this.performClearFilterButtonAction();
                FilterComponent.this.filterStringCombo.requestFocus();
                return;
            }
        }
    }

    private class PopupItemsListener
    implements ActionListener {
        private PopupItemsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FilterComponent.this.setFilterTypePopupItemActive((JMenuItem)actionEvent.getSource(), false);
            FilterComponent.this.filterStringCombo.requestFocus();
        }
    }

    private class JFilterStringCombo
    extends JComboBox {
        public JTextComponent comboEditor = (JTextComponent)this.getEditor().getEditorComponent();
        public boolean comboPopupActionFlag = false;
        public boolean comboPopupKeyFlag = false;

        public JFilterStringCombo() {
            this.setRenderer(new FilterStringComboRenderer());
            this.addPopupMenuListener(new FilterStringComboPopupMenuListener());
        }

        public void setText(String string) {
            this.comboEditor.setText(string);
        }

        public String getText() {
            return this.comboEditor.getText();
        }

        public void clearSelection() {
            this.comboEditor.setSelectionStart(this.comboEditor.getCaretPosition());
            this.comboEditor.setSelectionEnd(this.comboEditor.getCaretPosition());
        }
    }

    private class FilterTypeButtonMouseListener
    extends MouseAdapter {
        private FilterTypeButtonMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            FilterComponent.this.filterTypePopup.show(FilterComponent.this, 1, FilterComponent.this.getHeight() - 2);
        }
    }

    private class FilterTextFieldKeyListener
    extends KeyAdapter {
        private FilterTextFieldKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            ((FilterComponent)FilterComponent.this).filterStringCombo.comboPopupKeyFlag = true;
            if (keyEvent.getKeyCode() == 10) {
                FilterComponent.this.performSetFilterButtonAction();
                FilterComponent.this.filterStringCombo.clearSelection();
                return;
            }
            if (keyEvent.getKeyCode() == 27) {
                FilterComponent.this.filterStringCombo.setText(FilterComponent.this.filterString);
                FilterComponent.this.updateSetClearButtons();
                return;
            }
            if (keyEvent.getModifiers() == 1 && (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40)) {
                FilterComponent.this.filterTypePopup.show(FilterComponent.this, 1, FilterComponent.this.getHeight() - 2);
                return;
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            ((FilterComponent)FilterComponent.this).filterStringCombo.comboPopupKeyFlag = false;
        }
    }

    private class FilterTextFieldFocusListener
    implements FocusListener {
        private FilterTextFieldFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            FilterComponent.this.doFocusGained();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            FilterComponent.this.doFocusLost();
        }
    }

    private class FilterTextFieldDocumentListener
    implements DocumentListener {
        private FilterTextFieldDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            if (((FilterComponent)FilterComponent.this).filterStringCombo.comboPopupActionFlag) {
                return;
            }
            FilterComponent.this.checkRegExp();
            FilterComponent.this.updateSetClearButtons();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (((FilterComponent)FilterComponent.this).filterStringCombo.comboPopupActionFlag) {
                return;
            }
            FilterComponent.this.checkRegExp();
            FilterComponent.this.updateSetClearButtons();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (((FilterComponent)FilterComponent.this).filterStringCombo.comboPopupActionFlag) {
                return;
            }
            FilterComponent.this.checkRegExp();
            FilterComponent.this.updateSetClearButtons();
        }
    }

    private static class FilterStringComboRenderer
    extends DefaultListCellRenderer {
        private JSeparator separator = new JSeparator();

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JComponent jComponent = (JComponent)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            jComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0), jComponent.getBorder()));
            return jComponent;
        }
    }

    private class FilterStringComboPopupMenuListener
    implements PopupMenuListener {
        private FilterStringComboPopupMenuListener() {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            ((FilterComponent)FilterComponent.this).filterStringCombo.comboPopupActionFlag = false;
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            ((FilterComponent)FilterComponent.this).filterStringCombo.comboPopupActionFlag = false;
            FilterComponent.this.filterStringCombo.clearSelection();
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            ((FilterComponent)FilterComponent.this).filterStringCombo.comboPopupActionFlag = true;
        }
    }

    private class FilterStringComboActionListener
    implements ActionListener {
        private FilterStringComboActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (FilterComponent.this.internalChange) {
                return;
            }
            String string = (String)FilterComponent.this.filterStringCombo.getSelectedItem();
            if (string == null || string.equals(FilterComponent.EMPTY_STRING)) {
                return;
            }
            if (((FilterComponent)FilterComponent.this).filterStringCombo.comboPopupKeyFlag || !((FilterComponent)FilterComponent.this).filterStringCombo.comboPopupActionFlag) {
                return;
            }
            FilterComponent.this.setFilterString(string);
            FilterComponent.this.updateSetClearButtons();
        }
    }

    private static class ButtonBorderIcon
    implements Icon {
        private Color BUTTON_BORDER_DARK = new Color(115, 115, 115);
        private Color BUTTON_BORDER_LIGHT = new Color(204, 204, 204);
        private Icon icon;

        public ButtonBorderIcon(Icon icon) {
            this.icon = icon;
        }

        @Override
        public int getIconHeight() {
            return this.icon.getIconHeight();
        }

        @Override
        public int getIconWidth() {
            return this.icon.getIconWidth();
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.icon.paintIcon(component, graphics, n, n2);
            graphics.setColor(this.BUTTON_BORDER_DARK);
            graphics.drawLine(n + this.icon.getIconWidth() - 1, n2, n + this.icon.getIconWidth() - 1, n2 + this.icon.getIconHeight() - 1);
            graphics.drawLine(n, n2 + this.icon.getIconHeight() - 1, n + this.icon.getIconWidth() - 1, n2 + this.icon.getIconHeight() - 1);
            graphics.setColor(this.BUTTON_BORDER_LIGHT);
            graphics.drawLine(n, n2, n + this.icon.getIconWidth() - 1, n2);
            graphics.drawLine(n, n2, n, n2 + this.icon.getIconHeight() - 1);
        }
    }

    private static class ArrowSignIcon
    implements Icon {
        private final Icon popupArrowIcon = Icons.getIcon((String)"GeneralIcons.PopupArrow");
        private Icon icon;

        public ArrowSignIcon(Icon icon) {
            this.icon = icon;
        }

        @Override
        public int getIconHeight() {
            return this.icon.getIconHeight();
        }

        @Override
        public int getIconWidth() {
            return this.icon.getIconWidth();
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.icon.paintIcon(component, graphics, n, n2);
            this.popupArrowIcon.paintIcon(component, graphics, n + this.icon.getIconWidth() - this.popupArrowIcon.getIconWidth(), n2 + this.icon.getIconHeight() - this.popupArrowIcon.getIconHeight());
        }
    }

    public static interface FilterListener {
        public void filterChanged();
    }
}

