/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.slides;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.ModeView;
import org.netbeans.core.windows.view.SlidingView;
import org.netbeans.core.windows.view.ViewElement;
import org.netbeans.core.windows.view.dnd.TopComponentDraggable;
import org.netbeans.core.windows.view.dnd.TopComponentDroppable;
import org.netbeans.core.windows.view.dnd.WindowDnDManager;
import org.netbeans.core.windows.view.ui.AbstractModeContainer;
import org.netbeans.core.windows.view.ui.ModeComponent;
import org.netbeans.core.windows.view.ui.Tabbed;
import org.netbeans.core.windows.view.ui.slides.TabbedSlideAdapter;
import org.openide.windows.TopComponent;

public final class SlideBarContainer
extends AbstractModeContainer {
    VisualPanel panel = new VisualPanel(this);
    private static final boolean isAqua = "Aqua".equals(UIManager.getLookAndFeel().getID());
    private static Border bottomBorder;
    private static Border bottomEmptyBorder;
    private static Border leftEmptyBorder;
    private static Border leftBorder;
    private static Border rightEmptyBorder;
    private static Border rightBorder;
    private static Border topEmptyBorder;
    private static Border topBorder;

    public SlideBarContainer(ModeView modeView, WindowDnDManager windowDnDManager) {
        super(modeView, windowDnDManager, 2);
        this.panel.setBorder(SlideBarContainer.computeBorder(this.getSlidingView().getSide()));
        this.panel.add(this.tabbedHandler.getComponent(), "Center");
    }

    private SlidingView getSlidingView() {
        return (SlidingView)super.getModeView();
    }

    @Override
    public void requestAttention(TopComponent topComponent) {
        this.tabbedHandler.requestAttention(topComponent);
    }

    @Override
    public void cancelRequestAttention(TopComponent topComponent) {
        this.tabbedHandler.cancelRequestAttention(topComponent);
    }

    @Override
    public void setTopComponents(TopComponent[] topComponentArray, TopComponent topComponent) {
        super.setTopComponents(topComponentArray, topComponent);
    }

    public Rectangle getTabBounds(int n) {
        return this.tabbedHandler.getTabBounds(n);
    }

    @Override
    protected Component getModeComponent() {
        return this.panel;
    }

    @Override
    protected Tabbed createTabbed() {
        return new TabbedSlideAdapter(((SlidingView)this.modeView).getSide());
    }

    @Override
    protected boolean isAttachingPossible() {
        return false;
    }

    @Override
    protected TopComponentDroppable getModeDroppable() {
        return this.panel;
    }

    @Override
    protected void updateActive(boolean bl) {
        Window window;
        if (bl && (window = SwingUtilities.getWindowAncestor(this.panel)) != null && !window.isActive() && WindowManagerImpl.getInstance().getEditorAreaState() == 1) {
            window.toFront();
        }
    }

    @Override
    public boolean isActive() {
        Window window = SwingUtilities.getWindowAncestor(this.panel);
        return window == null ? false : window.isActive();
    }

    @Override
    protected void updateTitle(String string) {
    }

    private static Border computeBorder(String string) {
        if (isAqua) {
            return BorderFactory.createEmptyBorder();
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if ("left".equals(string)) {
            n4 = 1;
            n2 = 1;
            n = 1;
            n3 = 2;
        }
        if ("bottom".equals(string)) {
            n4 = 2;
            n2 = 1;
            n = 1;
            n3 = 1;
        }
        if ("top".equals(string)) {
            n4 = 1;
            n2 = 1;
            n = 2;
            n3 = 1;
        }
        if ("right".equals(string)) {
            n4 = 1;
            n2 = 2;
            n = 1;
            n3 = 1;
        }
        return new EmptyBorder(n4, n2, n, n3);
    }

    private static class VisualPanel
    extends JPanel
    implements ModeComponent,
    TopComponentDroppable {
        private final SlideBarContainer modeContainer;
        private final String side;

        public VisualPanel(SlideBarContainer slideBarContainer) {
            super(new BorderLayout());
            this.modeContainer = slideBarContainer;
            this.enableEvents(16L);
            this.side = slideBarContainer.getSlidingView().getSide();
            if (isAqua) {
                this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                this.setOpaque(true);
            }
            if (UIManager.getBoolean("NbMainWindow.showCustomBackground")) {
                this.setOpaque(false);
            }
        }

        @Override
        public ModeView getModeView() {
            return this.modeContainer.getModeView();
        }

        @Override
        public int getKind() {
            return this.modeContainer.getKind();
        }

        @Override
        public Shape getIndicationForLocation(Point point) {
            return this.modeContainer.getIndicationForLocation(point);
        }

        @Override
        public Object getConstraintForLocation(Point point) {
            return this.modeContainer.getConstraintForLocation(point);
        }

        @Override
        public Component getDropComponent() {
            return this.modeContainer.getDropComponent();
        }

        @Override
        public ViewElement getDropViewElement() {
            return this.modeContainer.getDropModeView();
        }

        @Override
        public boolean canDrop(TopComponentDraggable topComponentDraggable, Point point) {
            return this.modeContainer.canDrop(topComponentDraggable) && !topComponentDraggable.isModeTransfer();
        }

        @Override
        public boolean supportsKind(TopComponentDraggable topComponentDraggable) {
            if (topComponentDraggable.isModeTransfer()) {
                return false;
            }
            if (topComponentDraggable.isAllowedToMoveAnywhere()) {
                return true;
            }
            boolean bl = topComponentDraggable.getKind() == 0 || topComponentDraggable.getKind() == 2;
            boolean bl2 = this.getKind() == 0 || this.getKind() == 2;
            return bl == bl2;
        }

        @Override
        public Dimension getMinimumSize() {
            if (this.modeContainer.getTopComponents().length == 0) {
                Border border = this.getBorder();
                if (null != border) {
                    Insets insets = border.getBorderInsets(this);
                    return new Dimension(Math.max(1, insets.left + insets.right), Math.max(1, insets.top + insets.bottom));
                }
                return new Dimension(1, 1);
            }
            return super.getMinimumSize();
        }

        @Override
        public Dimension getPreferredSize() {
            if (isAqua && this.modeContainer.getTopComponents().length == 0) {
                return this.getMinimumSize();
            }
            return super.getPreferredSize();
        }

        @Override
        public Border getBorder() {
            if (!isAqua || null == this.modeContainer) {
                return super.getBorder();
            }
            Border border = "bottom".equals(this.side) ? (this.modeContainer.getTopComponents().length == 0 ? bottomEmptyBorder : bottomBorder) : ("top".equals(this.side) ? (this.modeContainer.getTopComponents().length == 0 ? topEmptyBorder : topBorder) : ("right".equals(this.side) ? (this.modeContainer.getTopComponents().length == 0 ? rightEmptyBorder : rightBorder) : ("left".equals(this.side) ? (this.modeContainer.getTopComponents().length == 0 ? leftEmptyBorder : leftBorder) : BorderFactory.createEmptyBorder())));
            return border;
        }

        static {
            if (isAqua) {
                bottomBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("NbBrushedMetal.darkShadow")), BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(187, 187, 187)));
                bottomEmptyBorder = BorderFactory.createMatteBorder(3, 0, 0, 0, UIManager.getColor("NbSplitPane.background"));
                topBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("NbBrushedMetal.darkShadow")), BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(187, 187, 187)));
                topEmptyBorder = BorderFactory.createMatteBorder(0, 0, 3, 0, UIManager.getColor("NbSplitPane.background"));
                leftEmptyBorder = BorderFactory.createMatteBorder(0, 0, 0, 3, UIManager.getColor("NbSplitPane.background"));
                leftBorder = BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(leftEmptyBorder, BorderFactory.createMatteBorder(0, 0, 0, 1, UIManager.getColor("NbBrushedMetal.darkShadow"))), BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("NbBrushedMetal.lightShadow")));
                rightEmptyBorder = BorderFactory.createMatteBorder(0, 3, 0, 0, UIManager.getColor("NbSplitPane.background"));
                rightBorder = BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(rightEmptyBorder, BorderFactory.createMatteBorder(0, 1, 0, 0, UIManager.getColor("NbBrushedMetal.darkShadow"))), BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("NbBrushedMetal.lightShadow")));
            }
        }
    }
}

