/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.openide.util.NbPreferences;
import org.openide.util.WeakSet;
import org.openide.windows.TopComponent;

public final class TopComponentTracker {
    private final Set<String> viewIds = new HashSet<String>(30);
    private final Set<String> editorIds = new HashSet<String>(30);
    private final Set<TopComponent> editors = new WeakSet(100);
    private static TopComponentTracker theInstance;

    private TopComponentTracker() {
    }

    public static synchronized TopComponentTracker getDefault() {
        if (null == theInstance) {
            theInstance = new TopComponentTracker();
        }
        return theInstance;
    }

    void clear() {
        this.viewIds.clear();
    }

    void load() {
        Preferences preferences = this.getPreferences();
        try {
            for (String string : preferences.keys()) {
                boolean bl = preferences.getBoolean(string, false);
                if (bl) {
                    this.viewIds.add(string);
                    continue;
                }
                this.editorIds.add(string);
            }
        }
        catch (BackingStoreException backingStoreException) {
            Logger.getLogger(TopComponentTracker.class.getName()).log(Level.INFO, null, backingStoreException);
        }
    }

    void save() {
        Preferences preferences = this.getPreferences();
        try {
            preferences.clear();
        }
        catch (BackingStoreException backingStoreException) {
            Logger.getLogger(TopComponentTracker.class.getName()).log(Level.INFO, null, backingStoreException);
        }
        for (String string : this.viewIds) {
            preferences.putBoolean(string, true);
        }
        for (String string : this.editorIds) {
            preferences.putBoolean(string, false);
        }
    }

    void add(TopComponent topComponent, ModeImpl modeImpl) {
        if (topComponent.getPersistenceType() == 2) {
            return;
        }
        String string = WindowManagerImpl.getInstance().findTopComponentID(topComponent);
        if (null == string) {
            return;
        }
        if (this.viewIds.contains(string) || this.editorIds.contains(string)) {
            return;
        }
        if (modeImpl.getKind() != 1) {
            if (this.editors.contains(topComponent)) {
                this.editorIds.add(string);
            } else {
                this.viewIds.add(string);
            }
        } else {
            this.editors.add(topComponent);
        }
    }

    void add(String string, ModeImpl modeImpl) {
        if (this.viewIds.contains(string) || this.editorIds.contains(string)) {
            return;
        }
        if (modeImpl.getKind() != 1) {
            this.viewIds.add(string);
        }
    }

    public boolean isEditorTopComponent(TopComponent topComponent) {
        return !this.isViewTopComponent(topComponent);
    }

    public boolean isViewTopComponent(TopComponent topComponent) {
        if (topComponent.getPersistenceType() == 2) {
            ModeImpl modeImpl = (ModeImpl)WindowManagerImpl.getInstance().findMode(topComponent);
            return null != modeImpl && modeImpl.getKind() != 1;
        }
        String string = WindowManagerImpl.getInstance().findTopComponentID(topComponent);
        return string != null && this.viewIds.contains(string);
    }

    private Preferences getPreferences() {
        Preferences preferences = NbPreferences.forModule(TopComponentTracker.class).node("tctracker");
        String string = WindowManagerImpl.getInstance().getRole();
        if (null != string) {
            preferences = preferences.node(string);
        }
        return preferences;
    }
}

