/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.Cursor;
import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.results.ProfilingResultsDispatcher;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.coderegion.CodeRegionResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ResultsListener;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.SnapshotsDiffWindow;
import org.netbeans.modules.profiler.SnapshotsListener;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.project.ProjectStorage;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public final class ResultsManager {
    private static final Logger LOGGER = Logger.getLogger(ResultsManager.class.getName());
    private static final String PROFILED_APP_TERMINATED_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_ProfiledAppTerminatedMsg");
    private static final String DATA_NOT_AVAILABLE_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_DataNotAvailableMsg");
    private static final String OUT_OF_MEMORY_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_OutOfMemoryMsg");
    private static final String SNAPSHOT_DELETE_FAILED_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SnapshotDeleteFailedMsg");
    private static final String SNAPSHOT_SAVE_FAILED_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SnapshotSaveFailedMsg");
    private static final String CANT_FIND_SNAPSHOT_LOCATION_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_CantFindSnapshotLocationMsg");
    private static final String SNAPSHOT_CREATE_IN_PROJECT_FAILED_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SnapshotCreateInProjectFailedMsg");
    private static final String SNAPSHOT_LOAD_FAILED_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SnapshotLoadFailedMsg");
    private static final String SNAPSHOTS_LOAD_FAILED_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SnapshotsLoadFailedMsg");
    private static final String OBTAIN_SAVED_SNAPSHOTS_FAILED_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_ObtainSavedSnapshotsFailedMsg");
    private static final String SELECT_DIR_DIALOG_CAPTION = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SelectDirDialogCaption");
    private static final String SAVE_BUTTON_NAME = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SaveButtonName");
    private static final String OVERWRITE_FILE_DIALOG_CAPTION = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_OverwriteFileDialogCaption");
    private static final String OVERWRITE_FILE_DIALOG_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_OverwriteFileDialogMsg");
    private static final String FILE_DELETE_FAILED_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_FileDeleteFailedMsg");
    private static final String SNAPSHOT_EXPORT_FAILED_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SnapshotExportFailedMsg");
    private static final String SAVE_SNAPSHOTS_DIALOG_CAPTION = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SaveSnapshotsDialogCaption");
    private static final String SAVE_SNAPSHOTS_DIALOG_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SaveSnapshotsDialogMsg");
    private static final String SELECT_FILE_OR_DIR_DIALOG_CAPTION = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SelectFileOrDirDialogCaption");
    private static final String PROFILER_SNAPSHOT_FILE_FILTER = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_ProfilerSnapshotFileFilter");
    private static final String PROFILER_HEAPDUMP_FILE_FILTER = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_ProfilerHeapdumpFileFilter");
    private static final String SNAPSHOT_CREATE_FAILED_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SnapshotCreateFailedMsg");
    private static final String OUT_OF_MEMORY_SAVING = NbBundle.getMessage(LoadedSnapshot.class, (String)"ResultsManager_OutOfMemorySavingMsg");
    private static final String CANNOT_COMPARE_SNAPSHOTS_MSG = NbBundle.getMessage(LoadedSnapshot.class, (String)"ResultsManager_CannotCompareSnapshotsMsg");
    private static final String DIRECTORY_DOESNT_EXIST_CAPTION = NbBundle.getMessage(LoadedSnapshot.class, (String)"ResultsManager_DirectoryDoesntExistCaption");
    private static final String DIRECTORY_DOESNT_EXIST_MSG = NbBundle.getMessage(LoadedSnapshot.class, (String)"ResultsManager_DirectoryDoesntExistMsg");
    private static final String CANNOT_OPEN_SNAPSHOT_MSG = NbBundle.getMessage(LoadedSnapshot.class, (String)"ResultsManager_CannotOpenSnapshotMsg");
    public static final String SNAPSHOT_EXTENSION = "nps";
    public static final String HEAPDUMP_EXTENSION = "hprof";
    public static final String STACKTRACES_SNAPSHOT_EXTENSION = "npss";
    private ArrayList<LoadedSnapshot> loadedSnapshots = new ArrayList();
    private File exportDir;
    private HashMap<FileObject, ProfilingSettings> settingsCache = new HashMap();
    private HashMap<FileObject, Integer> typeCache = new HashMap();
    private Window mainWindow;
    private boolean resultsAvailable = false;
    private Lookup.Result<SnapshotsListener> snapshotListeners;
    private Lookup.Result<ResultsListener> resultsListeners;
    private static final String HPROF_HEADER = "JAVA PROFILE 1.0";
    private static final long MIN_HPROF_SIZE = 0x100000L;

    private ResultsManager() {
        Lookup lookup = Lookup.getDefault();
        this.snapshotListeners = lookup.lookupResult(SnapshotsListener.class);
        this.resultsListeners = lookup.lookupResult(ResultsListener.class);
    }

    public static ResultsManager getDefault() {
        return Singleton.INSTANCE;
    }

    public String getDefaultSnapshotFileName(LoadedSnapshot loadedSnapshot) {
        return "snapshot-" + loadedSnapshot.getSnapshot().getTimeTaken();
    }

    public LoadedSnapshot[] getLoadedSnapshots() {
        return this.loadedSnapshots.toArray(new LoadedSnapshot[0]);
    }

    public LoadedSnapshot getSnapshotFromFileObject(FileObject fileObject) {
        LoadedSnapshot loadedSnapshot = this.findAlreadyLoadedSnapshot(fileObject);
        if (loadedSnapshot != null) {
            return loadedSnapshot;
        }
        try {
            return this.loadSnapshotFromFileObject(fileObject);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, null, iOException);
            return null;
        }
    }

    public ProfilingSettings getSnapshotSettings(FileObject fileObject) {
        ProfilingSettings profilingSettings = this.settingsCache.get(fileObject);
        if (profilingSettings == null && !this.settingsCache.containsKey(fileObject)) {
            profilingSettings = this.readSettingsFromFile(fileObject);
            this.settingsCache.put(fileObject, profilingSettings);
        }
        return profilingSettings;
    }

    public int getSnapshotType(FileObject fileObject) {
        Integer n = this.typeCache.get(fileObject);
        if (n == null) {
            n = this.readTypeFromFile(fileObject);
            this.typeCache.put(fileObject, n);
        }
        return n;
    }

    public void cctEstablished(RuntimeCCTNode runtimeCCTNode) {
        if (NetBeansProfiler.getDefaultNB().getProfilingState() == 1) {
            return;
        }
        this.resultsAvailable = true;
        this.fireResultsAvailable();
    }

    public void cctReset() {
        this.resultsAvailable = false;
        this.fireResultsReset();
    }

    public void closeSnapshot(LoadedSnapshot loadedSnapshot) {
        if (loadedSnapshot != null) {
            this.loadedSnapshots.remove(loadedSnapshot);
            this.fireSnapshotRemoved(loadedSnapshot);
        }
    }

    public void compareSnapshots(FileObject fileObject, FileObject fileObject2) {
        LoadedSnapshot loadedSnapshot = null;
        LoadedSnapshot loadedSnapshot2 = null;
        try {
            loadedSnapshot = this.findAlreadyLoadedSnapshot(fileObject);
            if (loadedSnapshot == null) {
                loadedSnapshot = this.loadSnapshotFromFileObject(fileObject);
            }
            if ((loadedSnapshot2 = this.findAlreadyLoadedSnapshot(fileObject2)) == null) {
                loadedSnapshot2 = this.loadSnapshotFromFileObject(fileObject2);
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, MessageFormat.format(SNAPSHOT_LOAD_FAILED_MSG, exception.getMessage()), exception);
            return;
        }
        if (loadedSnapshot != null && loadedSnapshot2 != null) {
            this.compareSnapshots(loadedSnapshot, loadedSnapshot2);
        } else {
            ProfilerDialogs.displayError((String)SNAPSHOTS_LOAD_FAILED_MSG);
        }
    }

    public void compareSnapshots(LoadedSnapshot loadedSnapshot, LoadedSnapshot loadedSnapshot2) {
        AllocMemoryResultsDiff allocMemoryResultsDiff = null;
        if (loadedSnapshot.getSnapshot() instanceof AllocMemoryResultsSnapshot && loadedSnapshot2.getSnapshot() instanceof AllocMemoryResultsSnapshot) {
            allocMemoryResultsDiff = new AllocMemoryResultsDiff((AllocMemoryResultsSnapshot)loadedSnapshot.getSnapshot(), (AllocMemoryResultsSnapshot)loadedSnapshot2.getSnapshot());
        } else if (loadedSnapshot.getSnapshot() instanceof LivenessMemoryResultsSnapshot && loadedSnapshot2.getSnapshot() instanceof LivenessMemoryResultsSnapshot) {
            allocMemoryResultsDiff = new LivenessMemoryResultsDiff((LivenessMemoryResultsSnapshot)loadedSnapshot.getSnapshot(), (LivenessMemoryResultsSnapshot)loadedSnapshot2.getSnapshot());
        }
        if (allocMemoryResultsDiff != null) {
            SnapshotsDiffWindow snapshotsDiffWindow = SnapshotsDiffWindow.get(allocMemoryResultsDiff, loadedSnapshot, loadedSnapshot2);
            snapshotsDiffWindow.open();
            snapshotsDiffWindow.requestActive();
        } else {
            ProfilerDialogs.displayError((String)MessageFormat.format(CANNOT_COMPARE_SNAPSHOTS_MSG, loadedSnapshot.getFile().getName(), loadedSnapshot2.getFile().getName()));
        }
    }

    public void deleteSnapshot(FileObject fileObject) {
        LoadedSnapshot loadedSnapshot = this.findLoadedSnapshot(FileUtil.toFile((FileObject)fileObject));
        try {
            fileObject.delete();
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, MessageFormat.format(SNAPSHOT_DELETE_FAILED_MSG, iOException.getMessage()), iOException);
            return;
        }
        if (loadedSnapshot != null) {
            this.loadedSnapshots.remove(loadedSnapshot);
            this.fireSnapshotRemoved(loadedSnapshot);
        }
    }

    public void exportSnapshots(FileObject[] fileObjectArray) {
        assert (fileObjectArray != null);
        assert (fileObjectArray.length > 0);
        if (fileObjectArray.length == 1) {
            SelectedFile selectedFile = this.selectSnapshotTargetFile(fileObjectArray[0].getName(), fileObjectArray[0].getExt().equals(HEAPDUMP_EXTENSION));
            if (selectedFile != null && this.checkFileExists(selectedFile)) {
                this.exportSnapshot(fileObjectArray[0], selectedFile.folder, selectedFile.fileName, selectedFile.fileExt);
            }
        } else {
            JFileChooser jFileChooser = new JFileChooser();
            if (this.exportDir != null) {
                jFileChooser.setCurrentDirectory(this.exportDir);
            }
            jFileChooser.setDialogTitle(SELECT_DIR_DIALOG_CAPTION);
            jFileChooser.setApproveButtonText(SAVE_BUTTON_NAME);
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setMultiSelectionEnabled(false);
            if (jFileChooser.showSaveDialog(WindowManager.getDefault().getMainWindow()) == 0) {
                File file = jFileChooser.getSelectedFile();
                if (!file.exists()) {
                    if (!ProfilerDialogs.displayConfirmation((String)DIRECTORY_DOESNT_EXIST_MSG, (String)DIRECTORY_DOESNT_EXIST_CAPTION)) {
                        return;
                    }
                    file.mkdir();
                }
                this.exportDir = file;
                FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
                for (int i = 0; i < fileObjectArray.length; ++i) {
                    this.exportSnapshot(fileObjectArray[i], fileObject, fileObjectArray[i].getName(), fileObjectArray[i].getExt());
                }
            }
        }
    }

    public LoadedSnapshot findLoadedSnapshot(ResultsSnapshot resultsSnapshot) {
        for (LoadedSnapshot loadedSnapshot : this.loadedSnapshots) {
            if (loadedSnapshot.getSnapshot() != resultsSnapshot) continue;
            return loadedSnapshot;
        }
        return null;
    }

    public LoadedSnapshot findLoadedSnapshot(File file) {
        for (LoadedSnapshot loadedSnapshot : this.loadedSnapshots) {
            if (loadedSnapshot.getFile() == null || !loadedSnapshot.getFile().equals(file)) continue;
            return loadedSnapshot;
        }
        return null;
    }

    public boolean ideClosing() {
        Object object;
        Iterator<LoadedSnapshot> iterator = this.loadedSnapshots.iterator();
        ArrayList<LoadedSnapshot> arrayList = new ArrayList<LoadedSnapshot>();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (((LoadedSnapshot)object).isSaved()) continue;
            arrayList.add((LoadedSnapshot)object);
        }
        if (arrayList.size() > 0) {
            object = ProfilerDialogs.displayCancellableConfirmation((String)MessageFormat.format(SAVE_SNAPSHOTS_DIALOG_MSG, "" + arrayList.size()), (String)SAVE_SNAPSHOTS_DIALOG_CAPTION);
            if (Boolean.TRUE.equals(object)) {
                for (LoadedSnapshot loadedSnapshot : arrayList) {
                    this.saveSnapshot(loadedSnapshot);
                }
                return true;
            }
            return Boolean.FALSE.equals(object);
        }
        return true;
    }

    public static boolean checkHprofFile(File file) {
        try {
            if (file.isFile() && file.canRead() && file.length() > 0x100000L) {
                byte[] byArray = new byte[HPROF_HEADER.length() + 4];
                RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
                randomAccessFile.readFully(byArray);
                randomAccessFile.close();
                if (new String(byArray).startsWith(HPROF_HEADER)) {
                    return true;
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        return false;
    }

    public FileObject[] listSavedHeapdumps(Lookup.Provider provider, File file) {
        try {
            FileObject fileObject = null;
            fileObject = provider == null && file != null ? FileUtil.toFileObject((File)file) : ProjectStorage.getSettingsFolder((Lookup.Provider)provider, (boolean)false);
            if (fileObject == null) {
                return new FileObject[0];
            }
            fileObject.refresh();
            FileObject[] fileObjectArray = fileObject.getChildren();
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                FileObject fileObject2 = fileObjectArray[i];
                if (!ResultsManager.checkHprofFile(FileUtil.toFile((FileObject)fileObjectArray[i]))) continue;
                arrayList.add(fileObject2);
            }
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    FileObject fileObject = (FileObject)object;
                    FileObject fileObject2 = (FileObject)object2;
                    return fileObject.getName().compareTo(fileObject2.getName());
                }
            });
            FileObject[] fileObjectArray2 = new FileObject[arrayList.size()];
            arrayList.toArray(fileObjectArray2);
            return fileObjectArray2;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, MessageFormat.format(OBTAIN_SAVED_SNAPSHOTS_FAILED_MSG, iOException.getMessage()), iOException);
            return new FileObject[0];
        }
    }

    public FileObject[] listSavedSnapshots(Lookup.Provider provider, File file) {
        try {
            FileObject fileObject = null;
            fileObject = provider == null && file != null ? FileUtil.toFileObject((File)file) : ProjectStorage.getSettingsFolder((Lookup.Provider)provider, (boolean)false);
            if (fileObject == null) {
                return new FileObject[0];
            }
            fileObject.refresh();
            FileObject[] fileObjectArray = fileObject.getChildren();
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                FileObject fileObject2 = fileObjectArray[i];
                if (!fileObject2.getExt().equalsIgnoreCase(SNAPSHOT_EXTENSION)) continue;
                arrayList.add(fileObject2);
            }
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    FileObject fileObject = (FileObject)object;
                    FileObject fileObject2 = (FileObject)object2;
                    return fileObject.getName().compareTo(fileObject2.getName());
                }
            });
            FileObject[] fileObjectArray2 = new FileObject[arrayList.size()];
            arrayList.toArray(fileObjectArray2);
            return fileObjectArray2;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, MessageFormat.format(OBTAIN_SAVED_SNAPSHOTS_FAILED_MSG, iOException.getMessage()), iOException);
            return new FileObject[0];
        }
    }

    public LoadedSnapshot loadSnapshot(FileObject fileObject) {
        try {
            return this.loadSnapshotImpl(fileObject);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, MessageFormat.format(SNAPSHOT_LOAD_FAILED_MSG, iOException.getMessage()), iOException);
            return null;
        }
    }

    public LoadedSnapshot[] loadSnapshots(FileObject[] fileObjectArray) {
        LoadedSnapshot[] loadedSnapshotArray = new LoadedSnapshot[fileObjectArray.length];
        for (int i = 0; i < fileObjectArray.length; ++i) {
            try {
                if (fileObjectArray[i] == null) continue;
                loadedSnapshotArray[i] = this.loadSnapshotImpl(fileObjectArray[i]);
                continue;
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, MessageFormat.format(SNAPSHOT_LOAD_FAILED_MSG, iOException.getMessage()), iOException);
            }
        }
        return loadedSnapshotArray;
    }

    public void openSnapshot(File file) {
        File file2 = FileUtil.normalizeFile((File)file);
        FileObject fileObject = FileUtil.toFileObject((File)file2);
        this.openSnapshot(fileObject);
    }

    public void openSnapshot(FileObject fileObject) {
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
            if (openCookie != null) {
                openCookie.open();
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
    }

    public void openSnapshot(LoadedSnapshot loadedSnapshot) {
        this.openSnapshot(loadedSnapshot, -1, false);
    }

    public void openSnapshot(final LoadedSnapshot loadedSnapshot, final int n, final boolean bl) {
        if (loadedSnapshot == null) {
            ProfilerDialogs.displayError((String)CANNOT_OPEN_SNAPSHOT_MSG);
        } else {
            CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    SnapshotResultsWindow snapshotResultsWindow = SnapshotResultsWindow.get(loadedSnapshot, n, bl);
                    snapshotResultsWindow.open();
                    snapshotResultsWindow.requestActive();
                }
            });
        }
    }

    public void openSnapshots(LoadedSnapshot[] loadedSnapshotArray) {
        LoadedSnapshot loadedSnapshot = null;
        try {
            SnapshotResultsWindow snapshotResultsWindow = null;
            for (int i = 0; i < loadedSnapshotArray.length; ++i) {
                loadedSnapshot = loadedSnapshotArray[i];
                if (loadedSnapshotArray[i] == null) continue;
                snapshotResultsWindow = SnapshotResultsWindow.get(loadedSnapshot);
                snapshotResultsWindow.open();
            }
            if (snapshotResultsWindow != null) {
                snapshotResultsWindow.requestActive();
            }
        }
        catch (Exception exception) {
            ProfilerLogger.log((Exception)exception);
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SnapshotLoadFailed", (Object[])new Object[]{loadedSnapshot.getFile().getAbsolutePath()}));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
    }

    public LoadedSnapshot prepareSnapshot() {
        return this.prepareSnapshot(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadedSnapshot prepareSnapshot(boolean bl) {
        ProfilerClient profilerClient;
        TargetAppRunner targetAppRunner;
        CodeRegionResultsSnapshot codeRegionResultsSnapshot = null;
        if (!this.resultsAvailable()) {
            return null;
        }
        try {
            targetAppRunner = Profiler.getDefault().getTargetAppRunner();
            profilerClient = targetAppRunner.getProfilerClient();
            int n = profilerClient.getCurrentInstrType();
            try {
                switch (n) {
                    case 5: 
                    case 6: {
                        codeRegionResultsSnapshot = profilerClient.getMemoryProfilingResultsSnapshot(bl);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        codeRegionResultsSnapshot = profilerClient.getCPUProfilingResultsSnapshot(bl);
                        break;
                    }
                    case 1: {
                        codeRegionResultsSnapshot = profilerClient.getCodeRegionProfilingResultsSnapshot();
                    }
                }
            }
            catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                LOGGER.log(Level.SEVERE, PROFILED_APP_TERMINATED_MSG, targetAppOrVMTerminated);
            }
            catch (CPUResultsSnapshot.NoDataAvailableException noDataAvailableException) {
                LOGGER.log(Level.SEVERE, DATA_NOT_AVAILABLE_MSG, noDataAvailableException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                try {
                    this.reset();
                    targetAppRunner.resetTimers();
                }
                catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                    targetAppRunner.getProfilerClient().resetClientData();
                }
                LOGGER.log(Level.SEVERE, OUT_OF_MEMORY_MSG, outOfMemoryError);
            }
        }
        finally {
            if (codeRegionResultsSnapshot != null) {
                targetAppRunner = new ProfilingSettings();
                Profiler.getDefault().getLastProfilingSettings().copySettingsInto((ProfilingSettings)targetAppRunner);
                targetAppRunner.setSettingsName(Profiler.getDefault().getLastProfilingSettings().getSettingsName());
                profilerClient = NetBeansProfiler.getDefaultNB().getProfiledProject();
                return new LoadedSnapshot((ResultsSnapshot)codeRegionResultsSnapshot, (ProfilingSettings)targetAppRunner, null, (Lookup.Provider)profilerClient);
            }
        }
        return null;
    }

    public void reset() {
        ProfilingResultsDispatcher.getDefault().reset();
        this.resultsReset();
    }

    public boolean resultsAvailable() {
        return this.resultsAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveSnapshot(LoadedSnapshot loadedSnapshot, FileObject fileObject) {
        FileLock fileLock = null;
        FilterOutputStream filterOutputStream = null;
        try {
            fileLock = fileObject.lock();
            OutputStream outputStream = fileObject.getOutputStream(fileLock);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
            filterOutputStream = new DataOutputStream(bufferedOutputStream);
            loadedSnapshot.save((DataOutputStream)filterOutputStream);
            filterOutputStream.close();
            loadedSnapshot.setFile(FileUtil.toFile((FileObject)fileObject));
            loadedSnapshot.setSaved(true);
            this.fireSnapshotSaved(loadedSnapshot);
        }
        catch (IOException iOException) {
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
                if (fileLock != null) {
                    fileObject.delete(fileLock);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ProfilerDialogs.displayError((String)MessageFormat.format(SNAPSHOT_SAVE_FAILED_MSG, iOException.getMessage()));
            boolean bl = false;
            return bl;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
                if (fileLock != null) {
                    fileObject.delete(fileLock);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ProfilerDialogs.displayError((String)OUT_OF_MEMORY_SAVING);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
        return true;
    }

    public boolean saveSnapshot(LoadedSnapshot loadedSnapshot) {
        FileObject fileObject = null;
        Lookup.Provider provider = loadedSnapshot.getProject();
        FileObject fileObject2 = null;
        try {
            fileObject2 = ProjectStorage.getSettingsFolder((Lookup.Provider)provider, (boolean)true);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, MessageFormat.format(CANT_FIND_SNAPSHOT_LOCATION_MSG, iOException.getMessage()), iOException);
            return false;
        }
        try {
            fileObject = fileObject2.createData(this.getDefaultSnapshotFileName(loadedSnapshot), SNAPSHOT_EXTENSION);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, MessageFormat.format(SNAPSHOT_CREATE_IN_PROJECT_FAILED_MSG, iOException.getMessage()), iOException);
            return false;
        }
        return this.saveSnapshot(loadedSnapshot, fileObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadedSnapshot takeSnapshot() {
        CommonUtils.runInEventDispatchThreadAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                ResultsManager.this.mainWindow = WindowManager.getDefault().getMainWindow();
            }
        });
        Cursor cursor = this.mainWindow.getCursor();
        this.mainWindow.setCursor(Cursor.getPredefinedCursor(3));
        try {
            LoadedSnapshot loadedSnapshot = this.prepareSnapshot();
            if (loadedSnapshot != null) {
                this.loadedSnapshots.add(loadedSnapshot);
                this.fireSnapshotTaken(loadedSnapshot);
                LoadedSnapshot loadedSnapshot2 = loadedSnapshot;
                return loadedSnapshot2;
            }
        }
        finally {
            this.mainWindow.setCursor(cursor);
        }
        return null;
    }

    protected void fireResultsAvailable() {
        if (this.resultsListeners.allClasses().isEmpty()) {
            return;
        }
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (ResultsListener resultsListener : ResultsManager.this.resultsListeners.allInstances()) {
                    resultsListener.resultsAvailable();
                }
            }
        });
    }

    protected void fireResultsReset() {
        if (this.resultsListeners.allClasses().isEmpty()) {
            return;
        }
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (ResultsListener resultsListener : ResultsManager.this.resultsListeners.allInstances()) {
                    resultsListener.resultsReset();
                }
            }
        });
    }

    protected void fireSnapshotLoaded(final LoadedSnapshot loadedSnapshot) {
        if (this.snapshotListeners.allClasses().isEmpty()) {
            return;
        }
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (SnapshotsListener snapshotsListener : ResultsManager.this.snapshotListeners.allInstances()) {
                    snapshotsListener.snapshotLoaded(loadedSnapshot);
                }
            }
        });
    }

    protected void fireSnapshotRemoved(final LoadedSnapshot loadedSnapshot) {
        if (this.snapshotListeners.allClasses().isEmpty()) {
            return;
        }
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (SnapshotsListener snapshotsListener : ResultsManager.this.snapshotListeners.allInstances()) {
                    snapshotsListener.snapshotRemoved(loadedSnapshot);
                }
            }
        });
    }

    protected void fireSnapshotSaved(final LoadedSnapshot loadedSnapshot) {
        if (this.snapshotListeners.allClasses().isEmpty()) {
            return;
        }
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (SnapshotsListener snapshotsListener : ResultsManager.this.snapshotListeners.allInstances()) {
                    snapshotsListener.snapshotSaved(loadedSnapshot);
                }
            }
        });
    }

    protected void fireSnapshotTaken(final LoadedSnapshot loadedSnapshot) {
        if (this.snapshotListeners.allClasses().isEmpty()) {
            return;
        }
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (SnapshotsListener snapshotsListener : ResultsManager.this.snapshotListeners.allInstances()) {
                    snapshotsListener.snapshotTaken(loadedSnapshot);
                }
            }
        });
    }

    void resultsBecameAvailable() {
        if (NetBeansProfiler.getDefaultNB().getProfilingState() == 1) {
            return;
        }
        this.resultsAvailable = true;
        this.fireResultsAvailable();
    }

    void resultsReset() {
        this.resultsAvailable = false;
        this.fireResultsReset();
    }

    SelectedFile selectSnapshotTargetFile(String string, final boolean bl) {
        String string2;
        FileObject fileObject;
        String string3;
        JFileChooser jFileChooser = new JFileChooser();
        if (this.exportDir != null) {
            jFileChooser.setCurrentDirectory(this.exportDir);
        }
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setDialogTitle(SELECT_FILE_OR_DIR_DIALOG_CAPTION);
        jFileChooser.setApproveButtonText(SAVE_BUTTON_NAME);
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith("." + (bl ? ResultsManager.HEAPDUMP_EXTENSION : ResultsManager.SNAPSHOT_EXTENSION));
            }

            @Override
            public String getDescription() {
                return MessageFormat.format(PROFILER_SNAPSHOT_FILE_FILTER, bl ? ResultsManager.HEAPDUMP_EXTENSION : ResultsManager.SNAPSHOT_EXTENSION);
            }
        });
        if (jFileChooser.showSaveDialog(WindowManager.getDefault().getMainWindow()) != 0) {
            return null;
        }
        File file = jFileChooser.getSelectedFile();
        String string4 = string3 = bl ? HEAPDUMP_EXTENSION : SNAPSHOT_EXTENSION;
        if (file.isDirectory()) {
            this.exportDir = jFileChooser.getCurrentDirectory();
            fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
            string2 = string;
        } else {
            this.exportDir = jFileChooser.getCurrentDirectory();
            fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)this.exportDir));
            String string5 = file.getName();
            int n = string5.lastIndexOf(".");
            if (n == -1) {
                string2 = string5;
            } else {
                string2 = string5.substring(0, n);
                string3 = string5.substring(n + 1);
            }
        }
        return new SelectedFile(fileObject, string2, string3);
    }

    private boolean checkFileExists(SelectedFile selectedFile) {
        FileObject fileObject = selectedFile.folder.getFileObject(selectedFile.fileName, selectedFile.fileExt);
        if (fileObject != null) {
            if (!ProfilerDialogs.displayConfirmation((String)MessageFormat.format(OVERWRITE_FILE_DIALOG_MSG, selectedFile.fileName + "." + selectedFile.fileExt), (String)OVERWRITE_FILE_DIALOG_CAPTION)) {
                return false;
            }
            try {
                fileObject.delete();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, MessageFormat.format(FILE_DELETE_FAILED_MSG, iOException.getMessage()), iOException);
                return false;
            }
        }
        return true;
    }

    private void exportSnapshot(FileObject fileObject, FileObject fileObject2, String string, String string2) {
        if (this.checkFileExists(new SelectedFile(fileObject2, string, string2))) {
            try {
                FileUtil.copyFile((FileObject)fileObject, (FileObject)fileObject2, (String)string, (String)string2);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, MessageFormat.format(SNAPSHOT_EXPORT_FAILED_MSG, iOException.getMessage()), iOException);
            }
        }
    }

    private LoadedSnapshot findAlreadyLoadedSnapshot(FileObject fileObject) {
        Iterator<LoadedSnapshot> iterator = this.loadedSnapshots.iterator();
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            return null;
        }
        while (iterator.hasNext()) {
            LoadedSnapshot loadedSnapshot = iterator.next();
            if (loadedSnapshot.getFile() == null || !loadedSnapshot.getFile().equals(file)) continue;
            return loadedSnapshot;
        }
        return null;
    }

    private Lookup.Provider findProjectForSnapshot(FileObject fileObject) {
        return ProjectStorage.getProjectFromSettingsFolder((FileObject)fileObject.getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoadedSnapshot loadSnapshotFromFileObject(FileObject fileObject) throws IOException {
        FilterInputStream filterInputStream = null;
        try {
            InputStream inputStream = fileObject.getInputStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            filterInputStream = new DataInputStream(bufferedInputStream);
            LoadedSnapshot loadedSnapshot = LoadedSnapshot.loadSnapshot((DataInputStream)filterInputStream);
            if (loadedSnapshot != null) {
                loadedSnapshot.setFile(FileUtil.toFile((FileObject)fileObject));
                loadedSnapshot.setProject(this.findProjectForSnapshot(fileObject));
            }
            LoadedSnapshot loadedSnapshot2 = loadedSnapshot;
            return loadedSnapshot2;
        }
        finally {
            if (filterInputStream != null) {
                filterInputStream.close();
            }
        }
    }

    private LoadedSnapshot loadSnapshotImpl(FileObject fileObject) throws IOException {
        LoadedSnapshot loadedSnapshot = this.findAlreadyLoadedSnapshot(fileObject);
        if (loadedSnapshot != null) {
            return loadedSnapshot;
        }
        loadedSnapshot = this.loadSnapshotFromFileObject(fileObject);
        if (loadedSnapshot != null) {
            this.loadedSnapshots.add(loadedSnapshot);
            this.fireSnapshotLoaded(loadedSnapshot);
        }
        return loadedSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProfilingSettings readSettingsFromFile(FileObject fileObject) {
        BufferedInputStream bufferedInputStream;
        LoadedSnapshot loadedSnapshot = this.findAlreadyLoadedSnapshot(fileObject);
        if (loadedSnapshot != null) {
            return loadedSnapshot.getSettings();
        }
        FilterInputStream filterInputStream = null;
        try {
            InputStream inputStream = fileObject.getInputStream();
            bufferedInputStream = new BufferedInputStream(inputStream);
            filterInputStream = new DataInputStream(bufferedInputStream);
            byte[] byArray = new byte["nBpRoFiLeR".length()];
            int n = ((DataInputStream)filterInputStream).read(byArray);
            if (n != "nBpRoFiLeR".length() || !"nBpRoFiLeR".equals(new String(byArray))) {
                ProfilingSettings profilingSettings = null;
                return profilingSettings;
            }
            byte by = ((DataInputStream)filterInputStream).readByte();
            byte by2 = ((DataInputStream)filterInputStream).readByte();
            int n2 = ((DataInputStream)filterInputStream).readInt();
            int n3 = ((DataInputStream)filterInputStream).readInt();
            int n4 = ((DataInputStream)filterInputStream).readInt();
            if (((DataInputStream)filterInputStream).skipBytes(n3) != n3) {
                ProfilingSettings profilingSettings = null;
                return profilingSettings;
            }
            int n5 = ((DataInputStream)filterInputStream).readInt();
            byte[] byArray2 = new byte[n5];
            if (((DataInputStream)filterInputStream).read(byArray2) != n5) {
                ProfilingSettings profilingSettings = null;
                return profilingSettings;
            }
            Properties properties = new Properties();
            ProfilingSettings profilingSettings = new ProfilingSettings();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            BufferedInputStream bufferedInputStream2 = new BufferedInputStream(byteArrayInputStream);
            DataInputStream dataInputStream = new DataInputStream(bufferedInputStream2);
            try {
                properties.load(dataInputStream);
            }
            catch (IOException iOException) {
                ProfilerLogger.log((Exception)iOException);
                ProfilingSettings profilingSettings2 = null;
                try {
                    if (filterInputStream != null) {
                        filterInputStream.close();
                    }
                }
                catch (IOException iOException2) {
                    ProfilerLogger.log((Exception)iOException2);
                }
                return profilingSettings2;
            }
            finally {
                dataInputStream.close();
            }
            profilingSettings.load((Map)properties);
            ProfilingSettings profilingSettings3 = profilingSettings;
            return profilingSettings3;
        }
        catch (Exception exception) {
            ProfilerLogger.log((Exception)exception);
            bufferedInputStream = null;
            return bufferedInputStream;
        }
        finally {
            try {
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
            }
            catch (IOException iOException) {
                ProfilerLogger.log((Exception)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readTypeFromFile(FileObject fileObject) {
        LoadedSnapshot loadedSnapshot = this.findAlreadyLoadedSnapshot(fileObject);
        if (loadedSnapshot != null) {
            return loadedSnapshot.getType();
        }
        FilterInputStream filterInputStream = null;
        try {
            int n;
            InputStream inputStream = fileObject.getInputStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            filterInputStream = new DataInputStream(bufferedInputStream);
            byte[] byArray = new byte["nBpRoFiLeR".length()];
            int n2 = ((DataInputStream)filterInputStream).read(byArray);
            if (n2 != "nBpRoFiLeR".length() || !"nBpRoFiLeR".equals(new String(byArray))) {
                int n3 = 0;
                return n3;
            }
            byte by = ((DataInputStream)filterInputStream).readByte();
            byte by2 = ((DataInputStream)filterInputStream).readByte();
            int n4 = n = ((DataInputStream)filterInputStream).readInt();
            return n4;
        }
        catch (Exception exception) {
            int n = 0;
            return n;
        }
        finally {
            try {
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
        }
    }

    private static class Singleton {
        private static final ResultsManager INSTANCE = new ResultsManager();

        private Singleton() {
        }
    }

    static class SelectedFile {
        FileObject folder;
        String fileExt;
        String fileName;

        SelectedFile(FileObject fileObject, String string, String string2) {
            this.folder = fileObject;
            this.fileName = string;
            this.fileExt = string2;
        }
    }
}

