/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.applet2.preloader.CancelException;
import com.sun.applet2.preloader.Preloader;
import com.sun.applet2.preloader.event.UserDeclinedEvent;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.SecuritySettings;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BlacklistedCerts;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.security.CertValidator;
import com.sun.deploy.security.DeniedCertStore;
import com.sun.deploy.security.DeployCertPathChecker;
import com.sun.deploy.security.DeploySigningCertStore;
import com.sun.deploy.security.LazyRootStore;
import com.sun.deploy.security.RootCertStore;
import com.sun.deploy.security.SessionCertStore;
import com.sun.deploy.security.X509CertificateWrapper;
import com.sun.deploy.security.X509Util;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.DeployLock;
import com.sun.deploy.util.PerfLogger;
import com.sun.deploy.util.URLUtil;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.security.Timestamp;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.OCSP;
import sun.security.validator.PKIXValidator;
import sun.security.validator.Validator;
import sun.security.validator.ValidatorException;

public class TrustDecider {
    public static final int TrustOption_GrantThisSession = 0;
    public static final int TrustOption_Deny = 1;
    public static final int TrustOption_GrantAlways = 2;
    private static CertStore rootStore = null;
    private static CertStore permanentStore = null;
    private static CertStore sandboxStore = null;
    private static CertStore sessionStore = null;
    private static CertStore sessionSandboxStore = null;
    private static CertStore deniedStore = null;
    private static CertStore browserRootStore = null;
    private static CertStore browserTrustedStore = null;
    private static LazyRootStore lazyRootStore = null;
    private static List jurisdictionList = null;
    private static X509CRL crl509 = null;
    private static boolean ocspValidConfig = false;
    private static String ocspSigner = null;
    private static String ocspURL = null;
    private static boolean crlCheck = false;
    private static boolean ocspCheck = false;
    private static boolean ocspEECheck = false;
    private static DeployLock deployLock = null;
    public static final long PERMISSION_DENIED = 0L;
    public static final long PERMISSION_GRANTED_FOR_SESSION = 1L;
    public static final long PERMISSION_UNKNOWN = 2L;
    private static final String SUN_NAMESPACE = "OU=Java Signed Extensions,OU=Corporate Object Signing,O=Sun Microsystems Inc";
    private static final String ORACLE_NAMESPACE = "OU=Java Signed Extensions,OU=Corporate Object Signing,O=Oracle Corporation";
    private static final String[] PRE_TRUSTED_NAMESPACES;
    private static final List preTrustList;
    private static boolean storesLoaded;
    private static boolean reloadDeniedStore;

    protected static void grabDeployLock() throws InterruptedException {
        deployLock.lock();
    }

    protected static void releaseDeployLock() {
        try {
            deployLock.unlock();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public static void resetDenyStore() {
        Trace.msgSecurityPrintln("trustdecider.check.reset.denystore");
        try {
            try {
                TrustDecider.grabDeployLock();
                deniedStore = new DeniedCertStore();
                reloadDeniedStore = true;
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            Object var2 = null;
        }
        catch (Throwable throwable) {
            Object var2_1 = null;
            TrustDecider.releaseDeployLock();
            throw throwable;
        }
        TrustDecider.releaseDeployLock();
    }

    public static void reset() {
        PerfLogger.setTime("Security: Start Reset call in TrustDecider class");
        try {
            try {
                TrustDecider.grabDeployLock();
                storesLoaded = false;
                rootStore = RootCertStore.getCertStore();
                permanentStore = DeploySigningCertStore.getCertStore();
                sandboxStore = DeploySigningCertStore.getSandboxCertStore();
                sessionStore = new SessionCertStore("TrustDecider");
                sessionSandboxStore = new SessionCertStore("SandboxSecurity");
                deniedStore = new DeniedCertStore();
                if (Config.getBooleanProperty("deployment.security.browser.keystore.use")) {
                    Service service = ServiceManager.getService();
                    browserRootStore = service.getBrowserSigningRootCertStore();
                    browserTrustedStore = service.getBrowserTrustedCertStore();
                }
                try {
                    lazyRootStore = new LazyRootStore(browserRootStore, rootStore);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            String string;
                            crlCheck = Config.getBooleanProperty("deployment.security.validation.crl");
                            if (crlCheck && (string = Config.getStringProperty("deployment.security.validation.crl.url")) != null && string.length() > 0) {
                                CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
                                URL uRL = new URL(string);
                                URLConnection uRLConnection = uRL.openConnection();
                                uRLConnection.setDoInput(true);
                                uRLConnection.setUseCaches(false);
                                DataInputStream dataInputStream = new DataInputStream(uRLConnection.getInputStream());
                                crl509 = (X509CRL)certificateFactory.generateCRL(dataInputStream);
                                dataInputStream.close();
                            }
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    privilegedActionException.printStackTrace();
                }
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            ocspCheck = Config.getBooleanProperty("deployment.security.validation.ocsp");
                            if (ocspCheck) {
                                ocspSigner = Config.getStringProperty("deployment.security.validation.ocsp.signer");
                                ocspURL = Config.getStringProperty("deployment.security.validation.ocsp.url");
                                if (ocspSigner != null && ocspSigner.length() > 0 && ocspURL != null && ocspURL.length() > 0) {
                                    ocspValidConfig = true;
                                }
                            }
                            ocspEECheck = Config.getBooleanProperty("deployment.security.validation.ocsp.publisher");
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    privilegedActionException.printStackTrace();
                }
                Object var2_5 = null;
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
        catch (Throwable throwable) {
            Object var2_6 = null;
            TrustDecider.releaseDeployLock();
            throw throwable;
        }
        TrustDecider.releaseDeployLock();
        PerfLogger.setTime("Security: End Reset call in TrustDecider class");
    }

    public static long isAllPermissionGranted(CodeSource codeSource, Preloader preloader) throws CertificateEncodingException, CertificateExpiredException, CertificateNotYetValidException, CertificateParsingException, CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException, CRLException, InvalidAlgorithmParameterException {
        return TrustDecider.isAllPermissionGranted(codeSource, new AppInfo(), false, preloader);
    }

    private static void notifyOnUserDeclined(Preloader preloader, String string) {
        if (preloader == null) {
            preloader = (Preloader)ToolkitStore.get().getAppContext().get("preloader_key");
        }
        try {
            if (preloader != null) {
                preloader.handleEvent(new UserDeclinedEvent(string));
            }
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
    }

    private static void doCheckRevocationStatus(X509Certificate[] x509CertificateArray, Date date, String string, boolean bl) throws KeyStoreException, CertificateException, NoSuchAlgorithmException {
        if (!permanentStore.contains(x509CertificateArray[0], string, bl)) {
            try {
                OCSP.RevocationStatus.CertStatus certStatus = TrustDecider.doOCSPEEValidation(x509CertificateArray[0], x509CertificateArray[1], lazyRootStore, date);
                if (certStatus != OCSP.RevocationStatus.CertStatus.GOOD) {
                    Trace.msgSecurityPrintln("trustdecider.check.ocsp.ee.bad");
                    throw new CertificateException(ResourceManager.getMessage("trustdecider.check.ocsp.ee.revoked"));
                }
                Trace.msgSecurityPrintln("trustdecider.check.ocsp.ee.good");
            }
            catch (IOException iOException) {
                Trace.msgSecurityPrintln(iOException.getMessage());
            }
            catch (CertPathValidatorException certPathValidatorException) {
                Trace.msgSecurityPrintln(certPathValidatorException.getMessage());
                throw new CertificateException(certPathValidatorException);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
    }

    protected static List breakDownMultiSignerChains(Certificate[] certificateArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        ArrayList arrayList = new ArrayList();
        while (n2 < certificateArray.length) {
            ArrayList<Certificate> arrayList2 = new ArrayList<Certificate>();
            int n4 = n;
            while (n4 + 1 < certificateArray.length && certificateArray[n4] instanceof X509Certificate && certificateArray[n4 + 1] instanceof X509Certificate && CertUtils.isIssuerOf((X509Certificate)certificateArray[n4], (X509Certificate)certificateArray[n4 + 1])) {
                ++n4;
            }
            n2 = n4 + 1;
            for (int i = n; i < n2; ++i) {
                arrayList2.add(certificateArray[i]);
            }
            arrayList.add(arrayList2);
            n = n2;
            ++n3;
        }
        return arrayList;
    }

    private static boolean haveValidatorSupport() {
        if (Config.isJavaVersionAtLeast16()) {
            try {
                Class<?> clazz = Class.forName("sun.security.validator.Validator", true, ClassLoader.getSystemClassLoader());
                if (clazz != null) {
                    return true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                Trace.msgSecurityPrintln("trustdecider.check.validate.notfound");
            }
        }
        return false;
    }

    private static boolean hasCRL(X509Certificate[] x509CertificateArray) throws IOException {
        if (crl509 != null) {
            return true;
        }
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            if (!CertUtils.getCertCRLExtension(x509CertificateArray[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean hasOCSP(X509Certificate[] x509CertificateArray) throws IOException {
        if (ocspValidConfig) {
            return true;
        }
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            if (!CertUtils.hasAIAExtensionWithOCSPAccessMethod(x509CertificateArray[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized void validateChainForWarmup(X509Certificate[] x509CertificateArray, CodeSource codeSource, int n, AppInfo appInfo, boolean bl) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException, CRLException, InvalidAlgorithmParameterException {
        try {
            try {
                TrustDecider.grabDeployLock();
                TrustDecider.ensureBasicStoresLoaded();
                long l = TrustDecider.validateChain(x509CertificateArray, codeSource, n, appInfo, bl, null);
                Trace.println("Warmup validation completed (res=" + l + ")", TraceLevel.SECURITY);
            }
            catch (InterruptedException interruptedException) {
                Object var8_8 = null;
                TrustDecider.releaseDeployLock();
                return;
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            TrustDecider.releaseDeployLock();
            throw throwable;
        }
        TrustDecider.releaseDeployLock();
    }

    private static long validateChain(X509Certificate[] x509CertificateArray, CodeSource codeSource, int n, AppInfo appInfo, boolean bl, Preloader preloader) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException, CRLException, InvalidAlgorithmParameterException {
        ValidationState validationState = TrustDecider.getValidationState(x509CertificateArray, codeSource, n, appInfo, bl, preloader, false);
        if (validationState.trustDecision != 2L) {
            return validationState.trustDecision;
        }
        return TrustDecider.askUser(x509CertificateArray, codeSource, validationState, appInfo, bl, preloader);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ValidationState getValidationState(X509Certificate[] x509CertificateArray, CodeSource codeSource, int n, AppInfo appInfo, boolean bl, Preloader preloader, boolean bl2) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException, CRLException, InvalidAlgorithmParameterException {
        Validator validator;
        PKIXParameters pKIXParameters;
        int n2;
        ValidationState validationState;
        String string;
        boolean bl3;
        boolean bl4;
        block36: {
            boolean bl5 = crlCheck;
            bl4 = ocspCheck;
            bl3 = ocspEECheck;
            string = TrustDecider.getLocString(codeSource.getLocation());
            validationState = new ValidationState();
            for (n2 = 0; n2 < x509CertificateArray.length; ++n2) {
                block35: {
                    long l = x509CertificateArray[n2].getNotAfter().getTime();
                    if (l < validationState.expirationDate) {
                        validationState.expirationDate = l;
                    }
                    try {
                        x509CertificateArray[n2].checkValidity();
                    }
                    catch (CertificateExpiredException certificateExpiredException) {
                        if (validationState.certExpiredException == null) {
                            validationState.certExpiredException = certificateExpiredException;
                            validationState.certValidity = -1;
                            validationState.certValidityNoTS = -1;
                            validationState.timeValid = false;
                        }
                    }
                    catch (CertificateNotYetValidException certificateNotYetValidException) {
                        if (validationState.certNotYetValidException != null) break block35;
                        validationState.certNotYetValidException = certificateNotYetValidException;
                        validationState.certValidity = 1;
                        validationState.certValidityNoTS = 1;
                        validationState.timeValid = false;
                    }
                }
                BlacklistedCerts.check(x509CertificateArray[n2]);
            }
            n2 = x509CertificateArray.length;
            X509Certificate x509Certificate = x509CertificateArray[n2 - 1];
            X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
            X500Principal x500Principal2 = x509Certificate.getSubjectX500Principal();
            PerfLogger.setTime("Security: End check certificate expired and start replace CA check");
            ArrayList<X509Certificate> arrayList = lazyRootStore.getTrustAnchors(x509Certificate);
            if (arrayList == null) {
                validationState.rootCANotValid = true;
                arrayList = new ArrayList<X509Certificate>();
                arrayList.add(x509Certificate);
            }
            PerfLogger.setTime("Security: End replace CA check and start timestamp check");
            validationState.timeStampInfo = TrustDecider.getTimeStampInfo(codeSource, n, x509CertificateArray, lazyRootStore, validationState.timeValid);
            if (validationState.timeStampInfo != null) {
                validationState.timeValid = true;
                validationState.certValidity = 0;
            }
            PerfLogger.setTime("Security: End timestamp check and start pre-trusted certificate check");
            if (!(validationState.rootCANotValid || validationState.certValidityNoTS != 0 || appInfo.getType() != 3 || bl || permanentStore.contains(x509CertificateArray[0], string, validationState.timeValid))) {
                bl3 = true;
                Trace.msgSecurityPrintln("trustdecider.check.extensioninstall.on");
            }
            boolean bl6 = false;
            boolean bl7 = false;
            pKIXParameters = null;
            try {
                try {
                    bl6 = bl5 && TrustDecider.hasCRL(x509CertificateArray);
                    bl7 = bl4 && TrustDecider.hasOCSP(x509CertificateArray);
                    PerfLogger.setTime("Security: Start getting validator class");
                    validator = Validator.getInstance("PKIX", "plugin code signing", arrayList);
                    PKIXValidator pKIXValidator = (PKIXValidator)validator;
                    pKIXParameters = pKIXValidator.getParameters();
                    pKIXParameters.addCertPathChecker(new DeployCertPathChecker(pKIXValidator));
                    PerfLogger.setTime("Security: End getting validator class and start CRL revocation check");
                    if (bl5) {
                        Trace.msgSecurityPrintln("trustdecider.check.validation.crl.on");
                        pKIXParameters = TrustDecider.doCRLValidation(pKIXParameters, bl6);
                    } else {
                        Trace.msgSecurityPrintln("trustdecider.check.validation.crl.off");
                    }
                    PerfLogger.setTime("Security: End CRL and start OCSP revocation check");
                    if (bl4) {
                        Trace.msgSecurityPrintln("trustdecider.check.validation.ocsp.on");
                        TrustDecider.doOCSPValidation(pKIXParameters, lazyRootStore, x509CertificateArray, bl7, bl5);
                    } else {
                        Trace.msgSecurityPrintln("trustdecider.check.validation.ocsp.off");
                    }
                    PerfLogger.setTime("Security: End OCSP revocation check and start validator class");
                    X509Certificate[] x509CertificateArray2 = new X509Certificate[n2];
                    for (int i = 0; i < n2; ++i) {
                        x509CertificateArray2[i] = new X509CertificateWrapper(x509CertificateArray[i]);
                    }
                    validator.validate(x509CertificateArray2);
                    PerfLogger.setTime("Security: End call validator class");
                    if (bl5 && bl6 || bl4 && bl7) {
                        Trace.msgSecurityPrintln("trustdecider.check.revocation.succeed");
                    }
                }
                catch (CertificateException certificateException) {
                    String string3;
                    if (!(certificateException instanceof ValidatorException)) throw certificateException;
                    ValidatorException validatorException = (ValidatorException)certificateException;
                    if (ValidatorException.T_NO_TRUST_ANCHOR.equals(validatorException.getErrorType())) {
                        validationState.rootCANotValid = true;
                        Object var25_35 = null;
                        Security.setProperty("com.sun.security.onlyCheckRevocationOfEECert", "false");
                        break block36;
                    }
                    String string2 = "Certificate has been revoked";
                    if (!bl5 || !bl6) {
                        if (!bl4) throw validatorException;
                        if (!bl7) throw validatorException;
                    }
                    if ((string3 = validatorException.getMessage()).contains(string2)) {
                        Trace.msgSecurityPrintln("trustdecider.check.validation.revoked");
                        throw validatorException;
                    }
                    Trace.msgSecurityPrintln(string3);
                    throw validatorException;
                }
                catch (IOException iOException) {
                    Trace.msgSecurityPrintln(iOException.getMessage());
                    throw iOException;
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    Trace.msgSecurityPrintln(invalidAlgorithmParameterException.getMessage());
                    throw invalidAlgorithmParameterException;
                }
                catch (CRLException cRLException) {
                    Trace.msgSecurityPrintln(cRLException.getMessage());
                    throw cRLException;
                }
                Object var25_34 = null;
            }
            catch (Throwable throwable) {
                Object var25_36 = null;
                Security.setProperty("com.sun.security.onlyCheckRevocationOfEECert", "false");
                throw throwable;
            }
            Security.setProperty("com.sun.security.onlyCheckRevocationOfEECert", "false");
        }
        PerfLogger.setTime("Security: End certificate validation and start OCSP End-Entity revocation check");
        if (bl3 && !bl4 && n2 > 1 && !validationState.rootCANotValid && validationState.certValidityNoTS == 0) {
            TrustDecider.doCheckRevocationStatus(x509CertificateArray, pKIXParameters.getDate(), string, validationState.timeValid);
        } else {
            Trace.msgSecurityPrintln("trustdecider.check.ocsp.ee.off");
        }
        PerfLogger.setTime("Security: End OCSP End-Entity revocation check");
        if (deniedStore.contains(x509CertificateArray[0], string, validationState.timeValid)) {
            validator = codeSource.getLocation() != null ? codeSource.getLocation().toString() : null;
            TrustDecider.notifyOnUserDeclined(preloader, (String)((Object)validator));
            validationState.trustDecision = 0L;
            return validationState;
        }
        if (validationState.rootCANotValid && TrustDecider.checkTrustedExtension(x509CertificateArray[0])) {
            validationState.trustDecision = 2L;
            return validationState;
        }
        if (permanentStore.contains(x509CertificateArray[0], string, validationState.timeValid)) {
            validationState.trustDecision = validationState.expirationDate;
            return validationState;
        }
        if (sessionStore.contains(x509CertificateArray[0], string, validationState.timeValid)) {
            validationState.trustDecision = 1L;
            return validationState;
        }
        if (bl2) {
            if (sandboxStore.contains(x509CertificateArray[0], string, validationState.timeValid)) {
                validationState.trustDecision = validationState.expirationDate;
                return validationState;
            }
            if (sessionSandboxStore.contains(x509CertificateArray[0], string, validationState.timeValid)) {
                validationState.trustDecision = 1L;
                return validationState;
            }
        }
        if (browserTrustedStore != null && browserTrustedStore.contains(x509CertificateArray[0])) {
            validationState.trustDecision = 1L;
            return validationState;
        }
        validationState.trustDecision = 2L;
        return validationState;
    }

    static boolean checkTrustedExtension(X509Certificate x509Certificate) {
        Trace.msgSecurityPrintln("trustdecider.check.trustextension.jurisdiction");
        X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
        String string = x500Principal.getName();
        Iterator iterator = preTrustList.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string.endsWith(string2)) continue;
            Trace.msgSecurityPrintln("trustdecider.check.trustextension.jurisdiction.found");
            return true;
        }
        return false;
    }

    private static long askUser(X509Certificate[] x509CertificateArray, CodeSource codeSource, ValidationState validationState, AppInfo appInfo, boolean bl, Preloader preloader) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException {
        String string = TrustDecider.getLocString(codeSource.getLocation());
        TrustDecider.releaseDeployLock();
        if (validationState.rootCANotValid && !SecuritySettings.isAskGrantSelfSignedSet()) {
            throw new CertificateException(ResourceManager.getMessage("trustdecider.user.cannot.grant.notinca"));
        }
        if (!SecuritySettings.isAskGrantShowSet()) {
            throw new CertificateException(ResourceManager.getMessage("trustdecider.user.cannot.grant.any"));
        }
        int n = X509Util.showSecurityDialog(x509CertificateArray, codeSource.getLocation(), 0, x509CertificateArray.length, validationState.rootCANotValid, validationState.certValidity, validationState.timeStampInfo, appInfo, bl);
        try {
            TrustDecider.grabDeployLock();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Intermediate error trying to perform security validation");
        }
        PerfLogger.setTime("Security: Start take action on security dialog box");
        if (n == 0) {
            Trace.msgSecurityPrintln("trustdecider.user.grant.session");
            sessionStore.add(x509CertificateArray[0], string, validationState.timeValid);
            sessionStore.save();
            validationState.trustDecision = 1L;
        } else if (n == 2) {
            Trace.msgSecurityPrintln("trustdecider.user.grant.forever");
            CertStore certStore = DeploySigningCertStore.getUserCertStore();
            certStore.load(true);
            if (certStore.add(x509CertificateArray[0], string, validationState.timeValid)) {
                certStore.save();
            }
            storesLoaded = false;
            validationState.trustDecision = validationState.expirationDate;
        } else {
            Trace.msgSecurityPrintln("trustdecider.user.deny");
            deniedStore.add(x509CertificateArray[0], string, validationState.timeValid);
            deniedStore.save();
            String string2 = codeSource.getLocation() != null ? codeSource.getLocation().toString() : null;
            TrustDecider.notifyOnUserDeclined(preloader, string2);
            validationState.trustDecision = 0L;
        }
        PerfLogger.setTime("Security: End take action on security dialog box");
        return validationState.trustDecision;
    }

    protected static void recordSandboxAnswer(Certificate[] certificateArray, CodeSource codeSource, ValidationState validationState, Preloader preloader, int n) {
        boolean bl = false;
        try {
            String string = TrustDecider.getLocString(codeSource.getLocation());
            if (n == 0) {
                sessionSandboxStore.add(certificateArray[0], string, validationState.timeValid);
                sessionSandboxStore.save();
            } else if (n == 2) {
                sandboxStore.load(true);
                if (sandboxStore.add(certificateArray[0], string, validationState.timeValid)) {
                    sandboxStore.save();
                }
            } else {
                deniedStore.add(certificateArray[0], string, validationState.timeValid);
                deniedStore.save();
                bl = true;
                String string2 = codeSource.getLocation() != null ? codeSource.getLocation().toString() : null;
                TrustDecider.notifyOnUserDeclined(preloader, string2);
            }
        }
        catch (Exception exception) {
            Trace.ignored(exception);
        }
        if (bl) {
            throw new SecurityException("user declined to run signed sandbox app", null);
        }
    }

    protected static void ensureBasicStoresLoaded() throws InterruptedException, IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        if (reloadDeniedStore || !storesLoaded) {
            deniedStore.load();
            reloadDeniedStore = false;
        }
        if (storesLoaded) {
            return;
        }
        storesLoaded = true;
        PerfLogger.setTime("Security: Start loading JRE permanent certStore");
        permanentStore.load();
        sandboxStore.load();
        PerfLogger.setTime("Security: End loading JRE permanent certStore");
        sessionStore.load();
        sessionSandboxStore.load();
        PerfLogger.setTime("Security: start loading browser Trust certStore");
        if (browserTrustedStore != null) {
            browserTrustedStore.load();
        }
        PerfLogger.setTime("Security: End loading browser Trust certStore");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized long isAllPermissionGranted(CodeSource codeSource, AppInfo appInfo, boolean bl, Preloader preloader) throws CertificateEncodingException, CertificateExpiredException, CertificateNotYetValidException, CertificateParsingException, CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException, CRLException, InvalidAlgorithmParameterException {
        long l;
        block13: {
            long l2;
            block12: {
                try {
                    try {
                        TrustDecider.grabDeployLock();
                        Certificate[] certificateArray = codeSource.getCertificates();
                        if (certificateArray == null) {
                            l2 = 0L;
                            Object var15_8 = null;
                            break block12;
                        }
                        TrustDecider.ensureBasicStoresLoaded();
                        List list = TrustDecider.breakDownMultiSignerChains(certificateArray);
                        PerfLogger.setTime("Security: End break certificate chain");
                        if (TrustDecider.haveValidatorSupport()) {
                            Trace.msgSecurityPrintln("trustdecider.check.validate.certpath.algorithm");
                            long l3 = 0L;
                            Iterator iterator = list.iterator();
                            int n = 0;
                            while (iterator.hasNext()) {
                                PerfLogger.setTime("Security: Start check certificate expired");
                                List list2 = (List)iterator.next();
                                X509Certificate[] x509CertificateArray = list2.toArray(new X509Certificate[0]);
                                l3 = TrustDecider.validateChain(x509CertificateArray, codeSource, n, appInfo, bl, preloader);
                                if (l3 != 0L) {
                                    long l4 = l3;
                                    Object var15_9 = null;
                                    TrustDecider.releaseDeployLock();
                                    return l4;
                                }
                                ++n;
                            }
                        } else {
                            Trace.msgSecurityPrintln("trustdecider.check.validate.legacy.algorithm");
                            rootStore.load();
                            if (browserRootStore != null) {
                                browserRootStore.load();
                            }
                            if (CertValidator.validate(codeSource, appInfo, certificateArray, list.size(), rootStore, browserRootStore, browserTrustedStore, sessionStore, permanentStore, deniedStore)) {
                                l = 1L;
                                break block13;
                            }
                        }
                        Object var15_11 = null;
                    }
                    catch (InterruptedException interruptedException) {
                        throw new RuntimeException(interruptedException);
                    }
                    TrustDecider.releaseDeployLock();
                    return 0L;
                }
                catch (Throwable throwable) {
                    Object var15_12 = null;
                    TrustDecider.releaseDeployLock();
                    throw throwable;
                }
            }
            TrustDecider.releaseDeployLock();
            return l2;
        }
        Object var15_10 = null;
        TrustDecider.releaseDeployLock();
        return l;
    }

    private static boolean checkTSAPath(CertPath certPath, LazyRootStore lazyRootStore) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("trustdecider.check.timestamping.tsapath");
        List<? extends Certificate> list = certPath.getCertificates();
        X509Certificate[] x509CertificateArray = list.toArray(new X509Certificate[0]);
        int n = x509CertificateArray.length;
        X509Certificate x509Certificate = x509CertificateArray[n - 1];
        List list2 = lazyRootStore.getTrustAnchors(x509Certificate);
        if (list2 == null) {
            return false;
        }
        Validator validator = Validator.getInstance("PKIX", "tsa server", list2);
        try {
            x509CertificateArray = validator.validate(x509CertificateArray);
        }
        catch (CertificateException certificateException) {
            Trace.msgSecurityPrintln(certificateException.getMessage());
            return false;
        }
        return true;
    }

    private static PKIXParameters doCRLValidation(PKIXParameters pKIXParameters, boolean bl) throws IOException, InvalidAlgorithmParameterException, CRLException, NoSuchAlgorithmException {
        if (crl509 != null) {
            Trace.msgSecurityPrintln("trustdecider.check.validation.crl.system.on");
            System.clearProperty("com.sun.security.enableCRLDP");
            pKIXParameters.setRevocationEnabled(true);
            pKIXParameters.addCertStore(java.security.cert.CertStore.getInstance("Collection", new CollectionCertStoreParameters(Collections.singletonList(crl509))));
        } else {
            Trace.msgSecurityPrintln("trustdecider.check.validation.crl.system.off");
            pKIXParameters.setRevocationEnabled(bl);
            System.setProperty("com.sun.security.enableCRLDP", Boolean.toString(bl));
        }
        return pKIXParameters;
    }

    private static void doOCSPValidation(PKIXParameters pKIXParameters, LazyRootStore lazyRootStore, X509Certificate[] x509CertificateArray, boolean bl, boolean bl2) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        X509Certificate x509Certificate = null;
        boolean bl3 = false;
        Security.setProperty("ocsp.enable", Boolean.toString(bl));
        if (ocspValidConfig) {
            Security.setProperty("ocsp.responderURL", ocspURL);
        }
        pKIXParameters.setRevocationEnabled(bl);
        if (ocspValidConfig) {
            Trace.msgSecurityPrintln("trustdecider.check.validation.ocsp.system.on");
            bl3 = lazyRootStore.containSubject(ocspSigner);
            x509Certificate = lazyRootStore.getOCSPCert();
            if (bl3 && x509Certificate != null) {
                Security.setProperty("ocsp.responderCertSubjectName", x509Certificate.getSubjectX500Principal().getName());
            }
        } else {
            Trace.msgSecurityPrintln("trustdecider.check.validation.ocsp.system.off");
        }
        if (!bl2 && bl) {
            System.setProperty("com.sun.security.enableCRLDP", "true");
        }
    }

    private static OCSP.RevocationStatus.CertStatus doOCSPEEValidation(X509Certificate x509Certificate, X509Certificate x509Certificate2, LazyRootStore lazyRootStore, Date date) throws IOException, CertPathValidatorException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("trustdecider.check.ocsp.ee.start");
        boolean bl = false;
        URI uRI = null;
        X509Certificate x509Certificate3 = x509Certificate2;
        if (ocspValidConfig) {
            try {
                uRI = new URI(ocspURL);
            }
            catch (URISyntaxException uRISyntaxException) {
                Trace.msgSecurityPrintln("trustdecider.check.ocsp.ee.responderURI.no");
                return OCSP.RevocationStatus.CertStatus.GOOD;
            }
            bl = lazyRootStore.containSubject(ocspSigner);
            if (bl) {
                x509Certificate3 = lazyRootStore.getOCSPCert();
            }
        } else {
            uRI = OCSP.getResponderURI(x509Certificate);
        }
        if (uRI == null) {
            Trace.msgSecurityPrintln("trustdecider.check.ocsp.ee.responderURI.no");
            return OCSP.RevocationStatus.CertStatus.GOOD;
        }
        Object object = uRI.toString();
        Trace.msgSecurityPrintln("trustdecider.check.ocsp.ee.responderURI.value", new Object[]{object});
        object = OCSP.check((X509Certificate)x509Certificate, (X509Certificate)x509Certificate2, (URI)uRI, (X509Certificate)x509Certificate3, (Date)date).getCertStatus();
        String string = ((Enum)object).name();
        Trace.msgSecurityPrintln("trustdecider.check.ocsp.ee.return.status", new Object[]{string});
        return object;
    }

    private static Date getTimeStampInfo(CodeSource codeSource, int n, X509Certificate[] x509CertificateArray, LazyRootStore lazyRootStore, boolean bl) {
        Date date = null;
        if (bl) {
            Trace.msgSecurityPrintln("trustdecider.check.timestamping.noneed");
            return null;
        }
        try {
            Trace.msgSecurityPrintln("trustdecider.check.timestamping.need");
            CodeSigner[] codeSignerArray = codeSource.getCodeSigners();
            Timestamp timestamp = codeSignerArray[n].getTimestamp();
            if (timestamp != null) {
                Trace.msgSecurityPrintln("trustdecider.check.timestamping.yes");
                date = timestamp.getTimestamp();
                CertPath certPath = timestamp.getSignerCertPath();
                Trace.msgSecurityPrintln("trustdecider.check.timestamping.need");
                Date date2 = x509CertificateArray[x509CertificateArray.length - 1].getNotAfter();
                Date date3 = x509CertificateArray[x509CertificateArray.length - 1].getNotBefore();
                if (date.before(date2) && date.after(date3)) {
                    Trace.msgSecurityPrintln("trustdecider.check.timestamping.valid");
                    if (!TrustDecider.checkTSAPath(certPath, lazyRootStore)) {
                        date = null;
                    }
                } else {
                    Trace.msgSecurityPrintln("trustdecider.check.timestamping.invalid");
                    date = null;
                }
            } else {
                Trace.msgSecurityPrintln("trustdecider.check.timestamping.no");
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            Trace.msgSecurityPrintln("trustdecider.check.timestamping.notfound");
        }
        catch (KeyStoreException keyStoreException) {
            Trace.msgSecurityPrintln("trustdecider.check.timestamping.notfound");
        }
        catch (IOException iOException) {
            Trace.msgSecurityPrintln("trustdecider.check.timestamping.notfound");
        }
        catch (CertificateException certificateException) {
            Trace.msgSecurityPrintln("trustdecider.check.timestamping.notfound");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Trace.msgSecurityPrintln("trustdecider.check.timestamping.notfound");
        }
        return date;
    }

    protected static String getLocString(URL uRL) {
        try {
            return uRL.getProtocol() + "//" + uRL.getHost() + ":" + URLUtil.getPort(uRL);
        }
        catch (Exception exception) {
            Trace.ignored(exception);
            return null;
        }
    }

    static {
        deployLock = new DeployLock();
        TrustDecider.reset();
        PRE_TRUSTED_NAMESPACES = new String[]{SUN_NAMESPACE, ORACLE_NAMESPACE};
        preTrustList = Arrays.asList(PRE_TRUSTED_NAMESPACES);
        storesLoaded = false;
        reloadDeniedStore = false;
    }

    public static class ValidationState {
        public long trustDecision = 2L;
        public boolean rootCANotValid = false;
        public boolean timeValid = true;
        public long expirationDate = Long.MAX_VALUE;
        public int certValidity = 0;
        public int certValidityNoTS = 0;
        public CertificateExpiredException certExpiredException = null;
        public CertificateNotYetValidException certNotYetValidException = null;
        public Date timeStampInfo = null;
    }
}

