/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.panels;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.integration.IntegrationUtils;
import org.netbeans.modules.profiler.attach.panels.AttachWizardPanel;
import org.netbeans.modules.profiler.attach.panels.RemoteAttachSettingsPanelUI;
import org.netbeans.modules.profiler.attach.wizard.AttachWizardContext;
import org.openide.util.HelpCtx;

public class RemoteAttachSettingsPanel
extends AttachWizardPanel {
    private static final String HELP_CTX_KEY = "RemoteAttachSettingsPanel.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("RemoteAttachSettingsPanel.HelpCtx");
    private Model model = new Model();
    private RemoteAttachSettingsPanelUI panel;

    public HelpCtx getHelp() {
        return HELP_CTX;
    }

    public boolean isValid() {
        return this.model.getRemoteHost() != null && this.model.getRemoteHost().length() > 0 && this.model.getRemoteOs() != null && this.model.getRemoteOs().length() > 0;
    }

    @Override
    public boolean canBack(AttachWizardContext attachWizardContext) {
        return true;
    }

    @Override
    public boolean canFinish(AttachWizardContext attachWizardContext) {
        return false;
    }

    @Override
    public boolean canNext(AttachWizardContext attachWizardContext) {
        return this.isValid();
    }

    @Override
    public boolean onCancel(AttachWizardContext attachWizardContext) {
        return true;
    }

    @Override
    public void onEnter(AttachWizardContext attachWizardContext) {
        this.model.setRemoteHost(attachWizardContext.getAttachSettings().getHost());
        if (this.model.getRemoteHost() != null && this.model.getRemoteHost().length() > 0) {
            this.model.setRemoteOs(attachWizardContext.getAttachSettings().getHostOS());
        }
    }

    @Override
    public void onExit(AttachWizardContext attachWizardContext) {
        AttachSettings attachSettings = attachWizardContext.getAttachSettings();
        if (this.model.getRemoteHost() != null) {
            attachSettings.setHost(this.model.getRemoteHost());
        }
        if (this.model.getRemoteOs() != null) {
            attachSettings.setHostOS(this.model.getRemoteOs());
        }
    }

    @Override
    public void onFinish(AttachWizardContext attachWizardContext) {
    }

    @Override
    public void onPanelShow() {
        this.panel.refresh();
    }

    @Override
    protected JPanel getRenderPanel() {
        if (this.panel == null) {
            this.panel = new RemoteAttachSettingsPanelUI(this.model);
        }
        return this.panel;
    }

    public class Model {
        private List<String> availableOsList = new ArrayList<String>(Arrays.asList(IntegrationUtils.PLATFORM_WINDOWS_OS, IntegrationUtils.PLATFORM_WINDOWS_AMD64_OS, IntegrationUtils.PLATFORM_LINUX_OS, IntegrationUtils.PLATFORM_LINUX_AMD64_OS, IntegrationUtils.PLATFORM_SOLARIS_SPARC_OS, IntegrationUtils.PLATFORM_SOLARIS_SPARC64_OS, IntegrationUtils.PLATFORM_SOLARIS_INTEL_OS, IntegrationUtils.PLATFORM_SOLARIS_AMD64_OS, IntegrationUtils.PLATFORM_MAC_OS));
        private String remoteHost = null;
        private String remoteOs = null;

        public Object[] getAvailableOsList() {
            return this.availableOsList.toArray(new Object[this.availableOsList.size()]);
        }

        public void setRemoteHost(String string) {
            this.remoteHost = string;
            RemoteAttachSettingsPanel.this.publishUpdate(new ChangeEvent(this));
        }

        public String getRemoteHost() {
            return this.remoteHost;
        }

        public void setRemoteOs(String string) {
            if (this.availableOsList.contains(string)) {
                this.remoteOs = string;
                RemoteAttachSettingsPanel.this.publishUpdate(new ChangeEvent(this));
            }
        }

        public String getRemoteOs() {
            return this.remoteOs;
        }
    }
}

