/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.ResultSet;
import org.apache.derby.client.am.ResultSetCallbackInterface;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.CodePoint;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetCursor;
import org.apache.derby.client.net.NetResultSet;
import org.apache.derby.client.net.NetSqlca;
import org.apache.derby.client.net.NetStatementReply;
import org.apache.derby.client.net.ResultSetReplyInterface;

public class NetResultSetReply
extends NetStatementReply
implements ResultSetReplyInterface {
    public NetResultSetReply(NetAgent netAgent, int n) {
        super(netAgent, n);
    }

    public void readFetch(ResultSetCallbackInterface resultSetCallbackInterface) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseCNTQRYreply(resultSetCallbackInterface, true);
        this.endOfSameIdChainData();
    }

    public void readPositioningFetch(ResultSetCallbackInterface resultSetCallbackInterface) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseCNTQRYreply(resultSetCallbackInterface, false);
        this.endOfSameIdChainData();
    }

    public void readScrollableFetch(ResultSetCallbackInterface resultSetCallbackInterface) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseCNTQRYreply(resultSetCallbackInterface, true);
        this.endOfSameIdChainData();
    }

    public void readCursorClose(ResultSetCallbackInterface resultSetCallbackInterface) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseCLSQRYreply(resultSetCallbackInterface);
        this.endOfSameIdChainData();
    }

    private void parseCLSQRYreply(ResultSetCallbackInterface resultSetCallbackInterface) throws DisconnectException {
        int n = this.parseTypdefsOrMgrlvlovrs();
        if (n == 9224) {
            NetSqlca netSqlca = this.parseSQLCARD(null);
            resultSetCallbackInterface.completeSqlca(netSqlca);
        } else {
            this.parseCloseError(resultSetCallbackInterface);
        }
    }

    private void parseCNTQRYreply(ResultSetCallbackInterface resultSetCallbackInterface, boolean bl) throws DisconnectException {
        boolean bl2 = false;
        int n = this.peekCodePoint();
        if (n == 8728) {
            bl2 = true;
            this.parseRDBUPDRM();
            n = this.peekCodePoint();
        }
        if (n == 9243) {
            bl2 = true;
            if (!bl) {
                this.parseLengthAndMatchCodePoint(9243);
                if (this.longValueForDecryption_ != null) {
                    this.longValueForDecryption_ = null;
                }
                if (this.longBufferForDecryption_ != null) {
                    this.longBufferForDecryption_ = null;
                }
                int n2 = this.getDdmLength();
                this.ensureBLayerDataInBuffer(n2);
                ((ResultSet)resultSetCallbackInterface).expandRowsetSqlca();
                NetSqlca netSqlca = this.parseSQLCARDrow(((ResultSet)resultSetCallbackInterface).rowsetSqlca_);
                byte by = this.readFastByte();
                this.adjustLengths(this.getDdmLength());
                if (netSqlca != null && netSqlca.containsSqlcax()) {
                    ((ResultSet)resultSetCallbackInterface).setRowCountEvent(netSqlca.getRowCount(this.netAgent_.targetTypdef_));
                }
                if ((n = this.peekCodePoint()) == 8728) {
                    this.parseRDBUPDRM();
                    n = this.peekCodePoint();
                }
                if (n == 49152) {
                    this.parsePBSD();
                }
                return;
            }
            do {
                this.parseQRYDTA((NetResultSet)resultSetCallbackInterface);
            } while ((n = this.peekCodePoint()) == 9243);
        }
        if (n == 5228) {
            bl2 = true;
            do {
                this.copyEXTDTA((NetCursor)((ResultSet)resultSetCallbackInterface).cursor_);
                if (this.longBufferForDecryption_ == null) continue;
                this.buffer_ = this.longBufferForDecryption_;
                this.pos_ = this.longPosForDecryption_;
                if (this.longBufferForDecryption_ == null || this.count_ <= this.longBufferForDecryption_.length) continue;
                this.count_ = this.longBufferForDecryption_.length;
            } while ((n = this.peekCodePoint()) == 5228);
        }
        if (n == 9224) {
            bl2 = true;
            ((ResultSet)resultSetCallbackInterface).expandRowsetSqlca();
            NetSqlca netSqlca = this.parseSQLCARD(((ResultSet)resultSetCallbackInterface).rowsetSqlca_);
            if (((ResultSet)resultSetCallbackInterface).sensitivity_ != 3 && netSqlca != null && netSqlca.containsSqlcax() && netSqlca.getRowsetRowCount() == 0L) {
                ((ResultSet)resultSetCallbackInterface).setRowCountEvent(netSqlca.getRowCount(this.netAgent_.targetTypdef_));
            }
            resultSetCallbackInterface.completeSqlca(netSqlca);
            n = this.peekCodePoint();
        }
        if (n == 8715) {
            bl2 = true;
            this.parseEndQuery(resultSetCallbackInterface);
            n = this.peekCodePoint();
        }
        if (n == 8728) {
            bl2 = true;
            this.parseRDBUPDRM();
            n = this.peekCodePoint();
        }
        if (!bl2) {
            this.parseFetchError(resultSetCallbackInterface);
        }
        if (n == 49152) {
            this.parsePBSD();
        }
        if (this.longBufferForDecryption_ != null) {
            this.buffer_ = new byte[Short.MAX_VALUE];
            this.longBufferForDecryption_ = null;
        }
    }

    void parseCloseError(ResultSetCallbackInterface resultSetCallbackInterface) throws DisconnectException {
        int n = this.peekCodePoint();
        switch (n) {
            case 8717: {
                NetSqlca netSqlca = this.parseAbnormalEndUow(resultSetCallbackInterface);
                resultSetCallbackInterface.completeSqlca(netSqlca);
                break;
            }
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8706: {
                this.parseQRYNOPRM(resultSetCallbackInterface);
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            default: {
                this.parseCommonError(n);
            }
        }
    }

    void parseFetchError(ResultSetCallbackInterface resultSetCallbackInterface) throws DisconnectException {
        int n = this.peekCodePoint();
        switch (n) {
            case 8717: {
                NetSqlca netSqlca = this.parseAbnormalEndUow(resultSetCallbackInterface);
                resultSetCallbackInterface.completeSqlca(netSqlca);
                break;
            }
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 4688: {
                this.parseCMDNSPRM();
                break;
            }
            case 8706: {
                this.parseQRYNOPRM(resultSetCallbackInterface);
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            default: {
                this.parseCommonError(n);
            }
        }
    }

    private void parseQRYNOPRM(ResultSetCallbackInterface resultSetCallbackInterface) throws DisconnectException {
        boolean bl = false;
        int n = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        String string = null;
        boolean bl3 = false;
        Object object = null;
        this.parseLengthAndMatchCodePoint(8706);
        this.pushLengthOnCollectionStack();
        int n2 = this.peekCodePoint();
        while (n2 != -1) {
            boolean bl4 = false;
            if (n2 == 4425) {
                bl4 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n = this.parseSVRCOD(CodePoint.SVRCOD_WARNING, CodePoint.SVRCOD_ERROR);
                n2 = this.peekCodePoint();
            }
            if (n2 == 8464) {
                bl4 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                string = this.parseRDBNAM(true);
                n2 = this.peekCodePoint();
            }
            if (n2 == 8467) {
                bl4 = true;
                bl3 = this.checkAndGetReceivedFlag(bl3);
                object = this.parsePKGNAMCSN(true);
                n2 = this.peekCodePoint();
            }
            if (bl4) continue;
            this.doPrmnsprmSemantics(n2);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl2, bl3);
        this.netAgent_.setSvrcod(n);
        if (n == CodePoint.SVRCOD_WARNING) {
            this.netAgent_.accumulateReadException(new SqlException(this.netAgent_.logWriter_, new ClientMessageId("24501.S")));
        } else {
            this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("08006.C"), (Object)SqlException.getMessageUtil().getTextMessage("J128")));
        }
    }
}

