/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.oql.engine.api.OQLEngine;
import org.openide.util.NbBundle;

public class HeapFragmentWalkerUI
extends JPanel {
    private static final String NAVIGATE_BACK_NAME = NbBundle.getMessage(HeapFragmentWalkerUI.class, (String)"HeapFragmentWalkerUI_NavigateBackName");
    private static final String NAVIGATE_BACK_DESCR = NbBundle.getMessage(HeapFragmentWalkerUI.class, (String)"HeapFragmentWalkerUI_NavigateBackDescr");
    private static final String NAVIGATE_FORWARD_NAME = NbBundle.getMessage(HeapFragmentWalkerUI.class, (String)"HeapFragmentWalkerUI_NavigateForwardName");
    private static final String NAVIGATE_FORWARD_DESCR = NbBundle.getMessage(HeapFragmentWalkerUI.class, (String)"HeapFragmentWalkerUI_NavigateForwardDescr");
    private static Icon ICON_BACK = Icons.getIcon((String)"GeneralIcons.Back");
    private static Icon ICON_FORWARD = Icons.getIcon((String)"GeneralIcons.Forward");
    private AbstractAction backAction;
    private AbstractAction forwardAction;
    private AbstractButton oqlControllerPresenter;
    private AbstractButton analysisControllerPresenter;
    private AbstractButton classesControllerPresenter;
    private AbstractButton instancesControllerPresenter;
    private AbstractButton summaryControllerPresenter;
    private CardLayout controllerUIsLayout;
    private HeapFragmentWalker heapFragmentWalker;
    private JPanel oqlControllerPanel;
    private JPanel analysisControllerPanel;
    private JPanel classesControllerPanel;
    private JPanel controllerUIsPanel;
    private JPanel instancesControllerPanel;
    private JPanel summaryControllerPanel;
    private JToolBar toolBar;
    private boolean analysisEnabled;
    private boolean oqlEnabled;
    private int subControllersIndex;

    public HeapFragmentWalkerUI(HeapFragmentWalker heapFragmentWalker) {
        this.heapFragmentWalker = heapFragmentWalker;
        ProfilerIDESettings profilerIDESettings = ProfilerIDESettings.getInstance();
        this.analysisEnabled = profilerIDESettings.getHeapWalkerAnalysisEnabled();
        this.oqlEnabled = OQLEngine.isOQLSupported();
        this.initComponents();
        this.updateNavigationActions();
    }

    public boolean isOQLViewActive() {
        if (this.oqlControllerPanel == null) {
            return false;
        }
        return this.oqlControllerPanel.isShowing();
    }

    public boolean isAnalysisViewActive() {
        if (this.analysisControllerPanel == null) {
            return false;
        }
        return this.analysisControllerPanel.isShowing();
    }

    public boolean isClassesViewActive() {
        return this.classesControllerPanel.isShowing();
    }

    public boolean isInstancesViewActive() {
        return this.instancesControllerPanel.isShowing();
    }

    public boolean isSummaryViewActive() {
        return this.summaryControllerPanel.isShowing();
    }

    public void showOQLView() {
        this.showOQLView(true);
    }

    public void showAnalysisView() {
        this.showAnalysisView(true);
    }

    public void showClassesView() {
        this.showClassesView(true);
    }

    public void showHistoryOQLView() {
        this.showOQLView(false);
    }

    public void showHistoryAnalysisView() {
        this.showAnalysisView(false);
    }

    public void showHistoryClassesView() {
        this.showClassesView(false);
    }

    public void showHistoryInstancesView() {
        this.showInstancesView(false);
    }

    public void showHistorySummaryView() {
        this.showSummaryView(false);
    }

    public void showInstancesView() {
        this.showInstancesView(true);
    }

    public void showSummaryView() {
        this.showSummaryView(true);
    }

    public void updateNavigationActions() {
        this.backAction.setEnabled(this.heapFragmentWalker.isNavigationBackAvailable());
        this.forwardAction.setEnabled(this.heapFragmentWalker.isNavigationForwardAvailable());
    }

    private JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar(){

            @Override
            public Component add(Component component) {
                if (component instanceof AbstractButton) {
                    UIUtils.fixButtonUI((AbstractButton)((AbstractButton)component));
                }
                return super.add(component);
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                return new Dimension(dimension.width, dimension.height + 4);
            }
        };
        jToolBar.setFloatable(false);
        jToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        return jToolBar;
    }

    private void initComponents() {
        this.summaryControllerPanel = this.heapFragmentWalker.getSummaryController().getPanel();
        this.classesControllerPanel = this.heapFragmentWalker.getClassesController().getPanel();
        this.instancesControllerPanel = this.heapFragmentWalker.getInstancesController().getPanel();
        if (this.oqlEnabled) {
            this.oqlControllerPanel = this.heapFragmentWalker.getOQLController().getPanel();
        }
        if (this.analysisEnabled) {
            this.analysisControllerPanel = this.heapFragmentWalker.getAnalysisController().getPanel();
        }
        this.summaryControllerPresenter = this.heapFragmentWalker.getSummaryController().getPresenter();
        this.classesControllerPresenter = this.heapFragmentWalker.getClassesController().getPresenter();
        this.instancesControllerPresenter = this.heapFragmentWalker.getInstancesController().getPresenter();
        if (this.oqlEnabled) {
            this.oqlControllerPresenter = this.heapFragmentWalker.getOQLController().getPresenter();
        }
        if (this.analysisEnabled) {
            this.analysisControllerPresenter = this.heapFragmentWalker.getAnalysisController().getPresenter();
        }
        this.backAction = new AbstractAction(NAVIGATE_BACK_NAME, ICON_BACK){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeapFragmentWalkerUI.this.heapFragmentWalker.navigateBack();
            }
        };
        this.backAction.putValue("ShortDescription", NAVIGATE_BACK_DESCR);
        this.forwardAction = new AbstractAction(NAVIGATE_FORWARD_NAME, ICON_FORWARD){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeapFragmentWalkerUI.this.heapFragmentWalker.navigateForward();
            }
        };
        this.forwardAction.putValue("ShortDescription", NAVIGATE_FORWARD_DESCR);
        this.setLayout(new BorderLayout());
        this.toolBar = this.createToolBar();
        this.toolBar.add(this.backAction);
        this.toolBar.add(this.forwardAction);
        this.toolBar.addSeparator();
        this.toolBar.add(this.summaryControllerPresenter);
        this.toolBar.add(this.classesControllerPresenter);
        this.toolBar.add(this.instancesControllerPresenter);
        if (this.analysisEnabled) {
            this.toolBar.add(this.analysisControllerPresenter);
        }
        if (this.oqlEnabled) {
            this.toolBar.add(this.oqlControllerPresenter);
        }
        JPanel jPanel = new JPanel(new FlowLayout(3, 0, 0)){

            @Override
            public Dimension getPreferredSize() {
                if (UIUtils.isGTKLookAndFeel() || UIUtils.isNimbusLookAndFeel()) {
                    int n = ((HeapFragmentWalkerUI)HeapFragmentWalkerUI.this).toolBar.getSize().width;
                    int n2 = ((HeapFragmentWalkerUI)HeapFragmentWalkerUI.this).toolBar.getMinimumSize().width;
                    int n3 = n - n2;
                    return new Dimension(Math.max(n3, 0), 0);
                }
                return super.getPreferredSize();
            }
        };
        jPanel.setOpaque(false);
        this.toolBar.add(jPanel);
        this.subControllersIndex = this.toolBar.getComponentCount();
        this.controllerUIsLayout = new CardLayout();
        this.controllerUIsPanel = new JPanel(this.controllerUIsLayout);
        this.controllerUIsPanel.add((Component)this.summaryControllerPanel, this.summaryControllerPresenter.getText());
        this.controllerUIsPanel.add((Component)this.classesControllerPanel, this.classesControllerPresenter.getText());
        this.controllerUIsPanel.add((Component)this.instancesControllerPanel, this.instancesControllerPresenter.getText());
        if (this.analysisEnabled) {
            this.controllerUIsPanel.add((Component)this.analysisControllerPanel, this.analysisControllerPresenter.getText());
        }
        if (this.oqlEnabled) {
            this.controllerUIsPanel.add((Component)this.oqlControllerPanel, this.oqlControllerPresenter.getText());
        }
        this.add((Component)this.toolBar, "North");
        this.add((Component)this.controllerUIsPanel, "Center");
        this.summaryControllerPresenter.setSelected(true);
        this.classesControllerPresenter.setSelected(false);
        this.instancesControllerPresenter.setSelected(false);
        if (this.analysisEnabled) {
            this.analysisControllerPresenter.setSelected(false);
        }
        if (this.oqlEnabled) {
            this.oqlControllerPresenter.setSelected(false);
        }
        this.summaryControllerPresenter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeapFragmentWalkerUI.this.showSummaryView();
            }
        });
        this.classesControllerPresenter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeapFragmentWalkerUI.this.showClassesView();
            }
        });
        this.instancesControllerPresenter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeapFragmentWalkerUI.this.showInstancesView();
            }
        });
        if (this.analysisEnabled) {
            this.analysisControllerPresenter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HeapFragmentWalkerUI.this.showAnalysisView();
                }
            });
        }
        if (this.oqlEnabled) {
            this.oqlControllerPresenter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HeapFragmentWalkerUI.this.showOQLView();
                }
            });
        }
        this.updateClientPresenters(this.heapFragmentWalker.getSummaryController().getClientPresenters());
        this.summaryControllerPresenter.setSelected(true);
        this.getActionMap().put("PreviousViewAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeapFragmentWalkerUI.this.moveToPreviousView();
                HeapFragmentWalkerUI.this.updatePresentersFocus();
            }
        });
        this.getActionMap().put("NextViewAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeapFragmentWalkerUI.this.moveToNextView();
                HeapFragmentWalkerUI.this.updatePresentersFocus();
            }
        });
    }

    private void moveToNextView() {
        if (this.isSummaryViewActive()) {
            this.showClassesView();
        } else if (this.isClassesViewActive()) {
            this.showInstancesView();
        } else if (this.isInstancesViewActive()) {
            if (this.analysisEnabled) {
                this.showAnalysisView();
            } else if (this.oqlEnabled) {
                this.showOQLView();
            } else {
                this.showSummaryView();
            }
        } else if (this.isAnalysisViewActive()) {
            if (this.oqlEnabled) {
                this.showOQLView();
            } else {
                this.showSummaryView();
            }
        } else if (this.isOQLViewActive()) {
            this.showSummaryView();
        }
    }

    private void moveToPreviousView() {
        if (this.isSummaryViewActive()) {
            if (this.oqlEnabled) {
                this.showOQLView();
            } else if (this.analysisEnabled) {
                this.showAnalysisView();
            } else {
                this.showInstancesView();
            }
        } else if (this.isOQLViewActive()) {
            if (this.analysisEnabled) {
                this.showAnalysisView();
            } else {
                this.showInstancesView();
            }
        } else if (this.isClassesViewActive()) {
            this.showSummaryView();
        } else if (this.isInstancesViewActive()) {
            this.showClassesView();
        } else if (this.isAnalysisViewActive()) {
            this.showInstancesView();
        }
    }

    private void showOQLView(boolean bl) {
        if (!this.isOQLViewActive()) {
            if (bl) {
                this.heapFragmentWalker.createNavigationHistoryPoint();
            }
            this.controllerUIsLayout.show(this.controllerUIsPanel, this.oqlControllerPresenter.getText());
            this.updateClientPresenters(this.heapFragmentWalker.getOQLController().getClientPresenters());
        }
        this.updatePresenters();
    }

    private void showAnalysisView(boolean bl) {
        if (!this.isAnalysisViewActive()) {
            if (bl) {
                this.heapFragmentWalker.createNavigationHistoryPoint();
            }
            this.controllerUIsLayout.show(this.controllerUIsPanel, this.analysisControllerPresenter.getText());
            this.updateClientPresenters(this.heapFragmentWalker.getAnalysisController().getClientPresenters());
        }
        this.updatePresenters();
    }

    private void showClassesView(boolean bl) {
        if (!this.isClassesViewActive()) {
            if (bl) {
                this.heapFragmentWalker.createNavigationHistoryPoint();
            }
            this.controllerUIsLayout.show(this.controllerUIsPanel, this.classesControllerPresenter.getText());
            this.updateClientPresenters(this.heapFragmentWalker.getClassesController().getClientPresenters());
        }
        this.updatePresenters();
    }

    private void showInstancesView(boolean bl) {
        if (!this.isInstancesViewActive()) {
            if (bl) {
                this.heapFragmentWalker.createNavigationHistoryPoint();
            }
            this.controllerUIsLayout.show(this.controllerUIsPanel, this.instancesControllerPresenter.getText());
            this.updateClientPresenters(this.heapFragmentWalker.getInstancesController().getClientPresenters());
        }
        this.updatePresenters();
    }

    private void showSummaryView(boolean bl) {
        if (!this.isSummaryViewActive()) {
            if (bl) {
                this.heapFragmentWalker.createNavigationHistoryPoint();
            }
            this.controllerUIsLayout.show(this.controllerUIsPanel, this.summaryControllerPresenter.getText());
            this.updateClientPresenters(this.heapFragmentWalker.getSummaryController().getClientPresenters());
        }
        this.updatePresenters();
    }

    private void unifyComponentsSize(Component component, Component component2) {
        Dimension dimension = new Dimension(Math.max(component.getPreferredSize().width, component2.getPreferredSize().width), Math.max(component.getPreferredSize().height, component2.getPreferredSize().height));
        component.setPreferredSize(dimension);
        component2.setPreferredSize(dimension);
    }

    private void updateClientPresenters(AbstractButton[] abstractButtonArray) {
        while (this.toolBar.getComponentCount() > this.subControllersIndex) {
            this.toolBar.remove(this.subControllersIndex);
        }
        for (int i = 0; i < abstractButtonArray.length; ++i) {
            this.toolBar.add(abstractButtonArray[i]);
        }
        this.toolBar.repaint();
    }

    private void updatePresenters() {
        this.summaryControllerPresenter.setSelected(this.summaryControllerPanel.isShowing());
        this.classesControllerPresenter.setSelected(this.classesControllerPanel.isShowing());
        this.instancesControllerPresenter.setSelected(this.instancesControllerPanel.isShowing());
        if (this.analysisEnabled) {
            this.analysisControllerPresenter.setSelected(this.analysisControllerPanel.isShowing());
        }
        if (this.oqlEnabled) {
            this.oqlControllerPresenter.setSelected(this.oqlControllerPanel.isShowing());
        }
    }

    private void updatePresentersFocus() {
        if (this.summaryControllerPresenter.isSelected()) {
            this.summaryControllerPresenter.requestFocus();
        } else if (this.classesControllerPresenter.isSelected()) {
            this.classesControllerPresenter.requestFocus();
        } else if (this.instancesControllerPresenter.isSelected()) {
            this.instancesControllerPresenter.requestFocus();
        } else if (this.analysisEnabled && this.analysisControllerPresenter.isSelected()) {
            this.analysisControllerPresenter.requestFocus();
        } else if (this.oqlEnabled && this.oqlControllerPresenter.isSelected()) {
            this.oqlControllerPresenter.requestFocus();
        }
    }
}

