/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.internal.toolkit.builders;

import com.javafx.tools.doclets.internal.toolkit.AnnotationTypeWriter;
import com.javafx.tools.doclets.internal.toolkit.ClassWriter;
import com.javafx.tools.doclets.internal.toolkit.Configuration;
import com.javafx.tools.doclets.internal.toolkit.PropertyWriter;
import com.javafx.tools.doclets.internal.toolkit.WriterFactory;
import com.javafx.tools.doclets.internal.toolkit.builders.AbstractBuilder;
import com.javafx.tools.doclets.internal.toolkit.builders.AnnotationTypeBuilder;
import com.javafx.tools.doclets.internal.toolkit.builders.AnnotationTypeOptionalMemberBuilder;
import com.javafx.tools.doclets.internal.toolkit.builders.AnnotationTypeRequiredMemberBuilder;
import com.javafx.tools.doclets.internal.toolkit.builders.ClassBuilder;
import com.javafx.tools.doclets.internal.toolkit.builders.ConstantsSummaryBuilder;
import com.javafx.tools.doclets.internal.toolkit.builders.ConstructorBuilder;
import com.javafx.tools.doclets.internal.toolkit.builders.EnumConstantBuilder;
import com.javafx.tools.doclets.internal.toolkit.builders.FieldBuilder;
import com.javafx.tools.doclets.internal.toolkit.builders.MemberSummaryBuilder;
import com.javafx.tools.doclets.internal.toolkit.builders.MethodBuilder;
import com.javafx.tools.doclets.internal.toolkit.builders.PackageSummaryBuilder;
import com.javafx.tools.doclets.internal.toolkit.builders.PropertyBuilder;
import com.javafx.tools.doclets.internal.toolkit.builders.SerializedFormBuilder;
import com.javafx.tools.doclets.internal.toolkit.util.ClassTree;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Type;

public class BuilderFactory {
    private Configuration configuration;
    private WriterFactory writerFactory;

    public BuilderFactory(Configuration configuration) {
        this.configuration = configuration;
        this.writerFactory = configuration.getWriterFactory();
    }

    public AbstractBuilder getConstantsSummaryBuider() throws Exception {
        return ConstantsSummaryBuilder.getInstance(this.configuration, this.writerFactory.getConstantsSummaryWriter());
    }

    public AbstractBuilder getPackageSummaryBuilder(PackageDoc pkg, PackageDoc prevPkg, PackageDoc nextPkg) throws Exception {
        return PackageSummaryBuilder.getInstance(this.configuration, pkg, this.writerFactory.getPackageSummaryWriter(pkg, prevPkg, nextPkg));
    }

    public AbstractBuilder getClassBuilder(ClassDoc classDoc, ClassDoc prevClass, ClassDoc nextClass, ClassTree classTree) throws Exception {
        return ClassBuilder.getInstance(this.configuration, classDoc, this.writerFactory.getClassWriter(classDoc, prevClass, nextClass, classTree));
    }

    public AbstractBuilder getAnnotationTypeBuilder(AnnotationTypeDoc annotationType, Type prevType, Type nextType) throws Exception {
        return AnnotationTypeBuilder.getInstance(this.configuration, annotationType, this.writerFactory.getAnnotationTypeWriter(annotationType, prevType, nextType));
    }

    public AbstractBuilder getMethodBuilder(ClassWriter classWriter) throws Exception {
        return MethodBuilder.getInstance(this.configuration, classWriter.getClassDoc(), this.writerFactory.getMethodWriter(classWriter));
    }

    public AbstractBuilder getAnnotationTypeOptionalMemberBuilder(AnnotationTypeWriter annotationTypeWriter) throws Exception {
        return AnnotationTypeOptionalMemberBuilder.getInstance(this.configuration, (ClassDoc)annotationTypeWriter.getAnnotationTypeDoc(), this.writerFactory.getAnnotationTypeOptionalMemberWriter(annotationTypeWriter));
    }

    public AbstractBuilder getAnnotationTypeRequiredMemberBuilder(AnnotationTypeWriter annotationTypeWriter) throws Exception {
        return AnnotationTypeRequiredMemberBuilder.getInstance(this.configuration, (ClassDoc)annotationTypeWriter.getAnnotationTypeDoc(), this.writerFactory.getAnnotationTypeRequiredMemberWriter(annotationTypeWriter));
    }

    public AbstractBuilder getEnumConstantsBuilder(ClassWriter classWriter) throws Exception {
        return EnumConstantBuilder.getInstance(this.configuration, classWriter.getClassDoc(), this.writerFactory.getEnumConstantWriter(classWriter));
    }

    public AbstractBuilder getFieldBuilder(ClassWriter classWriter) throws Exception {
        return FieldBuilder.getInstance(this.configuration, classWriter.getClassDoc(), this.writerFactory.getFieldWriter(classWriter));
    }

    public AbstractBuilder getPropertyBuilder(ClassWriter classWriter) throws Exception {
        PropertyWriter propertyWriter = this.writerFactory.getPropertyWriter(classWriter);
        return PropertyBuilder.getInstance(this.configuration, classWriter.getClassDoc(), propertyWriter);
    }

    public AbstractBuilder getConstructorBuilder(ClassWriter classWriter) throws Exception {
        return ConstructorBuilder.getInstance(this.configuration, classWriter.getClassDoc(), this.writerFactory.getConstructorWriter(classWriter));
    }

    public AbstractBuilder getMemberSummaryBuilder(ClassWriter classWriter) throws Exception {
        return MemberSummaryBuilder.getInstance(classWriter, this.configuration);
    }

    public AbstractBuilder getMemberSummaryBuilder(AnnotationTypeWriter annotationTypeWriter) throws Exception {
        return MemberSummaryBuilder.getInstance(annotationTypeWriter, this.configuration);
    }

    public AbstractBuilder getSerializedFormBuilder() throws Exception {
        return SerializedFormBuilder.getInstance(this.configuration);
    }
}

