/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.formats.html;

import com.javafx.tools.doclets.formats.html.ConfigurationImpl;
import com.javafx.tools.doclets.formats.html.HtmlDocletWriter;
import com.javafx.tools.doclets.formats.html.LinkInfoImpl;
import com.javafx.tools.doclets.formats.html.markup.HtmlAttr;
import com.javafx.tools.doclets.formats.html.markup.HtmlConstants;
import com.javafx.tools.doclets.formats.html.markup.HtmlStyle;
import com.javafx.tools.doclets.formats.html.markup.HtmlTag;
import com.javafx.tools.doclets.formats.html.markup.HtmlTree;
import com.javafx.tools.doclets.formats.html.markup.RawHtml;
import com.javafx.tools.doclets.internal.toolkit.Configuration;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.builders.PackageSummaryBuilder;
import com.javafx.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.javafx.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.javafx.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class PackageFrameWriter
extends HtmlDocletWriter {
    private PackageDoc packageDoc;
    private Set<ClassDoc> documentedClasses;
    public static final String OUTPUT_FILE_NAME = "package-frame.html";

    public PackageFrameWriter(ConfigurationImpl configuration, PackageDoc packageDoc) throws IOException {
        super(configuration, DirectoryManager.getDirectoryPath(packageDoc), OUTPUT_FILE_NAME, DirectoryManager.getRelativePath(packageDoc));
        this.packageDoc = packageDoc;
        if (configuration.root.specifiedPackages().length == 0) {
            this.documentedClasses = new HashSet<ClassDoc>(Arrays.asList(configuration.root.classes()));
        }
    }

    public static void generate(ConfigurationImpl configuration, PackageDoc packageDoc) {
        try {
            PackageFrameWriter packgen = new PackageFrameWriter(configuration, packageDoc);
            String pkgName = Util.getPackageName(packageDoc);
            HtmlTree body = packgen.getBody(false, packgen.getWindowTitle(pkgName));
            RawHtml pkgNameContent = new RawHtml(pkgName);
            HtmlTree heading = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, HtmlStyle.bar, packgen.getTargetPackageLink(packageDoc, "classFrame", pkgNameContent));
            ((Content)body).addContent(heading);
            HtmlTree div = new HtmlTree(HtmlTag.DIV);
            div.addStyle(HtmlStyle.indexContainer);
            packgen.addClassListing(div);
            ((Content)body).addContent(div);
            packgen.printHtmlDocument(configuration.metakeywords.getMetaKeywords(packageDoc), false, body);
            packgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), OUTPUT_FILE_NAME);
            throw new DocletAbortException();
        }
    }

    protected void addClassListing(Content contentTree) {
        Configuration config = this.configuration();
        if (this.packageDoc.isIncluded()) {
            this.addClassKindListing(this.packageDoc.interfaces(), this.getResource("doclet.Interfaces"), contentTree);
            this.addClassKindListing(this.packageDoc.ordinaryClasses(), this.getResource("doclet.Classes"), contentTree);
            this.addClassKindListing(this.packageDoc.enums(), this.getResource("doclet.Enums"), contentTree);
            this.addClassKindListing(this.packageDoc.exceptions(), this.getResource("doclet.Exceptions"), contentTree);
            this.addClassKindListing(this.packageDoc.errors(), this.getResource("doclet.Errors"), contentTree);
            this.addClassKindListing((ClassDoc[])this.packageDoc.annotationTypes(), this.getResource("doclet.AnnotationTypes"), contentTree);
        } else {
            String name = Util.getPackageName(this.packageDoc);
            this.addClassKindListing(config.classDocCatalog.interfaces(name), this.getResource("doclet.Interfaces"), contentTree);
            this.addClassKindListing(config.classDocCatalog.ordinaryClasses(name), this.getResource("doclet.Classes"), contentTree);
            this.addClassKindListing(config.classDocCatalog.enums(name), this.getResource("doclet.Enums"), contentTree);
            this.addClassKindListing(config.classDocCatalog.exceptions(name), this.getResource("doclet.Exceptions"), contentTree);
            this.addClassKindListing(config.classDocCatalog.errors(name), this.getResource("doclet.Errors"), contentTree);
            this.addClassKindListing(config.classDocCatalog.annotationTypes(name), this.getResource("doclet.AnnotationTypes"), contentTree);
        }
    }

    protected void addClassKindListing(ClassDoc[] arr, Content labelContent, Content contentTree) {
        if ((arr = PackageSummaryBuilder.filterOutPrivateClasses(arr)).length > 0) {
            Arrays.sort(arr);
            boolean printedHeader = false;
            HtmlTree ul = new HtmlTree(HtmlTag.UL);
            ul.addAttr(HtmlAttr.TITLE, labelContent.toString());
            for (int i = 0; i < arr.length; ++i) {
                if (this.documentedClasses != null && !this.documentedClasses.contains(arr[i]) || !Util.isCoreClass(arr[i]) || !this.configuration.isGeneratedDoc(arr[i])) continue;
                if (!printedHeader) {
                    HtmlTree heading = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, true, labelContent);
                    contentTree.addContent(heading);
                    printedHeader = true;
                }
                RawHtml link = new RawHtml(this.getLink(new LinkInfoImpl(13, arr[i], arr[i].isInterface() ? this.italicsText(arr[i].name()) : arr[i].name(), "classFrame")));
                HtmlTree li = HtmlTree.LI(link);
                ul.addContent(li);
            }
            contentTree.addContent(ul);
        }
    }
}

