/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TooManyListenersException;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.modules.masterfs.ProvidedExtensionsProxy;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.BaseFileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObjectFactory;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.RootObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.RootObjWindows;
import org.netbeans.modules.masterfs.providers.AnnotationProvider;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public final class FileBasedFileSystem
extends FileSystem {
    private static final Logger LOG = Logger.getLogger(FileBasedFileSystem.class.getName());
    private static FileBasedFileSystem INSTANCE = new FileBasedFileSystem();
    private transient RootObj<? extends FileObject> root;
    private final transient StatusImpl status = new StatusImpl();
    private static transient int modificationInProgress;

    public FileBasedFileSystem() {
        if (Utilities.isWindows()) {
            RootObjWindows rootObjWindows = new RootObjWindows();
            this.root = new RootObj<RootObjWindows>(rootObjWindows);
        } else {
            FileObjectFactory fileObjectFactory = FileObjectFactory.getInstance(new File("/"));
            this.root = new RootObj<BaseFileObj>(fileObjectFactory.getRoot());
        }
    }

    public static synchronized boolean isModificationInProgress() {
        return modificationInProgress != 0;
    }

    private static synchronized void setModificationInProgress(boolean bl) {
        modificationInProgress = bl ? ++modificationInProgress : --modificationInProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runAsInconsistent(Runnable runnable) {
        try {
            FileBasedFileSystem.setModificationInProgress(true);
            runnable.run();
        }
        finally {
            FileBasedFileSystem.setModificationInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <Retval> Retval runAsInconsistent(FSCallable<Retval> fSCallable) throws IOException {
        Retval Retval = null;
        try {
            FileBasedFileSystem.setModificationInProgress(true);
            Retval = fSCallable.call();
        }
        finally {
            FileBasedFileSystem.setModificationInProgress(false);
        }
        return Retval;
    }

    public static Map<File, ? extends FileObjectFactory> factories() {
        return FileObjectFactory.factories();
    }

    public static FileObject getFileObject(File file) {
        return FileBasedFileSystem.getFileObject(file, FileObjectFactory.Caller.GetFileObject);
    }

    public static FileObject getFileObject(File file, FileObjectFactory.Caller caller) {
        FileObjectFactory fileObjectFactory = FileObjectFactory.getInstance(file);
        Object object = null;
        if (fileObjectFactory != null) {
            object = file.getParentFile() == null && Utilities.isUnix() ? FileBasedFileSystem.getInstance().getRoot() : fileObjectFactory.getValidFileObject(file, caller);
        }
        return object;
    }

    public static FileBasedFileSystem getInstance() {
        return INSTANCE;
    }

    public void refresh(final boolean bl) {
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FileBasedFileSystem.this.refreshImpl(bl);
            }
        };
        try {
            FileBasedFileSystem.getInstance().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    FileBasedFileSystem.runAsInconsistent(runnable);
                }
            });
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public void refreshImpl(boolean bl) {
        FileObject fileObject = this.root.getRealRoot();
        if (fileObject instanceof BaseFileObj) {
            ((BaseFileObj)fileObject).getFactory().refresh(bl);
        } else if (fileObject instanceof RootObjWindows) {
            Collection<? extends FileObjectFactory> collection = FileBasedFileSystem.factories().values();
            for (FileObjectFactory fileObjectFactory : collection) {
                fileObjectFactory.refresh(bl);
            }
        }
    }

    public String getDisplayName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean isReadOnly() {
        return false;
    }

    public FileObject getRoot() {
        return this.root;
    }

    public FileObject findResource(String string) {
        if (Utilities.isWindows()) {
            if ("".equals(string)) {
                return FileBasedFileSystem.getInstance().getRoot();
            }
        } else {
            string = string.startsWith("/") ? string : "/" + string;
        }
        File file = new File(string);
        if (string.contains("..") || string.contains("./") || string.contains("/.")) {
            file = FileUtil.normalizeFile((File)file);
        }
        return FileBasedFileSystem.getFileObject(file);
    }

    public SystemAction[] getActions() {
        return new SystemAction[0];
    }

    public final SystemAction[] getActions(Set<FileObject> set) {
        SystemAction[] systemActionArray = this.status.getActions(set);
        if (systemActionArray != null) {
            return systemActionArray;
        }
        return new SystemAction[0];
    }

    public FileSystem.Status getStatus() {
        return this.status;
    }

    public Object writeReplace() throws ObjectStreamException {
        return new SerReplace();
    }

    public static interface FSCallable<V> {
        public V call() throws IOException;
    }

    private static class SerReplace
    implements Serializable {
        static final long serialVersionUID = -3714631266626840241L;

        private SerReplace() {
        }

        public Object readResolve() throws ObjectStreamException {
            return FileBasedFileSystem.getInstance();
        }
    }

    public final class StatusImpl
    implements FileSystem.HtmlStatus,
    LookupListener,
    FileStatusListener {
        private Lookup.Result<AnnotationProvider> annotationProviders = Lookup.getDefault().lookup(new Lookup.Template(AnnotationProvider.class));
        private Collection<? extends AnnotationProvider> previousProviders;

        public StatusImpl() {
            this.annotationProviders.addLookupListener((LookupListener)this);
            this.resultChanged(null);
        }

        public ProvidedExtensions getExtensions() {
            Collection<Object> collection = this.previousProviders != null ? Collections.unmodifiableCollection(this.previousProviders) : Collections.emptyList();
            return new ProvidedExtensionsProxy(collection);
        }

        public void resultChanged(LookupEvent lookupEvent) {
            HashSet<? extends AnnotationProvider> hashSet;
            HashSet<? extends AnnotationProvider> hashSet2 = this.annotationProviders.allInstances();
            if (this.previousProviders != null) {
                hashSet = new HashSet<AnnotationProvider>(hashSet2);
                hashSet.removeAll(this.previousProviders);
                HashSet<? extends AnnotationProvider> hashSet3 = new HashSet<AnnotationProvider>(this.previousProviders);
                hashSet3.removeAll(hashSet2);
                Iterator object = hashSet3.iterator();
                while (object.hasNext()) {
                    AnnotationProvider annotationProvider = (AnnotationProvider)object.next();
                    annotationProvider.removeFileStatusListener(this);
                }
            } else {
                hashSet = hashSet2;
            }
            for (AnnotationProvider annotationProvider : hashSet) {
                try {
                    annotationProvider.addFileStatusListener(this);
                }
                catch (TooManyListenersException tooManyListenersException) {
                    Exceptions.printStackTrace((Throwable)tooManyListenersException);
                }
            }
            this.previousProviders = hashSet2;
        }

        public SystemAction[] getActions(Set<FileObject> set) {
            Object object;
            Action[] actionArray = null;
            Iterator iterator = this.annotationProviders.allInstances().iterator();
            while (actionArray == null && iterator.hasNext()) {
                object = (AnnotationProvider)iterator.next();
                actionArray = ((AnnotationProvider)object).actions(set);
            }
            if (actionArray != null) {
                object = new SystemAction[actionArray.length];
                for (int i = 0; i < actionArray.length; ++i) {
                    if (!(actionArray[i] instanceof SystemAction)) continue;
                    object[i] = (SystemAction)actionArray[i];
                }
                return object;
            }
            return null;
        }

        public void annotationChanged(FileStatusEvent fileStatusEvent) {
            FileBasedFileSystem.this.fireFileStatusChanged(fileStatusEvent);
        }

        public Image annotateIcon(Image image, int n, Set<? extends FileObject> set) {
            Image image2 = null;
            Iterator iterator = this.annotationProviders.allInstances().iterator();
            while (image2 == null && iterator.hasNext()) {
                AnnotationProvider annotationProvider = (AnnotationProvider)iterator.next();
                image2 = annotationProvider.annotateIcon(image, n, set);
            }
            if (image2 != null) {
                return image2;
            }
            return image;
        }

        public String annotateName(String string, Set<? extends FileObject> set) {
            String string2 = null;
            Iterator iterator = this.annotationProviders.allInstances().iterator();
            while (string2 == null && iterator.hasNext()) {
                AnnotationProvider annotationProvider = (AnnotationProvider)iterator.next();
                string2 = annotationProvider.annotateName(string, set);
            }
            if (string2 != null) {
                return string2;
            }
            return string;
        }

        public String annotateNameHtml(String string, Set<? extends FileObject> set) {
            String string2 = null;
            Iterator iterator = this.annotationProviders.allInstances().iterator();
            while (string2 == null && iterator.hasNext()) {
                AnnotationProvider annotationProvider = (AnnotationProvider)iterator.next();
                string2 = annotationProvider.annotateNameHtml(string, set);
            }
            return string2;
        }
    }
}

