/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.AWTEventListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.datatransfer.ExClipboard;

public final class NbClipboard
extends ExClipboard
implements LookupListener,
Runnable,
FlavorListener,
AWTEventListener {
    private static final Logger log = Logger.getLogger(NbClipboard.class.getName());
    private Clipboard systemClipboard;
    private ExClipboard.Convertor[] convertors;
    private Lookup.Result<ExClipboard.Convertor> result;
    final boolean slowSystemClipboard;
    private Transferable last;
    private long lastWindowActivated;
    private long lastWindowDeactivated;
    private Reference<Object> lastWindowDeactivatedSource = new WeakReference<Object>(null);
    private static final RequestProcessor RP = new RequestProcessor("System clipboard synchronizer");
    private RequestProcessor.Task syncTask = RP.create((Runnable)this, true);
    private Transferable data;
    private ClipboardOwner dataOwner;

    public NbClipboard() {
        this(Toolkit.getDefaultToolkit().getSystemClipboard());
    }

    NbClipboard(Clipboard clipboard) {
        super("NBClipboard");
        this.systemClipboard = clipboard;
        this.result = Lookup.getDefault().lookupResult(ExClipboard.Convertor.class);
        this.result.addLookupListener((LookupListener)this);
        clipboard.addFlavorListener(this);
        this.resultChanged(null);
        this.slowSystemClipboard = System.getProperty("netbeans.slow.system.clipboard.hack") != null ? Boolean.getBoolean("netbeans.slow.system.clipboard.hack") : !Utilities.isMac();
        if (!this.slowSystemClipboard) {
            if (System.getProperty("sun.awt.datatransfer.timeout") == null) {
                System.setProperty("sun.awt.datatransfer.timeout", "1000");
            }
        } else {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 64L);
        }
    }

    protected synchronized ExClipboard.Convertor[] getConvertors() {
        return this.convertors;
    }

    public synchronized void resultChanged(LookupEvent lookupEvent) {
        Collection collection = this.result.allInstances();
        ExClipboard.Convertor[] convertorArray = new ExClipboard.Convertor[collection.size()];
        this.convertors = collection.toArray(convertorArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContents(Transferable transferable, ClipboardOwner clipboardOwner) {
        NbClipboard nbClipboard = this;
        synchronized (nbClipboard) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "setContents called with: ");
                this.logFlavors(transferable, Level.FINER, log.isLoggable(Level.FINEST));
            }
            transferable = this.convert(transferable);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "After conversion:");
                this.logFlavors(transferable, Level.FINER, log.isLoggable(Level.FINEST));
            }
            if (this.slowSystemClipboard) {
                if (this.contents != null) {
                    NbClipboard.transferableOwnershipLost((Transferable)this.contents);
                }
                final ClipboardOwner clipboardOwner2 = this.owner;
                final Transferable transferable2 = this.contents;
                this.owner = clipboardOwner;
                this.contents = transferable;
                if (clipboardOwner2 != null && clipboardOwner2 != clipboardOwner) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            clipboardOwner2.lostOwnership((Clipboard)((Object)NbClipboard.this), transferable2);
                        }
                    });
                }
            } else {
                if (this.last != null) {
                    NbClipboard.transferableOwnershipLost((Transferable)this.last);
                }
                this.last = transferable;
            }
            this.data = transferable;
            this.dataOwner = clipboardOwner;
            this.syncTask.schedule(0);
        }
        this.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transferable getContents(Object object) {
        try {
            Transferable transferable;
            log.log(Level.FINE, "getContents, slowSystemClipboard: {0}", this.slowSystemClipboard);
            if (this.slowSystemClipboard && !RP.isRequestProcessorThread()) {
                long l = System.currentTimeMillis();
                if (this.lastWindowActivated != 0L && this.lastWindowActivated + 100L < l) {
                    this.lastWindowActivated = 0L;
                    this.syncTask.schedule(0);
                    boolean bl = this.syncTask.waitFinished(100L);
                    log.log(Level.FINE, "after syncTask wait, finished {0}", bl);
                } else if (log.isLoggable(Level.FINE)) {
                    log.fine("no wait, last: " + this.lastWindowActivated + " now: " + l);
                }
                transferable = super.getContents(object);
            } else {
                this.syncTask.waitFinished();
                log.log(Level.FINE, "after syncTask clipboard wait");
                try {
                    transferable = this.systemClipboard.getContents(object);
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    log.log(Level.INFO, "System clipboard not available.", throwable);
                    transferable = null;
                }
            }
            NbClipboard nbClipboard = this;
            synchronized (nbClipboard) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "getContents by " + object);
                    this.logFlavors(transferable, Level.FINE, log.isLoggable(Level.FINEST));
                }
                if (transferable == null) {
                    return null;
                }
                Transferable transferable2 = this.convert(transferable);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "getContents by " + object);
                    this.logFlavors(transferable2, Level.FINE, log.isLoggable(Level.FINEST));
                    transferable2 = new LoggableTransferable(transferable2);
                }
                return transferable2;
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger(NbClipboard.class.getName()).log(Level.WARNING, null, interruptedException);
            return null;
        }
        catch (Throwable throwable) {
            Exceptions.printStackTrace((Throwable)throwable);
            return null;
        }
    }

    public FlavorListener[] getFlavorListeners() {
        return new FlavorListener[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Transferable transferable = null;
        ClipboardOwner clipboardOwner = null;
        log.fine("Running update");
        Object object = this;
        synchronized (object) {
            if (this.data != null) {
                transferable = this.data;
                clipboardOwner = this.dataOwner;
            }
            this.data = null;
            this.dataOwner = null;
        }
        if (transferable != null) {
            try {
                this.systemClipboard.setContents(transferable, clipboardOwner);
            }
            catch (IllegalStateException illegalStateException) {
                log.log(Level.FINE, "systemClipboard not available", illegalStateException);
                this.data = transferable;
                this.dataOwner = clipboardOwner;
                this.syncTask.schedule(100);
                return;
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "systemClipboard updated:");
                this.logFlavors(transferable, Level.FINE, log.isLoggable(Level.FINEST));
            }
            return;
        }
        try {
            object = this.systemClipboard.getContents(this);
            super.setContents((Transferable)object, null);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "internal clipboard updated:");
                this.logFlavors((Transferable)object, Level.FINE, log.isLoggable(Level.FINEST));
            }
            this.fireChange();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    final void waitFinished() {
        this.syncTask.waitFinished();
    }

    final void activateWindowHack(boolean bl) {
        this.lastWindowActivated = System.currentTimeMillis();
        if (bl) {
            this.syncTask.schedule(0);
        }
    }

    private void logFlavors(Transferable transferable, Level level, boolean bl) {
        if (transferable == null) {
            log.log(level, "  no clipboard contents");
        } else {
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                stringBuilder.append("  ").append(i).append(" = ").append(dataFlavorArray[i]);
                if (bl) {
                    try {
                        stringBuilder.append(" contains: ").append(transferable.getTransferData(dataFlavorArray[i]));
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                        Exceptions.printStackTrace((Throwable)unsupportedFlavorException);
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
                stringBuilder.append("\n");
            }
            log.log(level, stringBuilder.toString());
        }
    }

    @Override
    public void flavorsChanged(FlavorEvent flavorEvent) {
        this.fireChange();
    }

    private void fireChange() {
        FlavorEvent flavorEvent = new FlavorEvent((Clipboard)((Object)this));
        this.fireClipboardChange();
        for (FlavorListener flavorListener : super.getFlavorListeners()) {
            flavorListener.flavorsChanged(flavorEvent);
        }
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        if (!(aWTEvent instanceof WindowEvent)) {
            return;
        }
        if (aWTEvent.getID() == 206) {
            this.lastWindowDeactivated = System.currentTimeMillis();
            this.lastWindowDeactivatedSource = new WeakReference<Object>(aWTEvent.getSource());
        }
        if (aWTEvent.getID() == 205) {
            if (System.currentTimeMillis() - this.lastWindowDeactivated < 100L && aWTEvent.getSource() == this.lastWindowDeactivatedSource.get()) {
                this.activateWindowHack(false);
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "window activated scheduling update");
            }
            this.syncTask.schedule(0);
        }
    }

    private final class LoggableTransferable
    implements Transferable {
        private Transferable delegate;

        public LoggableTransferable(Transferable transferable) {
            this.delegate = transferable;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            log.log(Level.FINE, "Request for flavor: " + dataFlavor);
            Object object = this.delegate.getTransferData(dataFlavor);
            log.log(Level.FINE, "Returning value: " + object);
            return object;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.delegate.getTransferDataFlavors();
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            boolean bl = this.delegate.isDataFlavorSupported(dataFlavor);
            log.log(Level.FINE, "isDataFlavorSupported: " + dataFlavor + " result: " + bl);
            return bl;
        }
    }
}

