/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import org.netbeans.core.output2.LineInfo;
import org.netbeans.core.output2.Lines;
import org.netbeans.core.output2.OutputDocument;
import org.openide.util.Exceptions;

public class WrappedTextView
extends View
implements TabExpander {
    static final int TAB_SIZE = 8;
    private JTextComponent comp;
    private int charsPerLine = 80;
    private int fontDescent = 4;
    private static final Segment SEGMENT = new Segment();
    private int width = 0;
    private boolean changed = true;
    private int charWidth = 12;
    private int charHeight = 7;
    static final int[] ln = new int[3];
    private boolean aa = false;
    private static final boolean antialias = Boolean.getBoolean("swing.aatext") || "Aqua".equals(UIManager.getLookAndFeel().getID());
    static final Color arrowColor = new Color(80, 162, 80);
    private static Map hintsMap = null;
    int tabSize;
    int tabBase;
    private int tabOffsetX = 0;
    float viewWidth = -1.0f;

    static final Map getHints() {
        if (hintsMap == null && (hintsMap = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints")) == null) {
            hintsMap = new HashMap();
            if (antialias) {
                hintsMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
        }
        return hintsMap;
    }

    public WrappedTextView(Element element, JTextComponent jTextComponent) {
        super(element);
        this.comp = jTextComponent;
    }

    @Override
    public float getPreferredSpan(int n) {
        OutputDocument outputDocument = this.odoc();
        float f = 0.0f;
        if (outputDocument != null) {
            this.updateWidth();
            switch (n) {
                case 0: {
                    f = this.charsPerLine;
                    break;
                }
                case 1: {
                    f = outputDocument.getLines().getLogicalLineCountIfWrappedAt(this.charsPerLine) * this.charHeight + this.fontDescent;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Integer.toString(n));
                }
            }
        }
        return f;
    }

    @Override
    public float getMinimumSpan(int n) {
        return this.getPreferredSpan(n);
    }

    @Override
    public float getMaximumSpan(int n) {
        return this.getPreferredSpan(n);
    }

    @Override
    public void setSize(float f, float f2) {
        super.setSize(f, f2);
        if (this.viewWidth != f) {
            this.viewWidth = f;
            this.updateMetrics();
        }
    }

    private int getTabSize() {
        return 8;
    }

    @Override
    public float nextTabStop(float f, int n) {
        if (this.tabSize == 0) {
            return f;
        }
        int n2 = ((int)f - WrappedTextView.margin() + this.tabOffsetX) / this.tabSize;
        return WrappedTextView.margin() + (n2 + 1) * this.tabSize - this.tabOffsetX;
    }

    void updateMetrics() {
        Font font = this.comp.getFont();
        FontMetrics fontMetrics = this.comp.getFontMetrics(font);
        this.charWidth = fontMetrics.charWidth('m');
        this.charHeight = fontMetrics.getHeight();
        this.fontDescent = fontMetrics.getMaxDescent();
        Graphics2D graphics2D = (Graphics2D)this.comp.getGraphics();
        if (graphics2D != null) {
            this.aa = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING) == RenderingHints.VALUE_ANTIALIAS_ON;
        }
        this.tabSize = this.getTabSize() * this.charWidth;
        this.updateWidth();
    }

    private OutputDocument odoc() {
        Document document = this.comp.getDocument();
        if (document instanceof OutputDocument) {
            return (OutputDocument)document;
        }
        return null;
    }

    private void updateWidth() {
        if (this.comp.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.comp.getParent();
            this.width = jViewport.getExtentSize().width - (this.aa ? 18 : 17);
        } else {
            this.width = this.comp.getWidth() - (this.aa ? 18 : 17);
        }
        if (this.width < 0) {
            this.width = 0;
        }
        this.charsPerLine = this.width / this.charWidth;
    }

    private static int margin() {
        return 9;
    }

    @Override
    public void paint(Graphics graphics, Shape shape) {
        ((Graphics2D)graphics).addRenderingHints(WrappedTextView.getHints());
        this.comp.getHighlighter().paint(graphics);
        this.tabBase = ((Rectangle)shape).x + WrappedTextView.margin();
        OutputDocument outputDocument = this.odoc();
        if (outputDocument != null) {
            Rectangle rectangle = graphics.getClipBounds();
            rectangle.y = Math.max(0, rectangle.y - this.charHeight);
            rectangle.height += this.charHeight * 2;
            int n = outputDocument.getElementCount();
            if (n == 0) {
                return;
            }
            WrappedTextView.ln[0] = rectangle.y / this.charHeight;
            Lines lines = outputDocument.getLines();
            lines.toPhysicalLineIndex(ln, this.charsPerLine);
            int n2 = ln[0];
            graphics.setColor(this.comp.getForeground());
            Segment segment = SwingUtilities.isEventDispatchThread() ? SEGMENT : new Segment();
            int n3 = this.comp.getSelectionStart();
            int n4 = this.comp.getSelectionEnd();
            int n5 = rectangle.y - rectangle.y % this.charHeight + this.charHeight;
            int n6 = (rectangle.height + this.charHeight - 1) / this.charHeight * this.charsPerLine;
            try {
                for (int i = n2; i < n; ++i) {
                    int n7;
                    if (n5 > rectangle.y + rectangle.height) {
                        return;
                    }
                    int n8 = outputDocument.getLineStart(i);
                    int n9 = outputDocument.getLineEnd(i);
                    int n10 = n9 - n8;
                    if (n10 == 0) {
                        n5 += this.charHeight;
                        continue;
                    }
                    n10 = lines.lengthWithTabs(i);
                    LineInfo lineInfo = lines.getLineInfo(i);
                    int n11 = n10 <= this.charsPerLine ? 1 : (this.charsPerLine == 0 ? n10 : (n10 + this.charsPerLine - 1) / this.charsPerLine);
                    int n12 = i == n2 && n11 > 0 && ln[1] > 0 ? ln[1] : 0;
                    int n13 = 0;
                    int n14 = 0;
                    int n15 = n12 - 1;
                    int n16 = 0;
                    int n17 = this.charsPerLine;
                    if (n12 > 0) {
                        n7 = n12 * this.charsPerLine;
                        int[] nArray = new int[]{0};
                        n7 = lines.getNumPhysicalChars(n8, n7, nArray);
                        n8 += n7;
                        if (nArray[0] > 0) {
                            n17 -= nArray[0];
                            n16 = nArray[0] * this.charWidth;
                            n14 += nArray[0];
                        }
                    } else {
                        n7 = 0;
                    }
                    n10 = Math.min(n6, n10 - n7);
                    int n18 = Math.min(n6, n9 - n8);
                    outputDocument.getText(n8, n18, segment);
                    this.tabOffsetX = this.charWidth * n12 * this.charsPerLine;
                    for (LineInfo.Segment segment2 : lineInfo.getLineSegments()) {
                        if (segment2.getEnd() < n7) continue;
                        graphics.setColor(segment2.getColor());
                        int n19 = 0;
                        while (n13 < segment2.getEnd() - n7 && n12 < n11) {
                            int n20;
                            int n21 = n20 = Math.min(n17, segment2.getEnd() - n7 - n13);
                            if (n20 > 0) {
                                n21 = this.getCharsForLengthWithTabs(segment.array, n13, n12 * this.charsPerLine + n19, n20, n17);
                                if (n12 != n11 - 1 && n15 != n12) {
                                    n15 = n12;
                                    this.drawArrow(graphics, n5, n12 == n11 - 2);
                                }
                                this.drawText(segment, graphics, n16, n5, n8, n13, n3, n21, n4);
                                if (segment2.getListener() != null) {
                                    this.underline(graphics, segment, n13, n21, n16, n5);
                                }
                            }
                            n20 = this.getCharLengthWithTabs(segment.array, n13, n12 * this.charsPerLine + n19, n21);
                            n13 += n21;
                            n14 += n20;
                            n17 -= n20;
                            n16 += n20 * this.charWidth;
                            n19 += n20;
                            while (n17 <= 0) {
                                int n22;
                                int n23;
                                int n24;
                                n19 = -n17;
                                n17 += this.charsPerLine;
                                ++n12;
                                n16 = n19 * this.charWidth;
                                this.tabOffsetX += this.charWidth * this.charsPerLine;
                                if ((n5 += this.charHeight) > rectangle.y + rectangle.height) {
                                    return;
                                }
                                if (n19 <= 0 || n3 == n4 || (n24 = Math.max(n3, n23 = n8 + n13)) >= (n22 = Math.min(n4, n23 + n21))) continue;
                                this.drawSelection(graphics, 0, n16, n5);
                            }
                        }
                    }
                    if (this.charsPerLine != 0 && n14 % this.charsPerLine == 0) continue;
                    n5 += this.charHeight;
                }
                this.tabOffsetX = 0;
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
    }

    private void drawText(Segment segment, Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9;
        int n10;
        if (n5 != n7 && (n10 = Math.max(n5, n9 = n3 + n4)) < (n8 = Math.min(n7, n9 + n6))) {
            n9 = this.odoc().getLines().getNumLogicalChars(n3, n9 - n3) + n3;
            n10 = this.odoc().getLines().getNumLogicalChars(n3, n10 - n3) + n3;
            n8 = this.odoc().getLines().getNumLogicalChars(n3, n8 - n3) + n3;
            int n11 = n + WrappedTextView.margin() + (n10 - n9) * this.charWidth;
            int n12 = (n8 - n10) * this.charWidth;
            int n13 = this.charsPerLine * this.charWidth;
            if (n11 - WrappedTextView.margin() + n12 > n13) {
                n12 = n13 - n11 + WrappedTextView.margin();
            }
            Color color = graphics.getColor();
            graphics.setColor(this.comp.getSelectionColor());
            graphics.fillRect(n11, n2 + this.fontDescent - this.charHeight, n12, this.charHeight);
            graphics.setColor(color);
        }
        n9 = segment.count;
        n10 = segment.offset;
        segment.count = n6;
        segment.offset = n4;
        Utilities.drawTabbedText(segment, WrappedTextView.margin() + n, n2, graphics, (TabExpander)this, n4);
        segment.count = n9;
        segment.offset = n10;
    }

    private void drawSelection(Graphics graphics, int n, int n2, int n3) {
        Color color = graphics.getColor();
        graphics.setColor(this.comp.getSelectionColor());
        graphics.fillRect(n + WrappedTextView.margin(), n3 + this.fontDescent - this.charHeight, n2 - n, this.charHeight);
        graphics.setColor(color);
    }

    private void underline(Graphics graphics, Segment segment, int n, int n2, int n3, int n4) {
        int n5 = WrappedTextView.margin() + n3;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n6 = n5 + fontMetrics.charsWidth(segment.array, n, n2);
        int n7 = fontMetrics.getDescent() - 1;
        graphics.drawLine(n5, n4 + n7, n6, n4 + n7);
    }

    private void drawArrow(Graphics graphics, int n, boolean bl) {
        int n2;
        Color color = graphics.getColor();
        graphics.setColor(WrappedTextView.arrowColor());
        int n3 = this.width + 15;
        n += 2;
        int n4 = n2 = this.aa ? 8 : 4;
        if (this.aa) {
            graphics.drawArc(n3 - n2, n - this.charHeight / 2, n2 + 1, this.charHeight, 265, 185);
            ++n3;
        } else {
            graphics.drawLine(n3 - n2, n - this.charHeight / 2, n3, n - this.charHeight / 2);
            graphics.drawLine(n3, n - this.charHeight / 2 + 1, n3, n + this.charHeight / 2 - 1);
            graphics.drawLine(n3 - n2, n + this.charHeight / 2, n3, n + this.charHeight / 2);
        }
        if (bl) {
            n2 = this.aa ? 7 : 8;
            int[] nArray = new int[]{n3 - n2, n3 - n2 + 5, n3 - n2 + 5};
            int[] nArray2 = new int[]{n + this.charHeight / 2, n + this.charHeight / 2 - 5, n + this.charHeight / 2 + 5};
            graphics.fillPolygon(nArray, nArray2, 3);
        }
        graphics.setColor(WrappedTextView.arrowColor());
        graphics.drawLine(1, n - this.charHeight / 2, 5, n - this.charHeight / 2);
        graphics.drawLine(1, n - this.charHeight / 2, 1, n + this.charHeight / 2);
        graphics.drawLine(1, n + this.charHeight / 2, 5, n + this.charHeight / 2);
        graphics.setColor(color);
    }

    private static Color arrowColor() {
        return arrowColor;
    }

    @Override
    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        Rectangle rectangle = new Rectangle();
        rectangle.setBounds(0, 0, this.charWidth, this.charHeight);
        OutputDocument outputDocument = this.odoc();
        if (outputDocument != null) {
            int n2 = Math.max(0, outputDocument.getElementIndex(n));
            int n3 = outputDocument.getLineStart(n2);
            int n4 = n - n3;
            n4 = outputDocument.getLines().getNumLogicalChars(n3, n4);
            int n5 = outputDocument.getLines().getLogicalLineCountAbove(n2, this.charsPerLine);
            if (n4 > this.charsPerLine && this.charsPerLine != 0) {
                n5 += n4 / this.charsPerLine;
                n4 %= this.charsPerLine;
            }
            rectangle.y = n5 * this.charHeight + this.fontDescent;
            rectangle.x = WrappedTextView.margin() + n4 * this.charWidth;
        }
        return rectangle;
    }

    @Override
    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        OutputDocument outputDocument = this.odoc();
        if (outputDocument != null) {
            int n = Math.max((int)f - WrappedTextView.margin(), 0);
            int n2 = (int)f2 - this.fontDescent;
            WrappedTextView.ln[0] = n2 / this.charHeight;
            outputDocument.getLines().toPhysicalLineIndex(ln, this.charsPerLine);
            int n3 = ln[0];
            int n4 = ln[2] - 1;
            int n5 = outputDocument.getElementCount();
            if (n5 == 0) {
                return 0;
            }
            if (n3 >= n5) {
                return outputDocument.getLength();
            }
            int n6 = outputDocument.getLineStart(n3);
            int n7 = outputDocument.getLines().lengthWithTabs(n3);
            int n8 = n6 + n7;
            int n9 = n / this.charWidth;
            if (n9 > n7) {
                n9 = n7;
            }
            int n10 = n4 > 0 ? Math.min(n8, n6 + ln[1] * this.charsPerLine + n9) : Math.min(n6 + n9, n8);
            Lines lines = outputDocument.getLines();
            n10 = lines.getNumPhysicalChars(n6, n10 - n6, null) + n6;
            n10 = Math.min(outputDocument.getLength(), n10);
            return n10;
        }
        return 0;
    }

    private int getCharLengthWithTabs(char[] cArray, int n, int n2, int n3) {
        int n4 = Math.min(cArray.length, n + n3);
        int n5 = 0;
        for (int i = n; i < n4; ++i) {
            if ('\t' != cArray[i]) continue;
            int n6 = 8 - (i - n + n2 + n5) % 8;
            n5 += n6 - 1;
            n3 += n6 - 1;
        }
        return n3;
    }

    private int getCharsForLengthWithTabs(char[] cArray, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = Math.min(cArray.length, n + n3);
        int n7 = 0;
        int n8 = 0;
        for (n5 = n; n5 < n6 && n7 < n4; ++n5) {
            if ('\t' == cArray[n5]) {
                int n9 = 8 - (n5 - n + n2 + n8) % 8;
                n8 += n9 - 1;
                n7 += n9;
                continue;
            }
            ++n7;
        }
        if (n7 > n4 && n5 > n + 1 && cArray[n5 - 1] != '\t') {
            --n5;
        }
        return n5 - n;
    }
}

