/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

final class IntListSimple {
    private int[] array;
    private int used = 0;

    IntListSimple(int n) {
        this.array = new int[n];
    }

    public synchronized void add(int n) {
        if (this.used >= this.array.length) {
            this.growArray();
        }
        this.array[this.used++] = n;
    }

    public synchronized int get(int n) {
        if (n >= this.used) {
            throw new ArrayIndexOutOfBoundsException("List contains " + this.used + " items, but tried to fetch item " + n);
        }
        return this.array[n];
    }

    public synchronized int size() {
        return this.used;
    }

    private void growArray() {
        int[] nArray = this.array;
        this.array = new int[Math.round((float)this.array.length * 1.5f)];
        System.arraycopy(nArray, 0, this.array, 0, nArray.length);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("IntListSimple [");
        for (int i = 0; i < this.used; ++i) {
            stringBuilder.append(i);
            stringBuilder.append(':');
            stringBuilder.append(this.array[i]);
            if (i == this.used - 1) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

