/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.profiling.snapshot;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.DataSourceRepository;
import com.sun.tools.visualvm.core.datasource.Storage;
import com.sun.tools.visualvm.core.datasupport.DataChangeEvent;
import com.sun.tools.visualvm.core.datasupport.DataChangeListener;
import com.sun.tools.visualvm.core.snapshot.Snapshot;
import com.sun.tools.visualvm.core.ui.DataSourceWindowManager;
import com.sun.tools.visualvm.profiling.snapshot.ProfilerSnapshot;
import com.sun.tools.visualvm.profiling.snapshot.ProfilerSnapshotsSupport;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.ResultsManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

final class ProfilerSnapshotProvider {
    ProfilerSnapshotProvider() {
    }

    public void createSnapshot(LoadedSnapshot loadedSnapshot, Application application, boolean openView) {
        final ProfilerSnapshot snapshot = new ProfilerSnapshot(loadedSnapshot, (DataSource)application);
        application.getRepository().addDataSource((DataSource)snapshot);
        if (openView) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DataSourceWindowManager.sharedInstance().openDataSource((DataSource)snapshot);
                }
            });
        }
    }

    public void initialize() {
        DataSourceRepository.sharedInstance().addDataChangeListener((DataChangeListener)new SnapshotListener(), Snapshot.class);
        DataSourceRepository.sharedInstance().addDataChangeListener((DataChangeListener)new ApplicationListener(), Application.class);
    }

    private void processNewSnapshot(Snapshot snapshot) {
        if (snapshot instanceof ProfilerSnapshot) {
            return;
        }
        File snapshotFile = snapshot.getFile();
        if (snapshotFile != null && snapshotFile.isDirectory()) {
            LoadedSnapshot[] loadedSnapshots;
            HashSet<ProfilerSnapshot> snapshots = new HashSet<ProfilerSnapshot>();
            for (LoadedSnapshot loadedSnapshot : loadedSnapshots = this.findSnapshots(snapshotFile)) {
                if (loadedSnapshot == null) continue;
                snapshots.add(new ProfilerSnapshot(loadedSnapshot, (DataSource)snapshot));
            }
            snapshot.getRepository().addDataSources(snapshots);
        }
    }

    private void processNewApplication(Application application) {
        Storage storage = application.getStorage();
        if (storage.directoryExists()) {
            LoadedSnapshot[] loadedSnapshots;
            HashSet<ProfilerSnapshot> snapshots = new HashSet<ProfilerSnapshot>();
            for (LoadedSnapshot loadedSnapshot : loadedSnapshots = this.findSnapshots(storage.getDirectory())) {
                if (loadedSnapshot == null) continue;
                snapshots.add(new ProfilerSnapshot(loadedSnapshot, (DataSource)application));
            }
            application.getRepository().addDataSources(snapshots);
        }
    }

    private LoadedSnapshot[] findSnapshots(File directory) {
        File[] files = directory.listFiles(ProfilerSnapshotsSupport.getInstance().getCategory().getFilenameFilter());
        if (files == null) {
            return new LoadedSnapshot[0];
        }
        FileObject[] fileObjects = new FileObject[files.length];
        for (int i = 0; i < files.length; ++i) {
            fileObjects[i] = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)files[i]));
        }
        return ResultsManager.getDefault().loadSnapshots(fileObjects);
    }

    private class ApplicationListener
    implements DataChangeListener<Application> {
        private ApplicationListener() {
        }

        public void dataChanged(DataChangeEvent<Application> event) {
            final Set applications = event.getAdded();
            if (!applications.isEmpty()) {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        for (Application application : applications) {
                            ProfilerSnapshotProvider.this.processNewApplication(application);
                        }
                    }
                });
            }
        }
    }

    private class SnapshotListener
    implements DataChangeListener<Snapshot> {
        private SnapshotListener() {
        }

        public void dataChanged(DataChangeEvent<Snapshot> event) {
            final Set snapshots = event.getAdded();
            if (!snapshots.isEmpty()) {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        for (Snapshot snapshot : snapshots) {
                            ProfilerSnapshotProvider.this.processNewSnapshot(snapshot);
                        }
                    }
                });
            }
        }
    }
}

