/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.CameraImpl;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.javafx.jmx.HighlightRegion;
import com.sun.javafx.runtime.SystemProperties;
import com.sun.javafx.sg.DirtyRegionContainer;
import com.sun.javafx.sg.DirtyRegionPool;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.PaintCollector;
import com.sun.prism.BasicStroke;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsResource;
import com.sun.prism.Presentable;
import com.sun.prism.RenderingContext;
import com.sun.prism.ResourceFactory;
import com.sun.prism.camera.PrismPerspectiveCameraImpl;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.paint.Color;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractPainter {
    protected static boolean verbose = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean("quantum.paint");
        }
    });
    protected static final ReentrantLock renderLock = new ReentrantLock();
    protected static final PaintCollector collector = PaintCollector.getInstance();
    protected Presentable presentable;
    protected RenderingContext context = null;
    protected ResourceFactory factory;
    protected AtomicBoolean liveRepaint = new AtomicBoolean(false);
    protected int width;
    protected int height;
    private boolean renderOverlay = false;
    Rectangle dirtyRect;
    RectBounds clip;
    RectBounds dirtyRegionTemp;
    DirtyRegionPool dirtyRegionPool;
    DirtyRegionContainer dirtyRegionContainer;
    Affine3D tx;
    Affine3D scaleTx;
    GeneralTransform3D viewProjTx;
    GeneralTransform3D projTx;
    NGNode root;
    NGNode overlayRoot;
    GlassScene scene;

    protected AbstractPainter(GlassScene glassScene) {
        if (PrismSettings.dirtyOptsEnabled) {
            this.tx = new Affine3D();
            this.viewProjTx = new GeneralTransform3D();
            this.projTx = new GeneralTransform3D();
            this.scaleTx = new Affine3D();
            this.clip = new RectBounds();
            this.dirtyRect = new Rectangle();
            this.dirtyRegionTemp = new RectBounds();
            this.dirtyRegionPool = new DirtyRegionPool(PrismSettings.dirtyRegionCount);
            this.dirtyRegionContainer = this.dirtyRegionPool.checkOut();
        }
        this.scene = glassScene;
    }

    protected void setPaintBounds(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    protected void setRoot(NGNode nGNode) {
        this.root = nGNode;
    }

    protected NGNode getRoot() {
        return this.root;
    }

    protected void setOverlayRoot(NGNode nGNode) {
        this.overlayRoot = nGNode;
    }

    protected NGNode getOverlayRoot() {
        return this.overlayRoot;
    }

    protected void setRenderOverlay(boolean bl) {
        this.renderOverlay = bl;
    }

    protected abstract void doPaint(Graphics var1);

    protected abstract CameraImpl getCamera();

    private void adjustPerspective(CameraImpl cameraImpl) {
        if (cameraImpl instanceof PrismPerspectiveCameraImpl) {
            PrismPerspectiveCameraImpl prismPerspectiveCameraImpl = (PrismPerspectiveCameraImpl)cameraImpl;
            this.scaleTx.setToScale((double)this.width / 2.0, (double)(-this.height) / 2.0, 1.0);
            this.scaleTx.translate(1.0, -1.0);
            this.projTx.mul(this.scaleTx);
            this.viewProjTx = prismPerspectiveCameraImpl.getProjViewTx(this.viewProjTx, this.width, this.height);
            this.projTx.mul(this.viewProjTx);
        }
    }

    private int setDirtyRect(Graphics graphics) {
        this.clip.setBounds(0.0f, 0.0f, this.width, this.height);
        this.dirtyRegionTemp.makeEmpty();
        this.dirtyRegionContainer.reset();
        this.tx.setToIdentity();
        this.projTx.setIdentity();
        this.adjustPerspective(this.getCamera());
        int n = this.root.accumulateDirtyRegions(this.clip, this.dirtyRegionTemp, this.dirtyRegionPool, this.dirtyRegionContainer, this.tx, this.projTx);
        return n;
    }

    public void paintImpl(Graphics graphics) {
        Set<HighlightRegion> set;
        Object object;
        int n;
        int n2 = 0;
        if (PrismSettings.dirtyOptsEnabled && !this.scene.isEntireSceneDirty() && !this.renderOverlay && (n2 = this.setDirtyRect(graphics)) == 1) {
            this.root.doPreCulling(this.dirtyRegionContainer, this.tx, this.projTx);
        }
        if (!PrismSettings.showDirtyRegions && n2 == 1) {
            graphics.setHasPreCullingBits(true);
            for (n = 0; n < this.dirtyRegionContainer.size(); ++n) {
                object = this.dirtyRegionContainer.getDirtyRegion(n);
                if (!(((RectBounds)object).getWidth() > 0.0f) || !(((RectBounds)object).getHeight() > 0.0f)) continue;
                this.dirtyRect.setBounds((BaseBounds)object);
                graphics.setClipRect(this.dirtyRect);
                graphics.setClipRectIndex(n);
                this.doPaint(graphics);
            }
        } else {
            graphics.setHasPreCullingBits(false);
            graphics.setClipRect(null);
            this.doPaint(graphics);
        }
        if (PrismSettings.showDirtyRegions) {
            if (PrismSettings.showCull) {
                this.root.drawCullBits(graphics);
            }
            graphics.setDepthTest(false);
            if (n2 == 1) {
                graphics.setPaint(new Color(1.0f, 0.0f, 0.0f, 0.3f));
                for (n = 0; n < this.dirtyRegionContainer.size(); ++n) {
                    object = this.dirtyRegionContainer.getDirtyRegion(n);
                    graphics.fillRect(((RectBounds)object).getMinX(), ((RectBounds)object).getMinY(), ((RectBounds)object).getWidth(), ((RectBounds)object).getHeight());
                }
            } else {
                graphics.setPaint(new Color(1.0f, 0.0f, 0.0f, 0.3f));
                graphics.fillRect(0.0f, 0.0f, this.width, this.height);
            }
        }
        if (SystemProperties.isDebug() && (set = Toolkit.getToolkit().getHighlightedRegions()) != null) {
            graphics.setStroke(new BasicStroke(1.0f, 0, 2, 10.0f));
            for (HighlightRegion highlightRegion : set) {
                if (!this.scene.equals(highlightRegion.getTKScene())) continue;
                graphics.setPaint(new Color(1.0f, 1.0f, 1.0f, 1.0f));
                graphics.drawRect((float)highlightRegion.getMinX(), (float)highlightRegion.getMinY(), (float)highlightRegion.getWidth(), (float)highlightRegion.getHeight());
                graphics.setPaint(new Color(0.0f, 0.0f, 0.0f, 1.0f));
                graphics.drawRect((float)highlightRegion.getMinX() - 1.0f, (float)highlightRegion.getMinY() - 1.0f, (float)highlightRegion.getWidth() + 2.0f, (float)highlightRegion.getHeight() + 2.0f);
            }
        }
        if (this.renderOverlay) {
            this.overlayRoot.render(graphics);
        }
    }

    void disposePresentable() {
        if (this.presentable instanceof GraphicsResource) {
            ((GraphicsResource)((Object)this.presentable)).dispose();
        }
        this.presentable = null;
    }

    protected boolean validateStageGraphics() {
        if (this.scene == null) {
            return false;
        }
        return this.scene.glassStage != null;
    }
}

