/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.wrapper;

import java.security.Provider;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSUtil;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.wrapper.GSSLibStub;
import sun.security.jgss.wrapper.GSSNameElement;
import sun.security.jgss.wrapper.Krb5Util;
import sun.security.jgss.wrapper.SunNativeProvider;

public class GSSCredElement
implements GSSCredentialSpi {
    private int usage;
    long pCred;
    private GSSNameElement name = null;
    private GSSLibStub cStub;

    void doServicePermCheck() throws GSSException {
        if (GSSUtil.isKerberosMech(this.cStub.getMech()) && System.getSecurityManager() != null) {
            String string;
            if (this.isInitiatorCredential()) {
                string = Krb5Util.getTGSName(this.name);
                Krb5Util.checkServicePermission(string, "initiate");
            }
            if (this.isAcceptorCredential() && this.name != GSSNameElement.DEF_ACCEPTOR) {
                string = this.name.getKrbName();
                Krb5Util.checkServicePermission(string, "accept");
            }
        }
    }

    GSSCredElement(long l, GSSNameElement gSSNameElement, Oid oid) throws GSSException {
        this.pCred = l;
        this.cStub = GSSLibStub.getInstance(oid);
        this.usage = 1;
        this.name = gSSNameElement;
    }

    GSSCredElement(GSSNameElement gSSNameElement, int n, int n2, GSSLibStub gSSLibStub) throws GSSException {
        this.cStub = gSSLibStub;
        this.usage = n2;
        if (gSSNameElement != null) {
            this.name = gSSNameElement;
            this.doServicePermCheck();
            this.pCred = this.cStub.acquireCred(this.name.pName, n, n2);
        } else {
            this.pCred = this.cStub.acquireCred(0L, n, n2);
            this.name = new GSSNameElement(this.cStub.getCredName(this.pCred), this.cStub);
            this.doServicePermCheck();
        }
    }

    @Override
    public Provider getProvider() {
        return SunNativeProvider.INSTANCE;
    }

    @Override
    public void dispose() throws GSSException {
        this.name = null;
        if (this.pCred != 0L) {
            this.pCred = this.cStub.releaseCred(this.pCred);
        }
    }

    @Override
    public GSSNameElement getName() throws GSSException {
        return this.name == GSSNameElement.DEF_ACCEPTOR ? null : this.name;
    }

    @Override
    public int getInitLifetime() throws GSSException {
        if (this.isInitiatorCredential()) {
            return this.cStub.getCredTime(this.pCred);
        }
        return 0;
    }

    @Override
    public int getAcceptLifetime() throws GSSException {
        if (this.isAcceptorCredential()) {
            return this.cStub.getCredTime(this.pCred);
        }
        return 0;
    }

    @Override
    public boolean isInitiatorCredential() {
        return this.usage != 2;
    }

    @Override
    public boolean isAcceptorCredential() {
        return this.usage != 1;
    }

    @Override
    public Oid getMechanism() {
        return this.cStub.getMech();
    }

    public String toString() {
        return "N/A";
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }
}

