/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.webkit.dom;

import com.sun.webpane.platform.Disposer;
import com.sun.webpane.platform.DisposerRecord;
import org.w3c.dom.xpath.XPathNSResolver;

public class XPathNSResolverImpl
implements XPathNSResolver {
    protected final long contextPeer;
    protected final long rootPeer;
    protected final long peer;

    XPathNSResolverImpl(long peer, long contextPeer, long rootPeer) {
        this.peer = peer;
        this.contextPeer = contextPeer;
        this.rootPeer = rootPeer;
        Disposer.addRecord(this, new SelfDisposer(peer));
    }

    static XPathNSResolver create(long peer, long contextPeer, long rootPeer) {
        if (peer == 0L) {
            return null;
        }
        return new XPathNSResolverImpl(peer, contextPeer, rootPeer);
    }

    long getPeer() {
        return this.peer;
    }

    static long getPeer(XPathNSResolver arg) {
        return arg == null ? 0L : ((XPathNSResolverImpl)arg).getPeer();
    }

    public boolean equals(Object that) {
        return that instanceof XPathNSResolverImpl && this.peer == ((XPathNSResolverImpl)that).peer;
    }

    public int hashCode() {
        long p = this.peer;
        return (int)(p ^ p >> 17);
    }

    private static native void dispose(long var0);

    static XPathNSResolver getImpl(long peer, long contextPeer, long rootPeer) {
        return XPathNSResolverImpl.create(peer, contextPeer, rootPeer);
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        return XPathNSResolverImpl.lookupNamespaceURIImpl(this.getPeer(), prefix);
    }

    static native String lookupNamespaceURIImpl(long var0, String var2);

    static class SelfDisposer
    implements DisposerRecord {
        private final long peer;

        SelfDisposer(long peer) {
            this.peer = peer;
        }

        @Override
        public void dispose() {
            XPathNSResolverImpl.dispose(this.peer);
        }
    }
}

