/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.AbstractTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.BasicTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.DefaultTabLayoutModel;
import org.netbeans.swing.tabcontrol.plaf.ScrollingTabLayoutModel;
import org.netbeans.swing.tabcontrol.plaf.TabControlButton;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;
import org.netbeans.swing.tabcontrol.plaf.TabLayoutModel;
import org.netbeans.swing.tabcontrol.plaf.TabState;
import org.openide.windows.TopComponent;

public abstract class BasicScrollingTabDisplayerUI
extends BasicTabDisplayerUI {
    private Rectangle scratch = new Rectangle();
    private JPanel controlButtons;
    private TabControlButton btnScrollLeft;
    private TabControlButton btnScrollRight;
    private TabControlButton btnDropDown;
    private TabControlButton btnMaximizeRestore;
    private int lastKnownModelSize = Integer.MAX_VALUE;
    static SoftReference<BufferedImage> ctx = null;

    public BasicScrollingTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
    }

    @Override
    protected TabLayoutModel createLayoutModel() {
        DefaultTabLayoutModel defaultTabLayoutModel = new DefaultTabLayoutModel(this.displayer.getModel(), this.displayer);
        return new ScrollingTabLayoutModel(defaultTabLayoutModel, this.selectionModel, this.displayer.getModel());
    }

    @Override
    protected TabState createTabState() {
        return new ScrollingTabState();
    }

    @Override
    protected HierarchyListener createHierarchyListener() {
        return new ScrollingHierarchyListener();
    }

    @Override
    public void makeTabVisible(int n) {
        if (this.scroll().makeVisible(n, this.getTabsAreaWidth())) {
            this.getTabsVisibleArea(this.scratch);
            this.displayer.repaint(this.scratch.x, this.scratch.y, this.scratch.width, this.scratch.height);
        }
        if (null == this.btnMaximizeRestore) {
            return;
        }
        TabData tabData = this.displayer.getModel().getTab(n);
        Component component = tabData.getComponent();
        if (!(component instanceof TopComponent)) {
            return;
        }
        boolean bl = this.displayer.getContainerWinsysInfo().isTopComponentMaximizationEnabled((TopComponent)component);
        this.btnMaximizeRestore.setEnabled(bl);
    }

    protected final int getTabsAreaWidth() {
        int n = this.displayer.getWidth();
        Insets insets = this.getTabAreaInsets();
        return n - (insets.left + insets.right);
    }

    @Override
    public Insets getTabAreaInsets() {
        return new Insets(0, 0, 0, this.getControlButtons().getPreferredSize().width + 5);
    }

    @Override
    protected final int getLastVisibleTab() {
        if (this.displayer.getModel().size() == 0) {
            return -1;
        }
        return this.scroll().getLastVisibleTab(this.getTabsAreaWidth());
    }

    @Override
    protected final int getFirstVisibleTab() {
        if (this.displayer.getModel().size() == 0) {
            return -1;
        }
        return this.scroll().getFirstVisibleTab(this.getTabsAreaWidth());
    }

    @Override
    protected void install() {
        super.install();
        this.installControlButtons();
        ((ScrollingTabLayoutModel)this.layoutModel).setPixelsToAddToSelection(this.defaultRenderer.getPixelsToAddToSelection());
    }

    @Override
    protected void uninstall() {
        super.uninstall();
        this.displayer.setLayout(null);
        this.displayer.removeAll();
    }

    protected LayoutManager createLayout() {
        return new WCLayout();
    }

    protected Component getControlButtons() {
        if (null == this.controlButtons) {
            JPanel jPanel = new JPanel(null);
            jPanel.setOpaque(false);
            int n = 0;
            int n2 = 0;
            boolean bl = "GTK".equals(UIManager.getLookAndFeel().getID());
            Action action = this.scroll().getBackwardAction();
            action.putValue("control", this.displayer);
            this.btnScrollLeft = TabControlButtonFactory.createScrollLeftButton(this.displayer, action, bl);
            jPanel.add(this.btnScrollLeft);
            Dimension dimension = this.btnScrollLeft.getPreferredSize();
            this.btnScrollLeft.setBounds(n, 0, dimension.width, dimension.height);
            n += dimension.width;
            n2 = dimension.height;
            action = this.scroll().getForwardAction();
            action.putValue("control", this.displayer);
            this.btnScrollRight = TabControlButtonFactory.createScrollRightButton(this.displayer, action, bl);
            jPanel.add(this.btnScrollRight);
            dimension = this.btnScrollRight.getPreferredSize();
            this.btnScrollRight.setBounds(n, 0, dimension.width, dimension.height);
            n += dimension.width;
            n2 = Math.max(n2, dimension.height);
            this.btnDropDown = TabControlButtonFactory.createDropDownButton(this.displayer, bl);
            jPanel.add(this.btnDropDown);
            dimension = this.btnDropDown.getPreferredSize();
            this.btnDropDown.setBounds(n += 3, 0, dimension.width, dimension.height);
            n += dimension.width;
            n2 = Math.max(n2, dimension.height);
            if (null != this.displayer.getContainerWinsysInfo() && this.displayer.getContainerWinsysInfo().isTopComponentMaximizationEnabled()) {
                this.btnMaximizeRestore = TabControlButtonFactory.createMaximizeRestoreButton(this.displayer, bl);
                jPanel.add(this.btnMaximizeRestore);
                dimension = this.btnMaximizeRestore.getPreferredSize();
                this.btnMaximizeRestore.setBounds(n += 3, 0, dimension.width, dimension.height);
                n += dimension.width;
                n2 = Math.max(n2, dimension.height);
            }
            Dimension dimension2 = new Dimension(n, n2);
            jPanel.setMinimumSize(dimension2);
            jPanel.setSize(dimension2);
            jPanel.setPreferredSize(dimension2);
            jPanel.setMaximumSize(dimension2);
            this.controlButtons = jPanel;
        }
        return this.controlButtons;
    }

    @Override
    protected ComponentListener createComponentListener() {
        return new ScrollingDisplayerComponentListener();
    }

    @Override
    protected void modelChanged() {
        int n;
        this.scroll().clearCachedData();
        int n2 = this.selectionModel.getSelectedIndex();
        if (n2 >= this.scroll().getCachedFirstVisibleTab() && n2 < this.scroll().getCachedLastVisibleTab()) {
            this.makeTabVisible(this.selectionModel.getSelectedIndex());
        }
        if ((n = this.displayer.getModel().size()) < this.lastKnownModelSize) {
            this.scroll().ensureAvailableSpaceUsed(true);
        }
        this.lastKnownModelSize = n;
        super.modelChanged();
    }

    protected void installControlButtons() {
        this.displayer.setLayout(this.createLayout());
        this.displayer.add(this.getControlButtons());
    }

    protected final ScrollingTabLayoutModel scroll() {
        return (ScrollingTabLayoutModel)this.layoutModel;
    }

    @Override
    protected void processMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getWheelRotation();
        this.tabState.clearTransientStates();
        int n2 = this.scroll().getOffset();
        if (n > 0 && n2 < this.displayer.getModel().size() - 1) {
            if (this.scroll().isLastTabClipped()) {
                this.scroll().setOffset(n2 + 1);
            }
        } else if (n < 0) {
            if (n2 >= 0) {
                this.scroll().setOffset(n2 - 1);
            }
        } else {
            return;
        }
        this.displayer.repaint();
    }

    public static Graphics2D getOffscreenGraphics() {
        BufferedImage bufferedImage = null;
        if (ctx != null) {
            bufferedImage = ctx.get();
        }
        if (bufferedImage == null) {
            bufferedImage = new BufferedImage(10, 10, 1);
            ctx = new SoftReference<BufferedImage>(bufferedImage);
        }
        return (Graphics2D)bufferedImage.getGraphics();
    }

    protected Rectangle getControlButtonsRectangle(Container container) {
        Component component = this.getControlButtons();
        return new Rectangle(container.getWidth() - component.getWidth(), 0, component.getWidth(), component.getHeight());
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        int n = this.displayer.getSelectionModel().getSelectedIndex();
        TabDataModel tabDataModel = this.displayer.getModel();
        if (n < 0 || n >= tabDataModel.size()) {
            n = 0;
        }
        Dimension dimension = null;
        dimension = n >= tabDataModel.size() || null == tabDataModel.getTab(n).getComponent() ? new Dimension(100, 10) : tabDataModel.getTab(n).getComponent().getMinimumSize();
        dimension.width = Math.max(dimension.width, 100);
        dimension.height = Math.max(dimension.height, 10);
        return dimension;
    }

    private class WCLayout
    implements LayoutManager {
        private WCLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void layoutContainer(Container container) {
            Rectangle rectangle = BasicScrollingTabDisplayerUI.this.getControlButtonsRectangle(container);
            Component component = BasicScrollingTabDisplayerUI.this.getControlButtons();
            component.setBounds(rectangle);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return BasicScrollingTabDisplayerUI.this.getMinimumSize((JComponent)container);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return BasicScrollingTabDisplayerUI.this.getPreferredSize((JComponent)container);
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }
    }

    protected class ScrollingHierarchyListener
    extends AbstractTabDisplayerUI.DisplayerHierarchyListener {
        protected ScrollingHierarchyListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            super.hierarchyChanged(hierarchyEvent);
            if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && BasicScrollingTabDisplayerUI.this.displayer.isShowing() && BasicScrollingTabDisplayerUI.this.tabState != null && BasicScrollingTabDisplayerUI.this.selectionModel != null) {
                BasicScrollingTabDisplayerUI.this.tabState.setActive(BasicScrollingTabDisplayerUI.this.displayer.isActive());
                BasicScrollingTabDisplayerUI.this.makeTabVisible(BasicScrollingTabDisplayerUI.this.selectionModel.getSelectedIndex());
            }
        }
    }

    protected class ScrollingDisplayerComponentListener
    extends ComponentAdapter {
        protected ScrollingDisplayerComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            BasicScrollingTabDisplayerUI.this.makeTabVisible(BasicScrollingTabDisplayerUI.this.selectionModel.getSelectedIndex());
        }
    }

    protected class ScrollingTabState
    extends BasicTabDisplayerUI.BasicTabState {
        protected ScrollingTabState() {
            super(BasicScrollingTabDisplayerUI.this);
        }

        @Override
        public int getState(int n) {
            int n2 = super.getState(n);
            int n3 = BasicScrollingTabDisplayerUI.this.getFirstVisibleTab();
            int n4 = BasicScrollingTabDisplayerUI.this.getLastVisibleTab();
            if (n < n3 || n > n4) {
                return 64;
            }
            if (n3 == n4 && n3 == n && BasicScrollingTabDisplayerUI.this.displayer.getModel().size() > 1) {
                n2 |= 3;
            } else if (BasicScrollingTabDisplayerUI.this.getTabsAreaWidth() < BasicScrollingTabDisplayerUI.this.scroll().getMinimumLeftClippedWidth() + BasicScrollingTabDisplayerUI.this.scroll().getMinimumRightClippedWidth() && n == n3 && n4 == n3 - 1 && BasicScrollingTabDisplayerUI.this.displayer.getModel().size() > 1 && BasicScrollingTabDisplayerUI.this.scroll().isLastTabClipped()) {
                n2 |= 2;
            } else {
                if (n == n3 && BasicScrollingTabDisplayerUI.this.scroll().getOffset() == n3) {
                    n2 |= 2;
                }
                if (n == n4 && BasicScrollingTabDisplayerUI.this.scroll().isLastTabClipped()) {
                    n2 |= 1;
                }
            }
            return n2;
        }
    }
}

